
import os
import re
__all__ = ['Cf', 'ConfigFileParseErrror']

""" Read variables from the configuration file """

try:
	cffile=os.environ["POPCONFIG"]
except KeyError:
	cffile="/etc/pop.conf"

class NixIs:
	pass

class ConfigFileParseError(SyntaxError):
    def __init__(self, fname, lno, line):
        self.fname = fname
        self.lno = lno
        self.line = line.rstrip()

    def __str__(self):
        return "Konfig: %s:%i: '%s' verstehe ich nicht" % \
               (self.fname, self.lno, self.line)

class Cf(dict):
	def __init__(self, configfile=None):
		if configfile is None:
			try:
				configfile=os.environ["POPCONFIG"]
			except KeyError:
				configfile="/etc/pop.conf"
		self.load(configfile)

	def load(self, file):
		f=open(file,"r")

		r_var=re.compile(r'^(\w+)\s*=\s*(.*?)\s*$');
		r_cmt=re.compile(r'^\s*(?:\#.*)?$');

		lno=0
		for line in f:
			lno += 1
			m=r_var.match(line)
			if m:
				var,data = m.groups()
				if len(data) >= 2 and (data[0]=="'" or data[0]=='"') and data[0]==data[-1]:
					data=data[1:-1]
				else:
					try:
						data=int(data)
					except ValueError:
						pass
				self[var]=data
				# __all__.append(md)
			elif not r_cmt.match(line):
				raise ConfigFileParseError(file, lno, line)
		
		f.close()

	def db_update(self):
		import Db
		db=Db.Db()
		for cfg in self.KONFIG_SUCHLISTE.split():
			for var,data in db.DoSelect("""\
		SELECT V.name, W.wert
		FROM   konfig_wert W
		JOIN   konfig_namensraum N ON N.id = W.namensraum
		JOIN   konfig_variable   V ON V.id = W.variable
		WHERE  N.name = ${cfg}
					""", cfg=cfg):
				if var not in self:
					self[var] = data

	def __call__(self, var, default=NixIs):
		try:
			return self[var]
		except KeyError:
			if default == NixIs:
				raise 
			return default
	
	def __getattr__(self, var):
		try:
			x=os.environ[var]
			try:
				x=int(x)
			except ValueError:
				pass
			return x
		except KeyError:
			return self[var]
	
	def __setattr__(self, var,val):
		os.environ[var]=str(val)

	def __delattr__(self, var):
		del os.environ[var]
	
