use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::Status;

use Dbase::Help qw(in_list);
use Moose;

# Diese Klasse brauchen wir im Wesentlichen für den Sonderstatus "merged".

extends 'noris::Ticket::API::RT::Field::Descr';

has db_name => (
    is      => 'ro',
    isa     => 'Str',
    default => "IF( ticket.id = ticket.ticket, ticket.status, 'merged' )",
);
has descr => ( is => 'ro', isa => 'Str', default => 'tickets' );

sub rt2api {
    my $self = shift;
    my ($sql_value) = @_;
    return $sql_value if $sql_value =~ /\D/;    # merged
    $self->SUPER::rt2api(@_);
}

sub where_in {
    my ( $self, @values ) = @_;
    return 'NULL' unless @values;
    my $want_merged;
    my @where;

    @values = map {
        if ( $_ eq 'merged' ) { @where = 'ticket.id != ticket.ticket'; () }
        else { $_ }
      } @values
      and push @where, 'ticket.id = ticket.ticket AND '
      . in_list( 'ticket.status', '', $self->descr_names2ids(@values) );

    return 1 unless @where;
    return "@where" if @where == 1;
    '( ' . join( ' OR ', @where ) . ' )';
}

sub where_not_in {
    my ( $self, @values ) = @_;
    my @where;

    my $exclude_merged;
    if (
        @values = map {
            if ( $_ eq 'merged' )
            {
                @where = 'ticket.id = ticket.ticket';
                ++$exclude_merged;
                ();
            }
            else { $_ }
        } @values
      )
    {
        my $where = in_list(
            'ticket.status',
            NOT => undef,
            $self->descr_names2ids(@values)
        );
        $where = "( ticket.id != ticket.ticket OR $where )"
          unless $exclude_merged;
        push @where, $where;
    }

    return 1 unless @where;
    return "@where" if @where == 1;
    join ' AND ', @where;
}

1;
