use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::Numeric;

use Dbase::Help qw(in_range);
use Moose;
use Params::Validate qw(SCALAR UNDEF validate_pos);

use constant INTEGER_OR_UNDEF => {
    type      => SCALAR | UNDEF,
    callbacks => {
        integer_or_undef =>
          sub { my $value = shift; !defined $value || $value =~ /^\d+\z/ }
    },
    default => undef,
};

extends 'noris::Ticket::API::RT::Field::String';

has format => ( is => 'ro', isa => 'Str' );

sub rt2api {
    my ( $self, $value ) = @_;
    if ( defined $value && defined( my $format = $self->format ) ) {
        $value = sprintf $format, $value;
    }
    $value;
}

sub where_range {
	my ( $self, $lower, $upper ) =
	  validate_pos( @_, { isa => __PACKAGE__ }, (INTEGER_OR_UNDEF) x 2 );
    in_range( $self->db_name, $lower, $upper );
}

for (
    [ '<'  => sub { undef,       shift() - 1 } ],
    [ '<=' => sub { undef,       shift } ],
    [ '>'  => sub { shift() + 1, undef } ],
    [ '>=' => sub { shift,       undef } ],
  )
{
    no strict 'refs';
    my ( $operator, $gen_args4in_range ) = @$_;
    *{"where_$operator"} = sub {
        my ( $self, $boundary ) =
          validate_pos( @_, { isa => __PACKAGE__ }, INTEGER_OR_UNDEF );
        &in_range( $self->db_name, $gen_args4in_range->($boundary) );
    };
}

{
    no strict 'refs';
    *{'where_='} = sub { my $self = shift; $self->where_is(@_) };
}

1;
