use strict;
use utf8;
use warnings;

package noris::Ticket::API::OTRS::SelectResult;

use Moose;
use IO::Socket::INET qw();


has 'buffer_id' => (is => 'ro', isa => 'Int', required => 1);
has 'attributes' => (is => 'ro', isa => 'ArrayRef');
has 'connection' => (is => 'ro', isa => 'noris::Ticket::API::OTRS::Connection');
has '_buffer' => (is => 'rw', isa => 'ArrayRef', default => sub { return [] });
has '_last' => (is => 'rw', isa => 'Bool', default => sub { '' });

sub next {
    my ($self) = @_;
    if (! @{$self->_buffer}) {
        return if $self->_last;
        my $socket = $self->connection->socket;
        $socket->print("fetch $self->{buffer_id}\n");
        my $line = $socket->getline_expect(qr/\A(?:MORE|LAST)\z/);
        $self->_last($line eq 'LAST');
        {
            local $/ = "\n\n";
            $line = <$socket>;
        }
        die "Verbindungsabbruch während fetch" unless defined $line;
        $self->_buffer(JSON->new->jsonToObj($line));
    }
    return shift @{$self->_buffer};
}

            
sub foreach_row {
    my ($self, $fn) = @_;
    my $row;
    while (defined($row = $self->next())) {
        $fn->(@$row);
    }
}

sub count {
    my ($self) = @_;
    my $socket = $self->connection->socket;
    $socket->print("count $self->{buffer_id}\n");
    return $socket->get_number();
}

sub DEMOLISH {
    my ($self) = @_;
    my $socket = $self->connection->socket;
    return if $socket->has_error;
    if (defined $self->buffer_id) {
        $socket->print("close $self->{buffer_id}\n");
        $socket->getline_expect(qr/\AOK\z/);
    }
}

1;
