use strict;
use warnings;
use utf8;

package noris::Ticket::API::OTRS::Connection::Socket;

use base 'IO::Socket::INET';

use Carp qw(confess);

sub new {
    my ( $package, @args ) = @_;
    my $self = $package->SUPER::new(@args)
        or die "Fehler beim Verbindungsaufbau: $!";
    binmode $self, ':crlf :encoding(UTF-8)'
        or die "Fehler beim Setzen der I/O-Layer: $!";
    return bless $self, $package;
}

{
    my %has_error;

    sub has_error : lvalue {
        $has_error{ +shift };
    }

    sub DESTROY {
        my $self = shift;
        delete $has_error{$self};
        $self->SUPER::DESTROY(@_);
    }
}

sub getline_expect {
    my ( $self, $re_expected ) = @_;
    defined( my $line = $self->getline() )
        or die "Unerwarteter Verbindungsabbruch: $!";
    chomp $line;
    if ( $line =~ $re_expected ) { return $line }
    elsif ( $line =~ /^ERROR:\s*(.*)/ ) {
	    ++$self->has_error;
        confess("Der Ticket-Server hat einen Fehler gemeldet: $1");
    }
    else {
        die qq("$line" passt nicht zu "$re_expected".);
    }
}

sub get_number {
    my ($self) = @_;
    return $self->getline_expect( qr/\A\d+\z/ );
}

1;
