package noris::KundenListen;

use utf8;
use warnings;
use strict;

use Exporter ('import');
use Dbase::Globals ('get_bitmap');
use Dbase::Help qw(DoSelect in_list);

=head1

Die Funktionen hier haben die Aufgabe, Listen von Kunden-IDs zu liefern.
Darunter dürfen ruhig auch beendete Kunden sein; diese müssen also ggf.
vom aufrufenden Code noch herausgefiltert werden; in der Regel ist das
unser Trouble-Ticket-Generator.

=cut

our @EXPORT_OK = ('%KundenListen');
our %KundenListen =
(
	'Domain-Reseller-Kunden' => \&domain_reseller_kunden,
	'Kunden mit eigenen SMTP-MTAs' => \&kunden_mit_eigenem_mta,
	'Kunden mit ezmlm-Verteilern' => \&kunden_mit_ezmlm,
	'Kunden, die proxy.noris.net nutzen' => \&kunden_die_proxy_nutzen,
        'Kunden mit Hardware im RZ3' => sub { kunden_mit_hardware_in('nbg3') },
        'Kunden mit Hardware im RZ4' => sub { kunden_mit_hardware_in('nbg4') },
);

return (1);

sub kunden_mit_eigenem_mta
{
	my @kunden_ids;
	my ($grs) = get_bitmap (mailrules => 'eigener_mta');

	DoSelect (sub { push (@kunden_ids, @_) }, <<SQL);
	SELECT DISTINCT kunde FROM mailrules WHERE typ & $grs
SQL

	return wantarray ? @kunden_ids : \@kunden_ids;
} # kunden_mit_eigenem_mta

sub kunden_mit_ezmlm {
	my @kunden_ids;
	DoSelect { push @kunden_ids, shift } <<'_';
	SELECT DISTINCT kunde FROM mailrules WHERE ziel LIKE '%@list.noris.net'
_
	if (wantarray) { @kunden_ids } else { \@kunden_ids }
}

sub kunden_die_proxy_nutzen {
	my @kunden_ids;
	DoSelect { push @kunden_ids, shift } <<'_';
	SELECT DISTINCT kunde
	FROM            acct, dienst
	WHERE           acct.dienst = dienst.id
	            AND dienst.name IN ('cache','cache-hit')
		    AND acct.timestamp > DATE_SUB( NOW(), INTERVAL 42 DAY )
_
	if (wantarray) { @kunden_ids } else { \@kunden_ids }
}

sub kunden_mit_hardware_in {
	my @kunden_ids;
	DoSelect { push @kunden_ids, shift } <<_;
	SELECT DISTINCT hardware.kunde
	FROM            hardware
	JOIN            rack ON hardware.rack = rack.id
	JOIN            rz   ON rack.rz       = rz.id
	WHERE           ( hardware.ende IS NULL OR hardware.ende >= UNIX_TIMESTAMP(NOW()) )
	            AND ${\ in_list( 'rz.name', '', @_ ) }
_
	if (wantarray) { @kunden_ids } else { \@kunden_ids }
}

sub domain_reseller_kunden {
	my @kunden_ids;
	DoSelect { push @kunden_ids, shift } <<'_';
	SELECT DISTINCT kunde.id
	FROM            kunde, reseller
	WHERE           kunde.id = reseller.kunde OR kunde.reseller IS NOT NULL
_
	if (wantarray) { @kunden_ids } else { \@kunden_ids }
}
