package HTMLfilter;
use utf8;
use strict;
use warnings;
use HTML::Scrubber;
require Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw($filter);

our $filter = HTML::Scrubber->new();

    my @allow = qw[ a b blockquote br div em font hr img li ol p span strong tt ul ];
    my @rules = (
        blockquote => { cite => 1, '*'  => 0, },
        div => { align => 1, '*'  => 0, },
        font => { size => 1, face => 1, color => 1, '*'  => 0, },
        img => { alt => 1, '*' => 0, },
    );
    my @default = (
        0   =>    # default rule, deny all tags
        {
            '*'           => 0,
            'href'        => qr{^(?!(?:java)?script)}i,
            'src'         => qr{^(?!(?:java)?script)}i,
            'cite'        => qr{(?i-xsm:^(?!(?:java)?script))},
            'name'        => 1,
            'title'       => 1,
            'lang'        => 1,
            'xml_lang'    => 1,
        }
    );

    $filter->allow( @allow );
    $filter->rules( @rules );
    $filter->default( @default );
    $filter->script( 0 );
    $filter->style( 0 );

1;
