=head1 Dbase::Test

Hilfsfunktionen zum Testen der Datenbank.

Dieses Modul setzt automatisch Environmentvariablen, um auf eine lokale
Testdatenbank zuzugreifen. Es muß daher vor allen anderen Modulen
aufgerufen werden.

=head2 Funktionen

=over 4

=item DoS (Funktion, Argument...)

Ruft die Funktion (evtl. mit den Argumenten) auf.

Liefert 1 bei Gelingen, 0 wenn ein Fehler aufgetreten ist (der via
C<fehler()> gemeldet werden muss).


=item DoF (SQL)

Führt den SQL-Befehl aus. 

Liefert 1 bei Gelingen, 0 wenn ein Fehler aufgetreten ist (der via
C<fehler()> gemeldet werden muss).

Der Text läuft durch C<rep()>.


=item okF (SQL, Infotext)

entspricht Test::ok(Do(SQL),Infotext).

Der Infotext kann leer sein.


=item okS (Infotext, Funktion(Args))

entspricht Test::ok(Funktion(Args),Infotext).


=item okQ (Query,Wert...)

fragt ab ob diese SQL-Query genau diese Werte liefert.

Eine leere Werteliste prüft auf ein leeres Resultat. Die Länge einer
Resultatliste wird mit C<count(*)> geprüft; ein Teil einer Liste mit
C<LIMIT>.


=item okL (Tabelle, Anzahl, [Index, Wert]...)

Listet den Inhalt einer Tabelle (ggf. mit den angegebenen Selektoren)
auf. Es wird geprüft, ob die Anzahl der Zeilen der übergebenen Anzahl
entspricht.


=item sys (Programm...

wie system(); setzt die für das Testsystem relevanten
Environmentvariablen und prüft den Exitstatus.

=back

=cut

## Override-Variablen zwecks Test

package Dbase::Test;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(DoF DoS okF okS okL okQ sys);

use utf8;
use warnings;
use strict;
use File::Path;

BEGIN {
	$ENV{'USER'} = (getpwuid($<))[0]
		if not defined $ENV{'USER'} or $ENV{'USER'} eq "";
	die "USER-Environmentvariable nicht gesetzt!\n"
		if not defined $ENV{'USER'} or $ENV{'USER'} eq "";

	my $pwd = $ENV{'PWD'};
	if(not defined $pwd or $pwd eq "" or not -d $pwd) {
		$pwd = `pwd`;
		chop $pwd;
		$ENV{'PWD'}=$pwd;
	}
	my $tmpdir = $ENV{'TMPDIR'};
	if(not defined $tmpdir or $tmpdir eq "" or not -d $tmpdir) {
		$tmpdir="/var/tmp";
		$ENV{'TMPDIR'}=$tmpdir;
	}

	my $testhost = $ENV{'TESTHOST'} || "localhost";
	$ENV{'DATAHOST'}=$testhost;
	$ENV{'DATAHOST2'}=$testhost;
	$ENV{'DBDATABASE'}=$ENV{'TESTDB'} || "test_".$ENV{'USER'};
	$ENV{'OTRS'}=($ENV{'TESTDB'} || "test_".$ENV{'USER'})."_otrs";
	$ENV{'DATAUSER'}="test";
	$ENV{'DATAPASS'}="test";

	$ENV{'DEFAULTKLASSE'}="lokal";

	$ENV{'POPTMP'}="$tmpdir/dbtest.".$ENV{'USER'};
	rmtree($ENV{'POPTMP'});
	mkpath($ENV{'POPTMP'},0,0700);

	$ENV{'CACHEDIR'}=$ENV{'POPTMP'}."/cache";
	mkpath($ENV{'CACHEDIR'},0,0700);

	$ENV{'GPG'}=$ENV{'POPTMP'}."/gpg";
	mkpath($ENV{'GPG'},0,0700);

	$ENV{'TESTING2'}=1;
}

use Dbase::Help qw(in_test);
BEGIN { die "kein Test" if in_test() < 3 }

END {
	# rmtree($ENV{'POPTMP'}) if defined $ENV{'POPTMP'};
}

use Dbase::Help qw(Do DoSel DoSelect quote);
use Dbase::MailTest qw(rep dump_str);
use Fehler qw(ffehler fehler);
use Test::More;
use Data::Dumper;

sub sys(@) {
	system(@_);
	is($?,0,"@_");
}

sub DoF($) {
	my($cmd) = @_;
	ffehler {
		Do(rep($cmd));
		1;
	} sub {
		print " # Problem:\n# $cmd\n# ".join("\n# ",@_)."\n\n";
		0;
	}
}

sub DoS(&;@) {
	my($job,@args) = @_;
	ffehler {
		&$job(@args);
		1;
	} sub {
		print " # Problem:\n# ".(scalar caller)."\n# ".join("\n# ",@_)."\n\n";
		0;
	}
}

sub okF($;$) {
	my($cmd,$msg) = @_;
	$msg = $cmd unless defined $msg;
	local $Test::TestLevel;
	$Test::TestLevel++;
	ok(DoF($cmd),$msg);
}

sub okS($&;@) {
	my($msg,$job,@args) = @_;
	local $Test::TestLevel;
	$Test::TestLevel++;
	ok(DoS(sub{&$job(@args)}),$msg);
}

sub okQ($@) {
	my($query,@res) = @_;
	local $Test::TestLevel;
	$Test::TestLevel += 3;
	ffehler {
		$Test::TestLevel++;
		my $res = DoSel(rep($query));
		unless(ref $res) {
			fail("Kein SELECT für '$query'");
			return;
		}
		my $r = $res->nextrow;
		if(ref $r) {
			if(@res == 0) {
				fail("Resultat für '$query'");
				return;
			}
		} else {
			if(@res == 0) {
				pass("leeres Resultat für '$query'");
				return;
			}
		}
		my $rr = $res->nextrow;
		if($rr) {
			fail("zu viele Resultate für '$query'");
			return;
		}
		my($r1,$r2) = dump_str($r,[ map { rep($_) } @res ]);
		is($r1,$r2,$query);
	} sub {
		print " # Problem:\n# $query\n# ".join("\n# ",@_)."\n\n";
		$Test::TestLevel += 2;
		fail($query);
	}
}

sub okL($$@) {
	my($num,$tab,@idx) = @_;
	my $cmd="";
	while(@idx) {
		my $f=shift @idx;
		my $v=shift @idx;
		$cmd .= " and " if $cmd ne "";
		$cmd .= "`$f`";
		if(defined $v) {
			$cmd .= "='${\quote $v}'";
		} else {
			$cmd .= " is null";
		}
	}

	local Dbase::db_handle->{FieldHeader}=1;
	my $n = DoSelect {
		my $X="A";
		print "# ".join("|",map { $X++.":".((defined $_) ? ($_ eq "") ? "''": $_ : "<>")} @_)."\n";
	} "select * from $tab where $cmd";
	ok(((defined $num) or $num+1 == $n), "korrekte Zeilenzahl");
}

1;
