use strict;
use utf8;
use warnings;

package Dbase::Person;

use Moose;
extends 'Dbase::Object';

use overload '""' => sub { shift->name },

  # zur Vermeidung von Endlos-Rekursion in Class::MOP::Attribute:
  bool => sub { 1 },
  ;

use constant _attributes => {
    abteilung => { sql => 'abt' },
    map +( $_ => {} ), qw/email id name pager user/
};

use constant _uniq_attributes => qw/id user/;

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is        => 'ro',
        lazy      => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}

has anrede => (
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $name = shift->name;

        my $anrede;
        if ( defined $name ) {
            my ( $herrfrau, $vorname ) = split ' ', $name;
            $anrede = { Frau => 'Liebe', Herr => 'Lieber' }->{$herrfrau}
              and defined $vorname
              and $anrede .= " $vorname";
        }
        $anrede = 'Guten Tag' unless defined $anrede;

        $anrede;
    },
);

sub _after_load {
    my $self = shift;
    return unless defined $self->{pager};
    require Dbase::Globals and Dbase::Globals->import('rufnummernliste')
      unless defined &rufnummernliste;
    $self->{pager} = rufnummernliste( $self->{pager} );
}

has vorgesetzter => (
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        require Dbase::Help and Dbase::Help->import('DoFn')
          unless defined &DoFn;
        my $vorgesetzter =
          DoFn( 'SELECT vorgesetzter FROM perso WHERE person = ' . $self->id );
        $vorgesetzter = $self->new_cached( id => $vorgesetzter )
          if defined $vorgesetzter;
        $vorgesetzter;
    },
);

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Person - Objekt, das eine Person repräsentiert

=head1 SYNOPSE

  use Dbase::Person;
  my $person = Dbase::Person->new( id => 42 );
  my $name = $person->name;

=head2 KONSTRUKTOREN

=over 4

=item -E<gt>new( id => $kundennummer, [ name => $kundenname ], ... )

Anlegen eines neuen Person Objekts

=item -E<gt>new_cached

Falls für diese Person mit dieser Methode bereits ein Objekt angelegt wurde,
wird das bestehende Objekt zurückgeliefert, ansonsten ein neues erzeugt und
gecacht.

=back

=head2 METHODEN

Folgende Attribute können abgefragt werden:

=over 4

=item -E<gt>id

Datenbank-ID der Person

=item -E<gt>abteilung

Abteilung der Person

=item -E<gt>anrede

Anrede für die Person

=item -E<gt>email

primäre E-Mail-Adresse der Person

=item -E<gt>name

Name der Person

=item -E<gt>pager

L<Liste der zugeordneten Mobilrufnummern|Dbase::Globals/rufnummernliste>

=item -E<gt>user

Benutzername der Person

=item -E<gt>vorgesetzter

Vorgesetzter als L<Dbase::Person>-Objekt (nur für Mitarbeiter)

=back

