=head1 Dbase::OTRS

Hilfsfunktionen zum Arbeiten mit OTRS.

=head2 Funktionen

=over 4

=item TicketID (Nummer)

Liefert die (invariante) ID eines Tickets, gegeben die (sichtbare) Nummer.

C<undef>, wenn das Ticket nicht existiert.


=item TicketNr (id)

Liefert die (sichtbare) Nummer eines Tickets, gegeben die (invariante) ID.

C<undef>, wenn das Ticket nicht existiert.


=back

=cut

package Dbase::OTRS;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(TicketID TicketNr QueueDaten);

use utf8;
use warnings;
use strict;

use Cf qw($OTRS);
use Dbase::Help qw(DoFn qquote);

sub TicketID($) {
	# OTRS-Ticketnummer => Ticket-ID
	my($nr) = @_;
	my $id = DoFn("select writeonly id from $OTRS.ticket where tn=$nr and valid_id=1");
	return $id;
}

sub TicketNr($) {
	# OTRS-Ticket-ID => Ticketnummer
	my($id) = @_;
	my $nr = DoFn("select writeonly tn from $OTRS.ticket where id=$id and valid_id=1");
	return $nr;
}

sub QueueDaten($) {
	# RT-Queue-Name => (OTRS-Queue-Nr,-Name)
	my($qname) = @_;
	my($nr,$name) = DoFn(<<_);
select writeonly $OTRS.queue.id,$OTRS.queue.name
  from $OTRS.system_address,$OTRS.queue
 where $OTRS.queue.system_address_id=$OTRS.system_address.id
   and $OTRS.system_address.valid_id=1
   and $OTRS.system_address.value0 like ${\qquote $qname."@%"}
 order by $OTRS.queue.id limit 1
_
	return ($nr,$name);

}

1;
