=head1 Dbase::MailTest

Hilfsfunktionen zum Testen (nicht nur) der Mailfunktionen.

=head2 Funktionen

=over 4

=item dump_str( X1, X2)

Liefert Dumps dieser zwei Strings mit dem Ziel, sie hinterher zu
vergleichen.


=item rep(Text)

Ersetzt diverse Substrings, zwecks einfacherer Datenbankbedienung.

Ersetzungen:

=over 4

=item %TARIFNAME%name%

wird ersetzt durch die ID des globalen Tarifs C<name> in der
tarifname-Tabelle.

=item %TARIF%name%

wird ersetzt durch die ID des globalen Tarifs C<name> in der
tarifklasse-Tabelle.

=item %TARIF%name%kunde%

wird ersetzt durch die ID des kundenspezifischen Tarifs C<name> in der
tarifklasse-Tabelle.

=item %DIENST%name%

wird ersetzt durch die ID des genannten Diensts.

=item %DESCR%id%bla%

wird ersetzt durch die ID des C<bla>-Deskriptors in der
C<id>-Deskriptortabelle.

=item %DTYP%bla%

wird ersetzt durch die ID des C<bla>-Deskriptortyp in der
Deskriptortyp-Tabelle.

=item %DESCRS%id%bla,fasel%

wird ersetzt durch eine Zahl, in der die Bits der zu C<bla> und C<fasel>
korrespondierenden Deskriptoren der C<id>-Deskriptortabelle gesetzt
sind.

C<-> gibt an, dass kein Bit gesetzt ist.

=item %SEQ%id%

wird ersetzt durch die nächste Folgenummer für C<id>.

=item %QUEUE%name%

wird ersetzt durch die ID dieser Queue.

=item %IPNR%nr%

ersetzt eine IP-Adresse durch die in der Datenbank gespeicherte Form (für
SELECT).

=item %IPNR_I%nr%

ersetzt eine IP-Adresse durch die in der Datenbank gespeicherte Form (für
INSERT/UPDATE).

=item %DOMAIN%name%

wird ersetzt durch die ID dieser Domain.

=item %PERSON%name%

wird ersetzt durch die ID dieser Person.

=back


=item useHash (Hash)

Merkt sich diesen Hash für spätere Ersetzungen.


=item %stdhash

Standardliste von Ersetzungen; entspricht der Exportliste des Cf-Moduls.

=back

=cut

package Dbase::MailTest;
## Achtung: darf NICHT von Dbase::Test importieren,
## weil es von bin/domainmail verwendet wird..

use utf8;
use warnings;
use strict;
use Cf qw();
use Loader qw(reader);
use MIME::Parser;
use Fehler qw(fehler fehler problem warnungen probleme hat_problem
	ffehler report_fehler report_status);
use Text::ParseWords qw(quotewords);
use Dbase::Help qw(Do DoFn DoSel DoSeq qquote DoN);
use Dbase::Globals qw(find_descr get_kunde get_person
	get_descr kpersinfo mime2mail name_kunde 
	bignum find_dienst);
use Test::More;
use Data::Dumper;
use Dbase::TestSupport qw(sql_pre sql_post);
use Dbase::IP;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(useHash %stdhash rep
	DebugBreak dump_str);

my $parser = MIME::Parser->new;
$parser->output_to_core(1);
$parser->filer->purge;

our %stdhash;
{
	foreach my $v(@Cf::EXPORT) {
		my $vv = $v; $vv =~ s/\$//;
		$stdhash{$vv} = eval "\$Cf::$vv";
	}
}

sub grab($\%) {
	my($text,$h) = @_;
	if(ref $text) { # Annahme: MIME::Entity
		$text = $text->as_string;
	} elsif ($text !~ /\n/) {
		$text = reader $text;
		fehler "unlesbar/leer" unless defined $text;
	}
	$text =~ s/\@([_A-Z][_A-Z0-9]+)\@/defined $h->{$1} ? $h->{$1} : fehler "Unbekannt: $1"/eg;
	$text = rep($text);

	eval { $text = $parser->parse_data($text); };
	fehler $@ if $@;
	$text;
}

sub dump_str($$) {
	my($r1,$r2) = @_;
	local $Data::Dumper::Terse=1;
	local $Data::Dumper::Indent=0;
	local $Data::Dumper::Useqq=1;
	$r1 = Dumper($r1);
	$r2 = Dumper($r2);
	$r2 =~ s/'(\d+)'/$1/g;
	($r1,$r2);
}

sub hash_pre($\%) {
	my($msg,$res) = @_;
	foreach my $line ($msg->head->get("x-debug-break")) {
		foreach my $lin (split /\s+/,$line) {
			$res->{'breakpoint'}{$lin}=1;
		}
	}
	foreach my $stmt ($msg->head->get("x-hash-pre")) {
		chomp $stmt;
		my($key,$content) = split(/\s+/,$stmt,2);

		if($key eq "msgid") {
			my $tid;
			($tid,$content)=split(/\s+/,$content,2);
			foreach my $id(split(/\s+/,$content)) {
				DoN("insert into ticketid set ticket=$tid, id=${\qquote $id}");
			}

		} elsif($key eq "flags") {
			# Flags werden nicht komplett überbügelt
			foreach my $key(split(/\s+/,$content)) {
				if($key =~ s/^\!//) {
					delete $res->{'flags'}{$key};
				} else {
					$res->{'flags'}{$key}++;
				}
			}
		} else {
			$res->{$key} = eval $content;
		}
		fehler $@ if $@;
	}
}

sub hash_post($\%) {
	my($msg,$res) = @_;
stmt:
	foreach my $stmt ($msg->head->get("x-hash-post")) {
		chomp $stmt;
		my($key,$t) = split(/\s+/,$stmt,2);
		if($key eq "flags") {
			# Teste ob das betreffende Flag gesetzt bzw. nicht gesetzt ist
			foreach my $key(split(/\s+/,$t)) {
				if($key =~ s/^\!//) {
					problem "Flag '$key' gesetzt" if defined $res->{'flags'}{$key};
				} else {
					problem "Flag '$key' nicht gesetzt" unless defined $res->{'flags'}{$key};
				}
			}
			next stmt;
		} elsif($key eq "sendmail") {
			# Teste ob in der Email an diesen Empfänger ein Pattern vorkommt (oder nicht)
			my($adr,$pat) = split(/\s+/,$t,2);
			my $gefunden;

			# Das Pattern kann ein String sein oder ein qr{}-Ausdruck
			# Das Pattern kann mit ! vorweg negiert werden
			my $nicht;
			if(defined $pat and $pat ne "") {
				$nicht = ($pat =~ s/^\!//);
				if($pat =~ /^qr\b/) { # regexp
					$pat = eval $pat;
				} else {
					# Annahme: Alle Sonderzeichen in $pat sind vernünftig
					# gequotet, also auch '{}', also funktioniert der eval.
					$pat = eval "qr{$pat}";
				}
			} else {
				$nicht = undef; # gar keine Mail dorthin
			}
			if($@) { # Regexp fehlerhaft?
				problem "Match mit '$pat': $@";
				next stmt;
			}

			# prüfe alle Mails, wenn sie an diesen Absender gehen
			foreach my $mx(@{$res->{'sendmail'}}) {
				my($mail,$from,@to) = mime2mail($mx);

				foreach my $to(@to) {
					if(lc($to) eq lc($adr)) {
						# Ja => Test. Kein "next stmt" hier; es könnte ja
						# noch mehr Mails an den Adressaten geben, und
						# die müssen alle passen.

						if(not defined $nicht) {
							problem "Mail an '$adr'";
						} elsif($nicht) {
							problem "Mail an '$adr': Match: '$pat'" if $mail =~ $pat;
						} else {
							problem "Mail an '$adr': kein Match: '$pat'" unless $mail =~ $pat;
						}
						$gefunden++;
					}
				}
			}
			problem "Mail an '$adr': nicht gefunden"
				if defined $nicht and not $gefunden;
			next stmt;
		}
		# Ansonsten ist der Text ein Perl-Objekt und muss mit dem
		# Hash-Inhalt übereinstimmen. Evtl. TODO: Diesen textuellen Test
		# durch einen vernünftigen rekursiven ersetzen.

		$t = eval $t;
		fehler $@ if $@;

		my $d;
		($d,$t)=dump_str($res->{$key},$t);
		$t="<undef>" if $t eq "'NULL'";
		problem $key, "SOLL=$t", "IST=$d" if $d ne $t;
	}
}

my $h = \%stdhash;
sub useHash(\%) {
	($h) = @_;
}

sub DebugBreak(\%;$) {
	my($res,$flag) = @_;
	no warnings 'once';
	$DB::single = 1 if $res->{'breakpoint'}{$flag};
}

sub dlist($$) {
	my($desc,$ids) = @_;
	return 0 if $ids eq "-";
	my $sum=0;
	foreach my $id(split(/,/,$ids)) {
		my $i = find_descr($desc,$id); 
		fehler "Descr $desc//$id nicht gefunden" unless defined $i;
		$sum |= bignum(1)<<$i;
	}
	$sum;
}

sub rep($) {
	my($text) = @_;
	return undef unless defined $text;

	$text =~ s/%DTYP%([^%]+)%/DoFn("select id from descr_typ where name=${\qquote $1}") or fehler "Descr '$1:$2'"/eg;
	$text =~ s/%DESCR%([^%]+)%([^%]+)%/find_descr($1,$2) or fehler "Descr '$1:$2'"/eg;
	$text =~ s/%DESCRS%([^%]+)%([^%]+)%/dlist($1,$2)/eg;
	$text =~ s/%DIENST%([^%]+)%/find_dienst($1) or Do("insert into dienst set name='$1',info='beim Testen angelegt'")/eg;
	$text =~ s/%DOMAIN%([^%]+)%/DoFn("select id from domainkunde where domain = ${\qquote $1} and ende is null") or fehler "Domain '$1'"/eg;
	$text =~ s/%IPNR%([^%]+)%/Dbase::IP->new($1)->dbs/eg;
	$text =~ s/%IPNR_I%([^%]+)%/Dbase::IP->new($1)->dbi/eg;
	$text =~ s/%KUNDE%([^%]+)%/get_kunde($1) or fehler "kunde '$1'"/eg;
	$text =~ s/%PERSON%([^%]+)%/get_person($1) or fehler "Person '$1'"/eg;
	$text =~ s/%QUEUE%([^%]+)%/DoFn("select id from queue where name = ${\qquote $1}") or fehler "Queue '$1'"/eg;
	$text =~ s/%TARIF%([^% ]+)%([^% ]+)%/DoFn("select tarifklasse.id from tarifklasse,tarifname where tarifklasse.kunde=${\name_kunde '$2'} and tarifklasse.tarifname=tarifname.id and tarifklasse.tarifname='$1'") or fehler "KTarif '$1\/$2'"/eg;
	$text =~ s/%TARIF%([^% ]+)%/DoFn("select tarifklasse.id from tarifklasse,tarifname where tarifklasse.kunde is NULL and tarifklasse.tarifname=tarifname.id and tarifname.name='$1'") or fehler "KTarif '$1\/-'"/eg;
	$text =~ s/%TARIFNAME%([^%]+)%/DoFn("select id from tarifname where name='$1'") or Do("insert into tarifname set name='$1'")/eg;
	$text =~ s/%SEQ%([^%]+)%/DoSeq($1) or fehler "Seq '$1'"/eg;
	$text;
}

1;
