=head1 Dbase::KundeTest

Hilfsfunktionen zum Testen der Kundenfunktionen.

Nur in einer Testumgebung verwendbar!

=head2 Funktionen

=over 4

=item okK(@)

"Startet" das Kundeprogramm mit den gegebenen Arraywerten als Ausgabe.
Codereferenzen in dieser Array werden ausgeführt.

Der Rückgabewert sind sämtliche Druck-Ausgaben des Programms.

Es wird geprüft, ob der Aufruf keinen Fehler getriggert hat, keine
Probleme aufgetreten sind, und die Argumente im kunde-Programm keinen
Wechsel der Aufrufhierarchie verursacht haben.

Die Funktion erhöht die Zahl der durchgeführten Tests um 1.


=item okP (ListenCMD Feld SetzCMD [ Wert neuerWert ]... Wert?)

Analysiert, dass das wiederholte Setzen eines Parameters an einer Stelle
im Kundeprogramm in der resultierenden Liste den entsprechenden Erfolg
hat.

Äquivalent zu der nervig zu tippenden Folge

	$txt = okK (ListenCMD)
	like $txt,/^Feld: Wert$/m
	okK SetzCmd,neuerWert
	...

'undef' als Wert prüft, dass die betreffende Zeile nicht existiert.

'=' als Wert recycelt neuerWert zum Prüfen, damit man den nicht zweimal
tippen muss.

'|' wird als (in der Ausgabe entsprechend formatierter) Zeilenumbruch
interpretiert.


=item kunde($input &code)

Führt den übergebenen Code an dieser Stelle im Kunde-Programm aus.
Annahme: Mit einem I<Return> kommt man aus der Menuebene wieder heraus.

Die Funktion erhöht die Zahl der durchgeführten Tests nicht.

Anwendung:

	kunde($kundennr, sub {
		my $kundeninfo = okK("l");
		... Tests am Kunden ...
		kunde("d", sub {
			kunde($domainnr, sub {
				my $domaininfo = okK("l");
				... Tests an dieser Domain ...
			});
		});
	});

=item kunde_at($wo)

Verifiziere, dass der nächste Input von der bezeichneten Funktion
ausgeführt wird. Beispiel:

	kunde_test("POP", kunde_at("edit_kunde"), "","");

Die Funktion erhöht die Zahl der durchgeführten Tests um 1.

=item kunde_problem($was)

Verifiziert, dass es einen Problem-Text gibt, der '$was' matcht.

Die Funktion erhöht die Zahl der Tests um 1.

=item kunde_kein_problem($was)

Verifiziert, dass es keinen Problem-Text gibt, der '$was' matcht.

Die Funktion erhöht die Zahl der Tests um 1.

=item kunde_mails($was)

Die Funktion liefert einen numerischen Wert (Zahl der gefundenen Matches)
zurück.

C<$was> kann sein:

=over 4

=item qr//

Suche im Body.

=item [Adr]

Suche nach Mails mit einer dieser Adressen als Ziel.

Die Adressen werden als regexp interpretiert.

=item Adr

Suche nach Mails mit einer dieser Adressen als Absender.

Die Adresse wird als regexp interpretiert.

=back

=back

=head2 Variablen

=over 4

=item $Db::test_input

Array-Ref, aus dem alle Eingaben ins Kundeprogramm kommen.

=item $Db::test_output

Filehandle, an den alle Ausgaben ans Kundeprogramm geschickt werden.

=item $Db::test_mails

Array-Ref mit Mails, die hier gespeichert werden, anstelle im sendmail
zu landen

=back

=cut

package Dbase::KundeTest;
use utf8;
use strict;
use warnings;
use Test::More;
use Loader qw(edit_kunden);
use IO::String;
use Fehler qw(@fehler fehler warnungen probleme);

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(kunde kunde_sub okK okP kunde_at kunde_warnung kunde_problem);

my $outdata="";
my $outfile=IO::String->new($outdata);

sub argfilter($);
sub argfilter($) {
	my($arg)=$_;
	return () unless defined $arg;
	if(ref $arg) {
		return join(" ", map { argfilter $_ } @$arg)
			if ref $arg eq "ARRAY";
		return "<".ref($arg).">";
	};
	return "<".length($arg).">" if $arg =~ /\n/;
	return "'$arg'";
}

sub seqfilter($) {
	my($arg)=$_;
	return "-empty-" unless defined $arg;
	if(ref $arg) {
		return join(" ", map { argfilter $_ } @$arg)
			if ref $arg eq "ARRAY";
		return "<".ref($arg).">";
	};
	return "<".length($arg).">" if $arg =~ /\n/;
	return "'$arg'";
}

my @kbase=();
my @kback=("");
sub okK(@) {
	fehler "rekursiver Aufruf" if ref $Db::test_input;
	my @err;
	my $args1 = join(" ", map { argfilter $_ } @kbase);
	my $args2 = join(" ", map { argfilter $_ } @_);
	my $args3 = join(" ", map { argfilter $_ } @kback);
	my $args = "$args1|$args2|$args3";
	print "# *** Kunde *** $args ***\n";

	$Db::test_input = [ @kbase,@_,@kback ];
	$Db::test_output = $outfile;
	$Db::test_mails = [];
	$outfile->setpos(0);
	$outdata="";

	my $test = sub {
		edit_kunden(2,"");
		return ();
	testfehler:
		return @fehler;
	};
	@err = &$test();

	push(@err,"** Eingabe nicht abgearbeitet",@$Db::test_input) if @$Db::test_input;

	warnungen { 1; };
	probleme { push(@err, "** Problem:",@_); 1; };

	$Db::test_input = undef;
	$Db::test_output = undef;
	is(scalar @err,0,"Kunde-Aufruf beendet".(@err?(", Fehler:\n# ".join("\n# ",@err)):"."));
	$outdata;
}

sub okP($$$@) {
	my($list,$feld,$cmd,@seq) = @_;

	fehler "rekursiver Aufruf" if ref $Db::test_input;
	my @err;
	my $args = join(" ", map { argfilter $_ } @kbase);
	my $argseq = join(" ", map { seqfilter $_ } @seq);
	print "# *** Kunde-Check *** $args | $list $feld $cmd | $argseq ***\n";

	my $test = sub {
		$Db::test_input = [ @kbase,@_,@kback ];
		$Db::test_output = $outfile;
		$Db::test_mails = [];
		$outfile->setpos(0);
		$outdata="";

		edit_kunden(2,"");
		return ();
	testfehler:
		return @fehler;
	};
	my @cmd = ();
	while(@seq and not @err) {
		my $arg = join(" ", map { argfilter $_ } @cmd,$list);
		@err = &$test($list);
		push(@err,"** Eingabe nicht abgearbeitet",@$Db::test_input) if @$Db::test_input;
		warnungen { 1; };
		probleme { push(@err, "** Problem:",@_); 1; };
		last if @err;

		my $want = shift @seq;
		if(defined $want) {
			if ($want eq "=") {
				$want = pop @cmd;
				$want = pop @$want while ref $want;
			}
			if(not ref $want) { # könnte auch ein qr// sein
				$want =~ s/\|/\\s*\\n\\s+:\\s/g or # Zeilenumbruch
				$want =~ s/^:/#\\d+:/ or # Eintrag '#123:bla': als ':bla'
				$want = qr/\Q$want\E/;
			}
			unless($outdata =~ /^$feld\s*:\s$want\s*$/m) {
				fail "Nach '$arg': will $feld $want: hat '$outdata'";
				goto out;
			}
		} else {
			if($outdata =~ /^$feld\s*:/m) {
				fail "Nach $arg: will kein $feld: hat '$outdata'";
				goto out;
			}
		}
		last unless @seq;

		@cmd = ($cmd, shift @seq);
		@err = &$test(@cmd);
		push(@err,"** Eingabe nicht abgearbeitet",@$Db::test_input) if @$Db::test_input;
		warnungen { 1; };
		probleme { push(@err, "** Problem:",@_); 1; };
		last if @err;
	}
	is(scalar @err,0,"Kunde-Test beendet".(@err?(", Fehler:\n# ".join("\n# ",@err)):"."));
out:
	$Db::test_input = undef;
	$Db::test_output = undef;
}

sub kunde($&) {
	my($front,$cmd) = @_;
	push(@kbase,$front);
	push(@kback,"");

	&$cmd;

testfehler:
	splice(@kbase,-1);
	splice(@kback,-1);
}

sub kunde_mails(;$) {
	my($was)=@_;
	my $nmatch=0;
	if(not defined $was) { # Anzahl
		return scalar @$Db::test_mails;
	} elsif(not ref $was) { # From:
		foreach my $m(@$Db::test_mails) {
			$nmatch++ if $m->[1] =~ /$was/;
		}
	} elsif(ref $was eq "Regexp") { # Body
		foreach my $m(@$Db::test_mails) {
			$nmatch++ if $m->[0] =~ $was;
		}
	} elsif(ref $was eq "ARRAY") { # To:
		ml: foreach my $m(@$Db::test_mails) {
			my @m = @$m; splice(@m,0,2);
			foreach my $a(@$was) {
				foreach my $adr(@m) {
					if($adr =~ /$a/) {
						$nmatch++;
						next ml;
					}
				}
			}
		}
	}
	return $nmatch;
}

sub kunde_at($);
sub kunde_at($) {
	my($wo) = @_;

	# im void-Kontext, d.h. das Statement "kunde_at BLA",
	# soll das Ganze eigentlich "okK kunde_at BLA" bedeuten.
	return okK kunde_at $wo if not defined wantarray;
	return sub {
		my $frame=0;
		my $fin = 0;
		while(1) {
			my($package, $filename, $line, $subroutine, $hasargs,
				$wantarray, $evaltext, $is_require, $hints, $bitmask)=caller($frame);
			unless(defined $filename) {
				fail "kunde_at: '$wo': nicht gefunden";
				return;
			}
			$subroutine =~ s/.*:://;
			if($fin) {
				is($subroutine,$wo,"at '$wo'");
				return;
			} elsif($subroutine eq "line_in") {
				$fin++;
			}
		} continue { $frame++; }
	};
}

sub kunde_warnung(;$) {
	my($content) = @_;
	my $fund=0;
	warnungen {
		return 0 if $fund;

		my $tx = "@_";
		if($tx =~ $content) {
			$fund++;
			pass "OK '$content' @_";
			return 1;
		}
		return 0;
	};
	fail "keine zu '$content' passende Warnung gefunden"
		unless $fund;
}

sub kunde_problem(;$) {
	my($content) = @_;
	my $fund=0;
	probleme {
		return 0 if $fund;

		my $tx = "@_";
		if($tx =~ $content) {
			$fund++;
			pass "OK '$content' @_";
			return 1;
		}
		return 0;
	};
	fail "kein zu '$content' passendes Problem gefunden"
		unless $fund;
}

sub kunde_keine_warnung(;$) {
	my($content) = @_;
	my $fund=0;
	warnungen {
		return 0 if $fund;

		my $tx = "@_";
		if($tx =~ $content) {
			$fund++;
			fail "'$content' @_";
			return 1;
		}
		return 0;
	};
	pass "OK: keine zu '$content' passende Warnung gefunden"
		unless $fund;
}

sub kunde_kein_problem(;$) {
	my($content) = @_;
	my $fund=0;
	probleme {
		return 0 if $fund;

		my $tx = "@_";
		if($tx =~ $content) {
			$fund++;
			fail "'$content' @_";
			return 1;
		}
		return 0;
	};
	pass "OK: kein zu '$content' passendes Problem gefunden"
		unless $fund;
}

1;
