use strict;
use utf8;
use warnings;

package Dbase::Hardware;

use Moose;
extends 'Dbase::Object';

use overload '""' => sub { shift->name },

  # zur Vermeidung von Endlos-Rekursion in Class::MOP::Attribute:
  bool => sub { 1 },
  ;

use constant _attributes => {
    klasse => { bless => [ qw/Dbase::Descr descr hardware_klasse id/ ] },
    name   => {},
    status => { bless => [ qw/Dbase::Descr descr hardware_status id/ ] },
    typ    => { bless => [ qw/Dbase::Descr descr hardware_typ    id/ ] },
};

has text => (
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        no warnings 'once';
        require Loader and Loader->import(qw/list_hardware lister/)
          unless defined &list_hardware && defined &lister;
        lister(5);
        list_hardware( $self->id );
        lister(0);
        $Db::output;
    },
);

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is   => 'rw',    # w für Attribute, die in Objekte umgewandelt werden
        lazy => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}
while ( my ( $attr, $def ) = each %{ __PACKAGE__->_attributes } ) {
    defined( my $bless = $def->{bless} ) or next;
    my ( $package, @args ) = @$bless;
    around $attr => sub {
        my ( $orig, $self ) = @_;
        my $value = $self->$orig;
        return $value if !defined $value || ref $value;
        eval "require $package";
        die $@ if length $@;
        $self->$orig( $package->new( @args, $value ) );
    };
}

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Hardware - Objekt, das ein Hardware-Objekt repräsentiert

=head1 SYNOPSE

  use Dbase::Hardware;
  my $hardware = Dbase::Hardware->new( id => 42 );
  my $text = $hardware->text;

=head2 KONSTRUKTOREN

=over 4

=item ->new( id => $kundennummer, [ name => $kundenname ] )

Anlegen eines neuen Hardware Objekts

=back

=head2 METHODEN

=over 4

=item ->id

zur Abfrage der Hardware-ID

=item ->text

zur Abfrage des in "Kunde" vordefinierten Texts

=item ->status

=item ->typ

zur Abfrage des Hardware-Status bzw. -Typs als L<Dbase::Descr>-Objekt

=back

