use strict;
use utf8;
use warnings;

package Dbase::Descr;

use Moose;

# Diese Klasse ist bewusst _nicht_ auf Basis von Dbase::Object, sondern
# auf Basis der Standard-Funktionen für Deskriptoren aus Dbase::Globals
# implementiert, damit wir nicht noch eine Baustelle mehr haben, wenn
# wir mal die Implementation der Deskriptorenlisten ändern wollen.
use Dbase::Globals qw/find_descr get_descr info_descr/;

use overload '""' => sub { shift->name },

  # zur Vermeidung von Endlos-Rekursion in Class::MOP::Attribute:
  bool => sub { 1 },
  ;

sub BUILD {
    my $self = shift;
    confess('Bei einem '
          . __PACKAGE__
          . '-Objekt muss mindestens die ID oder der Name angegeben werden' )
      unless $self->has_id || $self->has_name;
}

has descr => ( is => 'ro', isa => 'Str', required => 1 );

has id => (
    is      => 'rw',
    isa     => 'Int',
    lazy    => 1,
    default => sub {
        my $self = shift;
        find_descr( $self->descr, $self->name, 1 );
    },
    predicate => 'has_id',
);

has name => (
    is      => 'rw',
    isa     => 'Str',
    lazy    => 1,
    default => sub {
        my $self = shift;
        get_descr( $self->descr, $self->id );
    },
    predicate => 'has_name',
);

has info => (
    is      => 'rw',
    isa     => 'Str',
    lazy    => 1,
    default => sub {
        my $self = shift;
        info_descr( $self->descr, $self->id );
    },
    predicate => 'has_info',
);

1;
