#!/usr/bin/python

from __future__ import generators
import os
import sys

sys.path.insert(0,os.path.join(os.environ.get("POPHOME","@POPHOME@"),"lib"))

"""

This program runs a quick database command.

"""

from optparse import OptionParser,SUPPRESS_HELP

import string

parser = OptionParser(conflict_handler="resolve")
parser.add_option("-h","--help","-?", action="help",
                    help="gibt diesen Hilfstext aus")
parser.add_option("-v", "--variable-width", dest="var", action="store_true",
                    help="druckt variabel breite Spalten (Default: TAB)")
parser.add_option("-w", "--names", dest="write", action="store_true",
					help=SUPPRESS_HELP),
parser.add_option("-n", "--names", dest="names", action="store_true",
                    help="druckt Spaltennamen")
parser.add_option("-i", "--line-num", dest="nums", action="store_true",
                    help="druckt Spaltennummern")
parser.add_option("-d", "--conv-date", dest="date", action="store_true",
                    help="konvertiert Datumsangaben in der Ausgabe zu ISO")
parser.add_option("-D", "--keep-date", dest="nodate", action="store_true",
                    help="konvertiert ISO-Datum in der Eingabe NICHT")
parser.add_option("-s", "--database", dest="db",
                    help="verwende die Datenbank DB", default=None)

(opts, args) = parser.parse_args()

if args:
	def rdr():
		yield string.join(args," ")
else:
	def rdr():
		import readline
		try:
			readline.read_history_file(os.path.expanduser("~/.kunde_db_history"))
		except IOError:
			pass
		while 1:
			try:
				r = raw_input("DB> ")
			except EOFError:
				print ""
				r = ""
			if r == "":
				readline.write_history_file(os.path.expanduser("~/.kunde_db_history"))
				return
			yield r.rstrip()

import datetime as dt
from time import time
d1=1; d2=0
if opts.date:
	d1 = int(dt.date(1995,1,1).strftime("%s"))
	d2 = int(time())+356*24*3600

import re;
no_col=re.compile(r'(.+);?$')
empty=re.compile(r'^\s*$')
date=re.compile(r'\b(\d{4})-(\d{2})-(\d{2})(?:\s+(\d{2}):(\d{2})(?:\:(\d{2}))?)?\b')
select=re.compile(r'^\s*(?:select|show|explain)\b',re.I)
seq=re.compile(r'^\s*(?:seq)\s+(\S+)$',re.I)
with_lf=re.compile(r'\n')

from noris import Db
if opts.db:
	host = opts.db
else:
	host = "DATAHOST"
	if not opts.write:
		host += "2"

db=Db.Db(opts.db)

for cmd in rdr():
	r=no_col.match(cmd)
	if r:
		cmd=r.group(1)
	if empty.match(cmd):
		continue
	
	if not opts.nodate:
		def date2sec(mo):
			def nnone(xx):
				return (xx != None)
			return str(int(apply(Date,map(int,filter(nnone,mo.groups()))).ticks()))
		cmd=date.sub(date2sec,cmd)

#	$cmd =~ s/\bUK\((\d+,(\S+))\)/unterkunden($1,$2)/eg;
#	$cmd =~ s/\bUK\((\d+)\)/unterkunden($1)/eg;

	if select.match(cmd):
		try:
			count=1
			if opts.names:
				count=0
			if opts.var:
				rs=[]
				wd=None
				try:
					for res in db.DoSelect(cmd, _head=opts.names):
						res=list(res)
						if opts.nums:
							res.insert(0,count)
						if wd is None:
							wd=[0]*len(res)
						i=0
						for d in res:
							if (type(d)==int or type(d)==long) and d>=d1 and d<=d2:
								res[i]=d=str(dt.datetime.fromtimestamp(d))
							elif type(d)==str and with_lf.match(d):
								res[i]=d="<"+str(len(d))+">"
							elif d is None:
								res[i]=d="<NULL>"
							l=len(str(d))
							if wd[i]<l:
								wd[i]=l
							i=i+1
						rs.append(res)
						count=count+1
					for res in rs:
						of=None
						i=0
						for d in res:
							if of is None:
								of=""
							else:
								of=of+" "
							if type(d)==int or type(d)==long:
								of=of+"%%%dd" % wd[i]
							else:
								of=of+"%%-%ds" % wd[i]
							i=i+1
						print of % tuple(res)
				except Db.NoData:
					pass
			else:
				def strn(xx):
					if xx is None:
						return "<NULL>"
					return str(xx)

				try:
					for res in db.DoSelect(cmd, _head=opts.names):
						if opts.nums:
							res=list(res)
							res.insert(0,count)
						count=count+1
						print string.join(map(strn,res),"\t")
				except Db.NoData:
					pass

		except Db.NoData:
			print "...no data"
	elif seq.match(cmd):
		x=seq.match(cmd);
		cmd=x.group(1)
		if opts.names:
			print cmd
		print db.DoSeq(cmd)
		db.commit()
	else:
		res=db.Do(cmd)
		if opts.var:
			print res
		db.commit()
