#!/bin/bash

DESTDIR="$1"

ARCH="`uname -m`"
LIB_SUBDIR="linux"

if [ "x$DESTDIR" = "x" ]
then
	echo "Usage: $0 <DESTDIR>" >&2
	exit 1
fi

if [ "x$ARCH" = "xx86_64" ]
then
	LIB_SUBDIR="linux-64"
fi

mkdir -p "$DESTDIR"/usr/include
cp -r manage-ontap-sdk-3.5P1/include "$DESTDIR"/usr/include/netapp
rm -rf "$DESTDIR"/usr/include/netapp/openssl

mkdir -p "$DESTDIR"/usr/lib
cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libnetapp.so "$DESTDIR"/usr/lib/libnetapp.so.0.0.0
ln -s libnetapp.so.0.0.0 "$DESTDIR"/usr/lib/libnetapp.so.0
ln -s libnetapp.so.0 "$DESTDIR"/usr/lib/libnetapp.so
cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libnetapp.a "$DESTDIR"/usr/lib/

cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libadt.so "$DESTDIR"/usr/lib/libadt.so.0.0.0
ln -s libadt.so.0.0.0 "$DESTDIR"/usr/lib/libadt.so.0
ln -s libadt.so.0 "$DESTDIR"/usr/lib/libadt.so
cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libadt.a "$DESTDIR"/usr/lib/

cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libxml.so "$DESTDIR"/usr/lib/libxml.so.0.0.0
ln -s libxml.so.0.0.0 "$DESTDIR"/usr/lib/libxml.so.0
ln -s libxml.so.0 "$DESTDIR"/usr/lib/libxml.so
cp manage-ontap-sdk-3.5P1/lib/$LIB_SUBDIR/libxml.a "$DESTDIR"/usr/lib/

mkdir -p "$DESTDIR"/usr/lib/pkgconfig
cp netapp1.pc "$DESTDIR"/usr/lib/pkgconfig/
