//============================================================//
//                                                            //
// $ID$                                                       //
//                                                            //
// zexploreDlg.cpp                                            //
//                                                            //
// Main dialog for the zexplore application.                  //
//                                                            //
// Copyright 2002-2003 Network Appliance, Inc. All rights     //
// reserved. Specifications subject to change without notice. // 
//                                                            //
// This SDK sample code is provided AS IS, with no support or //
// warranties of any kind, including but not limited to       //
// warranties of merchantability or fitness of any kind,      //
// expressed or implied.  This code is subject to the license //
// agreement that accompanies the SDK.                        //
//                                                            //
// tab size = 4                                               //
//                                                            //
//============================================================//

#include "stdafx.h"
#include "zexplore.h"
#include "zexploreDlg.h"
#include "zapitab.h"
#include <netapp_api.h>

extern ZapiDesc		zapitab[];

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CZapisamp4Dlg dialog

//=====================================================================//
// 
// all the sample application functionality is in this file
//
//=====================================================================//


const int BUFSZ = 256;

static void replace(char* s, char src, char dst)
{
	while (s && *s) {
		if (*s == src)
			*s = dst;
		s++;
	}
}

static void remove_prefix(char*s, char* prefix)
{
	int preflen = strlen(prefix);

	if (strncmp(s, prefix, preflen) == 0) 
		strcpy(s, s+preflen);
}

//=====================================================================//

BOOL CZapisamp4Dlg::OnInitDialog()
{
	char	err[1024];
	CString connType;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	//
	// zapisamp stuff
	//
	chooseparams = (CStatic*) GetDlgItem(IDC_CHOOSE_PARAMS);
	labels[0] = (CStatic*) GetDlgItem(IDC_PARAM_1_LABEL);
	inputs[0] = (CEdit*) GetDlgItem(IDC_PARAM_1_EDIT);
	labels[1] = (CStatic*) GetDlgItem(IDC_PARAM_2_LABEL);
	inputs[1] = (CEdit*) GetDlgItem(IDC_PARAM_2_EDIT);
	labels[2] = (CStatic*) GetDlgItem(IDC_PARAM_3_LABEL);
	inputs[2] = (CEdit*) GetDlgItem(IDC_PARAM_3_EDIT);
	labels[3] = (CStatic*) GetDlgItem(IDC_PARAM_4_LABEL);
	inputs[3] = (CEdit*) GetDlgItem(IDC_PARAM_4_EDIT);
	labels[4] = (CStatic*) GetDlgItem(IDC_PARAM_5_LABEL);
	inputs[4] = (CEdit*) GetDlgItem(IDC_PARAM_5_EDIT);
	labels[5] = (CStatic*) GetDlgItem(IDC_PARAM_6_LABEL);
	inputs[5] = (CEdit*) GetDlgItem(IDC_PARAM_6_EDIT);
	labels[6] = (CStatic*) GetDlgItem(IDC_PARAM_7_LABEL);
	inputs[6] = (CEdit*) GetDlgItem(IDC_PARAM_7_EDIT);
	labels[7] = (CStatic*) GetDlgItem(IDC_PARAM_8_LABEL);
	inputs[7] = (CEdit*) GetDlgItem(IDC_PARAM_8_EDIT);

	apiname		= (CComboBox*) GetDlgItem(IDC_FN_COMBO);
	conntype	= (CComboBox*) GetDlgItem(IDC_CTYPE);
	username	= (CEdit*) GetDlgItem(IDC_USERNAME);
	password	= (CEdit*) GetDlgItem(IDC_PASSWORD);
	filername	= (CEdit*) GetDlgItem(IDC_FILER);

	output		= (CEdit*) GetDlgItem(IDC_OUTPUT_EDIT);
	error		= (CEdit*) GetDlgItem(IDC_ERROR_EDIT);

	conntype->AddString("HTTP");
	conntype->AddString("DCE/RPC");
	conntype->SetCurSel(conntype->FindString(0, "HTTP"));

	nzapis = 0;
	LoadApiList();
	LoadApiCCombo();

	chooseparams->ShowWindow(false);
	for (int i=0; i<8; i++) {
		labels[i]->ShowWindow(false);
		inputs[i]->ShowWindow(false);
	}
	
	apiname->SetCurSel(apiname->FindString(0, "system-get-version"));


	//
	// load a few "settings" from last session,
	// if available.  
	//

	_filername = AfxGetApp()->GetProfileString("conndata", "filername");
	if (_filername != "")
		filername->SetWindowText(_filername);

	_username = AfxGetApp()->GetProfileString("conndata", "username");
	if (_username != "")
		username->SetWindowText(_username);

	_conntype = AfxGetApp()->GetProfileString("conndata", "conntype");
	if (_conntype != "")
		conntype->SetWindowText(_conntype);
	
	conntype->GetWindowText(connType);

	if(connType == "DCE/RPC")
	{
		password->EnableWindow(false);
		username->EnableWindow(false);
	}

	//
	// One-time startup - this should be executed once at the
	// beginning of any process that wants to use the Netapp APIs.
	//
	if ( ! na_startup(err,sizeof(err)) ) {
		MessageBox(err, "Error", MB_ICONERROR);
		OnCancel();
	}



	return TRUE;  // return TRUE  unless you set the focus to a control
}

//=====================================================================//

void CZapisamp4Dlg::OnOK() 
{
	na_server_t * s;
	char err[BUFSZ];
	CString	wbuf;
	char*	buf = NULL;
	char*	dosbuf = NULL;
	int use_rpc = 1;
	int i, j, n, siz;

	na_elem_t *ielt;
	na_elem_t *oelt;
	const char *r;

	filername->GetWindowText(_filername);
	username->GetWindowText(_username);
	password->GetWindowText(_password);
	conntype->GetWindowText(_conntype);

	//
	// do all this with a wait cursor
	//
	{
		CWaitCursor	wait;

		error->SetWindowText("");
		output->SetWindowText("");
		AfxGetApp()->GetMainWnd()->RedrawWindow();

		//
		// Initialize the things necessary to talk to a given host.
		// Multiple calls to this can be made (for the same, or different
		// hosts).    Each call to this should be accompanied by
		// a corresponding call to na_server_close() when the host
		// is no longer needed, to free up (minimal) resources.
		//
		s = na_server_open(_filername,1,1);	// zapi v1.1

		if (strcmp(_conntype, "DCE/RPC") == 0) {
			na_server_style(s, NA_STYLE_RPC);
		} else {
			/*
			 * This established the administrative user login name (usuall
			 * "root") and password to be used to authenticate.
			 */
			na_server_style(s, NA_STYLE_LOGIN_PASSWORD);
			na_server_adminuser(s, _username, _password);
		}

		apiname->GetWindowText(wbuf);
		for(n=0; n<nzapis; n++) {
			if (strcmp(zapis[n].fname, wbuf) == 0)
				break;
		}

		//
		// construct the function call
		//
		ielt = na_elem_new(zapis[n].fname);

		//
		// add the input arguments, if any
		//
		for(i=0; i<zapis[n].nargs; i++) {
			inputs[i]->GetWindowText(_inputs[i]);
			if (strcmp(_inputs[i], "") != 0) {
				na_child_add_string(ielt, zapis[n].args[i].argname, _inputs[i]);
			}
		}

		//
		// invoke the function
		//
		oelt = na_server_invoke_elem(s,ielt);

		//
		// get results and check for errors
		//
		r = na_results_reason(oelt);
		if ( r != NULL ) {
			strncpy(err,r,BUFSZ);
			error->SetWindowText(err);
		}

		//
		// print up the results in reasonably readable format
		//
		buf = na_elem_sprintf(oelt);

		//
		// convert to DOS format.  Every character
		// could be a newline in the worst case, so
		// allocate a buffer twice as big as buf.
		//
		siz = strlen(buf) + 1;

		dosbuf = (char*) malloc(siz*2);

		for(i=0, j=0; i<siz; i++) {
			if (buf[i] == '\n') {
				dosbuf[j++] = '\r';
				dosbuf[j++] = '\n';
			}
			else 
				dosbuf[j++] = buf[i];
		}

		output->SetWindowText(dosbuf);
	}

	free(buf);
	free(dosbuf);
}

//=====================================================================//

int CZapisamp4Dlg::LoadApiList()
	//
	// The indirection here is so that the format of
	// the automatically generated file zapitab.cpp
	// can change without requiring a lot of change
	// to this code.
{
	int		currzapi = 0;
	int		currarg = 0;
	ZapiDesc*	zptr = zapitab;

	while (zptr->item[0] != 0) {
		strcpy(zapis[currzapi].fname, zptr->item);
		replace(zapis[currzapi].fname, '_', '-');
		remove_prefix(zapis[currzapi].fname, "zapi-");
		zptr++;
		currarg = 0;
		
		while((zptr->item[0] != 0) && (zptr->elttype != ZAPIFUNC)) {
            if (zptr->elttype != Z_OUTPUT) {
				strcpy(zapis[currzapi].args[currarg].argname, zptr->item);
				replace(zapis[currzapi].args[currarg].argname, '_', '-');
				strcpy(zapis[currzapi].args[currarg].argtype, zptr->typestring);
				if (zptr->elttype == Z_OPTIONAL)
					zapis[currzapi].args[currarg].optional = 1;
				zapis[currzapi].nargs++;
			}
			currarg++;
			zptr++;
		}
		currzapi++;
	}
	nzapis = currzapi + 1;

	return 1;
}

//=====================================================================//

int CZapisamp4Dlg::LoadApiCCombo(void)
{
	// apiname->ResetContent();

	for(int i=0; i<nzapis; i++) {
		apiname->AddString(zapis[i].fname);
	}
	return 1;
}

//=====================================================================//



void CZapisamp4Dlg::OnSelendokCtype() 
{
	char	buf[BUFSZ];

	int	n = conntype->GetCurSel();
	conntype->GetLBText(n, buf);

	if (strcmp(buf, "HTTP") == 0) {
		password->EnableWindow(true);
		username->EnableWindow(true);
	}
	else {
		password->EnableWindow(false);
		username->EnableWindow(false);
	}
}

//=====================================================================//

void CZapisamp4Dlg::OnSelendokFnCombo() 
{
	char	s[256];
	
	int	n = apiname->GetCurSel();
	apiname->GetLBText(n, s);
	//
	// find the relevant function info for the selected api name
	//
	for(int i=0; i<nzapis; i++) {
		if (strcmp(s, zapis[i].fname) == 0) {

			//
			// show the labels and edit controls
			// for each of the function inputs
			//
			for(int j=0; j<zapis[i].nargs && j<8; j++) {
				char	str[256];

				strcpy(str, zapis[i].args[j].argname);
				strcat(str, " (");
				strcat(str, zapis[i].args[j].argtype);
				if (zapis[i].args[j].optional) 
					strcat(str, ", optional)");
				else
					strcat(str, ")");
				labels[j]->SetWindowText(str);
				inputs[j]->SetWindowText("");

				labels[j]->ShowWindow(true);
				inputs[j]->ShowWindow(true);

			}

			//
			// hide the rest
			//
			for(j=zapis[i].nargs; j<8; j++) {
				labels[j]->ShowWindow(false);
				inputs[j]->ShowWindow(false);
			}

			chooseparams->ShowWindow(zapis[i].nargs > 0);
		}
	}
}

//=====================================================================//

void CZapisamp4Dlg::OnCancel() 
{
	filername->GetWindowText(_filername);
	username->GetWindowText(_username);
	conntype->GetWindowText(_conntype);

	AfxGetApp()->WriteProfileString("conndata", "filername", _filername);
	AfxGetApp()->WriteProfileString("conndata", "username",  _username);
	AfxGetApp()->WriteProfileString("conndata", "conntype",  _conntype);

	CDialog::OnCancel();
}


//=====================================================================//
//
// rest of file is auto-generated
//
//=====================================================================//

CZapisamp4Dlg::CZapisamp4Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CZapisamp4Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CZapisamp4Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CZapisamp4Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZapisamp4Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CZapisamp4Dlg, CDialog)
	//{{AFX_MSG_MAP(CZapisamp4Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELENDOK(IDC_FN_COMBO, OnSelendokFnCombo)
	ON_CBN_SELENDOK(IDC_CTYPE, OnSelendokCtype)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CZapisamp4Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CZapisamp4Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CZapisamp4Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


