/*
 * $Id:$
 *
 * apitest.java
 * Copyright (c) 2001-2007 Network Appliance, Inc.
 * All rights reserved.
 *
 * Sample for using the netapp.manage.* classes to 
 * any ONTAPI API
 */
import netapp.manage.*;
import java.io.*;
import java.lang.*;
import java.io.StringReader;


public class apitest {

	public static void usage(){
		System.out.println("\nUsage:\n\tapitest (options) <host> <user> "
			+ "<password> <ONTAPI-name> [<paramname> <arg> ...]\n");
		System.out.println("Options:\n");
		System.out.println("\t-i\tAPI specified as XML input, on the command line\n");
		System.out.println("\t-I\tAPI specified as XML input, on standard input\n");
		System.out.println("\t-t {type}\tServer type(type = filer, dfm, agent)\n");
		System.out.println("\t-v {vfiler name}\tVfiler name, if the API has to be executed"
			+ "in the context of a vfiler \n");
		System.out.println("\t-r\tUse RPC transport (Windows)\n");
		System.out.println("\t-s\tUse SSL\n");
		System.out.println("\t-p\t{port}\n");
		System.out.println("\t-x\tShow the XML input and output\n");
		System.out.println("\t-X\tShow the raw XML input and output\n");
		System.out.println("\t-h\tUse Host equiv authentication mechanism."
			+ "Do not provide username, password with -h option\n");
		System.out.println("Examples:\n");
		System.out.println("\tapitest sweetpea root tryme "
			+ "system-get-version");
		System.out.println("\n\tapitest amana root meat quota-report volume vol0\n");
		System.exit(1);
	}
	public static void main(String[] args) {
		NaElement xi=null;
		NaElement xo;
		NaServer  s;
		String    server_type,user,password;
		int       argcnt=0,index,i=0,ind = 1,showxml = 0;
		String    read_xml="";
		boolean   dorpc,dovfiler,dofiler,dodfm,doagent,dossl,host_equiv;
		int       inputxml=0,use_port=-1;
		String    Cur_Line,vfiler_name=null,platform_type;

		dofiler=dodfm=doagent=dorpc=dovfiler=dossl=host_equiv=false;

		if ( args.length < 3 ) 
			usage();

		index=args[0].indexOf('-');
		while (args[argcnt].startsWith("-")){
			switch (args[argcnt].charAt(ind)) {
				case 'i':
					inputxml = 1;
					argcnt++;
					break;
				case 'I':
					inputxml = 2;
					argcnt++;
					break;
				case 't':
					server_type = args[argcnt+1];
					if (server_type.equals("dfm")) 
						dodfm = true;
					else if (server_type.equals("agent")) 
						doagent = true;
					else if (server_type.equals("filer")) 
						dofiler  = true;
					argcnt = argcnt + 2;
					break;
				case 'v':
					vfiler_name = args[argcnt+1];
					dovfiler = true;
					argcnt = argcnt + 2;
					break;
				case 'r':
					platform_type = (System.getProperty("os.name"));
					if(!platform_type.matches("(?i).*windows .*")){
						System.out.println("-r is valid only on windows\n");
						System.exit(1);
					}
					dorpc = true;
					argcnt++;
					break;
				case 's':
					dossl = true;
					argcnt++;
					break;
				case 'p':
					use_port = Integer.parseInt(args[argcnt+1]);
					argcnt = argcnt + 2;
					break;
				case 'x':
					showxml = 1;
					argcnt++;
					break;
				case 'X':
					showxml = 2;
					argcnt++;
					break;
				case 'h':					
					host_equiv = true;
					argcnt++;
					break;
				default:
					System.out.println("\nERROR::Invalid Option");
					usage();
				}
		}

		if ( (args.length < 4) && (host_equiv == false)) 
			usage();
		
		if(dodfm && dovfiler) {
			System.out.println("The -v option is not a valid option for dfm\n");
			System.exit(1);
		}
		if(dodfm && dorpc) {
			System.out.println("The -r option is not a vaid option for dfm\n");
			System.exit(1);
		}
		if(host_equiv && dorpc) {
                	System.out.println("Invalid usage of authentication style. "
                                + "Do not use -r option and -h option together.\n");
			System.exit(1);
        	} 
		/* Set the port to the host type specified */
		if (use_port == -1) {
			if (dodfm)
				use_port = (dossl) ? 8488 : 8088;
			else if (doagent)
				use_port = (dossl) ?  4093 : 4092;
			else
				use_port = (dossl) ? 443 : 80;
		}
		try {
				/* Vfiler tunnelling requires ONTAPI version 7.0 to work */ 
				/* 
				 * NaServer is called to connect to servers and invoke API's.
				 * The argument passed should be: 
				 * NaServer(hostname, major API version number, minor API version number
				 */
				if (vfiler_name != null)
					s = new NaServer(args[argcnt], 1, 7);
				else
					s = new NaServer(args[argcnt], 1, 0);

				/* This is needed for -X option */
				if (showxml == 2)
					s.setSnoop(-1);

				/* Set the authentication style for subsequent ONTAPI authentications.*/
				if (dorpc)
					s.setStyle(NaServer.STYLE_RPC);
				else if(host_equiv){
					s.setStyle(NaServer.STYLE_HOSTSEQUIV);
				}
				else
					s.setStyle(NaServer.STYLE_LOGIN_PASSWORD);

				/* 
				 * Set the login and password used for authenticating when 
				 * an ONTAPI API is invoked.
				 * When host_equiv is set do not set username and password
				 */
				if(!host_equiv){
					user = args[++argcnt];
					if (args.length == argcnt+1) {
						System.out.println("\nInsufficient Arguments Passed");
						usage();
					}
					password = args[++argcnt];
					s.setAdminUser(user, password);
				}
				
				/* Set the TCP port used for API invocations on the server.*/
				s.setPort(use_port);

				/* Set the Type of API Server */
				if (dodfm)
					s.setServerType(NaServer.SERVER_TYPE_DFM);
				else if (doagent)
					s.setServerType(NaServer.SERVER_TYPE_AGENT);
				else if (dossl)
					s.setTransportType(NaServer.TRANSPORT_TYPE_HTTPS);
				else
					s.setServerType(NaServer.SERVER_TYPE_FILER);

				/* Set the name of the vfiler on which the API commands need to be invoked. */
				if (vfiler_name != null)
					s.setVfilerTunneling(vfiler_name);
				
				if (inputxml > 0){
					if (inputxml == 2) {
						if(args.length-1 > argcnt) {
							System.out.println("The -I option expects no API "
							+"on the command-line, "+"it expects standard input\n");
							usage();
						}
						/* Read the input from standard in. */
						InputStreamReader converter = new InputStreamReader(System.in);
						BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
						while ((Cur_Line = in.readLine()) != null)
							read_xml = read_xml+Cur_Line;
					}
					else {
						if (args.length == argcnt+1) {
							System.out.println("API not specified");
							usage();
						}
						for ( int cnt = argcnt+1; cnt < args.length; cnt++) 
							read_xml = read_xml + args[cnt];
					}
					args=null;
					args = read_xml.split(" |\n");
					read_xml = "";
					for ( int cnt = 0; cnt < args.length;cnt++) 
						if (!(args[cnt].matches("\t")||args[cnt].matches(" ")))
							read_xml = read_xml + args[cnt];
					args=null;
					args = read_xml.split("\t|\n");
					argcnt = -1;
				}
				/* Invoke any  ONTAPI API with arguments
				 * in (key,value) pair 
				 * args[0]=filer,args[1]=user,args[2]=passwd
				 * args[3]=Ontapi API,args[4] onward arguments
				 * in (key,value) pair
				 */
				if (inputxml > 0) 
					xi = s.getXMLParseInput(args[++argcnt]);
				else 
					xi = new NaElement(args[++argcnt]);
				try {
					if(args.length > argcnt+1) {
						for(int index2=argcnt+1;index2<
							args.length;index2++){
							xi.addNewChild(args[index2],args[index2+1]);
							index2++;
						}
					}
				}
				catch(ArrayIndexOutOfBoundsException e) {
					throw new NaAPIFailedException(-1,
						"Mismatch in arguments passed "
						+ "(in (key,value) Pair) to "
						+ "Ontapi API" );
				}
				if (showxml == 1) {
					System.out.println("INPUT:\n"+xi.toPrettyString(""));
				}
				/* Invoke a single ONTAPI API */
				xo = s.invokeElem(xi);
				if (showxml != 2)
					System.out.println("OUTPUT:\n"+xo.toPrettyString(""));
	                        s.close();
		}
		catch( NaAPIFailedException e) {
			System.err.println(e.toString());
			System.exit(1);
		}
		catch (Exception e) {
			System.err.println(e.toString());
			System.exit(1);
		}
	}
}
