package Output;

use warnings;
use strict;

use 5.006_000; use 5.6.0; 

use Carp::Heavy;

#me
use Carp; 
use Data::Dumper;

#me
#me
#me
#me
#me
#me
#me
#me

#me
use Text::Wrap qw($columns &wrap &fill);
local $Text::Wrap::unexpand = 0; #me	 	              
            #me
            #me

use NagTools2 2.3.4 qw( 
    :debug
    commify	 	              
    :special_chars
    :nagios
);

#me
#me
#me
#me
#me
#me
#me

use version; our $VERSION = qv('2.3.1');

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

our @EXPORT_OK = qw( 
    cut_message
);
use base qw(Exporter);

#me
#me
#me

sub new {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($class, %args) = @_;
    my $self = {};                  #me
    bless($self, $class);
    

    $self->{'_p'} = $args{'p'}
        or croak ('missing argument p (ref to N::P-object)');
    
    $self->{'_ai'} = $args{'ai'};    #me
    if ( not defined $self->{'_ai'} ) {
        $self->{'_ai'} = "$BLANK" x $NAGIOS_ARG_INDENT;
    }
    

    $self->_add_args($self->{'_p'});	 	              

    #me
    #me
    $self->{$OK} = [ ];
    $self->{$WARN} = [ ];
    $self->{$CRIT} = [ ];
    return $self;
}

sub set_format {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($self, %args) = @_;
    my $p = $self->{'_p'};
    

    my $args_allowed = {
        sort_criterion => {
            default => undef,   #me
            allowed => [
                'name',
                'val',
                'status',
            ]
        },
        sort_order => {
            default => undef,   #me
            allowed => [
                'ascending',
                'descending',
            ]
        },
        show_status => {
            default => undef,   #me
            allowed => [
                'not_ok',
                'all',
                'none',
            ]
        },
        color => {
            default => 0,   
            allowed => [
                1,
                0,
            ]
        },
        progname => {
            default => undef,   #me
            pattern => qr{^[a-zA-Z0-9_-\ \.]{1,128}$},
        },
        precision => {
            default => 1,
            pattern => qr{^[0-9]{1}$},
        },
        key_value_seperator => {
            default => ': ',   
            pattern => qr{^.{0,10}$},
        },
        line_break => {
            default => "\n",
            pattern => qr{^.{0,10}$},
        },
        svc_output_seperator => {
            default => "\n",
            pattern => qr{^.{0,10}$}s,
        },
        max_msg_length => {
            default => 4096,
            pattern => qr{^\d{1,5}$},
        },
        min => {
            default => 0,
            pattern => qr{^\d+$}, #me
        },
        max => {
            default => 10**32 - 1 ,
            pattern => qr{^\d+$}, #me
        },
    };
    
 
    foreach my $arg (keys %args) {
        if (exists $args_allowed->{$arg}) {
                $self->{'_args'}{$arg} = $args{$arg};
         } else {
                croak 'Unknown argument' . $BLANK . q{'} . $arg . q{'}
         }
    }
 
    ARG_CHECK: foreach my $this_arg (keys %{$args_allowed}) {
        #me
        if (not defined $self->{'_args'}{$this_arg}) {
            if (not defined $args_allowed->{$this_arg}{'default'}) {
                croak 'argument' . $BLANK . $this_arg
                                            . $BLANK . 'requires a value';
            }
            $self->{'_args'}{$this_arg} = $args_allowed->{$this_arg}{'default'};
        } else {
            if (defined $args_allowed->{$this_arg}{'pattern'}) {


                next ARG_CHECK if ($self->{'_args'}{$this_arg} =~ m/$args_allowed->{$this_arg}{'pattern'}/);
                croak $self->{'_args'}{$this_arg} . $BLANK 
                    . 'does not match the required pattern for arg' 
                    . $BLANK . "$this_arg"; 
            } else {
                foreach my $allowed (@{$args_allowed->{$this_arg}{'allowed'}}) {
                    next ARG_CHECK if ($self->{'_args'}{$this_arg} eq "$allowed" );
                }
                $p->nagios_die($self->{'_args'}{$this_arg} . $BLANK 
                    . 'is not an allowed string / number for arg' 
                    . $BLANK . "$this_arg" . $DOT . $BLANK 
                    . 'Valid values are: ' 
                    . commify(@{$args_allowed->{$this_arg}{'allowed'}}) . "\n"
                ); #me

                #me
                #me
                #me
                #me
                #me
                #me
            }
        }
    }
    return $self;
}

sub _add_args {
    
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $p = shift || croak 'undefined p (N::P-object)';
    my $ai = $self->{'_ai'};    #me
    

    $p->add_arg(
        spec    => 'sort_criterion=s',
        default => 'val',
        help =>
            wrap($EMPTY, $ai,
                'How to sort instances in the output of overall-checks.'
                . $BLANK . 'This does not influence the check logic.'
                . $BLANK . q{Can either be set to 'name' (sort by name of the instance), status (OK, WARN, CRIT) or 'val' (sort by value).}
                . $BLANK . q{Default: 'val'. See also --sort_order}
                )
    );

    $p->add_arg(
        spec    => 'sort_order=s',
        default => 'descending',
        help =>
            wrap($EMPTY, $ai,
                'Sort-order for instances in over-all checks. '
                . 'Can be \'ascending\' or \'descending\'. '
                . 'Default: \'descending\'. '
                )
    );

    $p->add_arg(
        spec    => 'show_status=s',
        default => 'not_ok',
        help =>
            wrap($EMPTY, $ai,
                'Whether or not and to which extend the status (OK, WARNING, CRITICAL) of each instance is printed in the output. '
                . q{Can be 'not_ok', 'all' or 'none'. } . "\n"
                . q{not_ok: Print the status only for WARNING and CRITICAL instances.} . "\n"
                . q{all: Print the status also for OK instances.} . "\n"
                . q{none: Do not print the status. } 
                . q{This may be usefull if you are using --color and therefore already see the status from the instances color.} . "\n"
                . q{Default: 'not_ok'.}
                )
    );

    $p->add_arg(
        spec    => 'show_problems',
        default => '',
        help =>
            wrap($EMPTY, $ai,
                'Wether or not the problem-instances are listed in the first line of the output. '
                . q{Default: false (not set)}
                )
    );
    
    $p->add_arg(
        spec => 'include|I=s@',
        help =>
        wrap($EMPTY, $ai,
            'Optional name of the instances that should be checked.'
            . ' If omitted all instances are checked, except of excluded ones'
            . ' (see --exclude).'
            . ' Can be repeated.'
            . q{ Can be a regular expression like 'bak\d*-sales_department'.}
            )
        , #me
    );

    $p->add_arg(
        spec => 'exclude|X=s@',
        help =>
        wrap($EMPTY, $ai,
            'Instances (volumes, aggregates) which should not be checked.'
            . ' Can be repeated for excluding more than one object.'
            . q{ Can be a regular expression like 'bak2010\d*'.}
            . "\n"
            . q{Logic: monitor that instance if ANY include-option AND NO exclude-option matches.}
            . q{In other words: exclude overides include.}
            )
        , #me
    );


     return $self;
}

sub add_val {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $name = shift    || croak('missing name');
    my $val = shift;    #me
    my $result = shift;
    my $uom = shift; #me
    my $max_belegung = shift; #me

    if (not defined $name or not defined $val) {
        croak 'FATAL ERROR: Name and value must be defined!'
    }
    push @{$self->{'instances'}}, { 'name'   => $name,
                                    'val'    => $val,
                                    'status' => $result,
                                    'uom'           => $uom,
                                    'max_belegung'  => $max_belegung,
                                   };
    push @{$self->{$result}}, $name; #me

    if (not defined $self->{'max'}{'val'}) {

        $self->{'max'}{'val'} = $val;
    }



    if ($val > $self->{'max'}{'val'}) {

        $self->{'max'}{'name'} = "$name";
        $self->{'max'}{'val'} = $val;
        $self->{'max'}{'uom'} = $uom;
        $self->{'max'}{'number_of_instances'}++;

    } elsif ($val == $self->{'max'}{'val'}) {
        if ($self->{'max'}{'number_of_instances'} == 0) {

            $self->{'max'}{'name'} = "$name";
            $self->{'max'}{'val'} = $val;
            $self->{'max'}{'uom'} = $uom;
            $self->{'max'}{'number_of_instances'}++;
        } else {
            $self->{'max'}{'name'} .= q{ / } . "$name";
            $self->{'max'}{'number_of_instances'}++;
        }
    }
    return $self;
}

sub set_object_name {
    

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    $self->{'object_name'}{'singular'} = shift;
    $self->{'object_name'}{'plural'} = shift;
    $self->{'object_name'}{'max_satz'} = shift;
    $self->{'object_name'}{'_max_in_summary'} = 1; #me
    if (defined $self->{'object_name'}{'max_satz'}) {
        if (defined $self->{'max'}{'val'}) {
            croak 'ERROR: Calling set_object_name twice would reset the max-value';
        }
        $self->{'max'}{'val'} = $self->{'_args'}{'min'}; #me
        $self->{'max'}{'number_of_instances'} = 0
               #me
             ; #me
    }
    return $self;
}

sub get_instance_message {

#me
#me
#me
#me
#me

    my $self = shift;
    my $msg = shift;
    my $DP = $self->{'_args'}{'precision'};
    my $checked_total = @{$self->{'instances'}};
    if ($checked_total != 1) {
        croak 'Checked instances should be 1 but is ' . $checked_total;
    };
    if (not defined $self->{'object_name'}) {
        croak 'undefined object_name - forgot to set_object_name()?'
    }
    $msg =~ s/O_NAME/$self->{'object_name'}{'singular'}/;
    $msg =~ s/I_NAME/$self->{'instances'}[0]{'name'}/;
    my $val_rounded = sprintf ("%.${DP}f", $self->{'instances'}[0]{'val'});
    $msg =~ s/I_VAL/$val_rounded/;
    $msg =~ s/I_UOM/$self->{'instances'}[0]{'uom'}/;
    $msg =~ s/I_MAX-BELEGUNG/$self->{'instances'}[0]{'max_belegung'} $self->{'instances'}[0]{'uom'}/;
    return $msg;
}

sub get_overall_message {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    

    my $msg;
    if ( not defined $self->{'instances'} ) {
        $msg = "No matching instances found. Check the --include / --exclude-patterns.";
        return $msg;
    } else {
        my $checked_total = @{$self->{'instances'}};
        my $checked_warning = @{$self->{$WARN}};
        my $checked_critical = @{$self->{$CRIT}};

        my $p = $self->{'_p'};
        my $dp = $self->{'_args'}{'precision'}; #me
        
        if ($checked_warning > 0 or $checked_critical > 0) {
            $msg = $checked_total . q{ } .  $self->{'object_name'}{'plural'} 
            . q{ checked, } . $checked_critical . q{ critical and } 
            . $checked_warning . q{ warning.};
        } else {
            $msg = $checked_total . q{ } .  $self->{'object_name'}{'plural'} 
            . q{ checked.};
        }
        if ($p->opts->show_problems) {

            my $crit = $EMPTY;
            my $warn = $EMPTY;
            INSTANCE: foreach my $i (@{$self->{'instances'}}) {

                if ( $i->{'status'} == $OK ) {
                    next INSTANCE;
                } elsif ( $i->{'status'} == $WARN ) {
                    $warn .= $BLANK . $i->{'name'} . '=' . sprintf ("%.${dp}f", $i->{'val'}) . $i->{'uom'};
                } elsif ( $i->{'status'} == $CRIT ) {
                    $crit .= $BLANK . $i->{'name'} . '=' . sprintf ("%.${dp}f", $i->{'val'}) . $i->{'uom'};
                } else {
                    croak 'Strange status >>' . $i->{'status'} . '<< for instance '
                        . $i->{'name'};
                }
            }


            if ("$crit" or "$warn") {

                $crit =~ s/^\ //;
                $warn =~ s/^\ //;
                $msg .= q{ Problem } . $self->{'object_name'}{'plural'} . '(' . "$crit";
                if ("$warn" and $crit) { $msg .= $BLANK };
                $msg .= $warn . ')';
            }
        } else {
            #me
            if (defined $self->{'max'} and $self->{'object_name'}{'_max_in_summary'}) {
                croak 'no max name' if not defined $self->{'max'}{'name'};
                croak 'no max val' if not defined $self->{'max'}{'val'};
                croak 'no max uom' if not defined $self->{'max'}{'uom'};
                $msg .= $BLANK . $self->{'object_name'}{'max_satz'} 
                . $self->{'max'}{'name'}
                . $BLANK . q{(} . sprintf ("%.${dp}f", $self->{'max'}{'val'}) 
                . $self->{'max'}{'uom'} . q{)}
                ;
            }
        }
        my $msg_long = $self->get_long_info();
        my $SLS = $self->{'_args'}{'svc_output_seperator'};
        return $self->_cut_message($msg . $SLS . $msg_long);
    }
    croak 'FATAL: unreachable code at l642';
}

sub get_overall_exit {

#me
#me
#me
#me
#me
#me
#me

    my $debug = $main::DEBUG;
    my $self = shift;
    
    #me
    if ( not defined $self->{'instances'} ) {
        return $UNKNOWN;
    }
    my $checked_total = @{$self->{'instances'}};
    my $checked_warning = @{$self->{$WARN}};
    my $checked_critical = @{$self->{$CRIT}};
    if ($debug > 0) {
        print {*STDERR} '$checked_warning: '  . $checked_warning  . "\n";
        print {*STDERR} '$checked_critical: ' . $checked_critical . "\n";
    }
    my $result = $UNKNOWN;
    if ($checked_critical > 0) {
        $result = $CRIT;
    } elsif ($checked_warning > 0) {
        $result = $WARN;
    } elsif ($checked_warning == 0 and $checked_critical == 0)  { #me
        $result = $OK;
    }
    return $result;
}

sub _cut_message {

#me
#me
#me
#me
#me
    
    my $self = shift;
    my $message = shift;
    
    my $max_length = $self->{'_args'}{'max_msg_length'};
    my $progname = $self->{'_args'}{'progname'}; # 'check_netapp'
    
    return cut_message($message, $max_length, $progname);
}

sub cut_message {

#me
#me
#me
#me
#me
#me
#me

    my ($message, $max_length, $progname) = @_;
    
    #me
    my $prefx_len = length($progname) - length('check_') + length('CRITICAL - ');
    my $postfx = q{[...]};  #me
    my $postfx_len = length("$postfx");

    if  ( length("$message")  > $max_length  - $prefx_len  ) {  
        $message =  sprintf "%s   $postfx",   
                        substr ( $message, 0,  
                                 $max_length - ($prefx_len  + $postfx_len)                                 
                               );                                
    }
    
    return $message;
}

sub get_long_info {
    my $self = shift;
    my $txt;    #me
    my $criterion = $self->{'_args'}{'sort_criterion'};
    my $sort_order = $self->{'_args'}{'sort_order'};
    
    #me
    #me
    if ($criterion eq 'name') {
        if ($sort_order eq 'ascending') {
            foreach my $i (sort {$a->{$criterion} cmp $b->{$criterion}} @{$self->{'instances'}}) {
                $txt .= $self->compose_instance_info($i);
            }
        } elsif ($sort_order eq 'descending') {
            foreach my $i (sort {$b->{$criterion} cmp $a->{$criterion}} @{$self->{'instances'}}) {
                $txt .= $self->compose_instance_info($i);
            }
        } else {
            croak 'Invalid sort-order:' . "$sort_order"; 
        }
    } elsif ($criterion eq 'val' or $criterion eq 'status') {
        if ($sort_order eq 'ascending') {
            foreach my $i (sort {$a->{$criterion} <=> $b->{$criterion}} @{$self->{'instances'}}) {
                $txt .= $self->compose_instance_info($i);
            }
        } elsif ($sort_order eq 'descending') {
            foreach my $i (sort {$b->{$criterion} <=> $a->{$criterion}} @{$self->{'instances'}}) {
                $txt .= $self->compose_instance_info($i);
            }
        } else {
            croak 'Invalid sort-order:' . "$sort_order"; 
        }
    } else {
        croak 'Invalid sort criterion: ' . "$criterion";
    }
    return $txt;
}

sub compose_instance_info {
    my $self = shift;
    my $i = shift;
    my $kv  = $self->{'_args'}{'key_value_seperator'};
    my $br  = $self->{'_args'}{'line_break'};
    my $dp = $self->{'_args'}{'precision'}; #me
    
    my $txt = $i->{'name'}                #me
    . $kv                                 #me
    . sprintf ("%.${dp}f", $i->{'val'})   #me
    . $i->{'uom'};                        #me
    
    #me
    my $status;
    if ($self->{'_args'}{'show_status'} ne 'none') {
        if ($self->{'_args'}{'show_status'} eq 'not_ok') {
            if ($i->{'status'} == $OK) {
                $status = $EMPTY;
            } elsif ($i->{'status'} == $WARN) {
                $status = 'warning';
            } elsif ($i->{'status'} == $CRIT) { 
                $status = 'critical';
            } else {
                croak 'ERROR: Invalid status';
            }
        } elsif ($self->{'_args'}{'show_status'} eq 'all') {
            if ($i->{'status'} == $OK) {
                $status = 'ok';
            } elsif ($i->{'status'} == $WARN) {
                $status = 'warning';
            } elsif ($i->{'status'} == $CRIT) { 
                $status = 'critical';
            } else {
                croak 'ERROR: Invalid status';
            };
        } else {
            croak 'FATAL: Invalid value for show_status';
        }

        if ($status ne $EMPTY) {
            #me
            $txt .= $BLANK . q{(} . uc("$status") . q{)}; 
        }
    }
    
    #me
    if ($self->{'_args'}{'color'}) {
        my $color;  #me


        if ($i->{'status'} == $OK) {
            $color = $D_QUOT . qq{$COLOR_OK} . $D_QUOT     #me
        } elsif ($i->{'status'} == $WARN) {
            $color = $D_QUOT . qq{$COLOR_WARN} . $D_QUOT   #me
        } elsif ($i->{'status'} == $CRIT) { 
            $color = $D_QUOT . qq{$COLOR_CRIT} . $D_QUOT   #me
        } else {
            croak 'ERROR: Invalid status';
        };

        $txt = qq{<font color=$color>} . $txt;
        $txt .= q{</font>};
    }
    
    $txt .= $br;                          #me
    
    return $txt;
}

sub change_format {
#me
#me
#me
#me
#me
#me
#me
#me
#me
    
    my ($self, %args) = @_;
    foreach my $arg (keys %args) {
        if (exists $self->{'_args'}{$arg}) {
            $self->{'_args'}{$arg} = $args{"$arg"};
        } else {
            croak 'arg does not exist in Output-object: ' . "$arg" 
                . ' (You may want to set this format with an other method first.)';
        }
    }
    return $self;
}

sub max_in_summary {
    
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    $self->{'object_name'}{'_max_in_summary'} = shift;
    croak 'Should be 1 or 0, undef is not allowed' if not defined $self->{'object_name'}{'_max_in_summary'};
    return $self;
}

1; #me
__END__

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me


