#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-h:-u:-p:",\%opts;

if (!defined $opts{'h'}) {
	&usage();
} elsif (!defined $opts{'u'}) {
	&usage();
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
	exit 1;
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn, $opts{'u'}, "$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql Server: $@\n";
	exit 2;
}

my $sth = $dbh->prepare("show slave status");
$sth->execute();

my @arg;

while (my @res = $sth->fetchrow_array()) {
	@arg = @res;
}

$sth->finish();
$dbh->disconnect();

if ($arg[10] eq "No" or $arg[11] eq "No") {
	print "Der Slaveprozess laeuft nicht mehr !!!\n";
	exit 2;
} elsif ($arg[6] == 0 or $arg[6] eq "" or !defined $arg[6]) {
	print "Es ist keine Logfile Position im Slave gegeben !!!\n";
	exit 2;
} elsif ($arg[5] eq "" or !defined $arg[5]) {
	print "Der Slave hat kein Binlogfile zum lesen der Aenderungen !!!\n";
	exit 2;
} elsif ($arg[1] eq "" or !defined $arg[1]) {
	print "Der Slave hat keinen Masterhost zum connecten\n";
	exit 2;
} elsif ($arg[2] eq "" or !defined $arg[2]) {
	print "Der Slave hat keinen User zum Connecten auf den Masterhost\n";
	exit 2;
} elsif ($arg[19] ne "") {
	print "Es ist ein Fehler in der Replikation aufgetreten: $arg[10]\n";
	exit 2;
} else {
	print "Alles OK\n";
	exit 0;
}



