#!/usr/bin/perl
use strict;
use Getopt::Std;

my %opts;
getopts ":-h",\%opts;

if (defined $opts{'h'}) {
	print "USAGE:\t$0\n";
	exit 1;
}

open(PROC, "ls /proc |");
	my @proc = <PROC>;
close(PROC);

my $myproc = 0;

foreach my $proc (@proc) {
	chomp $proc;
	if ($proc =~ /^\d+$/) {
		open(STAT, "< /proc/$proc/status");
			my @stat = <STAT>;
		close(STAT);
		my $nameline = $stat[0];
		chomp $nameline;
		my @statline = split(/\s+|\s/,$nameline);
		if ($statline[1] eq "mysqld") {
			$myproc++;
		}
	}
}

if ($myproc < 3) {
	print "Achtung es laufen nur noch $myproc mysql Prozesse !!!\n";
	exit 2;
} elsif ($myproc >= 3 and $myproc <= 100) {
	print "Alles OK: $myproc laufende mysql Prozesse\n";
	exit 0;
} elsif ($myproc >= 101 and $myproc <= 150) {
	print "Im Moment sind es ein paar viele mysql Prozesse: $myproc laufende mysql Prozesse\n";
	exit 1;
} elsif ($myproc >= 151) {
	print "Achtung es laufen zu viele mysql Prozesse: $myproc laufende mysql Prozesse\n";
	exit 2;
}
	

	
	
