package NNIS::MessageBus::Util;

use 5.014;
use strict;
use warnings;
use utf8;

use Scalar::Util qw(blessed reftype);

use Exporter qw(import);
our @EXPORT_OK = qw(deserialize_nmf);

sub deserialize_nmf {
    my ($nmf) = @_;

    my %objects;
    while ( my ( $k, $objs ) = each %{ $nmf->{'_objectset'} } ) {
        $objects{$k} = { map +( $_->{id}, $_ ), @$objs };
    }
    my @result;

    my $resolve_if_possible = sub {
        my $ref = shift;
        my $type = $ref->{_target};
        my $resolved = $objects{$type}{ $ref->{id} };

        if ($resolved && $ref->{_title}) {
            $resolved->{_title} ||= $ref->{_title};
        }
        return $resolved || $ref;
    };

    for my $ref ( @{ $nmf->{'_resultset'} } ) {
        my $obj  = $resolve_if_possible->( $ref );
        for my $k (keys %$obj) {
            my $v = $obj->{$k};
            if (!blessed($v) && ref($v) && reftype($v) eq 'HASH') {
                $obj->{$k} = $resolve_if_possible->($v);
            }
        }
        push @result, $obj;
    }
    return @result;
}

1;
__END__

=encoding UTF-8

=head1 NAME

NNIS::MessageBus::Util - Utilities for working with the Noris Message Format

=head1 SYNOPSIS

    use NNIS::MessageBus::Util qw(deserialize_nmf);

    my $arrayref = deserialize_nmf($nmf->{'nmf-body'});

=head1 AUTHOR

Moritz Lenz (mlenz@noris.de> for the noris network AG.

=cut
