package NNIS::MessageBus::MultiCondVar;

require AnyEvent;
our @ISA = ('AnyEvent::CondVar');

use 5.014;
use strict;
use warnings;

use Exporter qw(import);
our @EXPORT_OK = qw(multi_cv);

sub multi_cv {
    __PACKAGE__->new;
}

sub new {
    my $class = shift;
    $class->SUPER::new(cb => sub {
        my $cv = shift;
        for my $cb (@{ $cv->{_multi_cvs} }) {
            $cb->($cv);
        }
    });
}

sub add_cb {
    my ($self, @cbs) = @_;
    push @{ $self->{_multi_cvs} }, @cbs;
    if ($self->ready) {
        $_->($self) for @cbs;
    }
    $self;
}

sub cb {
    shift->add_cb(@_);
}

1;
