use 5.014;
use strict;
use warnings;
use AnyEvent;

sub aesleep {
    my $seconds = shift;
    my $tcv = AnyEvent->condvar;
    my $t = AnyEvent->timer(
        after   => $seconds,
        cb      => $tcv,
    );
    $tcv->recv();


}

my %timers;

my $cv = AnyEvent->condvar;
sub build_timer {
    my $id = shift;
    return AnyEvent->timer(
        after   => 2,
        cb      => sub {
            printf "Timer %s fired at %d s\n", $id, (time - $^T);
            $cv->send if $id == 1;
        },
    );
}

for my $id (0..1) {
    $timers{$id} = build_timer($id);
    aesleep(5);
}
$cv->recv;
