##
# $Id$
# 
# Copyright (c) 2015 Network Appliance, Inc.
# All rights reserved.
# 
# This file was generated at Jul 15, 2015 9:17:25 PM
##

package Ontap7ModeAPI;

use strict;

use constant FIELD_SCALAR => 0x0;
use constant FIELD_TYPEDEF => 0x1;
use constant FIELD_ARRAY => 0x2;
use constant FIELD_OPTIONAL => 0x4;
use constant FIELD_ENCRYPTED => 0x8;

my $APIS = {
    'aggr-add' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cache-raid-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'force-cache-size' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
            },
            'force-spare-pool' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-selection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'simulate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'upgrade-64bit-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
            'selected-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'selected-mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'upgrade-64bit-cookie' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggr-check-spare-low' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'is-spare-low' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-create' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'force-spare-pool' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ha-policy' => {
                'type' => 'ha-policy-type',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-mirrored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snaplock' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'language-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'raid-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'simulate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'spare-pool' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'striping' => {
                'type' => 'striping-type',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
            'selected-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'ontap-d'],
            },
            'selected-mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c'],
            },
        },
    },
    'aggr-destroy' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-get-filer-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'allowed-raidtypes' => {
                'type' => 'raidtype-info',
                'flags' => 3,
                'scope' => [],
            },
            'checksum-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'default-raidtype' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'max-named-disks-per-request' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'raidgroup-size' => {
                'type' => 'raidgroup-size-info',
                'flags' => 3,
                'scope' => [],
            },
            'root-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots-max' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-get-root-name' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'root-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'filter-attrs' => {
                'type' => 'filter-attrs-info',
                'flags' => 5,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregates' => {
                'type' => 'aggr-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-mediascrub-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'mediascrub-details' => {
                'type' => 'mediascrub-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-mirror' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'override-vfiler-ownership' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'victim-aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-modify-raid-type' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-offline' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-delay-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'unmount-volumes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-online' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-online' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'keep-same-uuid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-d'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-options-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'options' => {
                'type' => 'aggr-option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-rename' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-aggregate-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-restrict' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-delay-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'unmount-volumes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'scrub-details' => {
                'type' => 'scrub-detail-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-scrub-resume' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-start' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-stop' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-suspend' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-set-option' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-space-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregates' => {
                'type' => 'aggr-space-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-split' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-aggr-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'verify-details' => {
                'type' => 'verify-detail-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-verify-resume' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-start' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fix-plex' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'log-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-stop' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-suspend' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-force-takeover' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'disaster' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
        },
        'outputs' => {
        },
    },
    'cf-get-partner' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'partner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-giveback' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-hwassist-stats' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'hwassist-stats-abnormal-reboot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-bad-nvram-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-keep-alive' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-loss-of-heartbeat' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-post-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-cycle-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-cycle-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-loss' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-off-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-off-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-reset-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-reset-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-ss-mismatch' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-test' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-times-throttled' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-unknown-alerts' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-watchdog-reset' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'no-stats' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cf-hwassist-status' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'keep-alive-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-hwassist-inactive-corrective-action' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-inactive-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-ipaddr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'no-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-inactive-corrective-action' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-inactive-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-ipaddr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cf-negotiated-failover-disable' => {
        'category' => 'cf',
        'family' => ['ontap-c'],
        'inputs' => {
            'module' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-negotiated-failover-enable' => {
        'category' => 'cf',
        'family' => ['ontap-c'],
        'inputs' => {
            'module' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-negotiated-failover-status' => {
        'category' => 'cf',
        'family' => ['ontap-c'],
        'inputs' => {
            'module' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-service-disable' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cf-service-enable' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cf-status' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'current-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'current-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-interconnect-up' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'local-in-headswap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'new-partner-sysid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'node-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'partner-in-headswap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'takeover-failure-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-until-takeover' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cf-takeover' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cg-commit' => {
        'category' => 'cg',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'cg-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cg-delete' => {
        'category' => 'cg',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => ['ontap-c'],
            },
        },
        'outputs' => {
        },
    },
    'cg-start' => {
        'category' => 'cg',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => ['ontap-c', 'ontap-vserver', 'vfiler'],
            },
        },
        'outputs' => {
            'cg-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-hash-stat' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'include-filesize-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-flush-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'filesize-more-than-100mb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-0kb-to-10kb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-100kb-to-250kb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-10kb-to-100kb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-10mb-to-100mb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-1mb-to-10mb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filesize-range-250kb-to-1mb' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hashes-flashed-post-fifth-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hashes-flashed-post-first-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hashes-flashed-post-fourth-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hashes-flashed-post-second-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hashes-flashed-post-third-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-set-key' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'server-secret' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-homedir-path-get-for-user' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'homedir-path-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cifs-homedir-paths-get' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'homedir-paths' => {
                'type' => 'homedir-path-info',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'cifs-homedir-paths-set' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'homedir-paths' => {
                'type' => 'homedir-path-info',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'path-error' => {
                'type' => 'path-error-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'cifs-list-config' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'AD-site' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'DC-connection' => {
                'type' => 'connection-info',
                'flags' => 7,
                'scope' => [],
            },
            'DNS-domainname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'LDAP-connection' => {
                'type' => 'connection-info',
                'flags' => 7,
                'scope' => [],
            },
            'NetBIOS-domainname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'NetBIOS-servername' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'Windows-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain-controller-functionality' => {
                'type' => 'cifs-functional-level',
                'flags' => 4,
                'scope' => [],
            },
            'domain-functionality' => {
                'type' => 'cifs-functional-level',
                'flags' => 4,
                'scope' => [],
            },
            'forest-functionality' => {
                'type' => 'cifs-functional-level',
                'flags' => 4,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-nbalias-names-get' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'nbalias-names' => {
                'type' => 'nbalias-name-info',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'cifs-nbalias-names-set' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'nbalias-names' => {
                'type' => 'nbalias-name-info',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'cifs-session-list-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-session-list-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-sessions' => {
                'type' => 'cifs-session-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-session-list-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'login-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'login-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ou-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pdc-ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'site-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-setup-create-group-file' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-setup-create-passwd-file' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'default-root-password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-setup-ou-list-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-setup-ou-list-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-setup-ous' => {
                'type' => 'cifs-setup-ou',
                'flags' => 2,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup-ou-list-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'domain-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'login-password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
            'login-user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup-site-list-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-setup-site-list-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-setup-sites' => {
                'type' => 'cifs-setup-site',
                'flags' => 2,
                'scope' => [],
            },
            'default-site' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup-site-list-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'domain-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'login-password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
            'login-user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'default-site' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup-verify-name' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'login-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'login-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pdc-ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-in-domain' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-setup-verify-passwd-and-group' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'group-file-exists' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'passwd-file-exists' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'required' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-ace-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'is-unixgroup' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unix-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-ace-set' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'access-rights' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-unixgroup' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unix-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-acl-list-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-acl-list-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-share-acls' => {
                'type' => 'cifs-share-acl-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-acl-list-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'share-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-add' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'caching' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dir-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'forcegroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-access-based-enum' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-browse' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-namespace-caching-allowed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-symlink-strict-security' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscanread' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-widelink' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maxusers' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-change' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'caching' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dir-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'forcegroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-access-based-enum' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-browse' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-namespace-caching-allowed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-symlink-strict-security' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscanread' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-widelink' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maxusers' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-list-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-list-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-shares' => {
                'type' => 'cifs-share-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-list-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'share-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-status' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-stop' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'workstation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-top-iter-end' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-top-iter-next' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-top' => {
                'type' => 'cifs-top-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-top-iter-start' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'avgtype' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'maxclients' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sortgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clock-get-clock' => {
        'category' => 'clock',
        'family' => ['ontap-c'],
        'inputs' => {
            'is-compliance-clock' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'local-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'utc-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clock-get-timezone' => {
        'category' => 'clock',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timezone-UTC' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timezone-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clock-set-clock' => {
        'category' => 'clock',
        'family' => ['ontap-c'],
        'inputs' => {
            'is-utc-clock' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clock-set-timezone' => {
        'category' => 'clock',
        'family' => ['ontap-c'],
        'inputs' => {
            'timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-clear' => {
        'category' => 'clone',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'clone-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-list-status' => {
        'category' => 'clone',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'clone-id' => {
                'type' => 'clone-id-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'status' => {
                'type' => 'ops-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'clone-start' => {
        'category' => 'clone',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'block-ranges' => {
                'type' => 'block-range',
                'flags' => 7,
                'scope' => [],
            },
            'change-log' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-locks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-streams' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'no-snap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-reserve' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-id' => {
                'type' => 'clone-id-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'clone-stop' => {
        'category' => 'clone',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'clone-id' => {
                'type' => 'clone-id-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'copyoffload-copy-abort' => {
        'category' => 'copyoffload',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'copy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bytes-copied' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'copyoffload-copy-start' => {
        'category' => 'copyoffload',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'copy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'copyoffload-copy-status' => {
        'category' => 'copyoffload',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'copy-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'copy-status' => {
                'type' => 'copyoffload-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'copyoffload-modify' => {
        'category' => 'copyoffload',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'copyoffload-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'copyoffload-show' => {
        'category' => 'copyoffload',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'copyoffload-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-get-server-info' => {
        'category' => 'dfm',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'dfm-server' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-dfm-cross-linked' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dfm-set-server-info' => {
        'category' => 'dfm',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'dfm-server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dfm-cross-linked' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-alert-definition-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-definition-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'acknowledge' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'acknowledger' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'suppress' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'suppressor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-config-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-config-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-delete-alert' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-policy-definition-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-policy-definition-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-policy-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'enable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-status-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-status',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-status',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-create' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'fail-thresh' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-notify-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'notify-table' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'psc-option' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'time-gap-notify' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'fail-thresh' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-notify-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'notify-table' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'psc-option' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'time-gap-notify' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-subsystem-config-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subsystem-config-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-fail' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-immediate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-list-info' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ownership-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-details' => {
                'type' => 'disk-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'disk-release-all-reservations' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'disk-remove' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-replace-start' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'replacement-disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-replace-stop' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-assign' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'auto' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'checksum' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-filer-list-info' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'disk-sanown-filer-details' => {
                'type' => 'disk-sanown-filer-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'disk-sanown-list-info' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ownership-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-sanown-details' => {
                'type' => 'disk-sanown-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'disk-sanown-reassign' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'new-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'new-owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'old-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'old-owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-remove-ownership' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-list' => {
                'type' => 'disk-name',
                'flags' => 6,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-swap' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'disk-unfail' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'make-spare' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-unswap' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'disk-update-disk-fw' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk-list' => {
                'type' => 'disk-name',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-zero-spares' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'ems-autosupport-log' => {
        'category' => 'ems',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'app-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'auto-support' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'computer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'log-level' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-invoke' => {
        'category' => 'ems',
        'family' => [],
        'inputs' => {
            'event-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-version' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'params' => {
                'type' => 'param',
                'flags' => 6,
                'scope' => [],
            },
            'severity' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmp' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'syslog' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-adapter-disable' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-adapter-enable' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-list-iter-end' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-list-iter-next' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'adapter-info' => {
                'type' => 'fc-config-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fc-config-list-iter-start' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fc-config-set-adapter-fc-type' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-clear-partner' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-config-down' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-config-media-type' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'media-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-config-up' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-initiators-list-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-adapters' => {
                'type' => 'fcp-adapter-initiators-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-list-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-config-adapters' => {
                'type' => 'fcp-config-adapter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-nameserver-list-iter-end' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-nameserver-list-iter-next' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-adapter-nameserver-objects' => {
                'type' => 'fcp-adapter-nameserver-object-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-nameserver-list-iter-start' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'zoned' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-reset-stats' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-set-partner' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'partner-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-set-speed' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'speed' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-stats-list-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-adapter-stats' => {
                'type' => 'fcp-adapter-stats-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-topology-list-iter-end' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-topology-list-iter-next' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-adapter-topology-switches' => {
                'type' => 'fcp-adapter-topology-switch-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-topology-list-iter-start' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'zoned' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-zone-list-iter-end' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-zone-list-iter-next' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-adapter-zones' => {
                'type' => 'fcp-adapter-zone-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-zone-list-iter-start' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-get-cfmode' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'fcp-cfmode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-node-get-name' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-node-set-name' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-ping' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'payload' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-id-or-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-ping-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'payload' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ping-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-id-or-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'frames-received' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'frames-transmitted' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-maximum-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-mean-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-minimum-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fcp-port-name-list-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'fcp-port-names' => {
                'type' => 'fcp-port-name-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-port-name-set' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-port-name-swap' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-adapter-1' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fcp-adapter-2' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-service-start' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fcp-service-status' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-service-stop' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fcp-set-cfmode' => {
        'category' => 'fcp',
        'family' => ['ontap-c'],
        'inputs' => {
            'fcp-cfmode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-wwpnalias-get-alias-info' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'alias' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'aliases' => {
                'type' => 'aliases-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-wwpnalias-remove' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'alias' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-wwpnalias-set' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'alias' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcport-get-link-state' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'adapter-link-state' => {
                'type' => 'link-state-info',
                'flags' => 3,
                'scope' => [],
            },
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcport-reset-dev' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'device-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcport-send-lip' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'loop-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcport-set-offline' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcport-set-online' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'feature-status-list-info' => {
        'category' => 'feature',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'managed-feature-status-list' => {
                'type' => 'managed-feature-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'file-create-directory' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perm' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-create-symlink' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'symlink' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-delete-directory' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-delete-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-get-file-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'file-info' => {
                'type' => 'file-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'file-get-fingerprint' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'fingerprint-algorithm' => {
                'type' => 'digest-algorithm',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-scope' => {
                'type' => 'file-scope',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'fingerprint' => {
                'type' => 'fingerprint-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'file-get-space-reservation-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-fill-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-overwrite-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-inode-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'encoded' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'generation' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'inode-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'logical-snap-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-cifs-paths' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-leaf-name' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-no-pathname' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-other-parents' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-parent-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snap-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snap-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-dsid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'inode-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inode-paths' => {
                'type' => 'inode-parent-info',
                'flags' => 3,
                'scope' => [],
            },
            'logical-snap-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'number-of-parents' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-dsid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-fsid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-list-directory-iter-end' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-list-directory-iter-next' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'files' => {
                'type' => 'file-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-list-directory-iter-start' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'encoded' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-punch-hole' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'hole-info' => {
                'type' => 'hole-range-info',
                'flags' => 3,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-read-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-read-symlink' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'symlink' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-rename-directory' => {
        'category' => 'file',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'from-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'to-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-set-space-reservation-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'is-fill-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-overwrite-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-truncate-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-usage-get' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'total-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unique-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-usage-result-get' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'cookie' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'total-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unique-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-usage-start' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'cookie' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-write-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flash-device-list-info' => {
        'category' => 'flash',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'slot-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'flash-device-info' => {
                'type' => 'flash-device-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'flash-get-thresholds' => {
        'category' => 'flash',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'profile' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'flash-threshold-profile' => {
                'type' => 'flash-threshold-profile',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'fpolicy-create-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-destroy-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-disable' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fpolicy-disable-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-enable' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fpolicy-enable-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-extensions' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'command' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'extensions' => {
                'type' => 'extension-list-info',
                'flags' => 7,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'set-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-extensions-list-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'exclude-extensions' => {
                'type' => 'extension-list-info',
                'flags' => 3,
                'scope' => [],
            },
            'include-extensions' => {
                'type' => 'extension-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fpolicy-get-policy-options' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-ads-monitored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-cifs-disconnect-check-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-cifs-setattr-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-required' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'reqcancel-timeout' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-servers' => {
                'type' => 'secondary-server-info',
                'flags' => 3,
                'scope' => [],
            },
            'serverprogress-timeout' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-get-required-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-required' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-get-secondary-servers-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'secondary-servers' => {
                'type' => 'secondary-server-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fpolicy-list-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'policies' => {
                'type' => 'policy-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fpolicy-operations-list-set' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monitored-operations' => {
                'type' => 'monitored-operation-info',
                'flags' => 3,
                'scope' => [],
            },
            'monitored-protocols' => {
                'type' => 'monitored-protocol-info',
                'flags' => 3,
                'scope' => [],
            },
            'offline-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-server-list-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'servers' => {
                'type' => 'server-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fpolicy-server-stop' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'server-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-set-policy-options' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'is-ads-monitored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-cifs-disconnect-check-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-cifs-setattr-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'reqcancel-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-servers' => {
                'type' => 'secondary-server-info',
                'flags' => 7,
                'scope' => [],
            },
            'serverprogress-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-set-required' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'required' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-set-secondary-servers' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-servers' => {
                'type' => 'secondary-server-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-status' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-volume-list-info' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'exclude-volumes' => {
                'type' => 'fpolicy-volumes-list-info',
                'flags' => 3,
                'scope' => [],
            },
            'include-volumes' => {
                'type' => 'fpolicy-volumes-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fpolicy-volume-list-set' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'list-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'fpolicy-volumes-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ic-config-show' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'ic-config-details' => {
                'type' => 'ic-config-details',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ic-get-error-stats' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'sfo-rv-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'active-logical-link' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nvram-hardware-error-stats' => {
                'type' => 'ic-counter',
                'flags' => 7,
                'scope' => [],
            },
            'nvram-hardware-perf-stats' => {
                'type' => 'ic-counter',
                'flags' => 7,
                'scope' => [],
            },
            'nvram-per-port-counters' => {
                'type' => 'nvram-per-port-counters-info',
                'flags' => 7,
                'scope' => [],
            },
            'nvram-software-counters' => {
                'type' => 'ic-counter',
                'flags' => 7,
                'scope' => [],
            },
            'peer-connect-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'per-link-parameters' => {
                'type' => 'per-link-parameters-info',
                'flags' => 7,
                'scope' => [],
            },
            'sfo-connection-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sfo-nic-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sfo-rv-role' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ic-get-infiniband-hw-stats' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'context-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'doorbell-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'overflow-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'packet-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'remote-abort-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'remote-ops-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'requester-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'responder-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'ic-get-infiniband-port-stats' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'port1-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'port2-stats' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'ic-get-perf-stats' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'ic-perf-details' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
            'virtual-interface-socket-stats' => {
                'type' => 'virtual-interface-socket-stat-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'ic-get-queue-info' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'virtual-interface' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'recv-queue-info' => {
                'type' => 'queue-info',
                'flags' => 5,
                'scope' => [],
            },
            'send-queue-info' => {
                'type' => 'queue-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'ic-reset-nic' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'ic-reset-nic-auto-off' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'ic-reset-nic-auto-on' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'ic-zero-error-stats' => {
        'category' => 'ic',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'igroup-add' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-bind-portset' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-create' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'bind-portset' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-destroy' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-list-info' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'initiator-groups' => {
                'type' => 'initiator-group-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'igroup-lookup-lun' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'igroup-remove' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-rename' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-set-attribute' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'attribute' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-unbind-portset' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ipspace-list-info' => {
        'category' => 'ipspace',
        'family' => [],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'ipspaces' => {
                'type' => 'ipspace-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-adapter-config-down' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-adapter-config-up' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-adapter-initiators-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-adapters' => {
                'type' => 'iscsi-adapter-initiators-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-adapter-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-config-adapters' => {
                'type' => 'iscsi-config-adapter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-adapter-reset-stats' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-adapter-stats-list-info' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
            'iscsi-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-auth-generate-chap-password' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'secret' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-connection-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'iscsi-connection-list-entries' => {
                'type' => 'iscsi-connection-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-add-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-auth-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-security-entries' => {
                'type' => 'iscsi-security-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-delete-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-get-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'auth-chap-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-get-default-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'auth-chap-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'iscsi-initiator-list-entries' => {
                'type' => 'iscsi-initiator-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-modify-chap-params' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'remove-outbound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-set-default-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-disable' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-enable' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-interface-list-entries' => {
                'type' => 'iscsi-interface-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-iptpgroup-create' => {
        'category' => 'iscsi',
        'family' => ['vfiler'],
        'inputs' => {
            'iptpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-iptpgroup-destroy' => {
        'category' => 'iscsi',
        'family' => ['vfiler'],
        'inputs' => {
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-iptpgroup-ipaddr-add' => {
        'category' => 'iscsi',
        'family' => ['vfiler'],
        'inputs' => {
            'ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-iptpgroup-ipaddr-delete' => {
        'category' => 'iscsi',
        'family' => ['vfiler'],
        'inputs' => {
            'ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-iptpgroup-list-info' => {
        'category' => 'iscsi',
        'family' => ['vfiler'],
        'inputs' => {
            'iptpgroup-tag' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-iptpgroup-list-entries' => {
                'type' => 'iscsi-iptpgroup-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-isns-config' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'isns-ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-isns-get-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-isns-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'isns-entity-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'isns-ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-isns-start' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-isns-stop' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-isns-update' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-node-get-name' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-node-set-name' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-portal-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'iscsi-portal-list-entries' => {
                'type' => 'iscsi-portal-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-reset-stats' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-service-start' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-service-status' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-service-stop' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-session-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tsih' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-session-list-entries' => {
                'type' => 'iscsi-session-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-stats-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'iscsi-stats' => {
                'type' => 'iscsi-stats-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'iscsi-target-alias-clear-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-target-alias-get-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'alias-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-alias-assigned' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-target-alias-set-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'alias-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-alua-set' => {
        'category' => 'iscsi',
        'family' => [],
        'inputs' => {
            'tpgroup-alua-preferred' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-alua-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-create' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'tpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-tpgroup-destroy' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-interface-add' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-interface-delete' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-list-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'iscsi-tpgroup-list-entries' => {
                'type' => 'iscsi-tpgroup-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'license-add' => {
        'category' => 'license',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'license-delete' => {
        'category' => 'license',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'service' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'license-list-info' => {
        'category' => 'license',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'hide-code' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'licenses' => {
                'type' => 'license-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'license-v2-add' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'codes' => {
                'type' => 'license-code-v2',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'license-v2-failure-list' => {
                'type' => 'license-v2-result',
                'flags' => 7,
                'scope' => [],
            },
            'license-v2-success-list' => {
                'type' => 'license-v2-added',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'license-v2-delete' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'package' => {
                'type' => 'licensed-package',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'license-v2-list-info' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'licenses' => {
                'type' => 'license-v2-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lock-break' => {
        'category' => 'lock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'errors' => {
                'type' => 'break-error',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lock-status-iter-end' => {
        'category' => 'lock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lock-status-iter-next' => {
        'category' => 'lock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lock-status' => {
                'type' => 'lock-status-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lock-status-iter-start' => {
        'category' => 'lock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-clear-persistent-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-clone-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-clone-list' => {
                'type' => 'lun-clone-lists-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-clone-split-start' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-efficient-split-disabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-clone-split-status-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-status' => {
                'type' => 'clone-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-clone-split-stop' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-clone-start' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-clone-status-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-status' => {
                'type' => 'clone-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-clone-stop' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-config-check-alua-conflicts-info' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'conflicting-luns' => {
                'type' => 'conflicting-luns-list',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-config-check-cfmode-info' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'fcp-cfmode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'invalid-cfmode-settings' => {
                'type' => 'invalid-cfmode-setting-info',
                'flags' => 5,
                'scope' => [],
            },
            'invalid-ostype-cfmode-settings' => {
                'type' => 'invalid-ostype-cfmode-setting-info',
                'flags' => 7,
                'scope' => [],
            },
            'invalid-use-partner-cfmode-settings' => {
                'type' => 'invalid-use-partner-cfmode-setting-info',
                'flags' => 7,
                'scope' => [],
            },
            'invalid-use-partner-ostype-settings' => {
                'type' => 'invalid-use-partner-ostype-setting-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-config-check-info' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'alua-setting-mismatch-info' => {
                'type' => 'alua-setting-mismatch-initiator-group',
                'flags' => 7,
                'scope' => [],
            },
            'alua-setting-mismatch-initiators' => {
                'type' => 'alua-setting-mismatch-initiator-info',
                'flags' => 7,
                'scope' => [],
            },
            'fcp-down-hbas' => {
                'type' => 'fcp-down-hba-info',
                'flags' => 7,
                'scope' => [],
            },
            'invalid-vsa-settings' => {
                'type' => 'invalid-vsa-setting-info',
                'flags' => 7,
                'scope' => [],
            },
            'mixed-ostype-initiators' => {
                'type' => 'mixed-ostype-initiator-info',
                'flags' => 7,
                'scope' => [],
            },
            'mixed-vsa-initiators' => {
                'type' => 'mixed-vsa-initiator-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-config-check-single-image-info' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'conflicting-initiators' => {
                'type' => 'conflicting-initiator-info',
                'flags' => 7,
                'scope' => [],
            },
            'conflicting-maps' => {
                'type' => 'conflicting-map-info',
                'flags' => 7,
                'scope' => [],
            },
            'invalid-nodename-settings' => {
                'type' => 'invalid-nodename-setting-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'lun-config-check-wwpn-conflicts-info' => {
        'category' => 'lun',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'conflicting-wwpns' => {
                'type' => 'conflict-wwpn',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'lun-create-by-size' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'ostype' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-create-clone' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'parent-lun-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'parent-snap' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-create-from-file' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'file-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ostype' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-create-from-snapshot' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-lun-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-destroy' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-get-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-comment' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-geometry' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bytes-per-sector' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cylinders' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-resize-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sectors-per-track' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tracks-per-cylinder' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-inquiry-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'product-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-maxsize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'lun-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'with-complete-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'with-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'without-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-minsize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'type' => {
                'type' => 'lun-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'min-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-occupied-size' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'occupied-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-persistent-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'persistent-reservation' => {
                'type' => 'persistent-reservation-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-get-select-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'creation-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'creation-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'previous-serial' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'select-attribute' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-serial-number' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-space-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-target-device-id' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'lun-serial-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'target-device-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-vdisk-attributes' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'filer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vdisk-snapshot-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-c', 'vfiler'],
            },
        },
    },
    'lun-has-scsi-reservations' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-reservation-held' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-initiator-list-map-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-maps' => {
                'type' => 'lun-map-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-initiator-logged-in' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-logged-in' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'get-clone-backing-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'are-vols-busy' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'are-vols-onlining' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'luns' => {
                'type' => 'lun-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-map' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-id-assigned' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-map-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'initiator-groups' => {
                'type' => 'initiator-group-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-move' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-offline' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-online' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-port-has-scsi-reservations' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-reservation-held' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-reset-stats' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-resize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-restore-status' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-running' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-set-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-comment' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-device-id' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'device-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-select-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'select-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-serial-number' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-share' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'share-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-space-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'enable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-snap-usage-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-snap-usage-luns' => {
                'type' => 'lun-snap-usage-lun-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-start' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-stats-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-stats' => {
                'type' => 'lun-stats-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-unmap' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-unset-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-unset-device-id' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nameservice-map-gid-to-group-name' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'gid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-group-name-to-gid' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'gid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-sid-to-uid' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'sid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'uid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-uid-to-user-name' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'uid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-unix-to-windows' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-user-name-to-uid' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'uid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-map-windows-to-unix' => {
        'category' => 'nameservice',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-config-get-active' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'net-config-info' => {
                'type' => 'net-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-config-get-persistent' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'net-config-info' => {
                'type' => 'net-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-config-set-persistent' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'net-config-info' => {
                'type' => 'net-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-dcb-list-info' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'priority-group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'net-dcb-entries' => {
                'type' => 'net-dcb-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-dcb-priority-list-info' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'priority' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'net-dcb-priority-entries' => {
                'type' => 'net-dcb-priority-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-get-address-info' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'host-info' => {
                'type' => 'host-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-result' => {
                'type' => 'net-address-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-ifconfig-get' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'interface-config-info' => {
                'type' => 'interface-config-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-ifconfig-set' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'interface-config-info' => {
                'type' => 'interface-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspace-assign' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'ipspace-config-info' => {
                'type' => 'ipspace-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspace-create' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'ipspace-config-info' => {
                'type' => 'ipspace-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspace-destroy' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspace-list' => {
        'category' => 'net',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'ipspace-list' => {
                'type' => 'ipspace-config-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-ping' => {
        'category' => 'net',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'host-name-or-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'retry-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ping-info' => {
        'category' => 'net',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'host-name-or-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ping-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'packets-received' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'packets-transmitted' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-maximum-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-mean-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'round-trip-minimum-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-resolve' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ip-addresses' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'net-reverse-resolve' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'alias-names' => {
                'type' => 'host-name',
                'flags' => 6,
                'scope' => [],
            },
            'canonical-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-route-add' => {
        'category' => 'net',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'route-info' => {
                'type' => 'route-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-route-delete' => {
        'category' => 'net',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'route-info' => {
                'type' => 'route-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-vlan-create' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'vlan-info' => {
                'type' => 'vlan-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-vlan-delete' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'vlan-info' => {
                'type' => 'vlan-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-disable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-enable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-append-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rules' => {
                'type' => 'exports-rule-info',
                'flags' => 3,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'exported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'loaded-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-append-rules-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rules' => {
                'type' => 'exports-rule-info-2',
                'flags' => 3,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'exported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'loaded-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-check-permission' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'permission' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-permissible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-delete-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'all-pathnames' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'deleted-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'unexported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-fence-disable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'all-pathnames' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'fenced-hosts' => {
                'type' => 'exports-hostname-info',
                'flags' => 3,
                'scope' => [],
            },
            'fenced-paths' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'remove-locks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-fence-enable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'all-pathnames' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'fenced-hosts' => {
                'type' => 'exports-hostname-info',
                'flags' => 3,
                'scope' => [],
            },
            'fenced-paths' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-flush-cache' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-list-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'rules' => {
                'type' => 'exports-rule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-list-rules-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'rules' => {
                'type' => 'exports-rule-info-2',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-load-exports' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'persistent-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-modify-rule' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'rule' => {
                'type' => 'exports-rule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-modify-rule-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'rule' => {
                'type' => 'exports-rule-info-2',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-storage-path' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-get-supported-sec-flavors' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'sec-flavor' => {
                'type' => 'sec-flavor-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-monitor-add' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'hosts' => {
                'type' => 'hostaddr',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-monitor-list' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'hosts' => {
                'type' => 'hostaddr',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'nfs-monitor-reclaim' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'hosts' => {
                'type' => 'hostaddr',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-monitor-remove' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'hosts' => {
                'type' => 'hostaddr',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-monitor-remove-locks' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'owners' => {
                'type' => 'owner-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-stats-get-client-stats' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'client-info' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-stats' => {
                'type' => 'nfs-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'rpc-stats' => {
                'type' => 'rpc-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'tcp-flowcontrol-stats' => {
                'type' => 'tcp-flowcontrol-stats-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nfs-stats-top-clients-list-iter-end' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-stats-top-clients-list-iter-next' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'nfs-top' => {
                'type' => 'nfs-top-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-stats-top-clients-list-iter-start' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maxclients' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-stats-zero-stats' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-status' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-drained' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'options-get' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cluster-constraint' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'options-list-info' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'options' => {
                'type' => 'option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'options-set' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cluster-constraint' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-object-counter-list-info' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'counters' => {
                'type' => 'counter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-object-get-instances' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'counters' => {
                'type' => 'counter',
                'flags' => 6,
                'scope' => [],
            },
            'instances' => {
                'type' => 'instance',
                'flags' => 6,
                'scope' => [],
            },
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'instance-data',
                'flags' => 3,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-get-instances-iter-end' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-object-get-instances-iter-next' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'instance-data',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-get-instances-iter-start' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'counters' => {
                'type' => 'counter',
                'flags' => 6,
                'scope' => [],
            },
            'instances' => {
                'type' => 'instance',
                'flags' => 6,
                'scope' => [],
            },
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-info' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'instance-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-info-iter-end' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-object-instance-list-info-iter-next' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'instance-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-info-iter-start' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-list-info' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'objects' => {
                'type' => 'object-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'portset-add' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-create' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-destroy' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-list-info' => {
        'category' => 'portset',
        'family' => [],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'portset-sets' => {
                'type' => 'portset-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'portset-remove' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'priority-disable' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'priority-enable' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'priority-hybridcache-get' => {
        'category' => 'priority',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-hybrid-cache-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'read-cache' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'write-cache' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'priority-hybridcache-set' => {
        'category' => 'priority',
        'family' => ['ontap-c'],
        'inputs' => {
            'read-cache' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'write-cache' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'priority-list-info' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'enabled-components' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'io-concurrency' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nvlog-cp-completion' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nvlog-cp-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'priority-list-info-default' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'level' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nvlog-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'system' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'system-read-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-read-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'priority-list-info-volume' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'priority-volume' => {
                'type' => 'priority-volume-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'priority-set' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'io-concurrency' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nvlog-cp-completion' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nvlog-cp-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'priority-set-default' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'level' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nvlog-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'system' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'system-read-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'user-read-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'priority-set-volume' => {
        'category' => 'priority',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'cache-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'level' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nvlog-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'service' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'system' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'system-read-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'user-read-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-create' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-delete' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-list' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'qtrees' => {
                'type' => 'qtree-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'qtree-list-iter-end' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-list-iter-next' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'qtrees' => {
                'type' => 'qtree-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-list-iter-start' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-rename' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-add-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-delete-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-get-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perform-user-mapping' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'quota-error' => {
                'type' => 'quota-error',
                'flags' => 5,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-list-entries' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'include-output-entry' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'quota-entries' => {
                'type' => 'quota-entry',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'quota-list-entries-iter-end' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-list-entries-iter-next' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'quota-entries' => {
                'type' => 'quota-entry',
                'flags' => 7,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-list-entries-iter-start' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'include-output-entry' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-modify-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-off' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'quota-on' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-report' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'error' => {
                'type' => 'error',
                'flags' => 5,
                'scope' => [],
            },
            'quotas' => {
                'type' => 'quota',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'quota-report-iter-end' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-report-iter-next' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'quotas' => {
                'type' => 'quota-info',
                'flags' => 7,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-report-iter-start' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'error' => {
                'type' => 'error',
                'flags' => 5,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-resize' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-set-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-status' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'quota-errors' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'substatus' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'radius-reset-stats' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'radius-server-add' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'is-default-server' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'radius-ip-addr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'radius-server-remove' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'radius-ip-addr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'radius-service-start' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'radius-service-status' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'radius-service-stop' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'radius-show-info' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'radius-server-list-entries' => {
                'type' => 'radius-server-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'radius-stats-list-info' => {
        'category' => 'radius',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'radius-stats' => {
                'type' => 'radius-stats-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'reallocate-delete-schedule' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-list-info' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'global-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'reallocate-jobs' => {
                'type' => 'reallocate-job-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'reallocate-measure' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'interval' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'measure-logfile' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'run-once' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-off' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'detail-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'reallocate-on' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'detail-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'reallocate-quiesce' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-restart' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'ignore-checkpoint' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-set-schedule' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-start' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'full' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interval' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-aggregate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'no-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'preserve-logical-bno' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'run-once' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'unshare' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'reallocate-stop' => {
        'category' => 'reallocate',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rsh-get-stats' => {
        'category' => 'rsh',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'active-high-sessions' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'current-active-sessions' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-available-sessions' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rsh-sessions' => {
                'type' => 'rsh-session-info',
                'flags' => 7,
                'scope' => [],
            },
            'session-invocations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rsh-kill' => {
        'category' => 'rsh',
        'family' => ['ontap-c'],
        'inputs' => {
            'session-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-shelf-bay-list-info' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'shelf-bay-list' => {
                'type' => 'shelf-bay-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-shelf-environment-list-info' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'shelf-environ-channel-list' => {
                'type' => 'shelf-environ-channel-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-shelf-get-shelf-info' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bay-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'bay-list' => {
                'type' => 'bay-info',
                'flags' => 3,
                'scope' => [],
            },
            'firmware-rev-A' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-rev-B' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-shelf-list-info' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'shelf-list' => {
                'type' => 'shelf-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-shelf-set-led-state' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'channel-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'identify' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lun' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-bay' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-shelf-update-fw' => {
        'category' => 'ses',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'sis-disable' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'sis-enable' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'sis-set-config' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'enable-compression' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'enable-idd' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'enable-inline-compression' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quick-check-fsize' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'sis-start' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'build-metadata' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'delete-checkpoint' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qos-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'queue-operation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'restart-checkpoint' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'scan-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'sis-status' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'sis-object' => {
                'type' => 'dense-status',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'sis-stop' => {
        'category' => 'sis',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'all-operations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-get-snaplock-retention-time' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'retention-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-get-snaplock-retention-time-list-info-max' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'max-list-entries' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-set-snaplock-retention-time' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'retention-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'set-infinite-retention' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-snaplock-retention-time-list-info' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'pathnames' => {
                'type' => 'pathname-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
            'file-retention-details' => {
                'type' => 'file-retention-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snaplock-get-compliance-clock' => {
        'category' => 'snaplock',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snaplock-get-log-volume' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'log-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snaplock-get-options' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'option' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snaplock-get-system-compliance-clock' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'system-compliance-clock' => {
                'type' => 'compliance-clock-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'snaplock-get-volume-compliance-clock' => {
        'category' => 'snaplock',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'system-compliance-clock' => {
                'type' => 'compliance-clock-info',
                'flags' => 1,
                'scope' => [],
            },
            'volume-compliance-clock' => {
                'type' => 'compliance-clock-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'snaplock-log-archive' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'log-basename' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'log-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snaplock-log-status-list-info' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'log-basename' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'log-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'log-file-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'log-file-details' => {
                'type' => 'log-file-info',
                'flags' => 7,
                'scope' => [],
            },
            'log-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snaplock-privileged-delete-file' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'do-it' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snaplock-set-log-volume' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'is-force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'log-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snaplock-set-options' => {
        'category' => 'snaplock',
        'family' => [],
        'inputs' => {
            'do-it' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'option' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snaplock-set-system-compliance-clock' => {
        'category' => 'snaplock',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snapmirror-abort' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'clear-checkpoint' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-break' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-delete-connection' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'connection' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-delete-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-delete-sync-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-get-status' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'snapmirror-status' => {
                'type' => 'snapmirror-status-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapmirror-get-volume-status' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-destination' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-transfer-broken' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-transfer-in-progress' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapmirror-initialize' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-list-connections' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'connection' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapmirror-connections' => {
                'type' => 'snapmirror-connection-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapmirror-list-destinations' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'destinations' => {
                'type' => 'destination-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapmirror-list-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapmirror-schedules' => {
                'type' => 'snapmirror-schedule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapmirror-list-sync-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapmirror-sync-schedules' => {
                'type' => 'snapmirror-sync-schedule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapmirror-off' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snapmirror-on' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snapmirror-quiesce' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-release' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-resume' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-resync' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-set-connection' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'address-pair1' => {
                'type' => 'address-pair',
                'flags' => 1,
                'scope' => [],
            },
            'address-pair2' => {
                'type' => 'address-pair',
                'flags' => 5,
                'scope' => [],
            },
            'connection' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-set-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'connection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'days-of-month' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'days-of-week' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hours' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-compressed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minutes' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'restart' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tcp-window-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-set-sync-schedule' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c'],
        'inputs' => {
            'connection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-compressed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ops-throttle' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sync-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'tcp-window-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'visibility-frequency' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-throttle' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapmirror-update' => {
        'category' => 'snapmirror',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-autodelete-list-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'options' => {
                'type' => 'snapshot-autodelete-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapshot-autodelete-set-option' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-create' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-valid-lun-clone-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-delete' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-instance-uuid' => {
                'type' => 'uuid',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-delta-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapshot1' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot2' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'consumed-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'elapsed-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-get-reserve' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'blocks-reserved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'percent-reserved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-get-schedule' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'days' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hours' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'minutes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weeks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'which-hours' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'which-minutes' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-list-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'is-7-mode-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lun-clone-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapowners' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'target-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'target-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'terse' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshots' => {
                'type' => 'snapshot-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapshot-multicreate' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'cleanup' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-names' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'volume-is-snapcreated-list' => {
                'type' => 'volume-is-snapcreated',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapshot-multicreate-validate' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-names' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'volume-errors' => {
                'type' => 'volume-error',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapshot-multidelete' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-names' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => ['ontap-c', 'ontap-vserver'],
            },
        },
        'outputs' => {
            'volume-errors' => {
                'type' => 'volume-error',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapshot-partial-restore-file' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'byte-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-instance-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'start-byte' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-partial-restore-file-list-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'max-byte-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-reclaimable-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapshots' => {
                'type' => 'snapshot-name',
                'flags' => 2,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'reclaimable-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-rename' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'current-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-reserve-list-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-reserve-details' => {
                'type' => 'snapshot-reserve-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapshot-restore-file' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'restore-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-instance-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'space-efficient-split-disabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-restore-file-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'max-sfsr-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sfsr-in-progress' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-restore-volume' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-instance-uuid' => {
                'type' => 'uuid',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-set-reserve' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'percentage' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-set-schedule' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'days' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hours' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minutes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weeks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'which-hours' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'which-minutes' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-volume-info' => {
        'category' => 'snapshot',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'size-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-add-softlock' => {
        'category' => 'snapvault',
        'family' => ['ontap-c'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'softlock-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-get-all-softlocked-snapshots' => {
        'category' => 'snapvault',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-list' => {
                'type' => 'snapshot-name',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'snapvault-get-softlocks' => {
        'category' => 'snapvault',
        'family' => ['ontap-c'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapvault-softlocks' => {
                'type' => 'snapvault-softlock-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-abort-snapshot-create' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-abort-transfer' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'is-hard-abort' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'system-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-system' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-delete-snapshot-schedule' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'schedule-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-destinations-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'source-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'destinations' => {
                'type' => 'snapvault-destination-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-get-relationship-status' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'system-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'status' => {
                'type' => 'snapvault-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-initiate-incremental-restore-transfer' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'connection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'no-lun-clone-expansion' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-initiate-restore-transfer' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'connection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'no-lun-clone-expansion' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-existing-content' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-initiate-snapshot-create' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'options' => {
                'type' => 'snapvault-snapcreate-options',
                'flags' => 5,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-relationship-status-list-iter-end' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-relationship-status-list-iter-next' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'status-list' => {
                'type' => 'snapvault-status-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-relationship-status-list-iter-start' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-release-relationship' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'primary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-set-snapshot-schedule' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'snapshot-schedule' => {
                'type' => 'snapvault-primary-snapshot-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-primary-snapshot-schedule-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-schedules' => {
                'type' => 'snapvault-primary-snapshot-schedule-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-snapshot-schedule-status-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-schedule-status' => {
                'type' => 'snapvault-snapshot-schedule-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapvault-remove-softlock' => {
        'category' => 'snapvault',
        'family' => ['ontap-c'],
        'inputs' => {
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'softlock-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-abort-snapshot-create' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-abort-transfer' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'is-hard-abort' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'system-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-system' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-configuration-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'configurations' => {
                'type' => 'snapvault-configuration-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-create-relationship' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'configuration' => {
                'type' => 'snapvault-configuration-info',
                'flags' => 1,
                'scope' => [],
            },
            'no-lun-clone-expansion' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-delete-relationship' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-delete-snapshot-schedule' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'delete-schedule-softlock' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-destinations-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'source-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'destinations' => {
                'type' => 'snapvault-destination-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-get-configuration' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'configuration' => {
                'type' => 'snapvault-configuration-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-get-relationship-status' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'system-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'status' => {
                'type' => 'snapvault-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-initiate-incremental-transfer' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'no-lun-clone-expansion' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-initiate-snapshot-create' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'lock-backing-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'options' => {
                'type' => 'snapvault-snapcreate-options',
                'flags' => 5,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-modify-configuration' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'configuration' => {
                'type' => 'snapvault-configuration-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-relationship-status-list-iter-end' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-relationship-status-list-iter-next' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'status-list' => {
                'type' => 'snapvault-status-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-relationship-status-list-iter-start' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-release-relationship' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'primary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-resync-relationship' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'configuration' => {
                'type' => 'snapvault-configuration-info',
                'flags' => 1,
                'scope' => [],
            },
            'no-lun-clone-expansion' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-set-snapshot-schedule' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'snapshot-schedule' => {
                'type' => 'snapvault-secondary-snapshot-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapvault-secondary-snapshot-schedule-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-schedules' => {
                'type' => 'snapvault-secondary-snapshot-schedule-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-snapshot-schedule-status-list-info' => {
        'category' => 'snapvault',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snapshot-schedule-status' => {
                'type' => 'snapvault-snapshot-schedule-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snmp-community-add' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'access-control' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'community' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-community-delete' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'access-control' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'community' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-community-delete-all' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snmp-disable' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snmp-enable' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snmp-get' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'object-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-value-hexadecimal' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snmp-get-next' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'object-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-value-hexadecimal' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'next-object-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snmp-status' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'communities' => {
                'type' => 'community-info',
                'flags' => 7,
                'scope' => [],
            },
            'contact' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-trap-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'traphosts' => {
                'type' => 'traphost-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'snmp-trap-delete' => {
        'category' => 'snmp',
        'family' => [],
        'inputs' => {
            'trap-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-trap-disable' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snmp-trap-enable' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'snmp-trap-list' => {
        'category' => 'snmp',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'trap-list' => {
                'type' => 'trap-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snmp-trap-load' => {
        'category' => 'snmp',
        'family' => [],
        'inputs' => {
            'filename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-trap-reset' => {
        'category' => 'snmp',
        'family' => [],
        'inputs' => {
            'trap-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-trap-set' => {
        'category' => 'snmp',
        'family' => [],
        'inputs' => {
            'trap-def' => {
                'type' => 'trap-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-traphost-add' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snmp-traphost-delete' => {
        'category' => 'snmp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'software-extract-metadata' => {
        'category' => 'software',
        'family' => [],
        'inputs' => {
            'package-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'package-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'npm-metadata' => {
                'type' => 'npm-meta-elem-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-adapter-enable-adapter' => {
        'category' => 'storage-adapter',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-adapter-get-adapter-info' => {
        'category' => 'storage-adapter',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'adapter-details' => {
                'type' => 'adapter-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-adapter-get-adapter-list' => {
        'category' => 'storage-adapter',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'adapter-list' => {
                'type' => 'adapter-name-elem',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-adapter-modify' => {
        'category' => 'storage-adapter',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-array-get-config-summary' => {
        'category' => 'storage-array',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'ownership-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'config-summary' => {
                'type' => 'storage-array-config-summary',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-array-list-info' => {
        'category' => 'storage-array',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'array-profiles' => {
                'type' => 'storage-array-profile',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-array-luns-list-info' => {
        'category' => 'storage-array',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ownership-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'array-luns' => {
                'type' => 'disk-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-array-ports-list-info' => {
        'category' => 'storage-array',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'array-ports' => {
                'type' => 'storage-array-port',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-array-update' => {
        'category' => 'storage-array',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'firmware' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'model' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'new-array-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'options' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'prefix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'array-profile' => {
                'type' => 'storage-array-profile',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'storage-disk-fw-status' => {
        'category' => 'storage-disk',
        'family' => ['ontap-c', 'ontap-d'],
        'inputs' => {
            'status-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'fw-update-status' => {
                'type' => 'fw-update-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-disk-get-iter' => {
        'category' => 'storage-disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'vfiler'],
        'inputs' => {
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'storage-disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-initiator-balance' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'storage-initiator-disk-path-list-info' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-path-info' => {
                'type' => 'disk-path-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-initiator-errors-list-info' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'errors' => {
                'type' => 'storage-error-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-initiator-get-load' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'load-info' => {
                'type' => 'storage-initiator-load-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-initiator-path-list-info' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
        },
        'outputs' => {
            'path-info' => {
                'type' => 'storage-initiator-path-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-initiator-path-quiesce' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-initiator-path-resume' => {
        'category' => 'storage-initiator',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'system-api-get-elements' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'api-list' => {
                'type' => 'api-list-info',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'api-entries' => {
                'type' => 'system-api-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'system-api-list' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'apis' => {
                'type' => 'system-api-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'system-api-list-types' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'type-entries' => {
                'type' => 'system-api-type-entry-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'system-available-replication-transfers' => {
        'category' => 'system',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'replication-transfer-table' => {
                'type' => 'replication-transfer-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'system-get-info' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'system-info' => {
                'type' => 'system-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'system-get-ontapi-version' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'major-version' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'minor-version' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-get-vendor-info' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'autosupport-email' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'autosupport-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'complete-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'customer-support-contact' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'customer-support-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'information-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ontap-oid-prefix' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'product-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'short-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-get-version' => {
        'category' => 'system',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-clustered' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ucm-adapter-list-info' => {
        'category' => 'ucm',
        'family' => ['ontap-c'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'uc-adapters' => {
                'type' => 'uc-adapter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ucm-adapter-modify' => {
        'category' => 'ucm',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc4-type' => {
                'type' => 'ucm-type',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'ucm-mode',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-domainuser-add' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user-identifier' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'useradmin-groups' => {
                'type' => 'useradmin-group-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-domainuser-delete' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user-identifier' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'useradmin-groups' => {
                'type' => 'useradmin-group-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-domainuser-list' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'user-identifiers' => {
                'type' => 'sid',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'useradmin-group-add' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'useradmin-group' => {
                'type' => 'useradmin-group-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-group-delete' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-group-list' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'useradmin-groups' => {
                'type' => 'useradmin-group-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'useradmin-group-modify' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'new-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'useradmin-group' => {
                'type' => 'useradmin-group-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-role-add' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'useradmin-role' => {
                'type' => 'useradmin-role-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-role-delete' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-role-list' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'role-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'useradmin-roles' => {
                'type' => 'useradmin-role-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'useradmin-role-modify' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'useradmin-role' => {
                'type' => 'useradmin-role-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-user-add' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'useradmin-user' => {
                'type' => 'useradmin-user-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-user-delete' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-user-list' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'useradmin-users' => {
                'type' => 'useradmin-user-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'useradmin-user-modify' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'useradmin-user' => {
                'type' => 'useradmin-user-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'useradmin-user-modify-password' => {
        'category' => 'useradmin',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'new-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'old-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-add-ipaddress' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-add-storage' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'storage-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-allow-protocol' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-create' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'ip-addresses' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-units' => {
                'type' => 'storage-unit',
                'flags' => 2,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-destroy' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-disallow-protocol' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-dr-activate' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-dr-configure' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'DNS-server-ipaddrs' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'NIS-server-ipaddrs' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'alternate-src-dst' => {
                'type' => 'hostname-pair',
                'flags' => 5,
                'scope' => [],
            },
            'ipaddrs' => {
                'type' => 'ipaddr-info',
                'flags' => 3,
                'scope' => [],
            },
            'is-synchronous' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'remote-authentication-info' => {
                'type' => 'authentication-info',
                'flags' => 5,
                'scope' => [],
            },
            'remote-encrypted-authentication-info' => {
                'type' => 'encrypted-authentication-info',
                'flags' => 5,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'snapmirror-not-initialize' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-dr-delete' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'is-forced' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-dr-get-status' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'dr-status' => {
                'type' => 'storage-dr-status',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-dr-resync' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'alternate-src-dst' => {
                'type' => 'hostname-pair',
                'flags' => 5,
                'scope' => [],
            },
            'is-synchronous' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'remote-authentication-info' => {
                'type' => 'authentication-info',
                'flags' => 5,
                'scope' => [],
            },
            'remote-encrypted-authentication-info' => {
                'type' => 'encrypted-authentication-info',
                'flags' => 5,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-get-allowed-protocols' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'allowed-protocols' => {
                'type' => 'protocol-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-get-disallowed-protocols' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'disallowed-protocols' => {
                'type' => 'protocol-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-get-status' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-list-info' => {
        'category' => 'vfiler',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'vfilers' => {
                'type' => 'vfiler-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-migrate' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ipaddrs' => {
                'type' => 'ipaddr-info',
                'flags' => 3,
                'scope' => [],
            },
            'migration-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
            'remote-filer' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-migrate-cancel' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-migrate-complete' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'migrate-transparent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'remote-authentication-info' => {
                'type' => 'authentication-info',
                'flags' => 5,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'use-secure-command-channel' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-migrate-start' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'ipaddrs' => {
                'type' => 'ipaddr-info',
                'flags' => 3,
                'scope' => [],
            },
            'remote-authentication-info' => {
                'type' => 'authentication-info',
                'flags' => 1,
                'scope' => [],
            },
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
            'snapmirror-not-initialize' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-migrate-status' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'remote-vfiler-location' => {
                'type' => 'vfiler-location',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'migrate-status' => {
                'type' => 'storage-mr-status',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-remove-ipaddress' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-remove-storage' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'storage-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-setup' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'adminhost' => {
                'type' => 'adminhost',
                'flags' => 5,
                'scope' => [],
            },
            'dnsdomain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dnsservers' => {
                'type' => 'dnsserver-info',
                'flags' => 7,
                'scope' => [],
            },
            'ipbindings' => {
                'type' => 'ipbinding-info',
                'flags' => 7,
                'scope' => [],
            },
            'nisdomain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nisservers' => {
                'type' => 'nisserver-info',
                'flags' => 7,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-start' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-stop' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vmservices-vsphere-credential-check' => {
        'category' => 'vmservices',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'vmservices-vsphere-credential-get' => {
        'category' => 'vmservices',
        'family' => ['ontap-c'],
        'inputs' => {
        },
        'outputs' => {
            'server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vmservices-vsphere-credential-modify' => {
        'category' => 'vmservices',
        'family' => ['ontap-c'],
        'inputs' => {
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-add' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'volume-autosize-get' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'grow-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'increment-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'maximum-size' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'minimum-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shrink-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-autosize-set' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'grow-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'increment-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'minimum-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'shrink-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-charmap-get' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'charmap' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-charmap-set' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'charmap' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-clone-create' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force-worm-clone' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'parent-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'parent-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qos-policy-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'space-reserve' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-clone-split-estimate' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-split-estimate' => {
                'type' => 'clone-split-estimate-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-clone-split-start' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-clone-split-status' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-split-details' => {
                'type' => 'clone-split-detail-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'volume-clone-split-stop' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-container' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'containing-aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-create' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'constituent-role' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'containing-aggr-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'is-mirrored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'is-snaplock' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'language-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-vserver', 'vfiler'],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'qos-policy-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'remote-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'space-reserve' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-align-sector' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vm-align-suffix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-raid-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => ['ontap-c', 'vfiler'],
            },
        },
    },
    'volume-decompress-abort' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-decompress-start' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-destroy' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-footprint-list-info' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'vol-footprint-infos' => {
                'type' => 'vol-footprint-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'volume-footprint-list-info-iter-end' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-footprint-list-info-iter-next' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vol-footprint-infos' => {
                'type' => 'vol-footprint-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-footprint-list-info-iter-start' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-get-filer-info' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'allowed-raidtypes' => {
                'type' => 'raidtype-info',
                'flags' => 3,
                'scope' => [],
            },
            'checksum-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'default-raidtype' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'raidgroup-size' => {
                'type' => 'raidgroup-size-info',
                'flags' => 3,
                'scope' => [],
            },
            'root-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots-max' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-get-language' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'language' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'language-code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-character-set' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'oem-character-set' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-get-root-name' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-get-supported-guarantees' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'guarantee-types' => {
                'type' => 'guarantee',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-list-info' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'volumes' => {
                'type' => 'volume-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-list-info-iter-end' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-list-info-iter-next' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'volume-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-list-info-iter-start' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-mediascrub-list-info' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'mediascrub-details' => {
                'type' => 'mediascrub-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-mirror' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'victim-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'volume-move-abort' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'source-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-move-cutover' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'cutover-window' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-move-pause' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'source-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-move-resume' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'cutover-attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cutover-window' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-keep-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-manual-cutover' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-override-warnings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'source-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'errors-warnings' => {
                'type' => 'errors-warnings-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'volume-move-start' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'cutover-attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cutover-window' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dest-aggr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-keep-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'is-manual-cutover' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'is-override-warnings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'perform-validation-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'source-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'errors-warnings' => {
                'type' => 'errors-warnings-info',
                'flags' => 7,
                'scope' => ['ontap-c'],
            },
        },
    },
    'volume-move-status' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'is-verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'source-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'status' => {
                'type' => 'vol-move-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-offline' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'cifs-delay' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-online' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-options-list-info' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'options' => {
                'type' => 'volume-option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-rename' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-restrict' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'cifs-delay' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-scrub-list-info' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'scrub-details' => {
                'type' => 'scrub-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-scrub-resume' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-scrub-start' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-scrub-stop' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-scrub-suspend' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-set-language' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'vfiler'],
        'inputs' => {
            'language-code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-set-option' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-set-total-files' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'requested-total-files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'resulting-total-files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-size' => {
        'category' => 'volume',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-fixed-size-flex-volume' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-readonly-flex-volume' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-replica-flex-volume' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume-size' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-space-list-info' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'vol-space-infos' => {
                'type' => 'vol-space-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-space-list-info-iter-end' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-space-list-info-iter-next' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vol-space-infos' => {
                'type' => 'vol-space-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-space-list-info-iter-start' => {
        'category' => 'volume',
        'family' => ['ontap-c'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-split' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'new-volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-verify-list-info' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'verify-details' => {
                'type' => 'verify-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-verify-resume' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-verify-start' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'fix-plex' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'log-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-verify-stop' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-verify-suspend' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-wafl-info' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'checksum-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'root-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots-max' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'wafl-sync' => {
        'category' => 'wafl',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volumes' => {
                'type' => 'volume-name',
                'flags' => 6,
                'scope' => ['ontap-c', 'ontap-vserver', 'vfiler'],
            },
        },
        'outputs' => {
        },
    },
};

my $TYPEDEFS = {
    'aggr-64bit-upgrade-check-info' => {
        'category' => 'aggr',
        'fields' => {
            'added-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cookie' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-estimate-complete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggr-64bit-upgrade-info' => {
        'category' => 'aggr',
        'fields' => {
            'check' => {
                'type' => 'aggr-64bit-upgrade-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'start' => {
                'type' => 'aggr-64bit-upgrade-start-info',
                'flags' => 5,
                'scope' => [],
            },
            'status' => {
                'type' => 'aggr-64bit-upgrade-status-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'aggr-64bit-upgrade-start-info' => {
        'category' => 'aggr',
        'fields' => {
            'last-errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-space-for-upgrade' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggr-64bit-upgrade-status-info' => {
        'category' => 'aggr',
        'fields' => {
            'block-format' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-info' => {
        'category' => 'aggr',
        'fields' => {
            'aggr-64bit-upgrade' => {
                'type' => 'aggr-64bit-upgrade-info',
                'flags' => 5,
                'scope' => [],
            },
            'aggregate-space-details' => {
                'type' => 'aggregate-space-info',
                'flags' => 5,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cache-raid-group-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'checksum-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dr-home-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dr-home-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'files-private-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'files-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'files-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'free-space-realloc' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ha-policy' => {
                'type' => 'ha-policy-type',
                'flags' => 4,
                'scope' => [],
            },
            'has-local-root' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'has-partner-root' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'home-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'home-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'inodefile-private-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inodefile-public-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-checksum-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-hybrid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-hybrid-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-inconsistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-mirrored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snaplock' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'max-write-alloc-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'mount-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'owner-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'plex-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'plexes' => {
                'type' => 'plex-info',
                'flags' => 3,
                'scope' => [],
            },
            'raid-lost-write-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'raid-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-percentage-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'size-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'striping' => {
                'type' => 'striping-type',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-count-collective' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-count-mirrors' => {
                'type' => 'mirror-count-info',
                'flags' => 5,
                'scope' => [],
            },
            'volume-count-not-online' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-count-quiesced' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-count-striped' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'contained-volume-info',
                'flags' => 3,
                'scope' => [],
            },
            'wafliron' => {
                'type' => 'aggr-wafliron-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'aggr-option-info' => {
        'category' => 'aggr',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-space-info' => {
        'category' => 'aggr',
        'fields' => {
            'aggregate-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size-asis-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-bssm-nvlog-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'size-free' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-image-backup-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-metadata' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-nominal' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-snap-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-volume-allocated' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-volume-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'volume-space-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-wafliron-info' => {
        'category' => 'aggr',
        'fields' => {
            'last-start-errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-start-error-info' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'scan-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'summary-scan-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggregate-space-info' => {
        'category' => 'aggr',
        'fields' => {
            'aggregate-space' => {
                'type' => 'fs-space-info',
                'flags' => 1,
                'scope' => [],
            },
            'snapshot-space' => {
                'type' => 'snapshot-space-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'contained-volume-info' => {
        'category' => 'aggr',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-info' => {
        'category' => 'aggr',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'filter-attrs-info' => {
        'category' => 'aggr',
        'fields' => {
            'all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-cfo' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dr-auxiliary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dr-partner' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-local' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-partner' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sfo' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fs-space-info' => {
        'category' => 'aggr',
        'fields' => {
            'fs-aggregate-metadata' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-files-private-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-files-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-files-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-hybrid-cache-size-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-inodefile-private-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-inodefile-public-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-maxfiles-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-maxfiles-possible' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-maxfiles-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-percent-inode-used-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-percent-used-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-sis-percent-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-sis-saved-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-sis-shared-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fs-size-available' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-size-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-size-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-total-reserved-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-used-including-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fs-volume-footprints' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ha-policy-type' => {
        'category' => 'aggr',
        'fields' => {
        },
    },
    'mirror-count-info' => {
        'category' => 'aggr',
        'fields' => {
            'dp-qtree-snapmirror-destinations' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dp-snapmirror-destinations' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ls-snapmirror-destinations' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'move-snapmirror-destinations' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'node-name' => {
        'category' => 'aggr',
        'fields' => {
        },
    },
    'plex-info' => {
        'category' => 'aggr',
        'fields' => {
            'is-online' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-resyncing' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'plex-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-groups' => {
                'type' => 'raid-group-info',
                'flags' => 7,
                'scope' => [],
            },
            'resync-level' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resyncing-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'raid-group-info' => {
        'category' => 'aggr',
        'fields' => {
            'checksum-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 3,
                'scope' => [],
            },
            'is-cache-tier' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-recomputing-parity' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-reconstructing' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-scrub-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'last-scrub-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'recomputing-parity-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reconstruction-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'scrub-percentage-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapshot-space-info' => {
        'category' => 'aggr',
        'fields' => {
            'snapshot-files-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-files-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-maxfiles-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-maxfiles-possible' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-maxfiles-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-percent-inode-used-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-percent-used-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-sis-percent-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-sis-saved-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-sis-shared-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-size-available' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-size-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-size-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'striping-type' => {
        'category' => 'aggr',
        'fields' => {
        },
    },
    'verify-detail-info' => {
        'category' => 'aggr',
        'fields' => {
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'percentage-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-space-info' => {
        'category' => 'aggr',
        'fields' => {
            'guarantee' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-allocated' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'warning-code' => {
        'category' => 'aggr',
        'fields' => {
            'code' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-name' => {
        'category' => 'cg',
        'fields' => {
        },
    },
    'access-rights-info' => {
        'category' => 'cifs',
        'fields' => {
            'access-rights' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unix-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'address-info' => {
        'category' => 'cifs',
        'fields' => {
            'has-nossl' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-broken' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-multihomed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-primary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cifs-functional-level' => {
        'category' => 'cifs',
        'fields' => {
        },
    },
    'cifs-session-info' => {
        'category' => 'cifs',
        'fields' => {
            'change-notifies' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dirs' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shares' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volumes-list' => {
                'type' => 'volumes-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'cifs-setup-ou' => {
        'category' => 'cifs',
        'fields' => {
        },
    },
    'cifs-setup-site' => {
        'category' => 'cifs',
        'fields' => {
        },
    },
    'cifs-share-acl-info' => {
        'category' => 'cifs',
        'fields' => {
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-acl-info' => {
                'type' => 'access-rights-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'cifs-share-info' => {
        'category' => 'cifs',
        'fields' => {
            'caching' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dir-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'forcegroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-access-based-enum' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-browse' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-namespace-caching-allowed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-symlink-strict-security' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vol-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vscanread' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-widelink' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maxusers' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mount-point' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cifs-top-info' => {
        'category' => 'cifs',
        'fields' => {
            'ops-per-sec' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'suspicious-per-sec' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-info' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'connection-info' => {
        'category' => 'cifs',
        'fields' => {
            'connected-address' => {
                'type' => 'address-info',
                'flags' => 7,
                'scope' => [],
            },
            'favored-address' => {
                'type' => 'address-info',
                'flags' => 7,
                'scope' => [],
            },
            'other-address' => {
                'type' => 'address-info',
                'flags' => 7,
                'scope' => [],
            },
            'preferred-address' => {
                'type' => 'address-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'homedir-path-info' => {
        'category' => 'cifs',
        'fields' => {
        },
    },
    'nbalias-name-info' => {
        'category' => 'cifs',
        'fields' => {
        },
    },
    'path-error-info' => {
        'category' => 'cifs',
        'fields' => {
            'error-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'error-path-desc' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volumes-list-info' => {
        'category' => 'cifs',
        'fields' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'block-range' => {
        'category' => 'clone',
        'fields' => {
            'block-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-block-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-block-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-id-info' => {
        'category' => 'clone',
        'fields' => {
            'clone-op-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ops-info' => {
        'category' => 'clone',
        'fields' => {
            'block-ranges' => {
                'type' => 'block-range',
                'flags' => 7,
                'scope' => [],
            },
            'blocks-copied' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'clone-id' => {
                'type' => 'clone-id-info',
                'flags' => 5,
                'scope' => [],
            },
            'clone-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'clone-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-file' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'error' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'percent-done' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-file' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'total-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'copyoffload-status-info' => {
        'category' => 'copyoffload',
        'fields' => {
            'bytes-copied' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'copy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'copyoffload-error' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'copyoffload-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'datetime' => {
        'category' => 'core-segment',
        'fields' => {
        },
    },
    'date' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'diagnosis-alert-definition-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'additional-information' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alert-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alert-type' => {
                'type' => 'hm-alert-type',
                'flags' => 4,
                'scope' => [],
            },
            'corrective-actions' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'perceived-severity' => {
                'type' => 'hm-perceived-sev',
                'flags' => 4,
                'scope' => [],
            },
            'possible-effect' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'probable-cause' => {
                'type' => 'hm-probable-cause',
                'flags' => 4,
                'scope' => [],
            },
            'probable-cause-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'acknowledge' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'acknowledger' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'additional-info' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'alert-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alerting-resource-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'corrective-actions' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'indication-time' => {
                'type' => 'date',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'perceived-severity' => {
                'type' => 'hm-perceived-sev',
                'flags' => 4,
                'scope' => [],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'possible-effect' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'probable-cause' => {
                'type' => 'hm-probable-cause',
                'flags' => 4,
                'scope' => [],
            },
            'probable-cause-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 4,
                'scope' => [],
            },
            'suppress' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'suppressor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'diagnosis-config-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'aggregator' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'context' => {
                'type' => 'hm-scope',
                'flags' => 4,
                'scope' => [],
            },
            'health' => {
                'type' => 'hm-status',
                'flags' => 4,
                'scope' => [],
            },
            'init-state' => {
                'type' => 'hm-subsystem-discovery-state',
                'flags' => 4,
                'scope' => [],
            },
            'mon-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pol-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resources' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'sub-pol-versions' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'diagnosis-policy-definition-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'alert-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'alert-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'creation-time' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'enable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'responsible-resource-info' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rule-expression' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'where' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'diagnosis-status' => {
        'category' => 'diagnosis',
        'fields' => {
            'status' => {
                'type' => 'hm-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'creation-time' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 4,
                'scope' => [],
            },
            'fail-thresh' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-notify-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 4,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 4,
                'scope' => [],
            },
            'notify-fptr' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'notify-table' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'notify-type' => {
                'type' => 'hm-notify-type',
                'flags' => 4,
                'scope' => [],
            },
            'psc-option' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-gap-notify' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'diagnosis-subsystem-config-info' => {
        'category' => 'diagnosis',
        'fields' => {
            'health' => {
                'type' => 'hm-status',
                'flags' => 4,
                'scope' => [],
            },
            'init-state' => {
                'type' => 'hm-subsystem-discovery-state',
                'flags' => 4,
                'scope' => [],
            },
            'outstanding-alert-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 4,
                'scope' => [],
            },
            'suppressed-alert-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'hm-alert-type' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-event-type' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-notify-type' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-perceived-sev' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-probable-cause' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-scope' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-status' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-subsystem' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-subsystem-discovery-state' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'hm-type' => {
        'category' => 'diagnosis',
        'fields' => {
        },
    },
    'disk-detail-info' => {
        'category' => 'disk',
        'fields' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'bay' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'blocks-read' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'blocks-written' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'broken-details' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'bytes-per-sector' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'checksum-compatibility' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'copy-destination' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'copy-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'effective-disk-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'grown-defect-list-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-dynamically-qualified' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-prefailed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-replacing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-zeroed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'physical-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'physical-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'poweron-hours' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'raid-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'raw-disk-sectors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reconstruction-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'scrub-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scrub-last-done' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-host-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shm-time-interval' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ssd-info' => {
                'type' => 'storage-ssd-info',
                'flags' => 5,
                'scope' => [],
            },
            'used-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'used-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'v-series-detail-info' => {
                'type' => 'v-series-detail-info',
                'flags' => 5,
                'scope' => [],
            },
            'vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'zeroing-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-name' => {
        'category' => 'disk',
        'fields' => {
        },
    },
    'disk-sanown-detail-info' => {
        'category' => 'disk',
        'fields' => {
            'checksum' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'home' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'home-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-failed' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reserved-by' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'serial-no' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-sanown-filer-detail-info' => {
        'category' => 'disk',
        'fields' => {
            'filer-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-ssd-info' => {
        'category' => 'disk',
        'fields' => {
            'percent-rated-life-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'percent-spares-consumed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'percent-spares-consumed-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'v-series-detail-info' => {
        'category' => 'disk',
        'fields' => {
            'alternate-array-node-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alternate-array-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alternate-array-switch-port-wwn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alternate-controller-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alternate-lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'alternate-switch-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alternate-switch-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'alternate-vseries-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-array-node-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-array-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-array-switch-port-wwn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-controller-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'primary-switch-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-switch-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'primary-vseries-port-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'product-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'param' => {
        'category' => 'ems',
        'fields' => {
        },
    },
    'fc-config-info' => {
        'category' => 'fc',
        'fields' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'pending-fc-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aliases-info' => {
        'category' => 'fcp',
        'fields' => {
            'aliases-alias' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'aliases-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-initiators-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fcp-connected-initiators' => {
                'type' => 'fcp-connected-initiator-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-nameserver-object-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'class-service' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fabric-port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fc4-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'symbolic-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'symbolic-port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-stats-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-resets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'crc-errors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'discarded-frames' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'frame-overruns' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'frame-underruns' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiators-connected' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'invalid-xmit-words' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-sfp-diagnostics-internally-calibrated' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sfp-optical-transceiver-valid' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-sfp-rx-power-in-range' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sfp-tx-power-in-range' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'link-breaks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lip-resets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lr-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lr-sent' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nos-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ols-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protocol-errors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'queue-depth' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scsi-requests-dropped' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sfp-connector' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-date-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-encoding' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-fc-speedcapabilities' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-formfactor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-rx-power' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-tx-power' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-vendor-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-vendor-oui' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sfp-wavelength' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'spurious-interrupts' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-logins' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-logouts' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-topology-attached-port-info' => {
        'category' => 'fcp',
        'fields' => {
            'is-visible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-topology-switch-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fcp-adapter-topology-switch-ports' => {
                'type' => 'fcp-adapter-topology-switch-port-info',
                'flags' => 7,
                'scope' => [],
            },
            'logical-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'release' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-topology-switch-port-info' => {
        'category' => 'fcp',
        'fields' => {
            'fcp-adapter-topology-attached-ports' => {
                'type' => 'fcp-adapter-topology-attached-port-info',
                'flags' => 3,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-zone-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fcp-adapter-zone-members' => {
                'type' => 'fcp-adapter-zone-member-info',
                'flags' => 1,
                'scope' => [],
            },
            'zone-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'zone-set-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-zone-member-info' => {
        'category' => 'fcp',
        'fields' => {
            'domain-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fabric-port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'zone-member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'zone-member-value' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fcp-config-adapter-info' => {
        'category' => 'fcp',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'cache-line-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'connection-established' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'data-link-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'error-msg' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'external-gbic-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'fabric-established' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hardware-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'info-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'loop-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'media-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mpi-firmware-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'packet-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'partner-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'pci-bus-width' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'pci-clock-speed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'phy-firmware-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'physical-data-link-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'physical-link-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-address' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'preload-table-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'speed' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sram-parity-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'standby' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'switch-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vlan-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fcp-connected-initiator-info' => {
        'category' => 'fcp',
        'fields' => {
            'initiator-group-list' => {
                'type' => 'initiator-group-list-info',
                'flags' => 7,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-address' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portname-alias-list' => {
                'type' => 'portname-alias-name',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'fcp-port-name-info' => {
        'category' => 'fcp',
        'fields' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-used' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'portname-alias-name' => {
        'category' => 'fcp',
        'fields' => {
            'portname-alias' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fc-ports' => {
        'category' => 'fcport',
        'fields' => {
            'port-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'switch-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'switch-wwn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'link-state-info' => {
        'category' => 'fcport',
        'fields' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc-port-info' => {
                'type' => 'fc-ports',
                'flags' => 5,
                'scope' => [],
            },
            'link-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'managed-feature' => {
        'category' => 'feature',
        'fields' => {
        },
    },
    'managed-feature-status' => {
        'category' => 'feature',
        'fields' => {
        },
    },
    'managed-feature-status-info' => {
        'category' => 'feature',
        'fields' => {
            'feature-name' => {
                'type' => 'managed-feature',
                'flags' => 4,
                'scope' => [],
            },
            'notes' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'managed-feature-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'digest-algorithm' => {
        'category' => 'file',
        'fields' => {
        },
    },
    'file-fingerprint-info' => {
        'category' => 'file',
        'fields' => {
            'access-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'changed-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'creation-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-fingerprint' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'file-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fileid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-access-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-changed-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-creation-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-modified-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-retention-time' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-changed-time-wraparound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-wraparound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-fingerprint' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'modified-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'owner-sid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'retention-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'file-info' => {
        'category' => 'file',
        'fields' => {
            'accessed-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'acl-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'bytes-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'changed-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'creation-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'file-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'file-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hard-links-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inode-gen-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'inode-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-empty' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-junction' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vm-aligned' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'modified-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'perm' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-scope' => {
        'category' => 'file',
        'fields' => {
        },
    },
    'fingerprint-info' => {
        'category' => 'file',
        'fields' => {
            'aggregate-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'filer-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fingerprint-algorithm' => {
                'type' => 'digest-algorithm',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-end-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-input-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-scope' => {
                'type' => 'file-scope',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-start-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fingerprint-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-fingerprint-end-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-fingerprint-start-time' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-snaplock-system-compliance-clock' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'formatted-snaplock-volume-compliance-clock' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'formatted-volume-expiry-date' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-volume-expiry-date-wraparound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-files' => {
                'type' => 'file-fingerprint-info',
                'flags' => 3,
                'scope' => [],
            },
            'snaplock-license' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-system-compliance-clock' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-volume-compliance-clock' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-containing-aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-expiry-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'hole-range-info' => {
        'category' => 'file',
        'fields' => {
            'hole-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hole-start' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'inode-parent-info' => {
        'category' => 'file',
        'fields' => {
            'inode-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'inode-parent-cookie' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'inode-parent-inode-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'inode-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'flash-device-info' => {
        'category' => 'flash',
        'fields' => {
            'average-erase-cycle-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-change-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'model-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'part-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'percent-online' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'service-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'slot-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-profile' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flash-threshold' => {
        'category' => 'flash',
        'fields' => {
            'action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-units' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-value' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'time-slice' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flash-threshold-profile' => {
        'category' => 'flash',
        'fields' => {
            'flash-threshold' => {
                'type' => 'flash-threshold',
                'flags' => 3,
                'scope' => [],
            },
            'profile' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'extension-list-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'name-spec' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-volumes-list-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'volume-spec' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'monitored-operation-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'monitored-protocol-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'policy-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'is-ads-monitored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-i2p-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-offline-files-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monitored-operations' => {
                'type' => 'monitored-operation-info',
                'flags' => 3,
                'scope' => [],
            },
            'monitored-protocols' => {
                'type' => 'monitored-protocol-info',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'number-of-requests-blocked-locally' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'number-of-screen-failures' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'number-of-screened-files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'secondary-server-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'server-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'server-info' => {
        'category' => 'fpolicy',
        'fields' => {
            'idl-version' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-asynchronous' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-size-and-owner-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapid-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-version2' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'number-of-screen-failures' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'number-of-screened-files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'offline-filter-bit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'server-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'server-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'smb-req-pipe-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ic-config-details' => {
        'category' => 'ic',
        'fields' => {
            'ic-rlib-if' => {
                'type' => 'ic-rlib-if-info',
                'flags' => 7,
                'scope' => [],
            },
            'ic-system-id' => {
                'type' => 'ic-system-id-info',
                'flags' => 3,
                'scope' => [],
            },
            'interconnect-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-config' => {
                'type' => 'interface-config-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ic-counter' => {
        'category' => 'ic',
        'fields' => {
            'counter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'counter-value' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ic-rlib-if-info' => {
        'category' => 'ic',
        'fields' => {
            'interface-ip' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ic-system-id-info' => {
        'category' => 'ic',
        'fields' => {
            'is-connection-initiator' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nvram-per-port-counters-info' => {
        'category' => 'ic',
        'fields' => {
            'counter-list' => {
                'type' => 'ic-counter',
                'flags' => 7,
                'scope' => [],
            },
            'port-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'per-link-parameters-info' => {
        'category' => 'ic',
        'fields' => {
            'link-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'link-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'num-mad-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'num-mad-sent' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'num-recv-desc' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-mtu' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'queue-info' => {
        'category' => 'ic',
        'fields' => {
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-complete-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-polled-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'virtual-interface-socket-stat-info' => {
        'category' => 'ic',
        'fields' => {
            'channel-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'per-channel-counters' => {
                'type' => 'ic-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'initiator-group-info' => {
        'category' => 'igroup',
        'fields' => {
            'initiator-group-alua-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-portset-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-report-scsi-name-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'initiator-group-throttle-borrow' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-throttle-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-use-partner' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-vsa-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiators' => {
                'type' => 'initiator-info',
                'flags' => 7,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'initiator-group-list-info' => {
        'category' => 'igroup',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'initiator-group-os-type' => {
        'category' => 'igroup',
        'fields' => {
        },
    },
    'initiator-info' => {
        'category' => 'igroup',
        'fields' => {
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'interface-info' => {
        'category' => 'ipspace',
        'fields' => {
            'interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ipspace-info' => {
        'category' => 'ipspace',
        'fields' => {
            'interfaces' => {
                'type' => 'interface-info',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'interface-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ipaddress-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-adapter-initiators-info' => {
        'category' => 'iscsi',
        'fields' => {
            'iscsi-connected-initiators' => {
                'type' => 'iscsi-connected-initiator-info',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-cdb-stats-info' => {
        'category' => 'iscsi',
        'fields' => {
            'data-in-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-out-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'error-status' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'success-status' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-config-adapter-info' => {
        'category' => 'iscsi',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portal-addresses' => {
                'type' => 'iscsi-portal-address-info',
                'flags' => 3,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-connected-initiator-info' => {
        'category' => 'iscsi',
        'fields' => {
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'isid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portal-group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-connection-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'connection-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'has-session' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-ip-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'remote-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'remote-ip-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-error-stats-info' => {
        'category' => 'iscsi',
        'fields' => {
            'data-digest' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'failed-logins' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'failed-logouts' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'failed-task-mgt' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'failed-text-cmd' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hdr-digest' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'invalid-header' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'outside-cmd-sn-window' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'initiator-aliasname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-list' => {
                'type' => 'initiator-group-list-info',
                'flags' => 7,
                'scope' => [],
            },
            'initiator-nodename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'isid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-interface-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-interface-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-iptpgroup-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'ipaddress-list-entries' => {
                'type' => 'ipaddress-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
            'tpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-portal-address-info' => {
        'category' => 'iscsi',
        'fields' => {
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inet-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-portal-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ip-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-received-stats-info' => {
        'category' => 'iscsi',
        'fields' => {
            'data-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'login-req' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'logout-req' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nop-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scsi-cmd' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scsi-task-mgt-cmd' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snack' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'text-req' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unknown' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-security-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'auth-chap-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-session-connection-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'authentication-method' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'connection-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-digest-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'header-digest-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-max-rcv-data-segment-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-ip-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rcv-window-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'remote-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'remote-ip-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-max-rcv-data-segment-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-session-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'cmd-window-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-pdu-in-order' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'data-sequence-in-order' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'default-time-to-retain' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'default-time-to-wait' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'error-recovery-level' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'first-burst-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'immediate-data-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initial-r2t-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-aliasname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-nodename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'iscsi-session-connection-list-entries' => {
                'type' => 'iscsi-session-connection-list-entry-info',
                'flags' => 3,
                'scope' => [],
            },
            'iscsi-sesssion-cmd-list-entries' => {
                'type' => 'iscsi-sesssion-cmd-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'isid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'max-burst-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-connections' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-outstanding-r2t' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'session-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-sesssion-cmd-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'cmd-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cmd-sub-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cmd-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-stats-info' => {
        'category' => 'iscsi',
        'fields' => {
            'iscsi-cdb-stats' => {
                'type' => 'iscsi-cdb-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'iscsi-error-stats' => {
                'type' => 'iscsi-error-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'iscsi-received-stats' => {
                'type' => 'iscsi-received-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'iscsi-transmitted-stats' => {
                'type' => 'iscsi-transmitted-stats-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'iscsi-tpgroup-list-entry-info' => {
        'category' => 'iscsi',
        'fields' => {
            'interface-list-entries' => {
                'type' => 'interface-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'tpgroup-alua-preferred' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'tpgroup-alua-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'tpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-transmitted-stats-info' => {
        'category' => 'iscsi',
        'fields' => {
            'async-msg' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'login-rsp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'logout-rsp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nop-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ready-to-transmit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reject' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scsi-rsp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scsi-task-mgt-rsp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'text-rsp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'license-info' => {
        'category' => 'license',
        'fields' => {
            'code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'expiration-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'installation-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-auto-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-demo' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-expired' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-licensed' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-site' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'node-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'package-list' => {
                'type' => 'package-master',
                'flags' => 6,
                'scope' => [],
            },
            'platform' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'service' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'package-master' => {
        'category' => 'license',
        'fields' => {
        },
    },
    'license-code-v2' => {
        'category' => 'license-v2',
        'fields' => {
        },
    },
    'license-v2-added' => {
        'category' => 'license-v2',
        'fields' => {
            'customer-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-time' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'license-key' => {
                'type' => 'license-code-v2',
                'flags' => 4,
                'scope' => [],
            },
            'package' => {
                'type' => 'licensed-package',
                'flags' => 4,
                'scope' => [],
            },
            'package-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'node-serial-number',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'license-v2-type',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'license-v2-info' => {
        'category' => 'license-v2',
        'fields' => {
            'customer-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-time' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'grace-period-expiration' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'is-in-grace-period' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c'],
            },
            'legacy' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'package' => {
                'type' => 'licensed-package',
                'flags' => 4,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'node-serial-number',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'license-v2-type',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'license-v2-op-status' => {
        'category' => 'license-v2',
        'fields' => {
        },
    },
    'license-v2-result' => {
        'category' => 'license-v2',
        'fields' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'entry' => {
                'type' => 'license-code-v2',
                'flags' => 4,
                'scope' => [],
            },
            'errcode' => {
                'type' => 'license-v2-op-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'license-v2-type' => {
        'category' => 'license-v2',
        'fields' => {
        },
    },
    'licensed-package' => {
        'category' => 'license-v2',
        'fields' => {
        },
    },
    'node-serial-number' => {
        'category' => 'license-v2',
        'fields' => {
        },
    },
    'break-error' => {
        'category' => 'lock',
        'fields' => {
            'err' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-lock' => {
        'category' => 'lock',
        'fields' => {
            'absolute-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'bytelock-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'bytelock-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dh-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fileid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-bytelock-exclusive' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lock-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'oplock-level' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'lock-status-info' => {
        'category' => 'lock',
        'fields' => {
            'cifs-lock' => {
                'type' => 'cifs-lock',
                'flags' => 5,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'nfsv4-lock' => {
                'type' => 'nfsv4-lock',
                'flags' => 5,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'nlm-lock' => {
                'type' => 'nlm-lock',
                'flags' => 5,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'pfs-lock' => {
                'type' => 'pfs-lock',
                'flags' => 5,
                'scope' => ['ontap-c', 'vfiler'],
            },
        },
    },
    'nfsv4-lock' => {
        'category' => 'lock',
        'fields' => {
            'bytelock-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'bytelock-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fileid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'is-bytelock-exclusive' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lock-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state-index-table' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'nlm-lock' => {
        'category' => 'lock',
        'fields' => {
            'bytelock-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'bytelock-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fileid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-bytelock-exclusive' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'last-hop-caching-filer' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'lock-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'pfs-lock' => {
        'category' => 'lock',
        'fields' => {
            'fileid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fsid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'lock-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'alua-setting-mismatch-initiator-group' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-alua-is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'partner-alua-is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'alua-setting-mismatch-initiator-info' => {
        'category' => 'lun',
        'fields' => {
            'alua-is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-status-info' => {
        'category' => 'lun',
        'fields' => {
            'blocks-completed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'blocks-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'conflict-wwpn' => {
        'category' => 'lun',
        'fields' => {
        },
    },
    'conflicting-initiator-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-local-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-partner-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'conflicting-luns-list' => {
        'category' => 'lun',
        'fields' => {
            'conflict-lun-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'conflicting-map-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-down-hba-info' => {
        'category' => 'lun',
        'fields' => {
            'adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-pr-nexus' => {
        'category' => 'lun',
        'fields' => {
            'initiator-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'invalid-cfmode-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'local-fcp-cfmode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'partner-fcp-cfmode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'invalid-nodename-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'local-fcp-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'partner-fcp-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'invalid-ostype-cfmode-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'invalid-use-partner-cfmode-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-use-partner-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'invalid-use-partner-ostype-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'is-use-partner-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'invalid-vsa-setting-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'is-vsa-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-pr-nexus' => {
        'category' => 'lun',
        'fields' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'isid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgtag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
        },
    },
    'lun-clone-lists-info' => {
        'category' => 'lun',
        'fields' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-info' => {
        'category' => 'lun',
        'fields' => {
            'alignment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backing-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'block-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'clone-backing-snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'device-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mapped' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'multiprotocol-type' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
            'online' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'share-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'size-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'staging' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'suffix-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'lun-map-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-os-type' => {
        'category' => 'lun',
        'fields' => {
        },
    },
    'lun-snap-usage-lun-info' => {
        'category' => 'lun',
        'fields' => {
            'backing-store' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-stats-info' => {
        'category' => 'lun',
        'fields' => {
            'block-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-zeroed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'other-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'read-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'mixed-ostype-initiator-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name-1' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name-2' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type-1' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-os-type-2' => {
                'type' => 'initiator-group-os-type',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'mixed-vsa-initiator-info' => {
        'category' => 'lun',
        'fields' => {
            'initiator-group-name-1' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name-2' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-vsa-enabled-1' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-vsa-enabled-2' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'persistent-reservation-info' => {
        'category' => 'lun',
        'fields' => {
            'fcp-pr-nexus' => {
                'type' => 'fcp-pr-nexus',
                'flags' => 5,
                'scope' => [],
            },
            'iscsi-pr-nexus' => {
                'type' => 'iscsi-pr-nexus',
                'flags' => 5,
                'scope' => [],
            },
            'reservation-key' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reservation-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'reservation-type-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'address-info-family' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'address-info-flag' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'address-info-socket-type' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'address-info-transport-protocol' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'config-status-info' => {
        'category' => 'net',
        'fields' => {
            'operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-info' => {
        'category' => 'net',
        'fields' => {
            'hints' => {
                'type' => 'net-address-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'service-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-name' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'ifgrp-info' => {
        'category' => 'net',
        'fields' => {
            'favored' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ifgrp-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ifgrp-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'links' => {
                'type' => 'link',
                'flags' => 6,
                'scope' => [],
            },
            'nofavored' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'interface-config-info' => {
        'category' => 'net',
        'fields' => {
            'aliases' => {
                'type' => 'ip-address-info',
                'flags' => 7,
                'scope' => [],
            },
            'dad-attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'flowcontrol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfo-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-trusted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-wins-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mac-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mediatype' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mtusize' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'partner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-role' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'v4-primary-address' => {
                'type' => 'ip-address-info',
                'flags' => 5,
                'scope' => [],
            },
            'v6-primary-address' => {
                'type' => 'ip-address-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'interface-dcb-entry-info' => {
        'category' => 'net',
        'fields' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'bandwidth-percentage' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'priority-entries' => {
                'type' => 'priority-entry-info',
                'flags' => 3,
                'scope' => [],
            },
            'priority-group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'interface-dcb-priority-entry-info' => {
        'category' => 'net',
        'fields' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-flow-control-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'priority' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'priority-group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ip-address' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'ip-address-info' => {
        'category' => 'net',
        'fields' => {
            'addr-family' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'address' => {
                'type' => 'ip-address-or-hostname',
                'flags' => 0,
                'scope' => [],
            },
            'broadcast' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'creator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lif-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'netmask-or-prefix' => {
                'type' => 'netmask-or-prefix',
                'flags' => 4,
                'scope' => [],
            },
            'no-ddns' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ip-address-or-hostname' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'ipspace-config-info' => {
        'category' => 'net',
        'fields' => {
            'interface-list' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'link' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'net-address-info' => {
        'category' => 'net',
        'fields' => {
            'address-info-family' => {
                'type' => 'address-info-family',
                'flags' => 4,
                'scope' => [],
            },
            'address-info-flags' => {
                'type' => 'address-info-flag',
                'flags' => 6,
                'scope' => [],
            },
            'address-info-socket-type' => {
                'type' => 'address-info-socket-type',
                'flags' => 4,
                'scope' => [],
            },
            'address-info-transport-protocol' => {
                'type' => 'address-info-transport-protocol',
                'flags' => 4,
                'scope' => [],
            },
            'canonical-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-config-info' => {
        'category' => 'net',
        'fields' => {
            'config-status' => {
                'type' => 'config-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'ifgrps' => {
                'type' => 'ifgrp-info',
                'flags' => 7,
                'scope' => [],
            },
            'interfaces' => {
                'type' => 'interface-config-info',
                'flags' => 3,
                'scope' => [],
            },
            'routes' => {
                'type' => 'route-info',
                'flags' => 7,
                'scope' => [],
            },
            'vlans' => {
                'type' => 'vlan-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'net-dcb-entry-info' => {
        'category' => 'net',
        'fields' => {
            'interface-dcb-entries' => {
                'type' => 'interface-dcb-entry-info',
                'flags' => 3,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-dcb-priority-entry-info' => {
        'category' => 'net',
        'fields' => {
            'interface-dcb-priority-entries' => {
                'type' => 'interface-dcb-priority-entry-info',
                'flags' => 3,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'netmask-or-prefix' => {
        'category' => 'net',
        'fields' => {
        },
    },
    'priority-entry-info' => {
        'category' => 'net',
        'fields' => {
            'priority' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'route-info' => {
        'category' => 'net',
        'fields' => {
            'addr-family' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'creator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination' => {
                'type' => 'ip-address-or-hostname',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'metric' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'next-hop' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'prefixlen' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'route-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vlan-info' => {
        'category' => 'net',
        'fields' => {
            'gvrp-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'parent-interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vlanid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'exports-hostname-info' => {
        'category' => 'nfs',
        'fields' => {
            'all-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'negate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'exports-rule-info' => {
        'category' => 'nfs',
        'fields' => {
            'actual-pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'anon' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nosuid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'read-only' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'read-write' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'root' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'sec-flavor' => {
                'type' => 'sec-flavor-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'exports-rule-info-2' => {
        'category' => 'nfs',
        'fields' => {
            'actual-pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'security-rules' => {
                'type' => 'security-rule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'hostaddr' => {
        'category' => 'nfs',
        'fields' => {
        },
    },
    'nfs-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'badcalls-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'calls-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nfsv2-client-stats' => {
                'type' => 'nfsv2-client-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'nfsv3-client-stats' => {
                'type' => 'nfsv3-client-stats-info',
                'flags' => 1,
                'scope' => [],
            },
            'nfsv4-client-stats' => {
                'type' => 'nfsv4-client-stats-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nfs-top-info' => {
        'category' => 'nfs',
        'fields' => {
            'client-info' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'create-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'getattr-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lookup-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readlink-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'remove-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfsv2-client-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'create-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'getattr-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'link-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lookup-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mkdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'null-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readlink-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'remove-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rename-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rmdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'root-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'setattr-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'statfs-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'symlink-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'wrcache-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfsv3-client-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'access-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'commit-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'create-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fsinfo-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fsstat-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'getattr-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'link-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lookup-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mkdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mknod-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'null-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'pathconf-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readdirplus-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'readlink-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'remove-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rename-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rmdir-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'setattr-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'symlink-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfsv4-client-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'access-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'acls-set-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'badproc2-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'close-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'commit-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'compound-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'create-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'delegpurge' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'delegret-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'getattr-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'getfh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'link-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lock-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lockt-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'locku-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lookup-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lookupp-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'no-delegation-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'null-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nverify-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'open-confirm-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'open-downgrade-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'open-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'openattr-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'putfh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'putpubfh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'putrootfh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-delegation-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'readdir-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'readlink-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'remove-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rename-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'renew-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'restorefh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rlsowner-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'savefh-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'secinfo-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'setattr-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'setclntid-cfm-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'setclntid-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'verify-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'write-delegation-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'write-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'owner-info' => {
        'category' => 'nfs',
        'fields' => {
            'client-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'client-host-pid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'pathname-info' => {
        'category' => 'nfs',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rpc-data-info' => {
        'category' => 'nfs',
        'fields' => {
            'badcalls-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'badlen-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'calls-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nullrecv-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'xdrcall-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rpc-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'tcp-info' => {
                'type' => 'rpc-data-info',
                'flags' => 1,
                'scope' => [],
            },
            'udp-info' => {
                'type' => 'rpc-data-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'sec-flavor-info' => {
        'category' => 'nfs',
        'fields' => {
            'flavor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-rule-info' => {
        'category' => 'nfs',
        'fields' => {
            'anon' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nosuid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'read-only' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'read-write' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'root' => {
                'type' => 'exports-hostname-info',
                'flags' => 7,
                'scope' => [],
            },
            'sec-flavor' => {
                'type' => 'sec-flavor-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'tcp-flowcontrol-stats-info' => {
        'category' => 'nfs',
        'fields' => {
            'receive-out-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'receive-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'transmit-out-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'transmit-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'option-info' => {
        'category' => 'options',
        'fields' => {
            'cluster-constraint' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'counter' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'counter-data' => {
        'category' => 'perf',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'counter-info' => {
        'category' => 'perf',
        'fields' => {
            'base-counter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'desc' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-key' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'labels' => {
                'type' => 'label-info',
                'flags' => 6,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'privilege-level' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'properties' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'instance' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'instance-data' => {
        'category' => 'perf',
        'fields' => {
            'counters' => {
                'type' => 'counter-data',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'instance-info' => {
        'category' => 'perf',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'label-info' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'object-info' => {
        'category' => 'perf',
        'fields' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'get-instances-preferred-counter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'privilege-level' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'initiator-group-name' => {
        'category' => 'portset',
        'fields' => {
        },
    },
    'portset-info' => {
        'category' => 'portset',
        'fields' => {
            'initiator-group-info' => {
                'type' => 'initiator-group-name',
                'flags' => 6,
                'scope' => [],
            },
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-port-info' => {
                'type' => 'portset-port-name',
                'flags' => 6,
                'scope' => [],
            },
            'portset-port-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'portset-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'portset-port-name' => {
        'category' => 'portset',
        'fields' => {
        },
    },
    'priority-volume-info' => {
        'category' => 'priority',
        'fields' => {
            'cache-policy' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'level' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nvlog-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'service' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'system-read-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-read-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-info' => {
        'category' => 'qtree',
        'fields' => {
            'export-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-export-policy-inherited' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'oplocks' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'owning-vfiler' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'error' => {
        'category' => 'quota',
        'fields' => {
            'errno' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota' => {
        'category' => 'quota',
        'fields' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-used' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'files-used' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-users' => {
                'type' => 'quota-user',
                'flags' => 7,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-entry' => {
        'category' => 'quota',
        'fields' => {
            'line' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'quota-error' => {
                'type' => 'quota-error',
                'flags' => 5,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'quota-error' => {
        'category' => 'quota',
        'fields' => {
            'detail' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'errno' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-info' => {
        'category' => 'quota',
        'fields' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-used' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'files-used' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-users' => {
                'type' => 'quota-user',
                'flags' => 3,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-user' => {
        'category' => 'quota',
        'fields' => {
            'quota-user-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-user-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'radius-server-list-entry-info' => {
        'category' => 'radius',
        'fields' => {
            'radius-server-info' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'radius-server-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'radius-server-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'radius-stats-info' => {
        'category' => 'radius',
        'fields' => {
            'access-accepted-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'access-challenged-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'access-rejected-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'authentication-requests' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'denied-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'late-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'retransmitted-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'short-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'timed-out-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unknown-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unknown-server-packets' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'reallocate-job-info' => {
        'category' => 'reallocate',
        'fields' => {
            'flags' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interval' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'layout-factor' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'measure-logfile' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'measure-only' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'scan-detail' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'rsh-session-info' => {
        'category' => 'rsh',
        'fields' => {
            'audit-log' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'audit-shell' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'command' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'command-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'connection-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'get-host-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ip-addr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'alternate-control-path-info' => {
        'category' => 'ses',
        'fields' => {
            'acp-element-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'controller-acp-connection-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'controller-acp-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'controller-acp-ethernet-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'controller-acp-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'controller-acp-netmask' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-acp-element-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-acp-element-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-controller-acp-active' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-controller-acp-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'module-firmware-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module-mac-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module-reset-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'module-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module-status-time' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ariodata-specific-info' => {
        'category' => 'ses',
        'fields' => {
            'ariodata-serial-no' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'bay-info' => {
        'category' => 'ses',
        'fields' => {
            'lun' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-bay' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'connector-info' => {
        'category' => 'ses',
        'fields' => {
            'sas-connector-list' => {
                'type' => 'sas-connector-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'cooling-element-info' => {
        'category' => 'ses',
        'fields' => {
            'cooling-element-is-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cooling-element-is-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cooling-element-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'current-sensor-info' => {
        'category' => 'ses',
        'fields' => {
            'current-sensor-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-sensor-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sensor-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'sensor-condition' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sensor-reading' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dongle-info' => {
        'category' => 'ses',
        'fields' => {
            'disable-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dongle-firmware-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dongle-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'enclosure-info' => {
        'category' => 'ses',
        'fields' => {
            'enclosure-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'module-list' => {
                'type' => 'module-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'es-electronics-info' => {
        'category' => 'ses',
        'fields' => {
            'es-electronics-element-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'es-electronics-is-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'es-electronics-is-not-installed' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'es-electronics-is-reporting-element' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'es-electronics-serial-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'es-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'es-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'es-swap-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'esh-list' => {
                'type' => 'esh-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'esh-info' => {
        'category' => 'ses',
        'fields' => {
            'esh-element-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'esh-is-error' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'eurologic-specific-info' => {
        'category' => 'ses',
        'fields' => {
            'eurologic-application-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-backplane-byte' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-backplane-function' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-backplane-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-cabinet-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-kernel-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'eurologic-serial-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'module-info' => {
        'category' => 'ses',
        'fields' => {
            'is-module-error' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-sas-expander-master-module' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'module-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'phy-expander-info' => {
        'category' => 'ses',
        'fields' => {
            'bay-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'crc-error-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dongle-data' => {
                'type' => 'dongle-info',
                'flags' => 5,
                'scope' => [],
            },
            'invalid-dword-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'link-rate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'loss-dword-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'pathway-timeout' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'phy-change-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'phy-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'phy-power-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'phy-reset-problem' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'phy-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'phy-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'power-cycle-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'release-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reserve-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'running-disparity-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'port-hub-info' => {
        'category' => 'ses',
        'fields' => {
            'clock-delta' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'disk-bay' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'insert-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'invalid-crc-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'invalid-word-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lip-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'loop-up-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'port-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'stall-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'utilization-percentage' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'power-supply-info' => {
        'category' => 'ses',
        'fields' => {
            'is-auto-power-reset-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-power-reset-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-element-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'power-supply-firmware-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-is-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-is-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-part-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-serial-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-swap-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'processor-complex-info' => {
        'category' => 'ses',
        'fields' => {
            'is-pcm-element-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-pcm-element-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pcm-element-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'sas-connector-info' => {
        'category' => 'ses',
        'fields' => {
            'attached-serial-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-end-identifier' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-length' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-manufacturer' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-part-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-serial-no' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-technology' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'connector-designator' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'connector-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-cable-connected' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-connector-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-module' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'swap-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'sas-specific-info' => {
        'category' => 'ses',
        'fields' => {
            'serial-no' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ses-generic-info' => {
        'category' => 'ses',
        'fields' => {
            'ses-chassis-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-config-access' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-config-access-controller-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-config-access-shelf-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-config-access-source-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ses-contact-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ses-logical-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ses-midplane-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-midplane-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-product-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ses-product-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ses-vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'shelf-bay-info' => {
        'category' => 'ses',
        'fields' => {
            'bay-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'bay-list' => {
                'type' => 'bay-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'shelf-bay-list-info' => {
        'category' => 'ses',
        'fields' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'module' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-list' => {
                'type' => 'shelf-bay-port-info',
                'flags' => 7,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-uid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'shelf-bay-port-info' => {
        'category' => 'ses',
        'fields' => {
            'bay-no' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-designator' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'port-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'shelf-environ-channel-address-map' => {
        'category' => 'ses',
        'fields' => {
            'address-map' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'shelf-environ-channel-info' => {
        'category' => 'ses',
        'fields' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-channel-monitor-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-shelf-channel-failure' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-environ-channel-address' => {
                'type' => 'shelf-environ-channel-address-map',
                'flags' => 7,
                'scope' => [],
            },
            'shelf-environ-shelf-list' => {
                'type' => 'shelf-environ-shelf-info',
                'flags' => 3,
                'scope' => [],
            },
            'shelves-present' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'shelf-environ-shelf-info' => {
        'category' => 'ses',
        'fields' => {
            'alternate-control-path-information' => {
                'type' => 'alternate-control-path-info',
                'flags' => 7,
                'scope' => [],
            },
            'ariodata-specific-info' => {
                'type' => 'ariodata-specific-info',
                'flags' => 5,
                'scope' => [],
            },
            'attached-shelf-bay-error-list' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'attached-shelf-bay-list' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'connector-information' => {
                'type' => 'connector-info',
                'flags' => 7,
                'scope' => [],
            },
            'control-writes-attempted' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'control-writes-failed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'controller-device-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'controller-device-path-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cooling-element-list' => {
                'type' => 'cooling-element-info',
                'flags' => 7,
                'scope' => [],
            },
            'current-sensor-list' => {
                'type' => 'current-sensor-info',
                'flags' => 7,
                'scope' => [],
            },
            'enclosure-information' => {
                'type' => 'enclosure-info',
                'flags' => 5,
                'scope' => [],
            },
            'es-electronics-list' => {
                'type' => 'es-electronics-info',
                'flags' => 7,
                'scope' => [],
            },
            'eurologic-specific-info' => {
                'type' => 'eurologic-specific-info',
                'flags' => 5,
                'scope' => [],
            },
            'is-shelf-monitor-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'power-control-failure-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'power-control-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'power-supply-list' => {
                'type' => 'power-supply-info',
                'flags' => 7,
                'scope' => [],
            },
            'processor-complex-information' => {
                'type' => 'processor-complex-info',
                'flags' => 7,
                'scope' => [],
            },
            'sas-specific-info' => {
                'type' => 'sas-specific-info',
                'flags' => 5,
                'scope' => [],
            },
            'ses-generic-info' => {
                'type' => 'ses-generic-info',
                'flags' => 1,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status-reads-attempted' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'status-reads-failed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'temp-sensor-list' => {
                'type' => 'temp-sensor-info',
                'flags' => 7,
                'scope' => [],
            },
            'voltage-sensor-list' => {
                'type' => 'voltage-sensor-info',
                'flags' => 7,
                'scope' => [],
            },
            'xyratex-specific-info' => {
                'type' => 'xyratex-specific-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'shelf-info' => {
        'category' => 'ses',
        'fields' => {
            'channel-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'firmware-rev-A' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-rev-B' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'module' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'module-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'phy-expander-list' => {
                'type' => 'phy-expander-info',
                'flags' => 7,
                'scope' => [],
            },
            'port-hub-list' => {
                'type' => 'port-hub-info',
                'flags' => 7,
                'scope' => [],
            },
            'shelf-bay-info' => {
                'type' => 'shelf-bay-info',
                'flags' => 5,
                'scope' => [],
            },
            'shelf-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'shelf-uid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'termination-switch' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'temp-sensor-info' => {
        'category' => 'ses',
        'fields' => {
            'temp-sensor-current-condition' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'temp-sensor-current-temperature' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'temp-sensor-element-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'temp-sensor-hi-critical' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'temp-sensor-hi-warning' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'temp-sensor-is-ambient' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'temp-sensor-is-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'temp-sensor-is-not-installed' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'temp-sensor-low-critical' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'temp-sensor-low-warning' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'voltage-sensor-info' => {
        'category' => 'ses',
        'fields' => {
            'is-sensor-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sensor-not-installed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'sensor-condition' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sensor-reading' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'voltage-sensor-no' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'xyratex-specific-info' => {
        'category' => 'ses',
        'fields' => {
            'xyratex-option-setting' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'xyratex-serial-no' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dense-status' => {
        'category' => 'sis',
        'fields' => {
            'blocks-skipped-sharing' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'changelog-used-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'checkpoint-op-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checkpoint-progress' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checkpoint-stage' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checkpoint-sub-stage' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checkpoint-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-compression-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-idd-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-inline-compression-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'last-operation-begin-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-operation-end-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-operation-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-operation-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'last-operation-size-bytes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-operation-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-success-operation-begin-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-success-operation-end-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'logical-data' => {
                'type' => 'sis-logical-data',
                'flags' => 5,
                'scope' => [],
            },
            'minimum-blocks-shared' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'progress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'queued-job-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'quick-check-fsize' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'stale-fingerprint-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'sis-logical-data' => {
        'category' => 'sis',
        'fields' => {
            'logical-data-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'logical-data-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'compliance-clock-info' => {
        'category' => 'snaplock',
        'fields' => {
            'formatted-snaplock-compliance-clock' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snaplock-compliance-clock' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'file-retention-info' => {
        'category' => 'snaplock',
        'fields' => {
            'formatted-retention-time' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-wraparound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'retention-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-error' => {
                'type' => 'snaplock-error',
                'flags' => 5,
                'scope' => [],
            },
            'snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'log-file-info' => {
        'category' => 'snaplock',
        'fields' => {
            'file-size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'formatted-retention-date' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'log-basename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'log-complete-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-error' => {
                'type' => 'snaplock-error',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'snaplock-error' => {
        'category' => 'snaplock',
        'fields' => {
            'errno' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'address-pair' => {
        'category' => 'snapmirror',
        'fields' => {
            'destination-addr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-addr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'destination-info' => {
        'category' => 'snapmirror',
        'fields' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapmirror-connection-info' => {
        'category' => 'snapmirror',
        'fields' => {
            'address-pair1' => {
                'type' => 'address-pair',
                'flags' => 1,
                'scope' => [],
            },
            'address-pair2' => {
                'type' => 'address-pair',
                'flags' => 5,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapmirror-error' => {
                'type' => 'snapmirror-error',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'snapmirror-error' => {
        'category' => 'snapmirror',
        'fields' => {
            'errno' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapmirror-schedule-info' => {
        'category' => 'snapmirror',
        'fields' => {
            'days-of-month' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'days-of-week' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hours' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-compressed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minutes' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapmirror-error' => {
                'type' => 'snapmirror-error',
                'flags' => 5,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'tcp-window-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapmirror-status-info' => {
        'category' => 'snapmirror',
        'fields' => {
            'base-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'contents' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'current-transfer-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'current-transfer-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'inodes-replicated' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lag-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-transfer-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-transfer-from' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-transfer-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-transfer-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replication-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'transfer-progress' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapmirror-sync-schedule-info' => {
        'category' => 'snapmirror',
        'fields' => {
            'destination-location' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-compressed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ops-throttle' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapmirror-error' => {
                'type' => 'snapmirror-error',
                'flags' => 5,
                'scope' => [],
            },
            'source-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sync-mode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tcp-window-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'visibility-frequency' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapshot-autodelete-info' => {
        'category' => 'snapshot',
        'fields' => {
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-info' => {
        'category' => 'snapshot',
        'fields' => {
            'access-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'busy' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'contains-lun-clones' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cumulative-percentage-of-total-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cumulative-percentage-of-used-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cumulative-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dependency' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fs-block-format' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c', 'vfiler'],
            },
            'is-7-mode-snapshot' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'percentage-of-total-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'percentage-of-used-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapmirror-label' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-instance-uuid' => {
                'type' => 'uuid',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-owners-list' => {
                'type' => 'snapshot-owner',
                'flags' => 7,
                'scope' => [],
            },
            'snapshot-version-uuid' => {
                'type' => 'uuid',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-provenance-uuid' => {
                'type' => 'uuid',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapshot-name' => {
        'category' => 'snapshot',
        'fields' => {
        },
    },
    'snapshot-owner' => {
        'category' => 'snapshot',
        'fields' => {
            'owner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-reserve-detail-info' => {
        'category' => 'snapshot',
        'fields' => {
            'percentage' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-error' => {
        'category' => 'snapshot',
        'fields' => {
            'errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-is-snapcreated' => {
        'category' => 'snapshot',
        'fields' => {
            'is-snapcreated' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-chained-destination-info' => {
        'category' => 'snapvault',
        'fields' => {
            'destination-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination-system' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-configuration-info' => {
        'category' => 'snapvault',
        'fields' => {
            'connection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-access-time-change-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-open-file-backup-allowed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-primary-path-utf8-encoded' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-transfer-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'primary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tries-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-compression' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-destination-info' => {
        'category' => 'snapvault',
        'fields' => {
            'chained-destinations' => {
                'type' => 'snapvault-chained-destination-info',
                'flags' => 3,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-primary-snapshot-schedule-info' => {
        'category' => 'snapvault',
        'fields' => {
            'is-auto-update' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'options' => {
                'type' => 'snapvault-schedule-options',
                'flags' => 5,
                'scope' => [],
            },
            'preserve-snapshots' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'snapvault-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'warn-at-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-schedule-info' => {
        'category' => 'snapvault',
        'fields' => {
            'days-of-week' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hours-of-day' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-schedule-options' => {
        'category' => 'snapvault',
        'fields' => {
            'retention-period' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'tries-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-secondary-snapshot-schedule-info' => {
        'category' => 'snapvault',
        'fields' => {
            'is-auto-update' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'options' => {
                'type' => 'snapvault-schedule-options',
                'flags' => 5,
                'scope' => [],
            },
            'preserve-snapshots' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'snapvault-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'warn-at-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapvault-snapcreate-options' => {
        'category' => 'snapvault',
        'fields' => {
            'tries-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-snapshot-schedule-status-info' => {
        'category' => 'snapvault',
        'fields' => {
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-softlock-info' => {
        'category' => 'snapvault',
        'fields' => {
            'softlock-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapvault-status-info' => {
        'category' => 'snapvault',
        'fields' => {
            'base-snapshot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'compressed-bytes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'contents' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'current-transfer-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'current-transfer-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'inodes-replicated' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lag-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-from-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-from-system' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'replication-ops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'transfer-progress' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'uncompressed-bytes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'community-info' => {
        'category' => 'snmp',
        'fields' => {
            'access-control' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'community' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'trap-info' => {
        'category' => 'snmp',
        'fields' => {
            'OID' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'active' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backoff-calculator' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backoff-multiplier' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backoff-step' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'current-value' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'edge-1' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'edge-1-direction' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'edge-2' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'edge-2-direction' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'interval-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'priority' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rate-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'trap-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'trigger' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'traphost-info' => {
        'category' => 'snmp',
        'fields' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'npm-meta-elem-info' => {
        'category' => 'software',
        'fields' => {
            'npm-meta-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'npm-meta-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-bar-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'bar-base' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'bar-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'bar-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-detail-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-fc' => {
                'type' => 'adapter-fc-info',
                'flags' => 5,
                'scope' => [],
            },
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-parallel-scsi' => {
                'type' => 'adapter-parallel-scsi-info',
                'flags' => 5,
                'scope' => [],
            },
            'adapter-sas' => {
                'type' => 'adapter-sas-info',
                'flags' => 5,
                'scope' => [],
            },
            'adapter-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-fc-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-bar' => {
                'type' => 'adapter-bar-info',
                'flags' => 7,
                'scope' => [],
            },
            'adapter-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-sff-info' => {
                'type' => 'adapter-sff-info',
                'flags' => 5,
                'scope' => [],
            },
            'adapter-sfp-info' => {
                'type' => 'adapter-sfp-info',
                'flags' => 5,
                'scope' => [],
            },
            'cache-line-sz' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'fc-link-rate' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fc-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc-packet-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fc-port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hardware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-loop-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-port-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-ext-gbic' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-pci-64-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-redundant' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-sram-parity' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'preload-table-rev' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'adapter-name-elem' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-parallel-scsi-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'bus-width' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'firmware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hardware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-sas-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-board-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-date-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-family' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-manufacturer' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-manufacturer-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'adapter-slot' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'adapter-vendor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'base-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'firmware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hardware-rev' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-redundant' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'sas-adapter-disabled-phy-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sas-adapter-enabled-phy-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sas-adapter-expander-phy-states' => {
                'type' => 'sas-adapter-expander-phy-state-info',
                'flags' => 7,
                'scope' => [],
            },
            'sas-phy' => {
                'type' => 'phy-state-info',
                'flags' => 7,
                'scope' => [],
            },
            'sas-qsfp-cable' => {
                'type' => 'sas-qsfp-cable-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'adapter-sff-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'part-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'speed-capabilities' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'adapter-sfp-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'part-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'speed-capabilities' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'expander-phy-state-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'expander-phy' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'expander-phy-attached-device-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'expander-phy-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'expander-phy-wwn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'phy-state-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'phy' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'phy-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'phy-wwn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'sas-adapter-expander-phy-state-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'adapter-phy' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'expander-phy-states' => {
                'type' => 'expander-phy-state-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'sas-qsfp-cable-info' => {
        'category' => 'storage-adapter',
        'fields' => {
            'attached-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-end-identifier' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-length' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-manufacturer' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cable-technology' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-array-config-summary' => {
        'category' => 'storage-array',
        'fields' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'device-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-array-port' => {
        'category' => 'storage-array',
        'fields' => {
            'array-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'wwnn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-array-profile' => {
        'category' => 'storage-array',
        'fields' => {
            'array-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'firmware' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'options' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-failover-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-aggregate-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'aggregate-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'copy-destination-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'copy-percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-media-scrubbing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-prefailed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-reconstructing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-replacing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-zeroed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-zeroing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'plex-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reconstruct-percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'zeroing-percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-inventory-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'bytes-per-sector' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'capacity-sectors' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'carrier-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'carrier-serialno' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-compatibility' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'grown-defect-list-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'health-monitor-time-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-dynamically-qualified' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-foreign' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-multidisk-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'media-scrub-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'media-scrub-last-done-time-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'model' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'right-size-sectors' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shelf-bay' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-ssd-info' => {
                'type' => 'storage-ssd-info',
                'flags' => 5,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmdisk-backing-info' => {
                'type' => 'vmdisk-backing-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'disk-outage-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'is-in-fdr' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-ownership-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'home-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'home-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-failed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'owner-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'owner-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reserved-by-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-raid-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'active-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'container-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-aggregate-info' => {
                'type' => 'disk-aggregate-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-outage-info' => {
                'type' => 'disk-outage-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-spare-info' => {
                'type' => 'disk-spare-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'effective-disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'effective-rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'physical-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'position' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'spare-pool' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'used-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-spare-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'is-media-scrubbing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sparecore' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-zeroed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-zeroing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'zeroing-percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-stats-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'average-latency' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'bytes-per-sector' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-io-kbps' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-iops' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path-error-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'power-on-time-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sectors-read' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sectors-written' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'fw-update-status-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'avg-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-completion' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-unable' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'waiting-disks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-disk-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'disk-inventory-info' => {
                'type' => 'disk-inventory-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-ownership-info' => {
                'type' => 'disk-ownership-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-paths' => {
                'type' => 'disk-path-info',
                'flags' => 7,
                'scope' => [],
            },
            'disk-raid-info' => {
                'type' => 'disk-raid-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-stats-info' => {
                'type' => 'disk-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vmdisk-backing-info' => {
        'category' => 'storage-disk',
        'fields' => {
            'vmdisk-backing-device-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vmdisk-backing-disk-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vmdisk-backing-serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vmdisk-backing-vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-path-info' => {
        'category' => 'storage-initiator',
        'fields' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-port-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-port-speed' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-path-use-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-link-errors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-quality' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'preferred-target-port' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'target-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-port-access-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgn' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vmdisk-device-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmdisk-hypervisor-area-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmdisk-hypervisor-file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-error-info' => {
        'category' => 'storage-initiator',
        'fields' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-uid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'error-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'error-text' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'error-type' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-initiator-load-info' => {
        'category' => 'storage-initiator',
        'fields' => {
            'initiator-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'io-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nodename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'percent-io' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'switch-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-initiator-path-info' => {
        'category' => 'storage-initiator',
        'fields' => {
            'array-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'device-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-port-speed' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-link-errors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path-quality' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-io-kbps' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-iops' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-lun-in-use-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-side-switch-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgn' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vmdisk-device-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'api-list-info' => {
        'category' => 'system',
        'fields' => {
        },
    },
    'replication-transfer-info' => {
        'category' => 'system',
        'fields' => {
            'replication-available-transfers' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replication-maximum-transfers' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replication-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-api-element-info' => {
        'category' => 'system',
        'fields' => {
            'encrypted' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-nonempty' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-optional' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-output' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-validated' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-api-entry-info' => {
        'category' => 'system',
        'fields' => {
            'api-elements' => {
                'type' => 'system-api-element-info',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-api-info' => {
        'category' => 'system',
        'fields' => {
            'is-streaming' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'license' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'system-api-type-entry-info' => {
        'category' => 'system',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type-elements' => {
                'type' => 'system-api-element-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'system-info' => {
        'category' => 'system',
        'fields' => {
            'backplane-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backplane-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backplane-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'board-speed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'board-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'controller-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-ciob-revision-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-firmware-release' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-microcode-version' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cpu-part-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-processor-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-processor-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cpu-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-aggregate-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-flexible-volume-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-flexible-volume-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'memory-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'number-of-processors' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'partner-system-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-system-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-system-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'prod-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'supports-raid-array' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'system-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-machine-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-revision' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'system-serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vm-system-disks' => {
                'type' => 'vm-system-disks',
                'flags' => 5,
                'scope' => [],
            },
            'vmhost-info' => {
                'type' => 'vmhost-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'vm-system-disks' => {
        'category' => 'system',
        'fields' => {
            'vm-bootdisk-area-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-bootdisk-file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-coredisk-area-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-coredisk-file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-logdisk-area-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vm-logdisk-file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vmhost-info' => {
        'category' => 'system',
        'fields' => {
            'vmhost-bios-release-date' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-bios-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-cpu-clock-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-cpu-core-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-cpu-socket-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-cpu-thread-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-hardware-vendor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-hypervisor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-memory' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-model' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vmhost-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'uc-adapter-info' => {
        'category' => 'ucm',
        'fields' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc4-type' => {
                'type' => 'ucm-type',
                'flags' => 0,
                'scope' => [],
            },
            'mode' => {
                'type' => 'ucm-mode',
                'flags' => 0,
                'scope' => [],
            },
            'pending-fc4-type' => {
                'type' => 'ucm-type',
                'flags' => 4,
                'scope' => [],
            },
            'pending-mode' => {
                'type' => 'ucm-mode',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'supported-fc4-type-for-cna-mode' => {
                'type' => 'ucm-type',
                'flags' => 6,
                'scope' => [],
            },
            'supported-fc4-type-for-fc-mode' => {
                'type' => 'ucm-type',
                'flags' => 6,
                'scope' => [],
            },
            'supported-mode' => {
                'type' => 'ucm-mode',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'ucm-mode' => {
        'category' => 'ucm',
        'fields' => {
        },
    },
    'ucm-type' => {
        'category' => 'ucm',
        'fields' => {
        },
    },
    'sid' => {
        'category' => 'useradmin',
        'fields' => {
        },
    },
    'useradmin-capability-info' => {
        'category' => 'useradmin',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'useradmin-group-info' => {
        'category' => 'useradmin',
        'fields' => {
            'allowed-capabilities' => {
                'type' => 'useradmin-capability-info',
                'flags' => 7,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'rid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'useradmin-roles' => {
                'type' => 'useradmin-role-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'useradmin-role-info' => {
        'category' => 'useradmin',
        'fields' => {
            'allowed-capabilities' => {
                'type' => 'useradmin-capability-info',
                'flags' => 7,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'useradmin-user-info' => {
        'category' => 'useradmin',
        'fields' => {
            'allowed-capabilities' => {
                'type' => 'useradmin-capability-info',
                'flags' => 7,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'password-maximum-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'password-minimum-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'useradmin-groups' => {
                'type' => 'useradmin-group-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'adminhost' => {
        'category' => 'vfiler',
        'fields' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'authentication-info' => {
        'category' => 'vfiler',
        'fields' => {
            'password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dns-info' => {
        'category' => 'vfiler',
        'fields' => {
            'dns-domain-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dns-servers' => {
                'type' => 'server-address',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dnsserver-info' => {
        'category' => 'vfiler',
        'fields' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'encrypted-authentication-info' => {
        'category' => 'vfiler',
        'fields' => {
            'password' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 8,
                'scope' => [],
            },
        },
    },
    'hostname-pair' => {
        'category' => 'vfiler',
        'fields' => {
            'alternate-destination' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alternate-source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ipaddr-info' => {
        'category' => 'vfiler',
        'fields' => {
            'interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ipbinding-info' => {
        'category' => 'vfiler',
        'fields' => {
            'interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nis-info' => {
        'category' => 'vfiler',
        'fields' => {
            'nis-domain-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-servers' => {
                'type' => 'server-address',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nisserver-info' => {
        'category' => 'vfiler',
        'fields' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'protocol-info' => {
        'category' => 'vfiler',
        'fields' => {
            'protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'server-address' => {
        'category' => 'vfiler',
        'fields' => {
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-dr-status' => {
        'category' => 'vfiler',
        'fields' => {
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-mr-status' => {
        'category' => 'vfiler',
        'fields' => {
            'error-msg' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-unit' => {
        'category' => 'vfiler',
        'fields' => {
        },
    },
    'vfiler-info' => {
        'category' => 'vfiler',
        'fields' => {
            'admin-host' => {
                'type' => 'adminhost',
                'flags' => 5,
                'scope' => [],
            },
            'dns-info' => {
                'type' => 'dns-info',
                'flags' => 3,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nis-info' => {
                'type' => 'nis-info',
                'flags' => 3,
                'scope' => [],
            },
            'uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfnets' => {
                'type' => 'vfnet-info',
                'flags' => 3,
                'scope' => [],
            },
            'vfstores' => {
                'type' => 'vfstore-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-location' => {
        'category' => 'vfiler',
        'fields' => {
            'filer' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfnet-info' => {
        'category' => 'vfiler',
        'fields' => {
            'interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfstore-info' => {
        'category' => 'vfiler',
        'fields' => {
            'is-etc' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosize-info' => {
        'category' => 'volume',
        'fields' => {
            'grow-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'increment-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minimum-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'shrink-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'clone-child-info' => {
        'category' => 'volume',
        'fields' => {
            'clone-child-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-parent-info' => {
        'category' => 'volume',
        'fields' => {
            'parent-snapshot-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'parent-volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-split-detail-info' => {
        'category' => 'volume',
        'fields' => {
            'blocks-scanned' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'blocks-updated' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inode-percentage-complete' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inodes-processed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inodes-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-split-estimate-info' => {
        'category' => 'volume',
        'fields' => {
            'estimate-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'compression-info' => {
        'category' => 'volume',
        'fields' => {
            'is-compression-enabled' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'errors-warnings-info' => {
        'category' => 'volume',
        'fields' => {
            'error-warning' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'guarantee' => {
        'category' => 'volume',
        'fields' => {
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'mediascrub-detail-info' => {
        'category' => 'volume',
        'fields' => {
            'mediascrub-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'percentage-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'raidgroup-size-info' => {
        'category' => 'volume',
        'fields' => {
            'default-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'maximum-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'minimum-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'raidtype' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'raidtype-info' => {
        'category' => 'volume',
        'fields' => {
            'raidtype' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'scrub-detail-info' => {
        'category' => 'volume',
        'fields' => {
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'last-scrub-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'percentage-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'sis-info' => {
        'category' => 'volume',
        'fields' => {
            'compress-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dedup-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-operation-begin' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-operation-end' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-operation-error' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-operation-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'percent-compress-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'percent-dedup-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'percent-total-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'percentage-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'progress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-shared' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'total-saved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snap-autodelete-info' => {
        'category' => 'volume',
        'fields' => {
            'commitment' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'defer-delete' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'delete-order' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destroy-list' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-free-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'trigger' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'transition-info' => {
        'category' => 'volume',
        'fields' => {
            'transition-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'transitioned' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vm-align-info' => {
        'category' => 'volume',
        'fields' => {
            'vm-align-sector' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vm-align-suffix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vol-footprint-info' => {
        'category' => 'volume',
        'fields' => {
            'aggregate-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dedupe-metafiles-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dedupe-metafiles-temporary-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'delayed-free-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'flexvol-metadata-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapmirror-destination-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tape-backup-metafiles-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-data-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-guarantee-footprint' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vol-move-status-info' => {
        'category' => 'volume',
        'fields' => {
            'current-transfer' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cutover-attempts' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cutover-window' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dest-aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dest-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'error-string' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-transfer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'move-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'pause-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vol-space-info' => {
        'category' => 'volume',
        'fields' => {
            'dedupe-metafiles' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dedupe-metafiles-temporary' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'filesystem-metadata' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inodes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'quota-metafiles' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapmirror-metadata' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-spill' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-data' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-64bit-upgrade-check-info' => {
        'category' => 'volume',
        'fields' => {
            'age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'available-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'capacity' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'grow-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'used-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-64bit-upgrade-info' => {
        'category' => 'volume',
        'fields' => {
            'check' => {
                'type' => 'volume-64bit-upgrade-check-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'volume-info' => {
        'category' => 'volume',
        'fields' => {
            'autosize' => {
                'type' => 'autosize-info',
                'flags' => 5,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'clone-children' => {
                'type' => 'clone-child-info',
                'flags' => 7,
                'scope' => [],
            },
            'clone-parent' => {
                'type' => 'clone-parent-info',
                'flags' => 7,
                'scope' => [],
            },
            'compression' => {
                'type' => 'compression-info',
                'flags' => 1,
                'scope' => [],
            },
            'containing-aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'expiry-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'files-private-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'files-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'files-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'filesystem-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'formatted-expiry-date' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'formatted-snaplock-volume-compliance-clock' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hybrid-cache-eligibility' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hybrid-cache-write-caching-ineligibility-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'inodefile-private-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'inodefile-public-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-checksum-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-snapmirror-jumpahead' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-inconsistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-invalid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snaplock' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-unrecoverable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-wraparound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'owning-vfiler' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'percentage-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'plex-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'plexes' => {
                'type' => 'plex-info',
                'flags' => 3,
                'scope' => [],
            },
            'quota-init' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'raid-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'raid-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'remote-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reserve-required' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reserve-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'reserve-used-actual' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sis' => {
                'type' => 'sis-info',
                'flags' => 5,
                'scope' => [],
            },
            'size-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snap-autodelete' => {
                'type' => 'snap-autodelete-info',
                'flags' => 5,
                'scope' => [],
            },
            'snaplock-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snaplock-volume-compliance-clock' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-blocks-reserved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-percent-reserved' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'space-reserve' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'space-reserve-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'transition' => {
                'type' => 'transition-info',
                'flags' => 5,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vm-align' => {
                'type' => 'vm-align-info',
                'flags' => 5,
                'scope' => [],
            },
            'volume-64bit-upgrade' => {
                'type' => 'volume-64bit-upgrade-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'volume-option-info' => {
        'category' => 'volume',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'uuid' => {
        'category' => 'wafl',
        'fields' => {
        },
    },
};

sub new {
    my $self = {'apis' => $APIS, 'typedefs' => $TYPEDEFS};
    bless $self;
    return $self;
}
sub GetApi {
    my ($self, $name) = @_;
    my $type = ref($self) || die "$self is not an object";
    my $api = $self->{apis}->{$name} || die "No definition for API $name found";
    return $api;
}
sub GetTypedef {
    my ($self, $name) = @_;
    my $type = ref($self) || die "$self is not an object";
    my $api = $self->{typedefs}->{$name} || die "No definition for typedef $name found";
    return $api;
}
sub IsTypedefFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_TYPEDEF) == FIELD_TYPEDEF;
}

sub IsArrayFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_ARRAY) == FIELD_ARRAY;
}

sub IsEncryptedFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_ENCRYPTED) == FIELD_ENCRYPTED;
}

1;


__END__

=head1 NAME

Ontap7ModeAPI - Contains the definitions and description of API Bindings for 7-Mode/7G Data ONTAP systems

=head1 SYNOPSIS

	 my $s = NaServer->new($server, 1, 0); # create NaServer (server context)
	 $s->set_admin_user('admin', 'password'); # provide username and password
	 $s->set_bindings_family('7-Mode'); # set the bindings family to 7-Mode for bindings validation

	 eval{ 
		 my $output = $s->system_get_version(); # use binding for system-get-version API
		 print "Data ONTAP version: $output->{version}\n"; # extract the required parameter from output

	 };
	 if($@) { # check for any exception
		 my ($error_reason, $error_code) = $@ =~ /(.+)\s\((\d+)\)/;  # parse out error reason and error code
		 print "Error Reason: $error_reason  Code: $error_code\n"
	 }

=head1 DESCRIPTION

NetApp Manageability SDK 5.3.1 provides support for Perl API bindings for both Data ONTAP APIs and OnCommand Unified Manager APIs.
The Perl API bindings libraries contain interfaces to establish a connection with either the Data ONTAP server or the OnCommand Unified Manager server.
By using these libraries, you can create Perl applications to access and manage the Data ONTAP server or OnCommand Unified Manager server.

NetApp Manageability SDK 5.3.1 Perl API bindings provide a runtime library NaServer.pm, which is available at <installation_folder>/lib/perl/NetApp.
This library file enables you to establish a server connection, send requests and receive responses, and interpret error messages.
Each binding can be called as a subroutine of NaServer module which in turn invokes the corresponding Data ONTAP or OnCommand Unified Manager API.



=head1 API BINDINGS



=head2 aggr_add

[B<Family:> ontap-classic]


=begin html

Add disks to the specified aggregate, whether it is free-standing or embedded in a traditional volume. The disks to add are specified in the same way as for "aggr-create". Disks cannot be added to a mirrored aggregate if one or more of the plexes is offline. By the time the API returns, the disk(s) may not yet be completely added. Use 'aggr-list-info' to query the aggregate status to determine when it has finished growing due to the added disk(s). Same can be done using 'aggr-get-iter' when requested from Admin Vserver LIF. When the upgrade-64bit-mode input is provided to this API, the API produces a set of results in the background. These results are not available as output from aggr-add. Use the 'aggr-list-info' and 'volume-list-info' APIs to query the results of the 64-bit upgrade process on the aggregate and flexible volumes, respectively.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate to which the disks will be added. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<allow-mixed-rpm>  =>   B<boolean, optional>

=begin html

<br>Disks in an aggregate are normally required to have the same RPM. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<allow-same-carrier>  =>   B<boolean, optional>

=begin html

<br>Using two disks from one carrier that houses multiple disks in one RAID group is not desirable. If that happens, Data ONTAP initiates a series of disk copy operations to correct that situation. Sometimes, selection of available spare disks makes it impossible to avoid placing two disks from one carrier in one RAID group. Setting this option to true allows placing two disks from one carrier in one RAID group. This option has an effect only when disks to be used are specified in 'disks'. This option is ignored when 'disk-count' is used.

=end html

=back



=over 2

=item * I<cache-raid-type>  =>   B<string, optional>

=begin html

<br>Specifies the raid-type of the new RAID groups being created as part of the disk add operation. This option should be used while adding SSD disks for the first time to a hybrid-enabled aggregate. Possible values: raid4 and raid_dp only. If not specified, the default value is the raid-type of the aggregate.

=end html

=back



=over 2

=item * I<checksum-style>  =>   B<string, optional>

=begin html

<br>Specifies the checksum style for the disks to be added to an aggregate. This input is not allowed if a list of disks to use is specified through the "disks" parameter. The possible values: <ul> <li> "advanced_zoned" - advanced_zoned checksum (azcs), <li> "block" - block. </ul> By default, disks with same checksum style as the aggregate are selected. Use this option to override that behavior and create a mixed checksum aggregate. "zoned" is not supported as one of the possible values as a mixed checksum aggregate can support only block and advanced_zoned checksum styles.

=end html

=back



=over 2

=item * I<disk-count>  =>   B<integer, optional>

=begin html

<br>Number of disks to add, including the parity disks. The disks will come from the pool of spare disks. The smallest disks in this pool join the aggregate first, unless the "disk-size" argument is specified. Either the "disk-count" or "disks" argument must be specified. Range : [0..2^31-1].

=end html

=back



=over 2

=item * I<disk-size>  =>   B<integer, optional>

=begin html

<br>The individual disk size in 4KB blocks. For example, a disk-size of 131072000 represents a 500GB drive (131072000 * 4 * 1024 = 500 * 1024 * 1024 * 1024). Disks that are within approximately 20% of the specified size will be selected. If neither the "disk-size" nor the "disk-size-with-unit" argument is specified, existing groups are appended with disks that are the best match by size for the largest disk in the group. When starting new groups, disks that are the best match by size for the largest disk in the last raidgroup are selected first, then smaller disks, and finally larger disks. This "disk-size" option is ignored if a specific list of disks is specified through the "disks" parameter. Range : [0..2^31-1]. You must only use one of either "disk-size" or "disk-size-with-unit" parameters. If both appear, an error message will be returned.

=end html

=back



=over 2

=item * I<disk-size-with-unit>  =>   B<string, optional>

=begin html

<br>This parameter accepts a disk size in the specified unit. It is a positive integer number followed by unit of "T", "G", "M" or "K". For example, these are accepted: 72G, 36G, 1T and 32M. But "72" will not be accepted. This "disk-size-with-unit" option is ignored if a specific list of disks is specified through the "disks" parameter. You must only use one of either "disk-size" or "disk-size-with-unit" parameters. If both appear, an error message will be returned.

=end html

=back



=over 2

=item * I<disk-type>  =>   B<string, optional>

=begin html

<br>Type of disks to use : ATA, BSAS, EATA, FCAL, FSAS, LUN, MSATA, SAS, SATA, SCSI, XATA, XSAS, or SSD. This option is required when converting an existing aggregate to a hybrid one, or when operating on a hybrid aggregate. Otherwise, the option is not required.

=end html

=back



=over 2

=item * I<disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>Specific list of disks to add to the aggregate. If the aggregate is mirrored and a specific list of disks is supplied, another list ("mirror-disks") must also be supplied with the same number of disks. Either the "disks" or "disk-count" argument must be specified.

=end html

=back



=over 2

=item * I<force-cache-size>  =>   B<boolean, optional>

=begin html

<br>When set to true this parameter forces the addition of SSD disks to hybrid enabled aggregate by skipping the check for total (local + partner) hybrid SSD capacity. This can be used when the partner's cache capacity cannot be retrieved. Default value is false. Warning: If force-cache-size is set to true, the administrator is responsible to ensure that the total limit will not be exceeded.

=end html

=back



=over 2

=item * I<force-spare-pool>  =>   B<boolean, optional>

=begin html

<br>Disks in a plex are not normally permitted to span spare pools. This behavior is overridden with this option when it is set to true. This is a deprecated parameter. Use the allow-mixed-rpm and ignore-pool-checks parameters instead.

=end html

=back



=over 2

=item * I<group-selection-mode>  =>   B<string, optional>

=begin html

<br>Specifies how DATA ONTAP adds the specified disks to raidgroups. Legitimate values are "last", "one", "new" or "all". group-selection-mode is an optional argument, and the behavior when it is not used is selected by value of raid-group. If raid-group is used, the behavior is the same as for group-selection-mode "one". If raid-group is not used, the behavior is the same as for group-selection-mode "last". The raid-group option must be used with group-selection-mode value "one", and it cannnot be used with others. If the string value is "last", Data ONTAP adds the specified disks to the existing last RAID group first. After the last RAID group is full, it creates one or more new RAID groups and adds the remaining disks to the new groups. If the string value is "one", Data ONTAP adds the specified disks to the existing RAID group specified by raid-group option until this specified RAID group is full. If the string value is "new", Data ONTAP creates one or more new RAID groups and adds the specified disks to the new groups, even if they would fit into an existing RAID group. The name of new RAID groups are selected automatically. It is not possible to specify the name for the new RAID groups. If the string value is "all", Data ONTAP adds the specified disks to existing RAID groups first. Only after all existing RAID groups are full, it creates one or more new RAID groups and adds the remaining disks to the new groups.

=end html

=back



=over 2

=item * I<ignore-pool-checks>  =>   B<boolean, optional>

=begin html

<br>Disks in a plex are normally required to come from the same spare pool. Similarly, disks in different plexes of a mirrored aggregate are required to come from different spare pools. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<mirror-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>Specific list of mirror disks needed to accompany the list in the "disks" parameter. This list must contain the same number of disks as specified in "disks".

=end html

=back



=over 2

=item * I<pre-check>  =>   B<boolean, optional>

=begin html

<br>Only check for the warnings without actually adding the disks. This option cannot be used when "simulate" is specified or "upgrade-64bit-mode" is set to "check". Default value is false.

=end html

=back



=over 2

=item * I<raid-group>  =>   B<string, optional>

=begin html

<br>Specifies the RAID group (for example rg0) to which the indicated disks are to be added. When a RAID group other than the last RAID group is specified, the aggregate can no longer be reverted to a version of Data ONTAP prior to 6.2. In such a case, the "force-spare-pool" option must be specified as well. By default, the filer fills up one RAID group with disks before starting another RAID group. Suppose an aggregate currently has one RAID group of 12 disks and its RAID group size is 14. If you add 5 disks to this aggregate, it will have one RAID group with 14 disks and another RAID group with 3 disks. The filer does not evenly distribute disks among RAID groups.

=end html

=back



=over 2

=item * I<simulate>  =>   B<boolean, optional>

=begin html

<br>Simulates the addition of disks to the given aggregate or UUID of the aggregate. If set to "true", addition of disks won't happen but returns the list of disks that would be automatically selected for the addition of the aggregate. By default, simulate option is set to false.

=end html

=back



=over 2

=item * I<upgrade-64bit-mode>  =>   B<string, optional>

=begin html

<br>Allows the aggregate to grow past 16 TB and begin 64-bit upgrade. If not supplied, adding disks past 16 TB to a 32-bit aggregate will fail. Legitimate values are "check", "grow_all", "grow_none", and "grow_reserved". If the "check" value is specified, aggr-add produces a summary of the space impact which would result from upgrading the aggregate to 64-bit. This summary includes the space usage of each contained volume after the volume is upgraded to 64-bit and the amount of space that must be added to the volume to successfully complete the 64-bit upgrade. The summary can be obtained by querying the 'aggr-list-info' and 'volume-list-info' APIs. The aggregate's summary is made available in the 'check' element that is part of the 'aggr-64bit-upgrade-info' typedef. The flexible volumes' summary is made available in the 'check' element that is part of the 'volume-64bit-upgrade-info' typedef. This option does not result in an upgrade to 64-bit or addition of disks. If the "grow_all" value is specified, "aggr-add" upgrades the aggregate to 64-bit if the total aggregate size after adding the specified disks exceeds 16TB. This option allows "aggr-add" to automatically grow volumes as needed if they run out of space due to the 64-bit upgrade. The volumes will be grown to accommodate all the files within these volumes. This option does not affect volumes which have autosize enabled. If the "grow_none" value is specified, "aggr-add" upgrades the aggregate to 64-bit if the total aggregate size after adding the specified disks exceeds 16TB. This option does not allow "aggr-add" to automatically grow volumes if they run out of space due to the 64-bit upgrade. If the "grow_reserved" value is specified, "aggr-add" upgrades the aggregate to 64-bit if the total aggregate size after adding the specified disks exceeds 16TB. This option allows "aggr-add" to automatically grow volumes if they run out of space due to the 64-bit upgrade, but only to accommodate the space reserved files within these volumes. This option does not affect volumes which have autosize enabled.

=end html

=back



B<Outputs>

=over 2

=item * I<bad-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of disks that were not added. This is only returned if there are bad disks.

=end html

=back



=over 2

=item * I<pre-check-results>  =>   B<L<"warning-code">[], optional>

=begin html

<br>Result of the pre-check for possible warnings. Possible warning codes are: <ul> <li> E_WARN_NEW_RAID_GROUP <li> E_WARN_EXCEEDS_HALF_CLUSTER_SIZE <li> E_WARN_DISK_DOWNSIZE <li> E_WARN_LOW_SPARE </ul>

=end html

=back



=over 2

=item * I<selected-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of disks that would be used for the addition of disks to the given aggregate. This is only returned if the simulate option is set to true.

=end html

=back



=over 2

=item * I<selected-mirror-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of mirror disks that would be used for the addition of disks to the given aggregate. This is only returned if the simulate option is set to true on the mirrored aggregate.

=end html

=back



=over 2

=item * I<upgrade-64bit-cookie>  =>   B<integer, optional>

=begin html

<br>The opaque cookie to uniquely identify this 64-bit upgrade transaction. This cookie can be compared against the cookie returned by aggr-list-info to ensure that the output produced by aggr-list-info corresponds to this 64-bit upgrade transaction. Range: [0..2^64-1].

=end html

=back



=head2 aggr_check_spare_low

[B<Family:> ontap-classic]


=begin html

Return true if there is no suitable spare disk available for any filesystem (parity or data) disk.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<is-spare-low>  =>   B<boolean>

=begin html

<br>"true", if system has insufficient spare disk, "false" otherwise. When requested from Admin Vserver LIF, "true" is returned if one or more nodes in the cluster have spare low condition, "false" otherwise.

=end html

=back



=head2 aggr_create

[B<Family:> ontap-classic]


=begin html

Create a new aggregate with the given name. The maximum number of aggregates that can be created on a filer varies by the type of configuration. In a standalone configuration, up to 200 aggregates can be created on a filer (including the aggregates that are "embedded" in traditional volumes, which must be created as a side effect of a traditional volume creation). In an HA configuration, this number drops to 100 and to 50 in a C-mode MetroCluster configuration. The aggregate may not yet be operational immediately after the API returns. Use 'aggr-list-info' to query the status of the newly-created aggregate to determine when it is fully operational. Same can be done using 'aggr-get-iter' when requested from Admin Vserver LIF. NOTE: If ECANT_USE_ALL_DISKS is returned, then the requested aggregate was indeed created, just not with all the disks that were specified.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the aggregate to create. The aggregate name can contain letters, numbers, and the underscore character(_), but the first character must be a letter or underscore. The maximum length of the aggregate name is 255.

=end html

=back



=over 2

=item * I<allow-mixed-rpm>  =>   B<boolean, optional>

=begin html

<br>Disks in an aggregate are normally required to have the same RPM. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<allow-same-carrier>  =>   B<boolean, optional>

=begin html

<br>Using two disks from one carrier that houses multiple disks in one RAID group is not desirable. If that happens, Data ONTAP initiates a series of disk copy operations to correct that situation. Sometimes, selection of available spare disks makes it impossible to avoid placing two disks from one carrier in one RAID group. Setting this option to true allows placing two disks from one carrier in one RAID group. This option has an effect only when disks to be used are specified in 'disks'. This option is ignored when 'disk-count' is used.

=end html

=back



=over 2

=item * I<block-type>  =>   B<string, optional>

=begin html

<br>The indirect block format that the aggregate can have. It can be either 32_bit or 64_bit. Specifying 64_bit allows creation of aggregates that can be larger than 16TB. The default is 64_bit. Possible values: 32_bit, 64_bit

=end html

=back



=over 2

=item * I<checksum-style>  =>   B<string, optional>

=begin html

<br>Specifies the checksum style for the aggregate. This input is not allowed if a list of disks to use is specified through the "disks" parameter. The possible values: <ul> <li> "advanced_zoned" - advanced_zoned checksum (azcs), <li> "block" - block, </ul>

=end html

=back



=over 2

=item * I<disk-count>  =>   B<integer, optional>

=begin html

<br>Number of disks to place into the aggregate, including parity disks. The disks in this newly- created aggregate come from the spare disk pool. The smallest disks in this pool join the aggregate first, unless the "disk-size" argument is provided. Either "disk-count" or "disks" must be supplied. Range [0..2^31-1].

=end html

=back



=over 2

=item * I<disk-size>  =>   B<integer, optional>

=begin html

<br>Disk size in 4KB blocks. Disks that are within 10% of the specified size will be selected for use in the aggregate. If neither "disk-size" nor "disk-size-with-unit" is specified, existing groups are appended with disks that are the best match for the largest disk in the group. When starting new groups, the smallest disks are selected first. This option is ignored if a specific list of disks to use is specified through the "disks" parameter. Range [0..2^31-1]. You must only use one of either "disk-size" or "disk-size-with-unit" parameters. If both appear, an error message will be returned.

=end html

=back



=over 2

=item * I<disk-size-with-unit>  =>   B<string, optional>

=begin html

<br>Disk size in the specified unit. It is a positive integer number followed by unit of "T", "G", "M" or "K". This "disk-size-with-unit" option is ignored if a specific list of disks is specified through the "disks" parameter. You must only use one of either "disk-size" or "disk-size-with-unit" parameters. If both appear, an error message will be returned.

=end html

=back



=over 2

=item * I<disk-type>  =>   B<string, optional>

=begin html

<br>Type of disks to use: ATA, BSAS, EATA, FCAL, FSAS, LUN, MSATA, SAS, SATA, SCSI, SSD, XATA, or XSAS. This option is needed only when disks of different types are connected to the filer. It is not allowed if a list of disks to use is specified through the "disks" parameter. The ability to mix compatible disk types in one aggregate is controlled by the system option 'raid.disktype.enable'.

=end html

=back



=over 2

=item * I<disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>Specific list of disks to use for the new aggregate. If "mirrored" is set to true and a specific list of disks is supplied, the "mirror-disks" list with the same number of disks must also be supplied. Either "disk-count" or "disks" must be supplied.

=end html

=back



=over 2

=item * I<force-spare-pool>  =>   B<boolean, optional>

=begin html

<br>Disks in a plex are not normally permitted to span spare pools. This behavior is overridden with this option when it is set to true. This is a deprecated parameter. Use the allow-mixed-rpm and ignore-pool-checks parameters instead.

=end html

=back



=over 2

=item * I<ha-policy>  =>   B<ha-policy-type, optional>

=begin html

<br>Aggregate's HA policy. The only allowed values are "cfo" and "sfo". In clustered environments default value is 'sfo' if not specified. In unclustered environments, it is not allowed to specify this attribute as it is always be 'cfo' internally. EINVALIDINPUTERROR is returned if value is other than "cfo" and "sfo". EOP_CLUSTER_ATTR_DISALLOWED is returned if this attribute is used in unclustered environments.

=end html

=back



=over 2

=item * I<ignore-pool-checks>  =>   B<boolean, optional>

=begin html

<br>Disks in a plex are normally required to come from the same spare pool. Similarly, disks in different plexes of a mirrored aggregate are required to come from different spare pools. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<is-mirrored>  =>   B<boolean, optional>

=begin html

<br>Specifies that the new aggregate be mirrored (have two plexes). If set to true, then the indicated disks will be split across the two plexes. By default, the new aggregate will not be mirrored.

=end html

=back



=over 2

=item * I<is-snaplock>  =>   B<boolean, optional>

=begin html

<br>Specifies the creation of a SnapLock aggregate. By default, is-snaplock is not specified. When is-snaplock is "true" the type of snaplock aggregate is determined in the following way - 1> If snaplock-type is set, create the type specified in snaplock-type (see snaplock-type for more details) 2> Otherwise, create a Snaplock enterprise aggregate if a Snaplock enterprise license has been installed. 3> Otherwise, create a Snaplock compliance aggregate. ESERVICENOTLICENSED is returned if the required Snaplock Compliance or Enterprise license is not installed. EONTAPI_EWORMNOCLOCK is returned if SnapLock Compliance Clock is not running. If you need to create a snaplock aggregate, the suggested method is to specify snaplock-type as "compliance" or "enterprise" and not specify is-snaplock at all. If you want to create a non-snaplock aggregate, the suggested method is to specify neither snaplock-type nor is-snaplock.

=end html

=back



=over 2

=item * I<language-code>  =>   B<string, optional>

=begin html

<br>Specifies the language to use for the new traditional volume via a language code. The default language is the one used by the filer's root volume. This option may be used only when creating a traditional volume, i.e. when "type" is "trad." <p> For the full list of available language codes, see 'volume-create'.

=end html

=back



=over 2

=item * I<mirror-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of mirror disks to use. It must contain the same number of disks specified in "disks".

=end html

=back



=over 2

=item * I<pre-check>  =>   B<boolean, optional>

=begin html

<br>Only check for the warnings without actually creating the aggregate. This option cannot be used when "simulate" is specified. Default value is false.

=end html

=back



=over 2

=item * I<raid-size>  =>   B<integer, optional>

=begin html

<br>Specifies the maximum number of disks in each RAID group in the aggregate. The maximum value for this parameter is 28. The default value is platform- dependent. The valid range of values is also platform-dependent, but never wider than [2..28].

=end html

=back



=over 2

=item * I<raid-type>  =>   B<string, optional>

=begin html

<br>Specifies the type of RAID groups to use in the new aggregate. Possible values: raid4, raid_dp. The default value is raid4 on most platforms.

=end html

=back



=over 2

=item * I<rpm>  =>   B<integer, optional>

=begin html

<br>Rotational speed of disks in revolutions per minute. Possible values are: 5400, 7200, 10000, and 15000. This option is needed only when disks with different rotational speeds are connected to the filer. It is not allowed if a list of disks to use is specified through the "disks" parameter.

=end html

=back



=over 2

=item * I<simulate>  =>   B<boolean, optional>

=begin html

<br>Specifies to return the list of disks getting used to create the new aggregate. If set to "true", new aggregate won't be created but returns the disks that would be automatically selected for the creation of the aggregate. By default, simulate option is set to false.

=end html

=back



=over 2

=item * I<snaplock-type>  =>   B<string, optional>

=begin html

<br>Specifies the type of Snaplock aggregate to be created. Possible values - "compliance" or "enterprise" ESERVICENOTLICENSED is returned if the necessary Snaplock compliance or enterprise license has not been installed. EINVALIDINPUTERROR is returned if snaplock-type has an illegal value or if is-snaplock has been set to "false". EONTAPI_EWORMNOCLOCK is returned if SnapLock Compliance Clock is not running.

=end html

=back



=over 2

=item * I<spare-pool>  =>   B<string, optional>

=begin html

<br>Specifies the spare pool from which to select spare disks to use in creation of a new aggregate. This option is not allowed if a list of disks specified through the "disks" parameter. This option cannot be used when "is-mirrored" is set to true. Possible values: <ul> <li> "Pool0" - Disks associated with spare Pool0. <li> "Pool1" - Disks associated with spare Pool1. </ul>

=end html

=back



=over 2

=item * I<striping>  =>   B<striping-type, optional>

=begin html

<br>Specifies the striping information about new aggregate. The only allowed values are "striped" and "not_striped". Default value is "not_striped". "striped" value creates striped aggregate on node. This attribute is not allowed in unclustered environments. EINVALIDINPUTERROR is returned if value is other than "striped" and "not_striped". EOP_CLUSTER_ATTR_DISALLOWED is returned if this attribute is used in unclustered environments. EOP_DISALLOWED_ON_CFO_AGGR is returned if this attribute is set to "striped" when aggregate being created with 'cfo' HA policy.

=end html

=back



=over 2

=item * I<type>  =>   B<string, optional>

=begin html

<br>The type of the aggregate. Possible values: aggr, trad. - "aggr" (aggregate contains flexible volumes) - "trad" (aggregate contains exactly one traditional volume) If not specified, the default is "aggr." The value "trad" is invalid when the request is sent to the Admin Vserver LIF.

=end html

=back



B<Outputs>

=over 2

=item * I<bad-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of disks that were not added. This is only returned if there are bad disks.

=end html

=back



=over 2

=item * I<pre-check-results>  =>   B<L<"warning-code">[], optional>

=begin html

<br>Result of the pre-check for possible warnings. Possible warning codes are: <ul> <li> E_WARN_EXCEEDS_HALF_CLUSTER_SIZE <li> E_WARN_DISK_DOWNSIZE <li> E_WARN_LOW_SPARE </ul>

=end html

=back



=over 2

=item * I<selected-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of disks that would be used for the creation of the new aggregate. This is only returned if the simulate option is set to true.

=end html

=back



=over 2

=item * I<selected-mirror-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of mirror disks that would be used for the creation of the new aggregate. This is only returned if both the simulate option and the is-mirrored option are set to true.

=end html

=back



=head2 aggr_destroy

[B<Family:> ontap-classic]


=begin html

Destroys the specified aggregate or plex. If an aggregate is specified, all plexes in the aggregate are destroyed. If the aggregate is embedded in a traditional volume, then the entire traditional volume is destroyed. If a plex is specified, only that plex is destroyed, leaving an unmirrored aggregate containing the remaining plex. The disks in the destroyed object become spare disks. Only offline aggregates and plexes can be destroyed. Note: Offline aggregates will be destroyed even if they contain one or more flexible volumes, which should not typically be the case. From cluster interface only aggregates are supported and plexes are not supported.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the existing aggregate or plex to be destroyed, using the following format: [/vol/]<aggrname>[<plexinfo>] UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>When using "aggr-destroy" on a traditional volume, force the destruction of the volume even if a non-default vfiler has storage on it. Normally, the system will not destroy such a volume and will instead return EVOLUME_HAS_VFILER_STORAGE.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_get_filer_info

[B<Family:> ontap-classic]


=begin html

Get information on what possibilities and parameters exist for aggregates on a given filer.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<allowed-raidtypes>  =>   B<L<"raidtype-info">[]>

=begin html

<br>List of RAID types allowed for aggregates on this filer.

=end html

=back



=over 2

=item * I<checksum-types>  =>   B<string>

=begin html

<br>Checksum types supported by this filer. The possible values: <ul> <li> "zoned" - if all aggregates are Fixed VBN, <li> "block" - if all aggregates are Block Appended, <li> "mixed" - if aggregates are mixed (Fixed VBN, Block Appended and Advanced Zoned), <li> "none" - if no aggregates have zoned or advanced_zoned checksum (azcs) or block checksums, <li> "advanced_zoned" - if all aggregates have Advanced Zoned Checksum scheme. </ul>

=end html

=back



=over 2

=item * I<default-raidtype>  =>   B<string>

=begin html

<br>Default type of RAID used to protect against disk failure in aggregates on this filer. Possible values: "raid0", "raid4", "raid_dp", "mixed_raid_type".

=end html

=back



=over 2

=item * I<disk-types>  =>   B<string>

=begin html

<br>Type of disks supported by this filer. Possible values: "512", "520", "4096", "mixed", "none". "512" if all disks are 512 BPS, "520" if all disks are 520 BPS, "4096" if all disks are 4096 BPS, "mixed" if disks are mixed 512, 520 and 4096 BPS, "none" if no disks have 512 or 520 or 4096 BPS.

=end html

=back



=over 2

=item * I<max-named-disks-per-request>  =>   B<integer>

=begin html

<br>The maximum number of named disks which can be specified to 'aggr add', 'aggr create', or 'agg mirror' operation. Disk addition process may fail if the specified number of named disk is more than this limit. This value is the maximum number of disk entries which can be specified in 'disks' or 'mirror-disks' argument of 'aggr-create' and 'aggr-add' api. Range : [0..2^31-1].

=end html

=back



=over 2

=item * I<raidgroup-size>  =>   B<L<"raidgroup-size-info">[]>

=begin html

<br>List of the RAID group sizing parameters for each RAID type supported on this filer.

=end html

=back



=over 2

=item * I<root-volume>  =>   B<string>

=begin html

<br>Current root volume on the filer.

=end html

=back



=over 2

=item * I<snapshots-max>  =>   B<integer>

=begin html

<br>Maximum number of snapshots available per aggregate on the filer. Range : [0..2^31-1].

=end html

=back



=head2 aggr_get_root_name

[B<Family:> ontap-classic, vfiler]


=begin html

Return the name of the "root" volume on the filer.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<root-volume>  =>   B<string>

=begin html

<br>Name of the root volume for the filer.

=end html

=back



=head2 aggr_list_info

[B<Family:> ontap-classic, vfiler]


=begin html

Get aggregate status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>The aggregate name or UUID to get status for. See the synopsis for name/UUID format. If not supplied, get status of all aggregates owned by the local node.

=end html

=back



=over 2

=item * I<filter-attrs>  =>   B<L<"filter-attrs-info">, optional>

=begin html

<br>This input is used as a discriminant when status is required for one or more aggregates. This option will be ignored when an aggregate name is specified. If no argument is supplied, default value is NULL. If this is NULL or all of its elements are not supplied, then this filter has no effect and the behavior is the same as described in the 'aggregate' input description.

=end html

=back



=over 2

=item * I<verbose>  =>   B<boolean, optional>

=begin html

<br>If set to "true", detailed volume and plex information (including all the RAID group and disk information) is returned. If not supplied or set to "false", this extra information is not returned.

=end html

=back



B<Outputs>

=over 2

=item * I<aggregates>  =>   B<L<"aggr-info">[]>

=begin html

<br>List of aggregates and their status.

=end html

=back



=head2 aggr_mediascrub_list_info

[B<Family:> ontap-classic]


=begin html

Get the status of media scrubbing on the named aggregate, plex, or RAID group. Status includes percentage complete and the media scrub's status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of an existing aggregate, plex, or RAID group, using the following format: [/vol/]<aggrname>[<plexinfo>][<groupinfo>] If no name is given, then status is generated for all RAID groups currently being media-scrubbed.

=end html

=back



B<Outputs>

=over 2

=item * I<mediascrub-details>  =>   B<L<"mediascrub-detail-info">[]>

=begin html

<br>List of RAID groups and their media scrub status.

=end html

=back



=head2 aggr_mirror

[B<Family:> ontap-classic]


=begin html

Turns an unmirrored aggregate into a mirrored aggregate by adding a plex to it. The plex is either newly formed from disks chosen from a spare pool or, if the "victim-aggregate" option is specified, taken from another existing unmirrored aggregate. The named aggregate must currently be unmirrored. Disks may be specified explicitly using the "mirror-disks" list option in the same way as with the "aggr-create" and "aggr-add" commands. The number of disks indicated must match the number present in the existing aggregate. If disks are not specified explicitly, then disks are automatically selected to match those in the aggregate's existing plex.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the existing aggregate to be mirrored. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<allow-mixed-rpm>  =>   B<boolean, optional>

=begin html

<br>Disks in an aggregate are normally required to have the same RPM. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<allow-same-carrier>  =>   B<boolean, optional>

=begin html

<br>Using two disks from one carrier that houses multiple disks in one RAID group is not desirable. If that happens, Data ONTAP initiates a series of disk copy operations to correct that situation. Sometimes, selection of available spare disks makes it impossible to avoid placing two disks from one carrier in one RAID group. Setting this option to true allows placing two disks from one carrier in one RAID group. This option has an effect only when disks to be used are specified in 'disks'. This option is ignored when 'disk-count' is used.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>Force the mirroring operation through, past the normal roadblocks that would otherwise cause it to be aborted. For example, disks in a plex are not normally permitted to span spare pools. Also, the victim cannot normally be accepted when it is owned by one or more vfilers. All these safety-driven behaviors are overridden when this option is set to true. This is a deprecated parameter. Use the allow-mixed-rpm and ignore-pool-checks parameters instead.

=end html

=back



=over 2

=item * I<ignore-pool-checks>  =>   B<boolean, optional>

=begin html

<br>Disks in a plex are normally required to come from the same spare pool. Similarly, disks in different plexes of a mirrored aggregate are required to come from different spare pools. This behavior is overridden with this option when it is set to true. Default value is false.

=end html

=back



=over 2

=item * I<mirror-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>Specific list of mirror disks to add. This list must match the number of disks present on the existing aggregate. The specified disks are not permitted to span disk pools unless overridden with the "force-spare-pool" option.

=end html

=back



=over 2

=item * I<override-vfiler-ownership>  =>   B<boolean, optional>

=begin html

<br>The victim aggregate cannot normally be accepted when it is owned by one or more vfilers. This option may be set to true in order to override that restriction. The option is ignored if 'victim-aggregate' is not specified.

=end html

=back



=over 2

=item * I<pre-check>  =>   B<boolean, optional>

=begin html

<br>Only check for the warnings without actually mirroring the aggregate. Default value is false.

=end html

=back



=over 2

=item * I<victim-aggregate>  =>   B<string, optional>

=begin html

<br>The "victim" aggregate to cannibalize in order to mirror the named aggregate. The "victim-aggregate" must have been previously joined with the aggregate to be mirrored and then split from it. The resulting mirrored aggregate is otherwise identical to the original aggregate before the operation. The "victim-aggregate" (and all its volumes) is effec- tively destroyed. "victim-aggregate" (and all its volumes) must be offline.

=end html

=back



B<Outputs>

=over 2

=item * I<bad-disks>  =>   B<L<"disk-info">[], optional>

=begin html

<br>List of disks that were not added. This is only returned if there are bad disks.

=end html

=back



=over 2

=item * I<pre-check-results>  =>   B<L<"warning-code">[], optional>

=begin html

<br>Result of the pre-check for possible warnings. <ul> <li> E_WARN_DISK_DOWNSIZE <li> E_WARN_LOW_SPARE </ul>

=end html

=back



=head2 aggr_modify_raid_type

[B<Family:> ontap-classic]


=begin html

Modify the RAID type for the given aggregate to the specified "raid-type". This API can also selectively change the RAID type of specific raid groups in the aggregate based on the specified "disk-type". The change remains effective even if the filer is rebooted. This API does not support modifying options of a striped aggregate.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate whose option is to be set. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<disk-type>  =>   B<string, optional>

=begin html

<br>Type of disks to use : ATA, BSAS, FCAL, FSAS, LUN, SAS, SATA, or SSD. This option is required if we want to change the raid type of raid groups created out of the specified disks only. Otherwise, if this is not specified then the raid type for all raid groups in the aggregate would change.

=end html

=back



=over 2

=item * I<raid-type>  =>   B<string>

=begin html

<br>possible values: "raid4","raid_dp" The type of RAID group used for this aggregate. The "raid4" setting provides one parity disk per RAID group, while "raid_dp" provides two. Changing this option immediately changes the RAID group type for the RAID groups in the aggregate. When upgrading RAID groups from "raid4" to "raid_dp", each RAID group begins a reconstruction onto a spare disk allocated for the second "dparity" parity disk.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_offline

[B<Family:> ontap-classic]


=begin html

Take the specified aggregate or plex offline. The operation takes effect before the API returns. Except in maintenance mode, the current root aggregate may not be taken offline. An aggregate marked to become the root aggregate cannot be taken offline. An aggregate containing one or more flexible volumes cannot be taken offline; its contained volumes must first be destroyed. A number of operations being performed on the given aggregate can prevent this operation from succeeding, either at all or for various lengths of time. If such operations are found, the system waits up to one second for them to finish. If they don't, the command is aborted. A check is also made for files in the aggregate opened by internal Data ONTAP processes. The command is aborted if any are found.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the existing aggregate or plex to offline, using the following format: [[/vol]/]<aggrname>[<plexinfo>] UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions. If the aggregate hosts any online volumes, then the offline request will fail unless the optional "unmount-volumes" argument (see below) appears and is set to TRUE. If we've been cleared to unmount any such online volumes hosted by the aggregate, the caller may also specify the number of seconds to wait should any of those volumes have active CIFS shares through the optional "cifs-delay-seconds" argument (see below). If a plex name is specified, the plex must be part of a mirrored aggregate, and both plexes must be online. Prior to offlining a plex, the system will flush all internally-buffered data associated with the plex and create a snapshot that is written out to both plexes. The snapshot allows for efficient resynchronization when the plex is subsequently brought back online. For ontap-cluster, plexinfo is being deprecated in lieu of the plex parameter.

=end html

=back



=over 2

=item * I<cifs-delay-seconds>  =>   B<integer, optional>

=begin html

<br>The number of seconds to wait before offlining any volumes that are hosted in the given aggregate that have active CIFS shares (if any). A value of 0 means that all such volumes are to be offlined immediately with no warning. CIFS users can lose data if they aren't given a chance to terminate applications gracefully. By default, "cifs-delay-seconds" is 0. NOTE: This argument may ONLY appear if the "unmount-volumes" argument (see above) also appears and is set to "TRUE".

=end html

=back



=over 2

=item * I<unmount-volumes>  =>   B<boolean, optional>

=begin html

<br>If set to "TRUE", this option specifies that all of the volumes hosted by the given aggregate are to be unmounted before the offline operation is executed. By default, the system will reject any attempt to offline an aggregate that hosts one or more online volumes.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_online

[B<Family:> ontap-classic]


=begin html

Bring the specified aggregate or plex online. This command takes effect immediately. All volumes on the aggregate are brought to whatever state they were in before the aggregate was restricted or taken offline. If there are CIFS shares associated with the any of the aggregate's volumes that were also onlined, they are enabled.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the existing aggregate or plex to online, using the following format: [/vol/]<aggrname>[<plexinfo>] UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions. If an aggregate is specified, it must currently be offline, restricted, or foreign (consisting of disks moved from another filer, and never having been brought online on the current filer). If the aggregate is foreign, it will be made native before being brought online on the current filer. Aggregates that aren't foreign are termed "native". If the aggregate is inconsistent but has not lost data, it is advisable to run WAFL_check or wafliron (or do a "snapmirror initialize" in case of a replica aggregate) prior to bringing it online. Bringing an inconsistent aggregate online increases the risk of further file system corruption. If the aggregate is inconsistent and has experienced possible loss of data, it can't be brought online unless WAFL_check or wafliron (or snapmirror initialize) is run on it. If a plex is specified, it must be part of an online mirrored aggregate. The system initiates resynchro- nization of the plex as part of online processing. For ontap-cluster, plexinfo is being deprecated in lieu of the plex parameter.

=end html

=back



=over 2

=item * I<force-online>  =>   B<boolean, optional>

=begin html

<br>An aggregate can not normally be brought online under the following conditions: 1. It has only 1 plex that is offline and not up-to-date. 2. It is an unmirrored or CFO aggregate that has been switched over to its DR partner as part of an MCC configuration. This behavior is overridden when this option is set "true". By default, "force-online" is "false".

=end html

=back



=over 2

=item * I<keep-same-uuid>  =>   B<boolean, optional>

=begin html

<br>Keep existing foreign raidtree id (aggregate uuid). Normally when a foreign raidtree is onlined, the raidtree rtid (aggregate uuid) is changed to guarantee uniqueness. The behavior is overridden when this option is set "true." By default, "keep-same-uuid" is "false."

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_options_list_info

[B<Family:> ontap-classic]


=begin html

Get the options that have been set for the specified aggregate. This API does not support listing options of striped aggregate.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate whose options to retrieve. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * I<options>  =>   B<L<"aggr-option-info">[]>

=begin html

<br>List of options set for this aggregate.

=end html

=back



=head2 aggr_rename

[B<Family:> ontap-classic]


=begin html

Rename the specified aggregate.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate to rename. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<new-aggregate-name>  =>   B<string>

=begin html

<br>The new name desired for the aggregate.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_restrict

[B<Family:> ontap-classic]


=begin html

Restrict the specified aggregate. If the aggregate is embedded in a traditional volume, the entire traditional volume will be restricted. An aggregate with one or more flexible volumes cannot be restricted; all of its contained volumes must first be destroyed.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate to restrict. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<cifs-delay-seconds>  =>   B<integer, optional>

=begin html

<br>The number of seconds to wait before restricting any volumes that are hosted in the given aggregate that have active CIFS shares (if any). A value of 0 means that all such volumes are to be offlined immediately with no warning. CIFS users can lose data if they aren't given a chance to terminate applications gracefully. By default, "cifs-delay-seconds" is 0. NOTE: This argument may ONLY appear if the "unmount-volumes" argument (see above) also appears and is set to "true".

=end html

=back



=over 2

=item * I<unmount-volumes>  =>   B<boolean, optional>

=begin html

<br>If set to "TRUE", this option specifies that all of the volumes hosted by the given aggregate are to be unmounted before the restrict operation is executed. By default, the system will reject any attempt to restrict an aggregate that hosts one or more online volumes.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_scrub_list_info

[B<Family:> ontap-classic]


=begin html

Get the status of parity scrubbing on the named aggregate. Status includes percentage complete and the scrub's suspended status (if appropriate). If no name is given, then status is generated for all RAID groups.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name or UUID of the entity to show scrubbing status for. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<verbose>  =>   B<boolean, optional>

=begin html

<br>If set to "true", this operation will be verbose. If not supplied or set to false, normal output levels will be used.

=end html

=back



B<Outputs>

=over 2

=item * I<scrub-details>  =>   B<L<"scrub-detail-info">[], optional>

=begin html

<br>List of RAID groups and their scrub status.

=end html

=back



=head2 aggr_scrub_resume

[B<Family:> ontap-classic]


=begin html

Resume parity scrubbing on the named aggregate, plex, or RAID group. If no name is given, then resume parity scrubbing on all RAID groups for which it has been suspended. Use "aggr-scrub-list-info" to check scrubbing status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name or UUID of the entity for which scrubbing is to resume. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_scrub_start

[B<Family:> ontap-classic]


=begin html

Start parity scrubbing on the named aggregate, plex, or RAID group. Parity scrubbing compares the data disks to the parity disk in a RAID group, correcting the parity disk's contents as necessary. If no name is given, then parity scrubbing is started on all online aggregates. If an aggregate name is given, scrubbing is started on all RAID groups in the aggregate. If a plex name is given, scrubbing is started on all RAID groups contained in the plex. If a RAID group name is given, scrubbing is started only on that group. Use "aggr-scrub-list-info" to check scrubbing status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name or UUID of the entity for which scrubbing is to start. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_scrub_stop

[B<Family:> ontap-classic]


=begin html

Stop parity scrubbing on the named aggregate, plex, or RAID group. If no name is given, scrubbing will stop on all RAID groups currently being scrubbed. Use "aggr-scrub-list-info" to check scrubbing status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name or UUID of the entity for which scrubbing is to stop. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_scrub_suspend

[B<Family:> ontap-classic]


=begin html

Suspend parity scrubbing on the named aggregate, plex, or RAID group. If no name is given, suspend scrubbing on all RAID groups currently being scrubbed. Use "aggr-scrub-list-info" to check scrubbing status.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name or UUID of the entity for which scrubbing is to suspend. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_set_option

[B<Family:> ontap-classic]


=begin html

Set the specified option for the given aggregate to "option-value". The change remains effective even if the filer is rebooted. Some options have values that are numbers, and some have values that are "on" (also expressible as "yes", "true", or "1" ) or "off" (also expressible as "no", "false", or "0"). A mixture of uppercase and lowercase characters may be used when typing an option's value. Note that the "root" option is special in that it doesn't have a corresponding value. This API does not support modifying options of striped aggregate.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name or UUID of the aggregate whose option to be set. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<option-name>  =>   B<string>

=begin html

<br>Option name. Possible values: <dl> <dt>"free_space_realloc" (value: "on" | "off" | "no_redirect")</dt> <dd> Setting this option to "on" enables free space reallocation (continuous segment cleaning) on a block checksum aggregate. Possible values : on, off, no_redirect "on" : Free space reallocation enabled with automatically starting the redirect scanner "off": Free space reallocate disabled "no_redirect": Free space reallocation enabled without running the redirect scanner The default value for this option is "off" </dd><br> <dt>"fs_size_fixed" (value: "on" | "off")</dt> <dd> Setting this option to "on" causes the file system to remain the same size (and not grow) when the mirror is broken on a SnapMirrored aggregate (which MUST be embedded in a traditional volume), or when an "aggr add" is performed on it. This option is automatically set to be "on" when an aggregate becomes SnapMirrored. It remains "on" after the "snapmirror break" command is issued for an aggregate embedded in a traditional volume. This option allows an embedded aggregate to be SnapMirrored back to the source without needing to add disks to the source aggregate. If the aggregate size is larger than the file system size, turning off this option forces the file system to grow to the size of the aggregate. This option is not supported when the request is sent to the Admin Vserver LIF. </dd><br> <dt>"ha_policy" (value: "cfo" | "sfo")</dt> <dd> This option is used to change the HA policy of given aggregate and restricted to clustered environments. It is not allowed in unclustered environments. Also this option does not apply to traditional volume. Changing the HA policy of an aggregate from SFO to CFO is allowed only in Maintenance mode. HA policy can not be changed if: 1. aggregate is striped. 2. aggregate contains node volumes. 3. aggregate is root. 4. aggregate is partner aggregate during takeover i.e. when it is not home to local node. EOP_CLUSTER_ATTR_DISALLOWED is returned if this option is used in unclustered environments. EOP_DISALLOWED_ON_STRIPED_AGGR is returned if this option is used with striped aggregate. EOP_DISALLOWED_ON_AGGR_WITH_NODE_VOLS is returned if this option is used on aggregate which contains node volumes. EOP_DISALLOWED_ON_ROOT_AGGR is returned if this option is used on root aggregate. EOP_DISALLOWED_ON_NOT_HOME_AGGR is returned if this option is used on partner aggregate during takeover. </dd><br> <dt>"ignore_inconsistent" (value: "on" | "off")</dt> <dd> This command can only be used in maintenance mode. If this option is set to "on", then the root aggregate may be brought online when booting even if it is marked as inconsistent. The user is cautioned that bringing it online prior to running WAFL_check or wafliron may result in further file system inconsistency. This option is not supported when the request is sent to the Admin Vserver LIF. </dd><br> <dt>"lost_write_protect" (value: "on" | "off")</dt> <dd> Setting this option to "off" disables lost write protection on the aggregate. The default is "on". The user is cautioned that turning off this option may expose the filesystem(s) contained in the aggregate to data loss and data corruption. This option should not be disabled, unless directed to do so by support personnel. </dd><br> <dt>"max_write_alloc_blocks" (value: value: &lt number &gt)</dt> <dd> The maximum number of blocks used for write allocation. Some sequential read workloads may benefit from increasing this value. Default value is 0 which uses the controller-wide default value of 64. The default is optimal for most users. The controller-wide default can be adjusted with the bootarg "wafl-max-write-alloc-blocks" </dd><br> <dt>"striping" (value: "striped" | "not_striped")</dt> <dd> This option sets the striping information of given aggregate. It is restricted to clustered environments and not allowed in unclustered environments. When set to true, it marks given aggregate as member of stripe. This option is not allowed if given aggregate is of 'cfo' HA policy. Also this option does not apply to traditional volume. EOP_CLUSTER_ATTR_DISALLOWED is returned if this option is used in unclustered environments. EOP_DISALLOWED_ON_CFO_AGGR is returned if given aggregate is of 'cfo' HA policy. This option is not supported when the request is sent to the Admin Vserver LIF. </dd><br> <dt>"nosnap" (value: "on" | "off")</dt> <dd> Setting this option to "on" disables automatic snapshots on the aggregate. </dd><br> <dt>"raid_cv" (value: "on" | "off")</dt> <dd> Setting this option to "off" disables block or advanced_zoned checksum (azcs) protection on the aggregate. The default is "on". The user is cautioned that turning off this option exposes the filesystems contained in the aggregate to inconsistency that could be caused by a misbehaving hardware component in the system. </dd><br> <dt>"raid_lost_write" (value: "on" | "off")</dt> <dd> Setting this option to "off" disables RAID Lost Write protection on the aggregate. The default is "on". The user is cautioned that turning off this option may expose the filesystem(s) contained in the aggregate to data loss and data corruption. The option should not be disabled, unless directed to do so by support personnel. </dd><br> <dt>"raid_zoned" (value: "on" | "off")</dt> <dd> Setting this option to "off" disables zoned checksum protection on the aggregate. The default is "on". The user is cautioned that turning off this option exposes the filesystems contained in the aggregate to inconsistency that could be caused by a misbehaving hardware component in the system. </dd><br> <dt>"raidsize" (value: &lt number &gt>)</dt> <dd> The maximum size of a RAID group within the aggregate. Changing this option doesn't cause existing RAID groups to grow or shrink. Rather, it only affects whether more disks will be added to the last existing RAID group in the future, and how large new RAID groups will be. </dd><br> <dt>"cache_raid_group_size" (value: &lt number &gt>)</dt> <dd> The current maximum size of a SSD RAID group within the hybrid aggregate. This option can only be modified for hybrid aggregate. Changing this option doesn't cause existing RAID groups to grow or shrink. Rather, it only affects whether more disks will be added to the existing SSD RAID group in the future, and how large new SSD RAID groups will be. </dd><br> <dt>"raidtype" (value: "raid4" | "raid_dp" | "raid0")</dt> <dd> The type of RAID group used for this aggregate. The "raid4" setting provides one parity disk per RAID group, while "raid_dp" provides two. Changing this option immediately changes the RAID group type for all RAID groups in the aggregate. When upgrading RAID groups from "raid4" to "raid_dp", each RAID group begins a reconstruction onto a spare disk allocated for the second "dparity" parity disk. </dd><br> <dt>"resyncsnaptime" (value: &lt number &gt)</dt> <dd> Sets the mirror resynchronization snapshot frequency to be the given number of minutes. The default value is 60 (minutes). </dd><br> <dt>"root" (value: &lt none &gt)</dt> <dd> The specified aggregate is to become the root aggregate for the filer on the next reboot. This option can be used only in maintenance mode and on only one aggregate at any given time. The existing root aggregate will become a non-root aggregate after the reboot. Until the system is rebooted, the original aggregate will continue to show root as an option, and the new root aggregate will show diskroot as an option. In general, the aggregate that has the diskroot option is the one that becomes the root aggregate following the next reboot. The only way to remove the root status of an aggregate is to set it on another aggregate. In clustered environments, this option is not allowed with aggregates with 'sfo' HA policy as root has to be an aggregate with 'cfo' HA policy. EOP_DISALLOWED_ON_SFO_AGGR is returned if given aggregate is of 'sfo' HA policy. </dd><br> <dt>"snapmirrored" (value : "off")</dt> <dd> If SnapMirror is enabled, the filer auto- matically sets this option to "on". Set this option to "off" with the "snapmirror" command if SnapMirror should no longer be used to update the mirror. After setting this option to "off", the mirror becomes a regular writable aggregate, and all its volumes are restored to whatever state they were last in. Note that it is not possible to set this option directly through this interface. Rather, it is automatically changed as a side effect of running the appropriate "snapmirror" commands. This option is not supported when the request is sent to the Admin Vserver LIF. </dd><br> <dt>"snapshot_autodelete" (value: "on" | "off")</dt> <dd> Setting this option to "off" disables automatic snapshot deletion on the aggregate. </dd><br> <dt>"thorough_scrub" (value: "on" | "off")</dt> <dd> Setting this option to "on" enables thorough scrub on a block checksum aggregate. That means that a scrub will initialize any zeroed checksum entries that it finds. If there are any checksum entries to be initialized, scrub will run slower than normal. </dd><br> <dt>"percent_snapshot_space" (value: &lt number &gt)</dt> <dd> Percentage of total blocks in the aggregate reserved for snapshots. </dd><br> <dt>"hybrid_enabled" (value: "true" | "false")</dt> <dd> Setting this option to "true" would mark the aggregate as hybrid_enabled. That means the aggregate can contain a mix of SSDs and HDDs(Hard Disk Drives, e.g., SAS, SATA, and/or FC). The operation can be forced by using the hybrid_enabled_force option for the aggregates having flexvols which cannot be write cached. EAGGR_CANT_UNDO_HYBRID is returned when we are trying to set the option hybrid_enabled to false on an aggregate that already contains a mix of HDDs and SSDs. EAGGR_HYBRID is returned when we are trying to set option hybrid_enabled to true on an aggregate which is already hybrid. EOP_DISALLOWED_WORM_HYBRID_AGGR is returned when we are trying to set option hybrid_enabled to true on an snaplock aggregate. ERAID_HYA_SUPPORT_DISABLED is returned when the partner node in HA pair is running a version of Data ONTAP which does not support hybrid aggregates. EOP_DISALLOWED_ON_SSD_AGGR is returned if this option is used on aggregates created out of SSD disks. EOP_DISALLOWED_HYA_ON_RAID0_AGGR is returned if this option is used on raid0 aggregates. EOP_DISALLOWED_HYA_ON_ZONED_AGGR is returned if this option is used on aggregates with zoned checksums. EOP_DISALLOWED_HYA_ON_LUNS_AGGR is returned if this option used on aggregates created out of LUNs. </dd><br> <dt>"hybrid_enabled_force" (value: "true" | "false")</dt> <dd> Setting this option to "true" would mark the aggregate as hybrid_enabled. That means the aggregate can contain a mix of SSDs and HDDs(Hard Disk Drives, e.g., SAS, SATA, and/or FC). This option is used for force marking of aggregates having flexvols which cannot be write cached as hybrid enabled. FlexVols in the aggregate marked as hybrid enabled using this option which cannot participate in write-caching only have read-caching enabled. All other flexvols in the aggregate can participate in both read and write caching. EAGGR_CANT_UNDO_HYBRID is returned when we are trying to set the option hybrid_enabled_force to false on an aggregate that already contains a mix of HDDs and SSDs. EAGGR_HYBRID is returned when we are trying to set option hybrid_enabled_force to true on an aggregate which is already hybrid. EOP_DISALLOWED_WORM_HYBRID_AGGR is returned when we are trying to set option hybrid_enabled_force to true on an snaplock aggregate. ERAID_HYA_SUPPORT_DISABLED is returned when the partner node in HA pair is running a version of Data ONTAP which does not support hybrid aggregates. EOP_DISALLOWED_ON_SSD_AGGR is returned if this option is used on aggregates created out of SSD disks. EOP_DISALLOWED_HYA_ON_RAID0_AGGR is returned if this option is used on raid0 aggregates. EOP_DISALLOWED_HYA_ON_ZONED_AGGR is returned if this option is used on aggregates with zoned checksums. </dd><br> </dl>

=end html

=back



=over 2

=item * I<option-value>  =>   B<string>

=begin html

<br>The value to set the named option. It may be the NULL/empty value only in the case of the "root" option.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_space_list_info

[B<Family:> ontap-classic]


=begin html

Show the space usage of the aggregate on a per flexible volume basis. This API is deprecated in Data ONTAP 8.2 and later. Use the aggr-space-info attributes in the aggr-list-info API for details related to aggregate space usage. Use volume-space-list-info and volume-footprint-list-info APIs for details related to volume space usage.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>The aggregate to get the space information for. If not specified the space information for all aggregates is obtained.

=end html

=back



B<Outputs>

=over 2

=item * I<aggregates>  =>   B<L<"aggr-space-info">[]>

=begin html

<br>Various counts describing space usage in the aggregate.

=end html

=back



=head2 aggr_split

[B<Family:> ontap-classic]


=begin html

Remove the specified plex from a mirrored aggregate and create a new unmirrored aggregate with the specified name that contains the plex. The original mirrored aggregate thus becomes unmirrored. The plex to be split from the original aggregate must be functional (not partial), but it can otherwise be inactive, resyncing, or out-of-date. "Aggr split" can therefore be used to gain access to a plex that isn't up to date with respect to its partner plex if its partner plex is currently failed. If the plex is offline at the time of the split, the resulting aggregate will be offline. Otherwise, the resulting aggregate will be in the same online/offline/restricted state as the original aggregate. A split mirror can be joined back together via the "victim-aggregate" option to "aggr-mirror".

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string>

=begin html

<br>Name of the plex to split out of its aggregate, using the following format: [/vol/]<aggrname>[<plexinfo>][<groupinfo>]

=end html

=back



=over 2

=item * I<new-aggr-name>  =>   B<string>

=begin html

<br>Name of the new aggregate to create from the split plex.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_verify_list_info

[B<Family:> ontap-classic]


=begin html

Get the status of RAID mirror verification on the named aggregate. Status includes percentage complete and whether it's currently suspended.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of an existing aggregate. If no name is given, then mirror verification status is generated for all aggregates currently being verified. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * I<verify-details>  =>   B<L<"verify-detail-info">[], optional>

=begin html

<br>List of aggregates and their mirror verification status.

=end html

=back



=head2 aggr_verify_resume

[B<Family:> ontap-classic]


=begin html

Resume RAID mirror verification on the named aggregate. If no name is given, then resume mirror verification on all aggregates that have been suspended.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of the existing aggregate for which mirror verification is to resume. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_verify_start

[B<Family:> ontap-classic]


=begin html

Start RAID mirror verification on the named aggregate. Verification compares the data in both plexes of a mirrored aggregate. In the default case, any blocks that differ are logged and no changes are made. The fix-plex option is used to fix any mismatches. It specifies which plex to fix. If no name is given, then mirror verification is started on all online aggregates. Use the "aggr-verify-list-info" API to check mirror verification status. If the fix-plex option is used, then a name must be specified.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of the mirrored aggregate to verify. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



=over 2

=item * I<fix-plex>  =>   B<integer, optional>

=begin html

<br>If provided, this specifies the plex to fix in case the two plexes do not match. The default is to log any discrepancies instead of fixing them.

=end html

=back



=over 2

=item * I<log-only>  =>   B<boolean, optional>

=begin html

<br>If provided, and if the value is "true", then simply log any discrepancies instead of fixing them. The default value is "true". If log-only is "false", then the fix-plex option must also be specified. If log-only is "true" and fix-plex is also specified, then the log-only option will be ignored.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_verify_stop

[B<Family:> ontap-classic]


=begin html

Stop RAID mirror verification on the named aggregate. If no name is given, stop mirror verification on all aggregates currently being verified.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of the aggregate for which we are to stop mirror verification. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggr_verify_suspend

[B<Family:> ontap-classic]


=begin html

Suspend RAID mirror verification on the named aggregate. If no name is given, suspend mirror verification on all aggregates currently being verified.

=end html



B<Inputs>

=over 2

=item * I<aggregate>  =>   B<string, optional>

=begin html

<br>Name of the aggregate for which we are to suspend mirror verification. UUID can be specified instead of aggregate name. See the synopsis for name/UUID format and restrictions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_force_takeover

[B<Family:> ontap-classic]


=begin html

Forces one filer to take over its partner even though the filer detects an error that would otherwise prevent a takeover. For example, normally, if a detached or faulty interconnect cable between the filers causes the filers' NVRAM contents to be unsynchronized, takeover is disabled. However, this will allow the filer to take over its partner despite the unsynchronized NVRAM contents. cf-force-takeover is dangerous and can lead to data corruption; in almost all cases, use cf-takeover instead.

=end html



B<Inputs>

=over 2

=item * I<disaster>  =>   B<boolean, optional>

=begin html

<br>When set to true, forces a filer to take over its partner in all cases where a force-takeover would. In addition it will force a takeover even if some partner mailbox disks are inaccessible. It can only be used when remotesyncmirror is licensed. This option is very dangerous. Not only can it cause data corruption, if not used carefully, it can also lead to a situation where both the filer and it's partner are operational (split brain). As such, it should only be used as a means of last resort when the takeover and force-takeover operations are unsuccessful in achieving a takeover. The operator must ensure that the partner filer does not become operational at any time while a filer is in a takeover mode initiated by the use of this operation. In conjunction with RAID mirroring, it can allow recovery from a disaster when the two filers are setup in a MetroCluster configuration.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_get_partner

[B<Family:> ontap-classic, vfiler]


=begin html

Get the host name of the partner. If the name is unknown, It will return partner-unknown.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<partner>  =>   B<string>

=begin html

<br>Host name of the partner or partner-unknown, if the host name is not known.

=end html

=back



=head2 cf_giveback

[B<Family:> ontap-classic]


=begin html

Initiates a giveback of partner resources. Once the giveback is complete, the automatic takeover capability is disabled until the partner is rebooted. A giveback fails if outstanding CIFS sessions, active system dump processes, or other filer operations makes a giveback dangerous or disruptive.

=end html



B<Inputs>

=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>When set to true, this allows a giveback to proceed even if there are outstanding CIFS sessions, active system dump processes, or other filer operations which makes a giveback dangerous or disruptive as long as it would not result in data corruption or filer error. When set to false, this does not allow a giveback to proceed if there are outstanding CIFS sessions, active system dump processes, or other filer operations which makes a giveback dangerous or disruptive. The default value is false.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_hwassist_stats

[B<Family:> ontap-classic]


=begin html

Get useful information about statistics of hardware assisted takeover functionality.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<hwassist-stats-abnormal-reboot>  =>   B<string, optional>

=begin html

<br>Number of abnormal_reboot alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-bad-nvram-id>  =>   B<string, optional>

=begin html

<br>Number of bad NVRAM id alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-keep-alive>  =>   B<string, optional>

=begin html

<br>Number of keep_alive alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-loss-of-heartbeat>  =>   B<string, optional>

=begin html

<br>Number of loss_of_heartbeat alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-post-error>  =>   B<string, optional>

=begin html

<br>Number of post_error alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-power-cycle-via-rlm>  =>   B<string, optional>

=begin html

<br>Number of power_cycle_via_rlm alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-power-cycle-via-sp>  =>   B<string, optional>

=begin html

<br>Number of power_cycle_via_sp alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-power-loss>  =>   B<string, optional>

=begin html

<br>Number of power_loss alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-power-off-via-rlm>  =>   B<string, optional>

=begin html

<br>Number of power_off_via_rlm alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-power-off-via-sp>  =>   B<string, optional>

=begin html

<br>Number of power off alerts received from service processor (power_off_via_sp alert).

=end html

=back



=over 2

=item * I<hwassist-stats-reset-via-rlm>  =>   B<string, optional>

=begin html

<br>Number of reset_via_rlm alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-reset-via-sp>  =>   B<string, optional>

=begin html

<br>Number of reset_via_sp alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-ss-mismatch>  =>   B<string, optional>

=begin html

<br>Number of shared secret key mismatch alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-test>  =>   B<string, optional>

=begin html

<br>Number of test alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-times-throttled>  =>   B<string, optional>

=begin html

<br>Number of times hardware assist alerts were throttled. Alerts are throttled when too many are received in a short interval.

=end html

=back



=over 2

=item * I<hwassist-stats-unknown-alerts>  =>   B<string, optional>

=begin html

<br>Number of unknown alerts received

=end html

=back



=over 2

=item * I<hwassist-stats-watchdog-reset>  =>   B<string, optional>

=begin html

<br>Number of l2_watchdog_reset alerts received

=end html

=back



=over 2

=item * I<no-stats>  =>   B<string, optional>

=begin html

<br>If no hardware assist statistics are available, this is set to "Cannot determine hwassist stats".

=end html

=back



=head2 cf_hwassist_status

[B<Family:> ontap-classic]


=begin html

Get useful information about the status of hw_assist functionality.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<keep-alive-status>  =>   B<string>

=begin html

<br>Possible values are: <ul> <li>healthy <li>missed_keep_alive_alerts </ul>

=end html

=back



=over 2

=item * I<local-hwassist-inactive-corrective-action>  =>   B<string, optional>

=begin html

<br>Indicates the corrective action if status is inactive.

=end html

=back



=over 2

=item * I<local-hwassist-inactive-reason>  =>   B<string, optional>

=begin html

<br>Indicates the reason if status is inactive.

=end html

=back



=over 2

=item * I<local-hwassist-ipaddr>  =>   B<string, optional>

=begin html

<br>If set, Ip address; 0.0.0.0 otherwise

=end html

=back



=over 2

=item * I<local-hwassist-port>  =>   B<integer, optional>

=begin html

<br>If set, port; 0 otherwise

=end html

=back



=over 2

=item * I<local-hwassist-status>  =>   B<string, optional>

=begin html

<br>Local node hw_assist status <p> Possible values are: <ul> <li>active: If functionality is active. <li>inactive: If functionality is inactive </ul>

=end html

=back



=over 2

=item * I<no-status>  =>   B<string, optional>

=begin html

<br>Set if no hw_assist status is avaliable. Either this or the remaining fields will be set,hence they are optional.

=end html

=back



=over 2

=item * I<partner-hwassist-inactive-corrective-action>  =>   B<string, optional>

=begin html

<br>Indicates the corrective action if status is inactive.

=end html

=back



=over 2

=item * I<partner-hwassist-inactive-reason>  =>   B<string, optional>

=begin html

<br>Indicates the reason if status is inactive.

=end html

=back



=over 2

=item * I<partner-hwassist-ipaddr>  =>   B<string, optional>

=begin html

<br>If set, Ip address, 0.0.0.0 otherwise

=end html

=back



=over 2

=item * I<partner-hwassist-port>  =>   B<integer, optional>

=begin html

<br>If set, current port, 0 otherwise

=end html

=back



=over 2

=item * I<partner-hwassist-status>  =>   B<string, optional>

=begin html

<br>partner node hw_assist status <p> Possible values are: <ul> <li>active: If functionality is active. <li>inactive: If functionality is inactive </ul>

=end html

=back



=head2 cf_negotiated_failover_disable

[B<Family:> ontap-classic]


=begin html

Disables negotiated failover. disk_shelf is the negotiated failover module currently supported.

=end html



B<Inputs>

=over 2

=item * I<module>  =>   B<string>

=begin html

<br>Module currently supported is 'disk_shelf'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_negotiated_failover_enable

[B<Family:> ontap-classic]


=begin html

Enables negotiated failover. disk_shelf is the negotiated failover module currently supported.

=end html



B<Inputs>

=over 2

=item * I<module>  =>   B<string>

=begin html

<br>Module currently supported is 'disk_shelf'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_negotiated_failover_status

[B<Family:> ontap-classic]


=begin html

Returns the status of the negotiated failover module. Negotiated failover is a general facility which supports negotiated failover on the basis of decisions made by various modules.

=end html



B<Inputs>

=over 2

=item * I<module>  =>   B<string>

=begin html

<br>Module currently supported is 'disk_shelf'

=end html

=back



B<Outputs>

=over 2

=item * I<is-enabled>  =>   B<boolean>

=begin html

<br>True, if clusterfailover for this module is enabled, false otherwise.

=end html

=back



=head2 cf_service_disable

[B<Family:> ontap-classic]


=begin html

Disables the takeover capability of this filer in the cluster.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_service_enable

[B<Family:> ontap-classic]


=begin html

Enables the takeover capability of this filer in the cluster. This spawns a process to enable the service

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cf_status

[B<Family:> ontap-classic, vfiler]


=begin html

Get useful information about the status of the high availability service. If the monitor is not initialized, this returns an error.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<current-mode>  =>   B<string, optional>

=begin html

<br>Current HA mode

=end html

=back



=over 2

=item * I<current-time>  =>   B<integer>

=begin html

<br>Current time on the filer

=end html

=back



=over 2

=item * I<is-enabled>  =>   B<boolean>

=begin html

<br>True, if the storage failover facility is enabled, false otherwise. Note that the facility can be enabled but takeover may not be possible due to various reason.

=end html

=back



=over 2

=item * I<is-interconnect-up>  =>   B<boolean>

=begin html

<br>True, if high availability interconnect is up

=end html

=back



=over 2

=item * I<local-in-headswap>  =>   B<boolean, optional>

=begin html

<br>True, if the local node is being replaced by a new node.

=end html

=back



=over 2

=item * I<new-partner-sysid>  =>   B<integer, optional>

=begin html

<br>The new partner system ID recieved via HA interconnect. The value is zero if partner is not in headswap.

=end html

=back



=over 2

=item * I<node-state>  =>   B<string, optional>

=begin html

<br>State of the storage failover of the node. Possible values are: <ul> <li>connected - Partner is available for takeover</li> <li>takeover_scheduled - Partner is down and takeover is scheduled</li> <li>takeover_started - Takeover process has begun</li> <li>takeover - Currently controlling partner's resources.</li> <li>takeover_failed - Failed to takeover the partner</li> <li>giveback_partial_waiting - This node controls partner aggregates even though the node is not in takeover. And we're waiting for a connection to the partner.</li> <li>giveback_partial_connected - This node controls partner aggregates even though the node is not in takeover. The partner is available to receive the aggregates.</li> <li>waiting_for_root_aggr - Partner is controlling dblade's root aggregate If we're in this state, many other optional fields are not returned.</li> <li>waiting - Waiting for a connection to partner. Generally happens while partner is rebooting.</li> <li>in_maintenance_mode - node is in maintenance mode. In the mode it is not possible to determine more detailed information (e.g. cluster or not; takeover or not, etc).</li> <li>pending_shutdown - starting a takeover/giveback is inhibited due to a pending system shutdown.</li> <li>relocating_aggrs_before_takeover - node is relocating its SFO aggregates to its partner prior to a negotiated takeover.</li> <li>sfo_takeover_phase_done - Node is done with the SFO phase of takeover.</li> <li>sfo_takenover_phase_done - This node has relocated its SFO aggregates to its partner during an optimized negotiated takeover by its partner.</li> <li>sfo_takeover_phase_aborted - The SFO phase of takeover has been aborted. Refer to takeover-failure-reason field to check the reason.</li> <li>sfo_takenover_phase_aborted - This node has aborted the relocation of its SFO aggregates to its partner, during an optimized negotiated takeover by its partner.</li> <li>in_non_HA_mode - Node is not in HA mode</li> <li>cfo_takeover_failed - CFO phase of takeover failed</li> <li>sfo_takeover_in_progress - SFO phase of takeover of partner is in progress</li> <li>relocated_aggrs_before_takeover - node has relocated its SFO aggregates to its partner prior to a negotiated takeover.</li> <li>giveback_in_progress - Giveback is in progress. Refer to current-giveback-module field to get the current module, the giveback process is in.</li> <li>giveback_failed_autogiveback_disabled - Previous giveback failed and auto giveback is disabled. Refer to current-giveback-module to get the module in which giveback process failed.</li> <li>giveback_failed_autogiveback_scheduled - Previous giveback failed and an auto giveback is scheduled. Refer to current-giveback-module to get the module in which giveback process failed.</li> Refer to time-until-autogiveback field to check time remaining before an auto giveback is initiated.</li> <li>previous_giveback_failed - Previous giveback failed. Refer to current-giveback-module to get the module in which giveback process failed.</li> <li>takeover_no_di - Local node is in takeover. A normal giveback is not possible as disk inventory from partner has not yet been received.</li> <li>takeover_partner_missing_disks - Local node is in takeover. A normal giveback is not possible as the patner is missing some of its file system disks.</li> <li>takeover_autogiveback_scheduled - Local node in takeover. An auto giveback is scheduled. Refer time-until-autogiveback field to check time remaining before an auto giveback is initiated.</li> <li>takeover_network_failure - Local node in takeover. The partner was taken over due to network failure.</li> <li>takeover_autogiveback_deferred - Local node in takeover. Auto giveback is deferred because the partner node was not ready to receive aggregates when the auto giveback timer expired. An auto giveback will be initiated as soon as the partner node is up and ready to receive aggregates.</li> <li>automatic_takeover_disabled_connected - Automatic takeover is disabled. Local node is connected to partner via HA interconnect. This happens only in debug builds when raid.panic.missing.disks is turned on from node CLI.</li> <li>automatic_takeover_disabled_waiting - Automatic takeover is disabled. Local node is waiting for partner node on HA interconnect. This happens only in debug builds when raid.panic.missing.disks is turned on from node CLI.</li> <li>ndo_upgrade_in_progress - Local node owns partner's aggregates as part of node upgrade process.</li> <li>own_aggr_non_local_connected - Local node owns aggregates of some other node in the cluster. Local node is connected to partner via HA interconnect. This is possible only during NDO double hop head upgrade.</li> <li>own_aggr_non_local_waiting - Local node owns aggregates of some other node in the cluster. Local node is waiting for partner on HA interconnect. This is possible only during NDO double hop head upgrade.</li> <li>clusterwait_connected - Connected to partner via HA interconnect. Local node waiting for cluster applications to come online.</li> <li>clusterwait_waiting - Waiting for partner on HA interconnect. Local node waiting for cluster applications to come online.</li> <li>error - There is an error with the system</li> </ul> User have to compare the return values case-insensitively.

=end html

=back



=over 2

=item * I<partner>  =>   B<string>

=begin html

<br>Hostname of the partner. If the partner is unknown, returns an empty string. This is for 7G like output compatibility.

=end html

=back



=over 2

=item * I<partner-in-headswap>  =>   B<boolean, optional>

=begin html

<br>True, if partner node is being replaced by a new node.

=end html

=back



=over 2

=item * I<state>  =>   B<string, optional>

=begin html

<br>connected - Partner is available for takeover takeover_scheduled - Partner is down and takeover is scheduled takeover_started - Takeover process has begun takeover - Currently controlling partner's resources. taken over - Partner is controlling filer's resources takeover_failed - Failed to takeover the partner sfo_takeover_phase - This node has asked its partner to relocate its SFO aggregates in preparation for takeover. This occurs when a user has initiated an optimized negotiated takeover. relocating_aggrs_before_takeover - This node is relocating its SFO aggregates to its partner during an optimized negotiated takeover by its partner. sfo_takeover_phase_done - This node is done with the SFO phase of an optimized negotiated takeover. sfo_takenover_phase_done - This node has relocated its SFO aggregates to its partner during an optimized negotiated takeover by its partner. sfo_takeover_phase_aborted - The SFO phase of takeover is aborted on this node during an optimized negotiated takeover of its partner. sfo_takenover_phase_aborted - This node has aborted the relocation of its SFO aggregates to its partner, during an optimized negotiated takeover by its partner. giving_back - Sendhome process in progress giveback_partial_waiting - This node controls partner aggregates even though the node is not in takeover. And we're waiting for a connection to the partner. giveback_partial_connected - This node controls partner aggregates even though the node is not in takeover. The partner is available to receive the aggregates. waiting_for_root_aggr - Partner is controlling dblade's root aggregate If we're in this state, many other optional fields are not returned. waiting - Waiting for a connection to partner. Generally happens while partner is rebooting. in_maintenance_mode - node is in maintenance mode. In the mode it is not possible to determine more detailed information (e.g. cluster or not; takeover or not, etc). pending_shutdown - starting a takeover/sendhome is inhibited due to a pending system shutdown. error - There is an error with the system User have to compare the return values case-insensitively.

=end html

=back



=over 2

=item * I<takeover-failure-reason>  =>   B<string, optional>

=begin html

<br>If state equals "takeover_failed", this is the reason for the takeover failure. Possible values are: <ul> <li>shutdown_in_progress - shutdown is in progress</li> <li>aggr_relocation_in_progress - aggregate relocation is in progress</li> <li>giveback_in_progress - giveback is in progress</li> <li>takeover_in_progress - takeover is in progress </li> <li>unknown_partner_id - node could not detect its partner's system ID</li> <li>conflicting_sysid - node has the same system ID as its partner</li> <li>pri_mbx_update_error - node could not update its primary mailbox</li> <li>takeover_disabled_by_partner - partner has disabled takeover</li> <li>cannot_takeover_partner_subsystem - node failed to takeover one of partner's subsystems</li> <li>non_etc_or_rc_boot - it is not possible to takeover in a non-etc/rc boot</li> <li>bck_mbx_update_error - node could not update its backup mailbox</li> <li>partner_taking_over - partner is taking over local node </li> <li>revert_in_progress - revert is in progress </li> <li>disaster_recovery_in_progress - disaster recovery operation is in progress</li> <li>headswap_in_progress - headswap is in progress </li> <li>destination_check_failed - destination check failed </li> <li>communication_failed - communication with destination failed</li> <li>operation_aborted - operation was aborted </li> <li>aggr_not_online - destination node did not online the aggregate being relocated in time </li> <li>sfo_disabled - storage failover service is not enabled </li> <li>partner_taking_over - partner is taking over local node </li> <li>bdfu_not_disabled_source - failed to disable background disk firmware update (BDFU) on local node </li> <li>bdfu_not_disabled_dest - failed to disable background disk firmware update (BDFU) on partner node </li> <li>partner_shutting_down - shutdown is in progress on the partner node</li> <li>partner_aggr_relocation_in_progress - aggregate relocation is in progress on the partner node</li> <li>partner_giveback_in_progress - giveback is in progress on the partner node</li> <li>partner_revert_in_progress - revert is in progress on the partner node </li> <li>partner_disaster_recovery_in_progress - disaster recovery operation is in progress on the partner node</li> <li>partner_in_headswap - headswap is in progress on the partner node</li> </ul>

=end html

=back



=over 2

=item * I<time-until-takeover>  =>   B<integer, optional>

=begin html

<br>if state == takeover_scheduled, this is the countdown time in seconds until state == takeover_started.

=end html

=back



=head2 cf_takeover

[B<Family:> ontap-classic]


=begin html

Initiates a takeover of the storage partner. Takeover is done asynchronously; status may be monitored by calling the cf-status API and examining the state field. If automatic giveback is enabled then control will be returned to storage partner once it boots up.

=end html



B<Inputs>

=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>In Classic mode: This causes takeover to be immediately initiated. The taken over node, if up, does not get to shut things down in an orderly manner so the takeover of the resources takes longer. This is the type of takeover that is done during normal cluster operation when one of the nodes goes away (dies). In Cluster mode: It forces a node to take over its storage partner even though the node detects an error that would otherwise prevent a takeover. For example, normally, if a detached or faulty interconnect cable between the nodes(ha pair) causes the nodes NVRAM contents to be unsynchronized, takeover is disabled. However, this will allow the node to take over its storage partner despite the unsynchronized NVRAM contents. cf-force-takeover is dangerous and can lead to data corruption; in almost all cases, use cf-takeover instead.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cg_commit

[B<Family:> ontap-classic, vfiler]


=begin html

Commits the snapshots that were started during the preceeding cg-start call that returned the cg-id key, and unfences the volumes that were fenced. If cg-commit API times out, then it means that either too many volumes were specified to the cg-start api or the timeout value for the cg-start api was very small. In this situation, the caller should try to perform the cg-start operation by specifying lesser volumes or by specifying higher timeout value.

=end html



B<Inputs>

=over 2

=item * I<cg-id>  =>   B<integer>

=begin html

<br>Key to identify the ongoing cg operation.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cg_delete

[B<Family:> ontap-classic]


=begin html

Deletes the snaps associated with a CG checkpoint in this filer. This API is deprecated as of Data ONTAP 8.2. Applications using this API should transition to snapshot-multidelete API as appropriate.

=end html



B<Inputs>

=over 2

=item * I<snapshot>  =>   B<string>

=begin html

<br>The name of the snapshot that is deleted in each volume.

=end html

=back



=over 2

=item * I<volumes>  =>   B<volume-name[]>

=begin html

<br>A list of volumes in this filer that is part of this CG operation.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cg_start

[B<Family:> ontap-classic, vfiler]


=begin html

Starts the checkpoint cycle for externally synchronized checkpoints in the filer. This operation fences the specified volumes and returns "success" (if successful). If the API returns "success", the call starts a snapshot create operation in these volumes. If the API returns "success", this operation SHOULD be followed by a call to cg-commit (below). <p> This API is not supported on Infinite Volume.

=end html



B<Inputs>

=over 2

=item * I<snapshot>  =>   B<string>

=begin html

<br>The provided name of the snapshot that is created in each volume. This name is the unique identifier by which the calling agent identifies the snapshots that constitute a checkpoint. The maximum length is 255 characters. (= MAXNAMLEN)

=end html

=back



=over 2

=item * I<timeout>  =>   B<string, optional>

=begin html

<br>Timeout selector. Possible vaules are "urgent", "medium" or "relaxed". If no value is specified, the default value is "medium". Following are the timeout values: <p> <dl> <dt><dd>"urgent" : 5 seconds </dd><br></dt> <dt><dd>"medium" : 7 seconds </dd><br></dt> <dt><dd>"relaxed" : 20 seconds </dd><br></dt> </dl> </p>

=end html

=back



=over 2

=item * I<volumes>  =>   B<volume-name[]>

=begin html

<br>A list of volumes in this filer that is part of this CG operation.

=end html

=back



B<Outputs>

=over 2

=item * I<cg-id>  =>   B<integer>

=begin html

<br>Identifier of the started cg-start operation. This identifier is used in the succeeding cg-commit call to identify the operation to be commited.

=end html

=back



=head2 cifs_branchcache_hash_stat

[B<Family:> ontap-classic, vfiler]


=begin html

Display the CIFS BranchCache statistics

=end html



B<Inputs>

=over 2

=item * I<include-filesize-stats>  =>   B<boolean, optional>

=begin html

<br>If true, it shows BranchCache hash stats of file sizes for which hashes were requested for. File sizes are <10K, 11K-100K, 101K-250K, 251K-1M, 1.1M-10M, 11M-100M, >100M. The default value of this is false.

=end html

=back



=over 2

=item * I<include-flush-stats>  =>   B<boolean, optional>

=begin html

<br>If true, returns BranchCache hash stats like how many hashes were flushed in multiples of BranchCache hash timeout duration. The default value of this field is false.

=end html

=back



B<Outputs>

=over 2

=item * I<filesize-more-than-100mb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 100mb.

=end html

=back



=over 2

=item * I<filesize-range-0kb-to-10kb>  =>   B<integer, optional>

=begin html

<br>Number of files of size less than equal to 10k for which hashes were asked for.

=end html

=back



=over 2

=item * I<filesize-range-100kb-to-250kb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 100kb and less than equal to 250kb for which hashes were asked for.

=end html

=back



=over 2

=item * I<filesize-range-10kb-to-100kb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 10kb and less than equal to 100kb for which hashes were asked for.

=end html

=back



=over 2

=item * I<filesize-range-10mb-to-100mb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 10mb and less than equal to 100mb for which hashes were asked for.

=end html

=back



=over 2

=item * I<filesize-range-1mb-to-10mb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 1mb and less than equal to 10mb for which hashes were asked for.

=end html

=back



=over 2

=item * I<filesize-range-250kb-to-1mb>  =>   B<integer, optional>

=begin html

<br>Number of files of size more than 250kb and less than equal to 1mb for which hashes were asked for.

=end html

=back



=over 2

=item * I<hashes-flashed-post-fifth-timeout>  =>   B<integer, optional>

=begin html

<br>Number of hashes flushed after fifth timeout.

=end html

=back



=over 2

=item * I<hashes-flashed-post-first-timeout>  =>   B<integer, optional>

=begin html

<br>Number of hashes flushed in between first and second timeout.

=end html

=back



=over 2

=item * I<hashes-flashed-post-fourth-timeout>  =>   B<integer, optional>

=begin html

<br>Number of hashes flushed in between fourth and fifth timeout.

=end html

=back



=over 2

=item * I<hashes-flashed-post-second-timeout>  =>   B<integer, optional>

=begin html

<br>Number of hashes flushed in between second and third timeout.

=end html

=back



=over 2

=item * I<hashes-flashed-post-third-timeout>  =>   B<integer, optional>

=begin html

<br>Number of hashes flushed in between third and fourth timeout.

=end html

=back



=head2 cifs_branchcache_set_key

[B<Family:> ontap-classic, vfiler]


=begin html

Sets the server secret for BranchCache.

=end html



B<Inputs>

=over 2

=item * I<server-secret>  =>   B<string>

=begin html

<br>A binary string that provides cryptographic data used by the BranchCache content server to generate hashes. Content servers that are serving the same data and are expected to provide the same hash values must use the same key. After changing this value, any existing cached content will be identified as stale and retrieved from the content server again.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_homedir_path_get_for_user

[B<Family:> ontap-classic, vfiler]


=begin html

Return path to the user's CIFS home directory if it exists.

=end html



B<Inputs>

=over 2

=item * I<user-name>  =>   B<string>

=begin html

<br>Name of the user. If the filer is using the "mapped" CIFS home directory naming style, then a mapped Unix name is provided. For the domain naming style, a domain/user is provided. Otherwise the filer will expect the NT name for the user. The filer's CIFS home directory naming style can be obtained with the "options-get" api, using input parameter "name cifs.home_dir_namestyle".

=end html

=back



B<Outputs>

=over 2

=item * I<homedir-path-user>  =>   B<string, optional>

=begin html

<br>A Unix-style path to the user's CIFS homedir directory, if it exists, for example: /vol/volName/users/joe.

=end html

=back



=head2 cifs_homedir_paths_get

[B<Family:> ontap-classic, vfiler]


=begin html

Return the current list of paths to users' cifs home directories, if any.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<homedir-paths>  =>   B<homedir-path-info[], optional>

=begin html

<br>An array, one entry per each cifs home directory path.

=end html

=back



=head2 cifs_homedir_paths_set

[B<Family:> ontap-classic, vfiler]


=begin html

Provides a list of CIFS home directory paths for the filer. Replaces the current list of paths in use by the filer. Note that supplying an empty path list causes the filer to delete any current entries.

=end html



B<Inputs>

=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>If true, the new set of homedir paths will be put into use even if some user homedir connections will be broken. This can cause users with open files in their home directories to lose access to the files. A user can lose data if there are updates not yet committed to disk.

=end html

=back



=over 2

=item * I<homedir-paths>  =>   B<homedir-path-info[], optional>

=begin html

<br>An array, one entry per each cifs home directory path. note: homedir-path-info defined above

=end html

=back



B<Outputs>

=over 2

=item * I<path-error>  =>   B<L<"path-error-info">[], optional>

=begin html

<br>An array, one entry for each homedir path error detected. Note that normally the API will complete sucessfully and activate as many paths as possible even if some paths cannot be activated.

=end html

=back



=head2 cifs_list_config

[B<Family:> ontap-classic, vfiler]


=begin html

This ZAPI is used to display the CIFS configuration.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<AD-site>  =>   B<string, optional>

=begin html

<br>Active Directory site that the filer is in.

=end html

=back



=over 2

=item * I<DC-connection>  =>   B<L<"connection-info">[], optional>

=begin html

<br>Information on the Domain Controller's connection.

=end html

=back



=over 2

=item * I<DNS-domainname>  =>   B<string, optional>

=begin html

<br>FQDN of DNS domain.

=end html

=back



=over 2

=item * I<LDAP-connection>  =>   B<L<"connection-info">[], optional>

=begin html

<br>Information on the LDAP connection.

=end html

=back



=over 2

=item * I<NetBIOS-domainname>  =>   B<string, optional>

=begin html

<br>NetBIOS domain name.

=end html

=back



=over 2

=item * I<NetBIOS-servername>  =>   B<string>

=begin html

<br>NetBIOS name of the server

=end html

=back



=over 2

=item * I<Windows-type>  =>   B<string, optional>

=begin html

<br>Windows type: "NT4"

=end html

=back



=over 2

=item * I<auth-type>  =>   B<string>

=begin html

<br>String specifying the type of authentication, such as: "ad" Active Directory "nt4" Windows NT4 "workgroup" Workgroup "passwd" Password file, NIS or LDAP

=end html

=back



=over 2

=item * I<domain-controller-functionality>  =>   B<cifs-functional-level, optional>

=begin html

<br>Domain controller functionality indicates the functional level of the DC.

=end html

=back



=over 2

=item * I<domain-functionality>  =>   B<cifs-functional-level, optional>

=begin html

<br>Domain functionality enables features that will affect the entire domain and that domain only. It indicates the functional level of the domain.

=end html

=back



=over 2

=item * I<forest-functionality>  =>   B<cifs-functional-level, optional>

=begin html

<br>Forest functionality enables features across all the domains within your forest. It indicates the functional level of the forest.

=end html

=back



=over 2

=item * I<security-style>  =>   B<string>

=begin html

<br>String specifying the security style, such as: "ntfs" NTFS "multiprotocol" Multiple Protocol

=end html

=back



=head2 cifs_nbalias_names_get

[B<Family:> ontap-classic, vfiler]


=begin html

Return the current list of NetBIOS alias names for the filer

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<nbalias-names>  =>   B<nbalias-name-info[], optional>

=begin html

<br>An array, one entry for each NetBIOS alias name

=end html

=back



=head2 cifs_nbalias_names_set

[B<Family:> ontap-classic, vfiler]


=begin html

Provides a list of NetBIOS alias names for the filer. The filer replaces the current list of aliases with with this list. Note that supplying an empty name list causes the filer to delete all current entries.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<nbalias-names>  =>   B<nbalias-name-info[], optional>

=begin html

<br>An array, one entry for each NetBIOS alias name note: nbalias-name_info defined above

=end html

=back



=head2 cifs_session_list_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminate a list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-session-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_session_list_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-session-list-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-session-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-sessions>  =>   B<L<"cifs-session-info">[]>

=begin html

<br>An array, one entry per each cifs session.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-session-list-iter-next. When this value is 0, you have retrieved everything. Range: [0..2^32-1].

=end html

=back



=head2 cifs_session_list_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Gives information on current CIFS activity. Without arguments, it returns a summary of information about the filer and lists the users who are connected to the filer.

=end html



B<Inputs>

=over 2

=item * I<host>  =>   B<string, optional>

=begin html

<br>IP address/machine name of the user's client machine.

=end html

=back



=over 2

=item * I<protocol>  =>   B<string, optional>

=begin html

<br>Filters the information on the basis of protocol version specified. When 'smb' is specified as the argument, this API retrieves information about only SMB 1.0 sessions. When 'smb2' is specified as the argument, this API retrieves information about only SMB 2.0 sessions. If this option is not specified, then information about both SMB 1.0 and SMB 2.0 sessions is retrieved.

=end html

=back



=over 2

=item * I<user>  =>   B<string, optional>

=begin html

<br>User name. If user is specified , this api returns information about the specified user, along with the names and access level of files that the user has opened. This api returns information about all the users, if the user is specified as '*' or is not specified.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-session-list-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-session-list-iter-next.

=end html

=back



=head2 cifs_setup

[B<Family:> ontap-classic, vfiler]


=begin html

Configures the filer's CIFS service. The CIFS service will start automatically once this call completes successfully.

=end html



B<Inputs>

=over 2

=item * I<auth-type>  =>   B<string>

=begin html

<br>The authentication style that determines the method by which clients will be authenticated when connecting to this CIFS server. These styles are subject to change in a future release. Possible values: ad, nt4, workgroup, passwd Note: The domain-name, login-user and login-password fields are optional unless the auth-type is ad.

=end html

=back



=over 2

=item * I<domain-name>  =>   B<string, optional>

=begin html

<br>The name of the domain that the CIFS server will join. This can be the NetBIOS or fully qualified domain name. Examples: cifsdomain, cifs.domain.com

=end html

=back



=over 2

=item * I<login-password>  =>   B<string, optional, encrypted>

=begin html

<br>The password for login-user.

=end html

=back



=over 2

=item * I<login-user>  =>   B<string, optional>

=begin html

<br>The name of a domain user that has the ability to add the CIFS server to the domain given in domain-name. Examples: username (assumes domain-name is the user's domain), cifsdomain\username, cifs.domain.com\username

=end html

=back



=over 2

=item * I<ou-name>  =>   B<string, optional>

=begin html

<br>The distinguished name of the organizational unit that the CIFS service will become a member of. This value must be one of the cifs-setup-ous retrieved from a call to the cifs-setup-container-list-iter APIs. By default, the filer will join the 'CN=Computers' organizational unit. Note: This information is only used when the auth-type is 'ad'.

=end html

=back



=over 2

=item * I<pdc-ip-address>  =>   B<ip-address, optional>

=begin html

<br>If this value is defined, CIFS will attempt to communicate with the domain controller directly using this address. Note: This information is only used when the auth-type is 'nt4'.

=end html

=back



=over 2

=item * I<security-style>  =>   B<string>

=begin html

<br>The security style determines whether or not the CIFS service will support multiprotocol access. These styles are subject to change in a future release. Possible values: ntfs, multiprotocol

=end html

=back



=over 2

=item * I<server-name>  =>   B<string>

=begin html

<br>The resulting CIFS server name.

=end html

=back



=over 2

=item * I<site-name>  =>   B<string, optional>

=begin html

<br>The name of the site that the CIFS service will become a member of. This value must be one of the cifs-setup-sites retrieved from a call to the cifs-setup-container-list-iter APIs. If a default-site was returned, it is the recommended choice. Sites will be ignored if this value is left blank. Note: This information is only used when the auth-type is 'ad'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_setup_create_group_file

[B<Family:> ontap-classic, vfiler]


=begin html

Creates a basic /etc/group file. Note: This will overwrite an existing /etc/group file. See cifs-setup-verify-passwd-and-group for more information.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_setup_create_passwd_file

[B<Family:> ontap-classic, vfiler]


=begin html

Creates a basic /etc/passwd file including a root user with the specified password. Note: This will overwrite an existing /etc/passwd file. See cifs-setup-verify-passwd-and-group for more information.

=end html



B<Inputs>

=over 2

=item * I<default-root-password>  =>   B<string, encrypted>

=begin html

<br>The password given to a locally defined root user which may be used in the event that other authentication services are unavailable. This will be defined in the filer's local /etc/passwd file.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_setup_ou_list_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminate a list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-setup-ou-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_setup_ou_list_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-setup-ou-list-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-setup-ou-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-setup-ous>  =>   B<cifs-setup-ou[]>

=begin html

<br>An array, one entry per each joinable organizational unit.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-setup-ou-list-iter-next. When this value is 0, you have retrieved everything.

=end html

=back



=head2 cifs_setup_ou_list_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Gathers a list of joinable sites and organizational units from Active Directory for the login-user specified, which is retrieved by using cifs-setup-ou-list-iter-next. For more information regarding Active Directory organizational units and their use, please reference Microsoft's Active Directory documentation.

=end html



B<Inputs>

=over 2

=item * I<domain-name>  =>   B<string>

=begin html

<br>The name of the domain that the CIFS server will join. Examples: cifsdomain, cifs.domain.com

=end html

=back



=over 2

=item * I<login-password>  =>   B<string, encrypted>

=begin html

<br>The password for login-user.

=end html

=back



=over 2

=item * I<login-user>  =>   B<string>

=begin html

<br>The name of a domain user that has the ability to add the CIFS server to the domain given in domain-name. Examples: username (assumes domain-name is the user's domain), cifsdomain\username, cifs.domain.com\username

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-setup-ou-list-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-setup-ou-list-iter-next.

=end html

=back



=head2 cifs_setup_site_list_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminate a list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-setup-site-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_setup_site_list_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-setup-site-list-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-setup-site-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-setup-sites>  =>   B<cifs-setup-site[]>

=begin html

<br>An array, one entry per each joinable organizational unit.

=end html

=back



=over 2

=item * I<default-site>  =>   B<string, optional>

=begin html

<br>If this subnet is part of a pre-defined site in Active Directory, this is the site name that would be used by default unless one of the other sites in cifs-setup-sites are specified instead.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-setup-site-list-iter-next. When this value is 0, you have retrieved everything.

=end html

=back



=head2 cifs_setup_site_list_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Gathers a list of joinable sites and organizational units from Active Directory for the login-user specified, which is retrieved by using cifs-setup-site-list-iter-next. For more information regarding Active Directory sites and their use, please reference Microsoft's Active Directory documentation.

=end html



B<Inputs>

=over 2

=item * I<domain-name>  =>   B<string>

=begin html

<br>The name of the domain that the CIFS server will join. Examples: cifsdomain, cifs.domain.com

=end html

=back



=over 2

=item * I<login-password>  =>   B<string, encrypted>

=begin html

<br>The password for login-user.

=end html

=back



=over 2

=item * I<login-user>  =>   B<string>

=begin html

<br>The name of a domain user that has the ability to add the CIFS server to the domain given in domain-name. Examples: username (assumes domain-name is the user's domain), cifsdomain\username, cifs.domain.com\username

=end html

=back



B<Outputs>

=over 2

=item * I<default-site>  =>   B<string, optional>

=begin html

<br>If this subnet is part of a pre-defined site in Active Directory, this is the site name that would be used by default unless one of the other sites in cifs-setup-sites are specified instead.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-setup-site-list-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-setup-site-list-iter-next.

=end html

=back



=head2 cifs_setup_verify_name

[B<Family:> ontap-classic, vfiler]


=begin html

Determines whether or not a particular CIFS server name is already in use on the network and a specified domain.

=end html



B<Inputs>

=over 2

=item * I<auth-type>  =>   B<string>

=begin html

<br>The authentication style that will be used in a subsequent call to cifs-setup. These styles are subject to change in a future release. Possible values: ad, nt4, workgroup, passwd Note: The domain-name, login-user and login-password fields are optional unless the auth-type is ad.

=end html

=back



=over 2

=item * I<domain-name>  =>   B<string>

=begin html

<br>The name of the domain that the CIFS server will join. Examples: cifsdomain, cifs.domain.com

=end html

=back



=over 2

=item * I<login-password>  =>   B<string, optional, encrypted>

=begin html

<br>The password for login-user.

=end html

=back



=over 2

=item * I<login-user>  =>   B<string, optional>

=begin html

<br>The name of a domain user that has the ability to add the CIFS server to the domain given in domain-name. Examples: username (assumes domain-name is the user's domain), cifsdomain\username, cifs.domain.com\username

=end html

=back



=over 2

=item * I<pdc-ip-address>  =>   B<ip-address, optional>

=begin html

<br>If this value is defined, CIFS will attempt to communicate with the domain controller directly using this address. Note: This information is only used when the auth-type is 'nt4'.

=end html

=back



=over 2

=item * I<server-name>  =>   B<string>

=begin html

<br>The NetBIOS CIFS server name that will be verified. Example: cifsserver

=end html

=back



B<Outputs>

=over 2

=item * I<is-in-domain>  =>   B<boolean>

=begin html

<br>Returns 'true' if the name exists in the domain, otherwise returns 'false'. For 'ad'-style domains, if an entry exists a warning should be provided. For 'nt4'-style domains, an entry must exist or cifs-setup will fail.

=end html

=back



=over 2

=item * I<is-in-use>  =>   B<boolean>

=begin html

<br>Returns 'true' if the name is in use on the network, otherwise returns 'false'.

=end html

=back



=head2 cifs_setup_verify_passwd_and_group

[B<Family:> ontap-classic, vfiler]


=begin html

Determines whether or not the /etc/passwd and /etc/group files exist, which would be used in the event that the configured CIFS authentication method fails.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<group-file-exists>  =>   B<boolean>

=begin html

<br>Returns 'true' if the /etc/group file exists, otherwise returns 'false'.

=end html

=back



=over 2

=item * I<passwd-file-exists>  =>   B<boolean>

=begin html

<br>Returns 'true' if the /etc/passwd file exists, otherwise returns 'false'.

=end html

=back



=over 2

=item * I<required>  =>   B<boolean>

=begin html

<br>Returns 'true' if the /etc/passwd and /etc/group files would be required before running the cifs-setup API. cifs-setup will require these files if neither LDAP nor NIS are enabled, as they will be used as a backup authentication method should the primary method (i.e. domain authentication) become unavailable.

=end html

=back



=head2 cifs_share_ace_delete

[B<Family:> ontap-classic, vfiler]


=begin html

Deletes the access control entry of the given share or the unix group. This API is equivalent to "cifs access <share> [-g] <user|group>" CLI.

=end html



B<Inputs>

=over 2

=item * I<is-unixgroup>  =>   B<boolean, optional>

=begin html

<br>This filter is used to tell that the access rights of the unix group have to be deleted. If its value is true, uinx-group-name needs to be provided. Otherwise it fails with the reason "group-name missing". The default value of this is false.

=end html

=back



=over 2

=item * I<share-name>  =>   B<string>

=begin html

<br>CIFS share name. It specifies name of the share of which the access rights have to be deleted. This is a case insensitive field. The maximum size of the share name is 256 characters.

=end html

=back



=over 2

=item * I<unix-group-name>  =>   B<string, optional>

=begin html

<br>Name of the unix group. This field specifies the unix group of which the access rights to be deleted. The format of this field <group-name>. This is a case sensitive field. If the specified group name does not exist, it fails with the reason "Unknown Unix group <group-name>"

=end html

=back



=over 2

=item * I<user-name>  =>   B<string, optional>

=begin html

<br>Name of the user. This API deletes the access rights of the specified user. This is a case sensitive field. The format of the field is <user-name>. If specified user does not exist, It fails with the reason "Unknown user <username>".

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_ace_set

[B<Family:> ontap-classic, vfiler]


=begin html

Sets the ace to the share for the given user or unix group. This API is equivalent to "cifs access <share> [-g] <user|group> <rights>" CLI.

=end html



B<Inputs>

=over 2

=item * I<access-rights>  =>   B<string>

=begin html

<br>Access rights to be set to the above share and user. The format of the rights can be Unix-style combinations of r w x - or NT-style "No Access", "Read", "Change", and "Full Control"

=end html

=back



=over 2

=item * I<is-unixgroup>  =>   B<boolean, optional>

=begin html

<br>This filter is used to tell that the access rights are to be set to the unix group. If its value is true, unix-group-name needs to be provided. Otherwise API fails with the reason "group-name missing". The default value of this is false.

=end html

=back



=over 2

=item * I<share-name>  =>   B<string>

=begin html

<br>CIFS share name. It specifies name of the share to which the access rights have to be set. This is a case insensitive field. The maximum size of the share name is 256 characters.

=end html

=back



=over 2

=item * I<unix-group-name>  =>   B<string, optional>

=begin html

<br>Name of the unix group. This field specifies the unix group to which the access rights are to be set. The format of this field <unix-group-name>. This is a case sensitive field. If the specified group name does not exist, it fails with the reason "Unknown Unix group : <groupname>".

=end html

=back



=over 2

=item * I<user-name>  =>   B<string, optional>

=begin html

<br>Name of the user. This API sets the access rights to the specified user. This is a case sensitive field. The format of the field <user-name>. If specified user does not exist, It fails with the reason "Unknown user: <username>".

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_acl_list_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminates a list iteration and cleans up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from the previous cifs-share-acl-list-iter-start

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_acl_list_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-share-acl-list-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range:[0..2^32-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from the previous cifs-share-acl-list-iter-start

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-share-acls>  =>   B<L<"cifs-share-acl-info">[]>

=begin html

<br>An array, one entry per each cifs share.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-share-acl-list-iter-next. When this value is 0, you have retrieved everything. Range:[0..2^32-1]

=end html

=back



=head2 cifs_share_acl_list_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Gives information about one or more shares acl.

=end html



B<Inputs>

=over 2

=item * I<share-name>  =>   B<string, optional>

=begin html

<br>Cifs share name. If share-name is specified, only information about that share is returned. If share-name is not specified, then information about all the shares is returned. If the name contains the wildcard characters * or ?, then all the shares matching the specified pattern are listed.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-share-acl-list-iter-next. Range:[0..2^32-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-share-acl-list-iter-next

=end html

=back



=head2 cifs_share_add

[B<Family:> ontap-classic, vfiler]


=begin html

Creates a new CIFS share rooted at the specified path.

=end html



B<Inputs>

=over 2

=item * I<caching>  =>   B<string, optional>

=begin html

<br>If specified, the following is done based on the value of the string: "no_caching": disallow Windows clients from caching any files on this share. This is the default value. "auto_document_caching": allow Windows clients to cache user documents on this share. "auto_program_caching": allow Windows clients to cache programs on this share. The actual caching behavior depends on the Windows client. "branchcache": clients connecting to this share can make requests using BranchCache technology that allows them to cache the content in an attempt to reduce WAN utilization from a remote office.

=end html

=back



=over 2

=item * I<comment>  =>   B<string, optional>

=begin html

<br>If specified, gives description of the new share. CIFS clients see this description when browsing the filer's shares. If not specified, the description is blank.

=end html

=back



=over 2

=item * I<dir-umask>  =>   B<integer, optional>

=begin html

<br>If specified, sets file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created directory. For directories, this mask overrides one set with "umask".

=end html

=back



=over 2

=item * I<file-umask>  =>   B<integer, optional>

=begin html

<br>If specified, sets file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created file. For files, this mask overrides one set with "umask".

=end html

=back



=over 2

=item * I<forcegroup>  =>   B<string, optional>

=begin html

<br>If specified, provides name of the group to which files to be created in the share belong. The groupname is the name of a group in the UNIX group database. If it is an empty string or else not specified, then files to be created in the share do not belong to a particular UNIX group. That is, each file belongs to the same group as the owner of the file.

=end html

=back



=over 2

=item * I<is-access-based-enum>  =>   B<boolean, optional>

=begin html

<br>If true Access Based Enumeration (ABE) is enabled, else it is disabled. ABE filtered shared folders are visible to a user based on that individual user's access rights, preventing the display of folders or other shared resources that the user does not have rights to access.

=end html

=back



=over 2

=item * I<is-browse>  =>   B<boolean, optional>

=begin html

<br>If true or not specified, shares are visible to browsing clients and can be enumerated (e.g. "net view", SrvMgr, AD).

=end html

=back



=over 2

=item * I<is-namespace-caching-allowed>  =>   B<boolean, optional>

=begin html

<br>If true, namespace caching is enabled on the share. If namespace caching is enabled on a share, clients are allowed to cache the directory enumeration results for better performance.

=end html

=back



=over 2

=item * I<is-symlink-strict-security>  =>   B<boolean, optional>

=begin html

<br>If true or not specified, strict symlink security is enabled. If false, allows clients to follow symbolic links to destinations on this filer but outside of the current share. It is not checked if the client is authenticated to the symbolic link's destination.

=end html

=back



=over 2

=item * I<is-vscan>  =>   B<boolean, optional>

=begin html

<br>If true or not specified, virus scan is done when clients open files on this share, else no virus scan is done.

=end html

=back



=over 2

=item * I<is-vscanread>  =>   B<boolean, optional>

=begin html

<br>If true or not specified, virus scan is done when clients open files on this share for read access, else no virus scan is done for read access on this share.

=end html

=back



=over 2

=item * I<is-widelink>  =>   B<boolean, optional>

=begin html

<br>If true, allows clients to follow absolute symbolic links outside of this share, subject to NT security. This feature requires an entry in the /etc/symlink.translations file and it requires that the client supports Microsoft's Distributed File System (DFS). If false or not specified, widelinks in the share are disabled.

=end html

=back



=over 2

=item * I<maxusers>  =>   B<integer, optional>

=begin html

<br>If specified, gives the maximum number of simultaneous connections to the new share. It must be a positive number. If not specified, the filer does not impose a limit on the number of connections to the share.

=end html

=back



=over 2

=item * I<path>  =>   B<string>

=begin html

<br>Full path name of the directory on the filer corresponding to the root of the new share.

=end html

=back



=over 2

=item * I<share-name>  =>   B<string>

=begin html

<br>Name of the share to be added. The name cannot exceed 12 characters for DOS-style shares and 256 characters for others.

=end html

=back



=over 2

=item * I<umask>  =>   B<integer, optional>

=begin html

<br>If specified, sets file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created file or directory. If not specified, the file mode creation mask of the share is 0. This field is ignored when both dir-umask and file-umask are present.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_change

[B<Family:> ontap-classic, vfiler]


=begin html

Changes settings of one or more CIFS shares at any time, even if the shares are in use.

=end html



B<Inputs>

=over 2

=item * I<caching>  =>   B<string, optional>

=begin html

<br>If specified, the following is done based on the value of the string: "no_caching": disallow Windows clients from caching any files on this share. This is the default value. "auto_document_caching": allow Windows clients to cache user documents on this share. "auto_program_caching": allow Windows clients to cache programs on this share. The actual caching behavior depends on the Windows client. "manual_caching": allow users on Windows clients to manually select files to be cached. "branchcache": clients connecting to this share can make requests using BranchCache technology that allows them to cache the content in an attempt to reduce WAN utilization from a remote office.

=end html

=back



=over 2

=item * I<comment>  =>   B<string, optional>

=begin html

<br>If specified, changes description of the share. CIFS clients see this description when browsing the filer's shares. Specifying an empty string clears the previous description.

=end html

=back



=over 2

=item * I<dir-umask>  =>   B<integer, optional>

=begin html

<br>If specified, changes file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created directory. For directories, this mask overrides one set with "umask". Specifying an empty string resets (removes) this dir-umask.

=end html

=back



=over 2

=item * I<file-umask>  =>   B<integer, optional>

=begin html

<br>If specified, changes file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created file. For files, this mask overrides one set with "umask". Specifying an empty string resets (removes) this file-umask.

=end html

=back



=over 2

=item * I<forcegroup>  =>   B<string, optional>

=begin html

<br>If specified, changes name of the group to which files to be created in the share belong. The groupname is the name of a group in the UNIX group database. If the string is empty, files to be created in the share do not belong to a particular UNIX group. That is, each file belongs to the same group as the owner of the file.

=end html

=back



=over 2

=item * I<is-access-based-enum>  =>   B<boolean, optional>

=begin html

<br>If true Access Based Enumeration (ABE) is enabled, if false it is disabled. ABE filtered shared folders are visible to a user based on that individual user's access rights, preventing the display of folders or other shared resources that the user does not have rights to access.

=end html

=back



=over 2

=item * I<is-browse>  =>   B<boolean, optional>

=begin html

<br>If true or undefined, share is visible to browsers and can be enumerated.

=end html

=back



=over 2

=item * I<is-namespace-caching-allowed>  =>   B<boolean, optional>

=begin html

<br>If true, namespace caching is enabled on the share. If false, namespace caching is disabled on the share. If namespace caching is enabled on a share, clients are allowed to cache the directory enumeration results for better performance.

=end html

=back



=over 2

=item * I<is-symlink-strict-security>  =>   B<boolean, optional>

=begin html

<br>If true, strict symlink security is enabled. If false, allows clients to follow symbolic links to destinations on this filer but outside of the current share. It is not checked if the client is authenticated to the symbolic link's destination.

=end html

=back



=over 2

=item * I<is-vscan>  =>   B<boolean, optional>

=begin html

<br>If true, virus scan is done when clients open files on this share, else virus scan is not done.

=end html

=back



=over 2

=item * I<is-vscanread>  =>   B<boolean, optional>

=begin html

<br>If true, virus scan is done when clients open files on this share for read access, else virus scan is not done for read access.

=end html

=back



=over 2

=item * I<is-widelink>  =>   B<boolean, optional>

=begin html

<br>If true, allows clients to follow absolute symbolic links outside of this share, subject to NT security. This feature requires an entry in the /etc/symlink.translations file and it requires that the client supports Microsoft's Distributed File System (DFS). If false, widelinks in the share are disabled.

=end html

=back



=over 2

=item * I<maxusers>  =>   B<integer, optional>

=begin html

<br>If specified, changes the maximum number of simultaneous connections to the new share. It must be a positive number or else zero, in which case no limit is imposed on the number of connections to the share.

=end html

=back



=over 2

=item * I<share-name>  =>   B<string>

=begin html

<br>If fully specified, it's the name of the existing share to be changed. If the name contains the wildcard characters * or ?, then all the shares matching the specified name are to be changed.

=end html

=back



=over 2

=item * I<umask>  =>   B<integer, optional>

=begin html

<br>If specified, changes file mode creation mask for a share in qtrees with Unix or mixed security styles. The mask restricts the initial permissions setting of a newly created file or directory. Specifying a zero value resets (removes) the file mode creation mask. This field is ignored when both dir-umask and file-umask are present.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_delete

[B<Family:> ontap-classic, vfiler]


=begin html

Deletes the specified CIFS share.

=end html



B<Inputs>

=over 2

=item * I<share-name>  =>   B<string>

=begin html

<br>The name of the CIFS share. The CIFS share name is a UTF-8 string with the following characters being illegal: control characters from 0x00 to 0x1F, both inclusive, 0x22 (double quotes) and the characters \/[]:|<>+=;,?"*

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_list_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminate a list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-share-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_share_list_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-share-list-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-share-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-shares>  =>   B<L<"cifs-share-info">[]>

=begin html

<br>An array, one entry per each cifs share.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-share-list-iter-next. When this value is 0, you have retrieved everything. Range:[0..2^32-1]

=end html

=back



=head2 cifs_share_list_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Gives information about one or more shares, the results of which are retrieved by using cifs-share-list-iter-next.

=end html



B<Inputs>

=over 2

=item * I<share-name>  =>   B<string, optional>

=begin html

<br>Cifs share name. If share-name is specified, only information about that share is returned. If share-name is not specified, then information about all the shares is returned. If the name contains the wildcard characters * or ?, then all the shares matching the specified name are listed.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-share-list-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-share-list-iter-next.

=end html

=back



=head2 cifs_start

[B<Family:> ontap-classic, vfiler]


=begin html

Starts the CIFS service, usually after a previous call to cifs-stop as the CIFS service starts automatically when cifs-setup completes successfully or the system reboots.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_status

[B<Family:> ontap-classic, vfiler]


=begin html

Returns the running state of the CIFS service.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<status>  =>   B<string>

=begin html

<br>The current status of the CIFS service, which will be one of the following: STOPPED, STARTED, STOPPING, STARTING

=end html

=back



=head2 cifs_stop

[B<Family:> ontap-classic, vfiler]


=begin html

Stops the CIFS service for all users or a particular workstation, if specified. Appropriate warning should be given to connected clients before calling this API, as it will immediately terminate those sessions regardless of their current state. See the cifs-sessions API for the list of clients that are currently connected.

=end html



B<Inputs>

=over 2

=item * I<workstation>  =>   B<string, optional>

=begin html

<br>The name or IP address of a workstation that will be disconnected from the CIFS service. Note that the CIFS service does not stop if this value is specified, it simply disconnects related sessions.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_top_iter_end

[B<Family:> ontap-classic, vfiler]


=begin html

Terminate a list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-top-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_top_iter_next

[B<Family:> ontap-classic, vfiler]


=begin html

Returns items from a previous call to cifs-top-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous cifs-top-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-top>  =>   B<L<"cifs-top-info">[]>

=begin html

<br>An array, one entry per cifs top.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>This tells you how many records are being returned from this particular call to cifs-top-iter-next. When this value is 0, you have retrieved everything.

=end html

=back



=head2 cifs_top_iter_start

[B<Family:> ontap-classic, vfiler]


=begin html

Display CIFS client statistics

=end html



B<Inputs>

=over 2

=item * I<avgtype>  =>   B<string, optional>

=begin html

<br>Specifies how the client statistics are to be averaged for display: "smooth": Use a smoothed average which is weighted towards recent behavior but takes into account previous history of the client. "now": Use a one-second sample taken immediately and no history is taken into account. "total": Use the total count of each statistic divided by the total time since sampling started. If the is-verbose option is also set, the totals are given without dividing by the sample time.

=end html

=back



=over 2

=item * I<maxclients>  =>   B<integer, optional>

=begin html

<br>Specifies the maximum number of top clients to display (the default is 20).

=end html

=back



=over 2

=item * I<sortgroup>  =>   B<string, optional>

=begin html

<br>If specified, the client statistics are sorted by the value of the string: "ops": Sort by the number of operations per second of any type. "reads": Sort by kbytes/sec of data in response to read requests. "writes": Sort by kbytes/sec of data written to the filer. "ios": Sort by the combined total of reads plus writes for each client. "suspicious": Sort by the number of "suspicious" events per second by each client.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with cifs-session-list-iter-next. Range:[0..2^32-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to cifs-session-list-iter-next.

=end html

=back



=head2 clock_get_clock

[B<Family:> ontap-classic]


=begin html

gets current date and time from filer.

=end html



B<Inputs>

=over 2

=item * I<is-compliance-clock>  =>   B<boolean, optional>

=begin html

<br>If true, then local-time and utc-time are values for the compliance clock, otherwise they are values for the local clock. Default is false. Note: This field is deprecated in Data ONTAP 8.1 and later. If true, the operation will fail with error EOPNOTSUPPORTED. Clients should use the API snaplock-get-system-compliance-clock or snaplock-get-volume-compliance-clock as applicable to get the compliance clock time.

=end html

=back



B<Outputs>

=over 2

=item * I<local-time>  =>   B<integer>

=begin html

<br>Local date and time of the filer in seconds since Midnight, 1/1/1970. Depending on the time zone and clock settings, this might be negative by up to 12 hours.

=end html

=back



=over 2

=item * I<utc-time>  =>   B<integer>

=begin html

<br>Current date and time of the filer in seconds since Midnight, 1/1/1970.

=end html

=back



=head2 clock_get_timezone

[B<Family:> ontap-classic]


=begin html

Gets current timezone and timezone file version.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<timezone>  =>   B<string>

=begin html

<br>Current timezone name where the storage system is operating. A timezone can have one of the two formats: <ol> <li>"Using a location string specified in Arthur David Olsen's public domain time zone database. For example, "Americas/New_York" represents most of the Eastern Time Zone."; <li>"A traditional time zone abbreviation incorporating default rules for daylight savings time. For example, "EST5EDT" for the US Eastern Time Zone."; </ol>

=end html

=back



=over 2

=item * I<timezone-UTC>  =>   B<string>

=begin html

<br>Current timezone of the storage system in UTC +/-hhmm format. This indicates that the local time zone is hh hours and mm minutes ahead or behind UTC. For example, Central European Time(CET) is +0100 and U.S./Canadian Eastern Standard Time(EST) is -0500.

=end html

=back



=over 2

=item * I<timezone-version>  =>   B<string>

=begin html

<br>Version of the time zone database. "YYYY" is the year the data base was released and "v" is the version within that year. "YYYY" will be four decimal digits and "v" will be an ASCII letter starting with "a" and increasing with each version. For example, the second 2007 version is "2007b".

=end html

=back



=head2 clock_set_clock

[B<Family:> ontap-classic]


=begin html

Set current date and time to the specified date and time.

=end html



B<Inputs>

=over 2

=item * I<is-utc-clock>  =>   B<boolean>

=begin html

<br>If this is true, then clock is given in UTC (universal time) instead of local time.

=end html

=back



=over 2

=item * I<time>  =>   B<integer>

=begin html

<br>Actual value of the date and time which has to be set as the current date and time on filer. Value will be seconds since Midnight, 1/1/1970. Depending on the time zone and clock settings, this might be negative by up to 12 hours.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 clock_set_timezone

[B<Family:> ontap-classic]


=begin html

Set current timezone to the specified timezone.

=end html



B<Inputs>

=over 2

=item * I<timezone>  =>   B<string>

=begin html

<br>Name of the timezone value which has to be set as current timezone value. A timezone can have one of the two formats: <ol> <li>"Using a location string specified in Arthur David Olsen's public domain time zone database. For example, "Americas/New_York" represents most of the Eastern Time Zone."; <li>"A traditional time zone abbreviation incorporating default rules for daylight savings time. For example, "EST5EDT" for the US Eastern Time Zone."; </ol>

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 clone_clear

[B<Family:> ontap-classic, vfiler]


=begin html

Clears information of a failed clone operation. If not successful, the error code will be returned as API error. This API is deprecated in Data ONTAP 8.1 and later, and will always fail with EDENSE_CLONE_NOT_RUNNING.

=end html



B<Inputs>

=over 2

=item * I<clone-id>  =>   B<integer>

=begin html

<br>ID information of the clone operation.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 clone_list_status

[B<Family:> ontap-classic, vfiler]


=begin html

Gets the information of a clone operations identified by clone-id. If clone-id is not specified, then it will get the status of all running and failed clone operation on the filer. It will get the status as 'running', 'failed' or 'completed'. User may see some other transient status for the clone operation, but any other status should be considered for polling clone-list-status again. User should keep polling clone-list-status till status returned is 'failed' or 'completed'. If status is 'completed', the clone operation has been completed successfully. If status is 'failed', then user is responsible for doing clone-clear to clean the status of the clone information. When a clone operation is aborted using clone-stop, it may take some time to stop the clone operation. User should poll clone-list-status till status returned is 'completed'. When status returned is 'completed' after clone-stop, the clone operation has been stopped successfully. This API is deprecated in Data ONTAP 8.1 and later. If a clone-id from a previous successful call to clone-start is provided, the operation will always be in the "completed" state.

=end html



B<Inputs>

=over 2

=item * I<clone-id>  =>   B<L<"clone-id-info">, optional>

=begin html

<br>ID information of the clone operation. If not specified, it will get the status of all running and failed clone operations on the filer.

=end html

=back



B<Outputs>

=over 2

=item * I<status>  =>   B<L<"ops-info">[], optional>

=begin html

<br>List of information of running and failed clone operations on the filer.

=end html

=back



=head2 clone_start

[B<Family:> ontap-classic, vfiler]


=begin html

In Data ONTAP 8.0 and earlier this API starts a file/LUN or sub-file/sub-LUN clone operation asynchronously. If clone operation starts successfully, a unique clone-id is returned. User is supposed to poll clone-list-status specifying clone-id to get the status of the clone operation. When clone-list-status returns status as completed, user can consider that the clone operation has been completed successfully. If user gets status as failed, user is responsible for doing clone-clear which will clean the status of the clone operation. In Data ONTAP 8.1 and later, this API performs a file/LUN or sub-file/sub-LUN clone operation synchronously. When this API returns successfully, the destination file is ready for use.

=end html



B<Inputs>

=over 2

=item * I<block-ranges>  =>   B<L<"block-range">[], optional>

=begin html

<br>List of block ranges for sub-file/sub-LUN cloning. The number of block ranges is limited to 32. For sub-LUN cloning the block range specified will be considered as SCSI LBA range. If only one block range is supplied, the source and destination range must not overlap and both ranges must not extend past the end of the file If multiple block ranges are specified in one operation, the user must ensure all source and destination ranges do not overlap, otherwise the result is undefined. In case of sub-LUN cloning, the API will copy data in case the LBAs are not block aligned. If the user provides LBAs such that actual number of blocks to be cloned is zero, then API will return error. The API will fail if the source range overlaps with the destination range or if the source and the destination ranges overlap amongst themselves. If block range is not provided then the file/LUN cloning is fully cloned.

=end html

=back



=over 2

=item * I<change-log>  =>   B<boolean, optional>

=begin html

<br>If this option is "true", fingerprints of data blocks of the destination file/block ranges created will be change logged to the change log file if A-SIS is enabled on the volume. With change logging clone operation will be slow, as to get fingerprints all the data blocks will be read. Without change logging clone operation deals with only indirect blocks without reading data blocks. Without change logging, fingerprints of the clone blocks are not recorded. The clone blocks are shared with the source blocks, but as later the source blocks are modified, corresponding clone blocks will no longer be shared. If change logging option is not used, clone blocks, which could be involved in sharing with rest of the file system, can not be shared in next sis operation. The only option, in case user had not used change logging while creating clone, will be to start sis from beginning using "sis start -s" to gather fingerprints of clone blocks. In Data ONTAP 8.1 and later, this field is accepted for backwards compatibility and is ignored.

=end html

=back



=over 2

=item * I<destination-path>  =>   B<string, optional>

=begin html

<br>Full path of the Destination file or LUN in /<volume-name>/file-path format. Destination path should be in same flexible volume as "source-path". If not specified, a sub-range clone of the source file or LUN will be performed onto itself. Either "destination-path" or "block-ranges" must be specified.

=end html

=back



=over 2

=item * I<ignore-locks>  =>   B<boolean, optional>

=begin html

<br>Clone even if (advisory/mandatory) byte_range locks or share_mode locks exist on the source or destination. By default value is false.

=end html

=back



=over 2

=item * I<ignore-streams>  =>   B<boolean, optional>

=begin html

<br>Clone only the base file and ignore streams on source or destination. By default value is false so streams are also cloned from source and existing destination streams are deleted.

=end html

=back



=over 2

=item * I<no-snap>  =>   B<boolean, optional>

=begin html

<br>If no-snap is FALSE or unspecified, then a temporary snapshot will be taken and source file locked in snapshot will be considered for cloning. So that the clone operation does not get affected by writes to the source file in parallel to the clone operation. User will get atomic point in time copy of the source. Irrespective of clone operation completes successfully or unsuccessfully, any temporary snapshot taken for cloning will be deleted automatically. If no-snap is "true", then the source file in AFS will be used for cloning. In this case user may get random data in clone if source file is modified while clone operation is in progress. This option should only be used when user is assured that the source file will remain consistent during the clone operation. Destination file is not protected against any modification while clone operation is in progress. User should use the destination file or destination block ranges after clone operation is finished. In Data ONTAP 8.1 and later, this field is accepted for backwards compatibility and is ignored.

=end html

=back



=over 2

=item * I<snapshot-name>  =>   B<string, optional>

=begin html

<br>Snapshot name from which to clone the source file or LUN. If not specified, the contents of in the active filesystem will be used. This field is available in Data ONTAP 8.1 or later

=end html

=back



=over 2

=item * I<source-path>  =>   B<string>

=begin html

<br>Full path of the source file or LUN in /<volume-name>/file-path format.

=end html

=back



=over 2

=item * I<space-reserve>  =>   B<boolean, optional>

=begin html

<br>Set the space reservation of the destination clone. By default space reservation is inherited from source. The API errors out if used in conjunction with block range arguments, since space reservations cannot be set for a block range.

=end html

=back



B<Outputs>

=over 2

=item * I<clone-id>  =>   B<L<"clone-id-info">>

=begin html

<br>Unique ID information for the clone operation returned if clone operation starts successfully. This field is deprecated in Data ONTAP 8.1 and later, the returned value is guaranteed to be a completed clone operation if supplied to clone-list-info.

=end html

=back



=head2 clone_stop

[B<Family:> ontap-classic, vfiler]


=begin html

Stops a running clone operation. If not successful, the error code will be returned as API error. This API is deprecated in Data ONTAP 8.1 and later, and will always fail with EDENSE_CLONE_NOT_RUNNING.

=end html



B<Inputs>

=over 2

=item * I<clone-id>  =>   B<L<"clone-id-info">>

=begin html

<br>ID information of the clone operation.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 copyoffload_copy_abort

[B<Family:> ontap-classic, vfiler]


=begin html

Abort an on-going copyoffload-copy-file request.

=end html



B<Inputs>

=over 2

=item * I<copy-id>  =>   B<string>

=begin html

<br>Unique identifier for an on-going copy operation.

=end html

=back



B<Outputs>

=over 2

=item * I<bytes-copied>  =>   B<integer>

=begin html

<br>Number of bytes that were copied prior to the abort.

=end html

=back



=head2 copyoffload_copy_start

[B<Family:> ontap-classic, vfiler]


=begin html

Copy specified whole/sub source file to specified destination file. This operation is handled asynchronously. Source and destination files must exist. The calling entity must poll for a status indication, via the copyoffload-copy-status, until either a failure or completed state is returned. still have copied some portion of the source to the destination: a copy operation involves multiple iterations of data copy before completing and may fail after some number of sub-copy operations. The caller should reissue the copy operation request to either reattempt the operation or to restore the destination to its previous content. Copy operations are not persistent over reboots or takeover scenarios.

=end html



B<Inputs>

=over 2

=item * I<destination-offset>  =>   B<integer, optional>

=begin html

<br>Byte offset in the destination file to begin copying data into, aligned to a 4,096 byte boundary. If not specified, copy will start at beginning of file.

=end html

=back



=over 2

=item * I<destination-path>  =>   B<string>

=begin html

<br>Full path of the destination file to where the data will be copied, in /vol/<volume-name>/<file-path> format.

=end html

=back



=over 2

=item * I<length>  =>   B<i