/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netapp.manage.ARCFour;
import org.xml.sax.Attributes;

public class NaElement {
    private String _name;
    private String _content;
    private Map _attrs = new HashMap();
    private List _children = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public NaElement(String string) {
        this(string, null);
    }

    public NaElement(String string, String string2) {
        this(string, string2, null);
    }

    NaElement(String string, String string2, Attributes attributes) {
        if (null != attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.setAttr(attributes.getQName(i), attributes.getValue(i));
            }
        }
        this.setName(string);
        this.setContent(string2);
    }

    private static String sgmlEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void appendEncoded(StringBuffer stringBuffer, boolean bl, int n, int n2) {
        Object object;
        if (bl) {
            stringBuffer.append('\n');
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
        }
        stringBuffer.append('<');
        if (!$assertionsDisabled && null == this._name) {
            throw new AssertionError();
        }
        stringBuffer.append(this._name);
        Iterator<Object> iterator = this._attrs.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append(' ');
            stringBuffer.append((String)object);
            stringBuffer.append("='");
            String string = this.getAttr((String)object);
            if (0 <= string.indexOf(39)) {
                string = string.replace('\'', '\"');
            }
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        if (!this.hasChildren() && null == this._content) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        if (null != this._content) {
            stringBuffer.append(NaElement.sgmlEscape(this._content));
        } else if (n < n2) {
            iterator = this._children.iterator();
            while (iterator.hasNext()) {
                object = (NaElement)iterator.next();
                if (!$assertionsDisabled && null == object) {
                    throw new AssertionError();
                }
                super.appendEncoded(stringBuffer, bl, n + 1, n2);
            }
            if (bl) {
                stringBuffer.append('\n');
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append('\t');
                }
            }
        } else {
            stringBuffer.append("...");
        }
        stringBuffer.append("</");
        stringBuffer.append(this._name);
        stringBuffer.append('>');
    }

    public String toPrettyString(String string, int n) {
        if (null == string) {
            throw new NullPointerException("prefix must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendEncoded(stringBuffer, true, 0, n);
        String string2 = stringBuffer.toString();
        String string3 = string2.replaceAll("\n", "\n" + string);
        return string3.substring(1) + "\n";
    }

    public String toPrettyString(String string) {
        return this.toPrettyString(string, Integer.MAX_VALUE);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendEncoded(stringBuffer, false, 0, Integer.MAX_VALUE);
        return stringBuffer.toString();
    }

    public void setName(String string) {
        if (null == string) {
            throw new NullPointerException("name must not be null");
        }
        this._name = string;
    }

    public String getName() {
        if (!$assertionsDisabled && null == this._name) {
            throw new AssertionError();
        }
        return this._name;
    }

    public String getChildContent(String string) {
        try {
            return this.getChildByName(string).getContent();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getChildContentOrNull(String string) {
        try {
            String string2 = this.getChildByName(string).getContent();
            return string2.length() == 0 ? null : string2;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getChildIntValue(String string, int n) {
        try {
            return Integer.parseInt(this.getChildContent(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getChildLongValue(String string, long l) {
        try {
            return Long.parseLong(this.getChildContent(string));
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public List getChildren() {
        return this._children;
    }

    public NaElement getChildByName(String string) {
        Iterator iterator = this._children.iterator();
        while (iterator.hasNext()) {
            NaElement naElement = (NaElement)iterator.next();
            if (!naElement._name.equals(string)) continue;
            return naElement;
        }
        return null;
    }

    public boolean hasChildren() {
        return 0 != this._children.size();
    }

    public void setContent(String string) {
        this._content = string;
    }

    public void setEncryptedContent(String string) {
        this._content = ARCFour.encryptAndEncode(string);
    }

    public String getContent() {
        return this._content == null ? "" : this._content;
    }

    public void addNewChild(String string, String string2) {
        this.addChildElem(new NaElement(string, string2));
    }

    public void addChildElem(NaElement naElement) {
        this._children.add(naElement);
    }

    private void setAttr(String string, String string2) {
        this._attrs.put(string, string2);
    }

    public String getAttr(String string) {
        return (String)this._attrs.get(string);
    }

    public Set getAttrNames() {
        return this._attrs.keySet();
    }

    public void addNewEncryptedChild(String string, String string2) {
        String string3 = ARCFour.encryptAndEncode(string2);
        this.addNewChild(string, string3);
    }

    public String getChildEncryptContent(String string) {
        String string2 = this.getChildContent(string);
        if (null == string2) {
            return null;
        }
        String string3 = ARCFour.decodeAndDecrypt(string2);
        return string3;
    }

    public String getEncryptContent() {
        String string = this.getContent();
        String string2 = ARCFour.decodeAndDecrypt(string);
        return string2;
    }

    public String toString(String string) {
        return this.toPrettyString(string, Integer.MAX_VALUE);
    }

    public String childGetString(String string) {
        return this.getChildContent(string);
    }

    public int childGetInt(String string, int n) {
        return this.getChildIntValue(string, n);
    }

    public Vector childrenGet() {
        return new Vector(this._children);
    }

    public NaElement childGet(String string) {
        return this.getChildByName(string);
    }

    public NaElement childAddString(String string, String string2) {
        NaElement naElement = new NaElement(string, string2);
        this.addChildElem(naElement);
        return naElement;
    }

    public void childAdd(NaElement naElement) {
        this.addChildElem(naElement);
    }

    public String resultsReason() {
        return null;
    }

    public int resultsErrno() {
        return 0;
    }

    public boolean resultsStatus() {
        return true;
    }

    static {
        $assertionsDisabled = !NaElement.class.desiredAssertionStatus();
    }
}

