/*
 * Decompiled with CFR 0.152.
 */
package zexplore.statusbar;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zexplore.IconMap;
import zexplore.Server;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -1059206854115611037L;
    private static final String gap = "  ";
    private static JLabel connectionStatusLabel = new JLabel();
    private static JPanel executionStatusPanel = new JPanel();
    private static JLabel executionProgressLabel = new JLabel();
    private static JLabel executionTimeLabel = new JLabel();

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setDefaultStatus();
        this.add((Component)connectionStatusLabel, "West");
        this.add((Component)executionStatusPanel, "East");
        executionStatusPanel.add(executionProgressLabel);
        executionStatusPanel.add(executionTimeLabel);
    }

    public void setConnectionStatus(String string) {
        connectionStatusLabel.setText(gap + string);
        if (string.contains("Disconnected")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("disconnected"));
        } else if (string.contains("Connected") && string.contains("HTTPS")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("connected-secured"));
        } else if (string.contains("Connected") && !string.contains("HTTPS")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("connected"));
        }
    }

    public String getConnectionStatus() {
        return connectionStatusLabel.getText();
    }

    public void setExecutionProgress(String string) {
        executionProgressLabel.setText(string);
    }

    public void setExecutionProgress(String string, int n, int n2) {
        String string2 = "";
        if (string != null && !string.trim().isEmpty()) {
            string2 = "Executing '" + string.trim() + "'.";
        }
        int n3 = n * 100 / n2;
        string2 = string2 + " " + n + " out of " + n2 + " APIs [" + n3 + "%] executed";
        if (n != 0) {
            string2 = string2 + " in";
        }
        executionProgressLabel.setText(string2);
    }

    public String getExecutionProgress() {
        return executionProgressLabel.getText();
    }

    public void setExecutionTime(long l) {
        if (l == -1L) {
            executionTimeLabel.setText("");
        } else {
            executionTimeLabel.setText(l + " ms" + gap);
        }
    }

    public void addExecutionTime(long l) {
        long l2 = this.getExecutionTime();
        this.setExecutionTime(l2 + l);
    }

    public long getExecutionTime() {
        long l = 0L;
        String string = executionTimeLabel.getText().trim();
        if (string != null && !string.isEmpty()) {
            if (string.contains("ms")) {
                string = string.replaceFirst("ms", "").trim();
            }
            l = Long.parseLong(string);
        }
        return l;
    }

    public void setDefaultStatus() {
        this.setConnectionStatus("Disconnected");
        this.setExecutionProgress("");
        this.setExecutionTime(-1L);
    }

    public void setServerStatus(Server server) {
        if (server != null) {
            String string = server.getServerFieldInfo("login");
            String string2 = server.getServerFieldInfo("server");
            String string3 = server.getServerFieldInfo("port");
            String string4 = server.getServerFieldInfo("protocol");
            String string5 = server.getVersion();
            String string6 = "Connected  " + string + " @ " + string2 + " : " + string3 + " (" + string4 + ") " + " [" + string5 + "] ";
            this.setConnectionStatus(string6);
        } else {
            this.setDefaultStatus();
        }
    }
}

