/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import zexplore.IconMap;
import zexplore.menubar.preferences.OptionsDialog;

public class OptionsItem
extends JMenuItem {
    private static final long serialVersionUID = 4879314695223310930L;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static final String PREF_NODE_OPTIONS = "OPTIONS";
    private static final boolean defaultIncludeCommentsInCode = false;
    private static final boolean defaultIncludeOptionalElements = true;
    private static final boolean defaultEnableIteratorComprehension = true;
    private static final long defaultIteratorFetchSize = 10000L;
    private static final boolean defaultExecuteMultipleAPIs = false;
    private static final boolean defaultShowAPINameExecutionTime = true;
    private static boolean currentIncludeCommentsInCode = false;
    private static boolean currentIncludeOptionalElements = true;
    private static boolean currentEnableIteratorComprehension = true;
    private static long currentIteratorFetchSize = 10000L;
    private static boolean currentExecuteMultipleAPIs = false;
    private static boolean currentShowAPINameExecutionTime = true;

    public OptionsItem() {
        this.loadCurrentOptions();
        this.setText("Options                                  Ctrl+O");
        this.setMnemonic(79);
        this.setIcon(new IconMap().getIcon("options"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsItem.this.showOptions();
            }
        });
    }

    public void showOptions() {
        new OptionsDialog();
    }

    public void storeCurrentOptions() {
        String string = String.valueOf(currentIncludeCommentsInCode) + ":" + String.valueOf(currentIncludeOptionalElements) + ":" + String.valueOf(currentEnableIteratorComprehension) + ":" + String.valueOf(currentIteratorFetchSize) + ":" + String.valueOf(currentExecuteMultipleAPIs) + ":" + String.valueOf(currentShowAPINameExecutionTime);
        this.prefs.put(PREF_NODE_OPTIONS, string);
    }

    public void loadCurrentOptions() {
        String string = this.prefs.get(PREF_NODE_OPTIONS, null);
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(":");
        currentIncludeCommentsInCode = Boolean.parseBoolean(stringArray[0]);
        currentIncludeOptionalElements = Boolean.parseBoolean(stringArray[1]);
        currentEnableIteratorComprehension = Boolean.parseBoolean(stringArray[2]);
        currentIteratorFetchSize = Long.parseLong(stringArray[3]);
        currentExecuteMultipleAPIs = Boolean.parseBoolean(stringArray[4]);
        currentShowAPINameExecutionTime = Boolean.parseBoolean(stringArray[5]);
    }

    public boolean getDefaultIncludeCommentsInCode() {
        return false;
    }

    public boolean getDefaultIncludeOptionalElements() {
        return true;
    }

    public boolean getDefaultEnableIteratorComprehension() {
        return true;
    }

    public long getDefaultIteratorFetchSize() {
        return 10000L;
    }

    public boolean getDefaultExecuteMultipleAPIs() {
        return false;
    }

    public boolean getDefaultShowAPINameExecutionTime() {
        return true;
    }

    public boolean getCurrentIncludeCommentsInCode() {
        return currentIncludeCommentsInCode;
    }

    public void setCurrentIncludeCommentsInCode(boolean bl) {
        currentIncludeCommentsInCode = bl;
    }

    public boolean getCurrentIncludeOptionalElements() {
        return currentIncludeOptionalElements;
    }

    public void setCurrentIncludeOptionalElements(boolean bl) {
        currentIncludeOptionalElements = bl;
    }

    public boolean getCurrentEnableIteratorComprehension() {
        return currentEnableIteratorComprehension;
    }

    public void setCurrentEnableIteratorComprehension(boolean bl) {
        currentEnableIteratorComprehension = bl;
    }

    public long getCurrentIteratorFetchSize() {
        return currentIteratorFetchSize;
    }

    public void setCurrentIteratorFetchSize(long l) {
        currentIteratorFetchSize = l;
    }

    public boolean getCurrentExecuteMultipleAPIs() {
        return currentExecuteMultipleAPIs;
    }

    public void setCurrentExecuteMultipleAPIs(boolean bl) {
        currentExecuteMultipleAPIs = bl;
    }

    public boolean getCurrentShowAPINameExecutionTime() {
        return currentShowAPINameExecutionTime;
    }

    public void setCurrentShowAPINameExecutionTime(boolean bl) {
        currentShowAPINameExecutionTime = bl;
    }
}

