/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import zexplore.KeyOperationsListener;
import zexplore.View;
import zexplore.menubar.preferences.PreferencesMenu;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1987121236947802028L;
    private static JPanel mainPanel;
    private static JCheckBox includeCommentsInCodeCheckBox;
    private static JCheckBox includeOptionalElementsCheckBox;
    private static JCheckBox enableIteratorComprehensionCheckBox;
    private static JLabel iteratorFetchSizeLabel;
    private static JPanel iteratorFetchSizePanel;
    private static JTextField iteratorFetchSizeTextField;
    private static JCheckBox executeMultipleAPIsCheckBox;
    private static JCheckBox showAPINameExecutionTimeCheckBox;
    private static JPanel saveChangesButtonPanel;
    private static JButton saveChangesButton;
    private static JPanel restoreDefaultsButtonPanel;
    private static JButton restoreDefaultsButton;
    private static final Border errorBorder;
    private static Border defaultBorder;

    public OptionsDialog() {
        super(View.frame, "Options", false);
        mainPanel = new JPanel(new GridLayout(4, 2, 50, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        includeCommentsInCodeCheckBox.setSelected(PreferencesMenu.optionsItem.getCurrentIncludeCommentsInCode());
        mainPanel.add(includeCommentsInCodeCheckBox);
        includeCommentsInCodeCheckBox.addKeyListener(new KeyOperationsListener(this));
        includeOptionalElementsCheckBox.setSelected(PreferencesMenu.optionsItem.getCurrentIncludeOptionalElements());
        mainPanel.add(includeOptionalElementsCheckBox);
        includeOptionalElementsCheckBox.addKeyListener(new KeyOperationsListener(this));
        enableIteratorComprehensionCheckBox.setSelected(PreferencesMenu.optionsItem.getCurrentEnableIteratorComprehension());
        mainPanel.add(enableIteratorComprehensionCheckBox);
        enableIteratorComprehensionCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.setIteratorFetchSizeTextField();
            }
        });
        enableIteratorComprehensionCheckBox.addKeyListener(new KeyOperationsListener(this));
        iteratorFetchSizePanel.add((Component)iteratorFetchSizeLabel, "West");
        iteratorFetchSizePanel.add((Component)iteratorFetchSizeTextField, "East");
        iteratorFetchSizePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 0));
        mainPanel.add(iteratorFetchSizePanel);
        this.setIteratorFetchSizeTextField();
        defaultBorder = iteratorFetchSizeTextField.getBorder();
        this.addIteratorFetchSizeDocumentListener();
        iteratorFetchSizeLabel.addKeyListener(new KeyOperationsListener(this));
        iteratorFetchSizeTextField.addKeyListener(new KeyOperationsListener(this));
        executeMultipleAPIsCheckBox.setSelected(PreferencesMenu.optionsItem.getCurrentExecuteMultipleAPIs());
        mainPanel.add(executeMultipleAPIsCheckBox);
        executeMultipleAPIsCheckBox.addKeyListener(new KeyOperationsListener(this));
        showAPINameExecutionTimeCheckBox.setSelected(PreferencesMenu.optionsItem.getCurrentShowAPINameExecutionTime());
        mainPanel.add(showAPINameExecutionTimeCheckBox);
        showAPINameExecutionTimeCheckBox.addKeyListener(new KeyOperationsListener(this));
        saveChangesButtonPanel.add(saveChangesButton);
        mainPanel.add(saveChangesButtonPanel);
        saveChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.saveChanges()) {
                    OptionsDialog.this.dispose();
                }
            }
        });
        saveChangesButton.addKeyListener(new KeyOperationsListener(this));
        restoreDefaultsButtonPanel.add(restoreDefaultsButton);
        mainPanel.add(restoreDefaultsButtonPanel);
        restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.restoreDefaults();
            }
        });
        restoreDefaultsButton.addKeyListener(new KeyOperationsListener(this));
        this.getContentPane().add(mainPanel);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(View.frame);
        this.setVisible(true);
    }

    private boolean saveChanges() {
        PreferencesMenu.optionsItem.setCurrentIncludeCommentsInCode(includeCommentsInCodeCheckBox.isSelected());
        PreferencesMenu.optionsItem.setCurrentIncludeOptionalElements(includeOptionalElementsCheckBox.isSelected());
        PreferencesMenu.optionsItem.setCurrentEnableIteratorComprehension(enableIteratorComprehensionCheckBox.isSelected());
        if (enableIteratorComprehensionCheckBox.isSelected()) {
            String string = iteratorFetchSizeTextField.getText();
            long l = PreferencesMenu.optionsItem.getDefaultIteratorFetchSize();
            l = Long.parseLong(string);
            PreferencesMenu.optionsItem.setCurrentIteratorFetchSize(l);
        }
        PreferencesMenu.optionsItem.setCurrentExecuteMultipleAPIs(executeMultipleAPIsCheckBox.isSelected());
        PreferencesMenu.optionsItem.setCurrentShowAPINameExecutionTime(showAPINameExecutionTimeCheckBox.isSelected());
        return true;
    }

    private void restoreDefaults() {
        includeCommentsInCodeCheckBox.setSelected(PreferencesMenu.optionsItem.getDefaultIncludeCommentsInCode());
        includeOptionalElementsCheckBox.setSelected(PreferencesMenu.optionsItem.getDefaultIncludeOptionalElements());
        enableIteratorComprehensionCheckBox.setSelected(PreferencesMenu.optionsItem.getDefaultEnableIteratorComprehension());
        if (enableIteratorComprehensionCheckBox.isSelected()) {
            iteratorFetchSizeTextField.setText("" + PreferencesMenu.optionsItem.getDefaultIteratorFetchSize() + "");
            iteratorFetchSizeTextField.setEditable(true);
        } else {
            iteratorFetchSizeTextField.setText("");
            iteratorFetchSizeTextField.setToolTipText(null);
            iteratorFetchSizeTextField.setBorder(defaultBorder);
            iteratorFetchSizeTextField.setEditable(false);
        }
        executeMultipleAPIsCheckBox.setSelected(PreferencesMenu.optionsItem.getDefaultExecuteMultipleAPIs());
        showAPINameExecutionTimeCheckBox.setSelected(PreferencesMenu.optionsItem.getDefaultShowAPINameExecutionTime());
    }

    private void setIteratorFetchSizeTextField() {
        if (enableIteratorComprehensionCheckBox.isSelected()) {
            if (iteratorFetchSizeTextField.getText().trim().isEmpty()) {
                iteratorFetchSizeTextField.setText("" + PreferencesMenu.optionsItem.getCurrentIteratorFetchSize() + "");
            }
            iteratorFetchSizeTextField.setEditable(true);
        } else {
            iteratorFetchSizeTextField.setText("");
            iteratorFetchSizeTextField.setEditable(false);
        }
    }

    private void addIteratorFetchSizeDocumentListener() {
        iteratorFetchSizeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = iteratorFetchSizeTextField.getText().trim();
                if (OptionsDialog.this.checkIteratorFetchSize(string)) {
                    iteratorFetchSizeTextField.setToolTipText(null);
                    iteratorFetchSizeTextField.setBorder(defaultBorder);
                    saveChangesButton.setEnabled(true);
                } else {
                    iteratorFetchSizeTextField.setBorder(errorBorder);
                    saveChangesButton.setEnabled(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = iteratorFetchSizeTextField.getText().trim();
                if (OptionsDialog.this.checkIteratorFetchSize(string)) {
                    iteratorFetchSizeTextField.setToolTipText(null);
                    iteratorFetchSizeTextField.setBorder(defaultBorder);
                    saveChangesButton.setEnabled(true);
                } else {
                    iteratorFetchSizeTextField.setBorder(errorBorder);
                    saveChangesButton.setEnabled(false);
                }
            }
        });
    }

    private boolean checkIteratorFetchSize(String string) {
        if (!enableIteratorComprehensionCheckBox.isSelected()) {
            return true;
        }
        if (string == null || string.isEmpty()) {
            iteratorFetchSizeTextField.setToolTipText("Iterator Fetch Size cannot be empty.");
            return false;
        }
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            iteratorFetchSizeTextField.setToolTipText("Iterator Fetch Size Invalid " + numberFormatException.getMessage());
            return false;
        }
        if (l <= 0L) {
            iteratorFetchSizeTextField.setToolTipText("Iterator Fetch Size must be positive");
            return false;
        }
        return true;
    }

    static {
        includeCommentsInCodeCheckBox = new JCheckBox("Include comments in generated code");
        includeOptionalElementsCheckBox = new JCheckBox("Include optional elements in code generation");
        enableIteratorComprehensionCheckBox = new JCheckBox("Enable iterator comprehension");
        iteratorFetchSizeLabel = new JLabel("Iterator Fetch Size");
        iteratorFetchSizePanel = new JPanel(new BorderLayout());
        iteratorFetchSizeTextField = new JTextField(8);
        executeMultipleAPIsCheckBox = new JCheckBox("Execute multiple APIs in single invocation");
        showAPINameExecutionTimeCheckBox = new JCheckBox("Show API name and execution time as comment in XML output");
        saveChangesButtonPanel = new JPanel();
        saveChangesButton = new JButton("Save Changes");
        restoreDefaultsButtonPanel = new JPanel();
        restoreDefaultsButton = new JButton("Restore Defaults");
        errorBorder = BorderFactory.createEtchedBorder(Color.RED, Color.PINK);
        defaultBorder = null;
    }
}

