/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.ConnectItem;
import zexplore.menubar.preferences.Connection;
import zexplore.menubar.preferences.ConnectionListTableModel;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = -4947420065262559745L;
    private JFrame frame = View.frame;
    protected JTextComponent portField;
    protected JTextComponent vfiler;
    protected JComboBox protocolComboBox;
    protected JRadioButton ontapRadioButton;
    protected JRadioButton dfmRadioButton;
    private ButtonGroup serverTypeRadioButtonGroup;
    private JPanel radioPanel;
    private JPanel serverCredentialPanel;
    protected JTextComponent serverTextField;
    protected JTextComponent userTextField;
    protected JTextComponent passwordField;
    private JPanel manageConnectionsPanel;
    private JPanel connectionNameAndFieldPanel;
    private JPanel connectionNameAndTablePanel;
    private JLabel connectionNameLabel;
    private JTextComponent connectionNameField;
    private JScrollPane connectionScrollPane;
    private JTable connectionsListTable;
    private static ConnectionListTableModel connectionListTableModel;
    private boolean autoCompleteConnectionName = true;
    private JPanel connectOptionsButtonPanel;
    private JButton connectButton;
    private JButton cancelButton;
    private JToggleButton optionsButton;
    private JPanel advancedOptionsPanel;
    private JPanel advancedOptionsPanelWithEmptyBorder;
    private JPanel connectionParametersPanel;
    private JCheckBox vfilerTunnelingCheckBox;
    private JPanel vfilerTunnelingPanel;
    private JCheckBox timeoutCheckBox;
    private JTextField timeoutTextField;
    private ConnectDialog dialog = this;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel basicParametersPanel = new JPanel(new BorderLayout());
    private JPanel basicParametersConnectionsPanel;
    private final Dimension dialogBasicDim;
    private final Dimension dialogAdvancedOntapDim;
    private final Dimension dialogAdvancedDfmDim;

    public ConnectDialog() {
        super(View.frame, "Connect", true);
        this.basicParametersPanel.setBorder(BorderFactory.createEmptyBorder(5, 40, 5, 40));
        this.addServerTypeRadioPanel(this.basicParametersPanel);
        this.addServerCredentialPanel(this.basicParametersPanel);
        this.basicParametersConnectionsPanel = new JPanel(new BorderLayout());
        this.basicParametersConnectionsPanel.add((Component)this.basicParametersPanel, "North");
        this.addManageConnectionsPanel(this.basicParametersConnectionsPanel);
        this.mainPanel.add((Component)this.basicParametersConnectionsPanel, "North");
        this.addConnectOptionsButtons(this.mainPanel);
        this.addAdvancedOptionsPanel(this.mainPanel);
        this.dialog.getContentPane().add(this.mainPanel);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialogAdvancedOntapDim = this.dialog.getSize();
        this.dialogAdvancedDfmDim = new Dimension(this.dialog.getWidth(), this.dialog.getHeight() - this.vfilerTunnelingPanel.getHeight());
        this.dialogBasicDim = new Dimension(this.dialog.getWidth(), 2 * (this.dialog.getHeight() / 3));
        this.dialog.setSize(this.dialogBasicDim);
        this.advancedOptionsPanelWithEmptyBorder.setVisible(false);
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
        this.dialog.addKeyListener(new KeyOperationsListener(this.dialog));
    }

    private void addServerTypeRadioPanel(JPanel jPanel) {
        this.ontapRadioButton = new JRadioButton("Data ONTAP", true);
        this.ontapRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.vfilerTunnelingPanel.setVisible(true);
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
                if (ConnectDialog.this.optionsButton.getText().equals("Basic <<")) {
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedOntapDim);
                    ConnectDialog.this.mainPanel.updateUI();
                }
            }
        });
        this.ontapRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.dfmRadioButton = new JRadioButton("DataFabric Manager server", false);
        this.dfmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.vfilerTunnelingPanel.setVisible(false);
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
                if (ConnectDialog.this.optionsButton.getText().equals("Basic <<")) {
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedDfmDim);
                    ConnectDialog.this.mainPanel.updateUI();
                }
            }
        });
        this.dfmRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.serverTypeRadioButtonGroup = new ButtonGroup();
        this.serverTypeRadioButtonGroup.add(this.ontapRadioButton);
        this.serverTypeRadioButtonGroup.add(this.dfmRadioButton);
        this.radioPanel = new JPanel(new GridLayout(2, 1));
        this.radioPanel.add(this.ontapRadioButton);
        this.radioPanel.add(this.dfmRadioButton);
        this.radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Server Type "));
        jPanel.add((Component)this.radioPanel, "West");
    }

    private void addServerCredentialPanel(JPanel jPanel) {
        this.serverCredentialPanel = new JPanel(new BorderLayout());
        this.serverCredentialPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 0, 5));
        JLabel jLabel = new JLabel("Server");
        this.serverTextField = new JTextField(16);
        this.addControlKeyListener(this.serverTextField);
        this.serverTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        this.serverTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ConnectDialog.this.autoCompleteConnectionName) {
                    ConnectDialog.this.connectionNameField.setText(ConnectDialog.this.serverTextField.getText().trim());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (ConnectDialog.this.autoCompleteConnectionName) {
                    ConnectDialog.this.connectionNameField.setText(ConnectDialog.this.serverTextField.getText().trim());
                }
            }
        });
        JLabel jLabel2 = new JLabel("Username");
        this.userTextField = new JTextField(16);
        this.addControlKeyListener(this.userTextField);
        this.userTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        JLabel jLabel3 = new JLabel("Password");
        this.passwordField = new JPasswordField(16);
        this.addControlKeyListener(this.passwordField);
        this.passwordField.addKeyListener(new KeyOperationsListener(this.dialog));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel3.add(this.serverTextField);
        jPanel3.add(this.userTextField);
        jPanel3.add(this.passwordField);
        this.serverCredentialPanel.add((Component)jPanel2, "West");
        this.serverCredentialPanel.add((Component)jPanel3, "East");
        jPanel.add((Component)this.serverCredentialPanel, "East");
    }

    private void addManageConnectionsPanel(JPanel jPanel) {
        this.manageConnectionsPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Manage Connections ");
        Border border = BorderFactory.createEmptyBorder(0, 40, 0, 40);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, titledBorder);
        this.manageConnectionsPanel.setBorder(compoundBorder);
        this.connectionNameAndFieldPanel = new JPanel(new BorderLayout());
        this.connectionNameLabel = new JLabel("Connection Name ");
        this.connectionNameField = new JTextField(16);
        this.connectionNameAndFieldPanel.add((Component)this.connectionNameLabel, "West");
        this.connectionNameAndFieldPanel.add((Component)this.connectionNameField, "Center");
        this.connectionNameAndTablePanel = new JPanel(new BorderLayout());
        connectionListTableModel = new ConnectionListTableModel();
        this.connectionsListTable = new JTable(connectionListTableModel);
        this.connectionsListTable.setFillsViewportHeight(true);
        this.connectionsListTable.setShowGrid(false);
        this.connectionsListTable.setTableHeader(null);
        this.connectionsListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ConnectDialog.this.loadConnection();
                }
            }
        });
        this.connectionScrollPane = new JScrollPane(this.connectionsListTable);
        this.connectionScrollPane.setVerticalScrollBarPolicy(22);
        this.connectionScrollPane.setHorizontalScrollBarPolicy(30);
        this.connectionScrollPane.setPreferredSize(new Dimension(270, 100));
        this.connectionNameAndTablePanel.add((Component)this.connectionNameAndFieldPanel, "North");
        this.connectionNameAndTablePanel.add((Component)new JLabel("  "), "Center");
        this.connectionNameAndTablePanel.add((Component)this.connectionScrollPane, "South");
        this.connectionNameAndTablePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(30, 50, 0, 0));
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Load");
        jPanel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.loadConnection();
            }
        });
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Save");
        jPanel4.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.saveConnection();
            }
        });
        JPanel jPanel5 = new JPanel();
        JButton jButton3 = new JButton("Delete");
        jPanel5.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.deleteConnection();
            }
        });
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        this.manageConnectionsPanel.add((Component)this.connectionNameAndTablePanel, "West");
        this.manageConnectionsPanel.add((Component)jPanel2, "East");
        jPanel.add((Component)this.manageConnectionsPanel, "South");
    }

    private void addConnectOptionsButtons(JPanel jPanel) {
        this.connectOptionsButtonPanel = new JPanel();
        this.connectButton = new JButton("Connect");
        this.cancelButton = new JButton("Cancel");
        this.optionsButton = new JToggleButton("Advanced >>");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.connect();
            }
        });
        this.connectButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.dispose();
            }
        });
        this.cancelButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.optionsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ConnectDialog.this.optionsButton.setText("Basic <<");
                    ConnectDialog.this.advancedOptionsPanelWithEmptyBorder.setVisible(true);
                    if (ConnectDialog.this.ontapRadioButton.isSelected()) {
                        ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedOntapDim);
                    } else {
                        ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedDfmDim);
                    }
                } else {
                    ConnectDialog.this.optionsButton.setText("Advanced >>");
                    ConnectDialog.this.advancedOptionsPanelWithEmptyBorder.setVisible(false);
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogBasicDim);
                }
            }
        });
        this.optionsButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.connectOptionsButtonPanel.add(this.connectButton);
        this.connectOptionsButtonPanel.add(this.cancelButton);
        this.connectOptionsButtonPanel.add(this.optionsButton);
        jPanel.add((Component)this.connectOptionsButtonPanel, "South");
    }

    private void addAdvancedOptionsPanel(JPanel jPanel) {
        this.advancedOptionsPanelWithEmptyBorder = new JPanel();
        this.advancedOptionsPanelWithEmptyBorder.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        this.advancedOptionsPanel = new JPanel(new BorderLayout());
        this.advancedOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Advanced "));
        this.connectionParametersPanel = new JPanel(new GridLayout(1, 3));
        this.vfilerTunnelingPanel = new JPanel(new GridLayout(2, 3));
        this.vfilerTunnelingPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Transport");
        String[] stringArray = new String[]{"HTTP", "HTTPS"};
        this.protocolComboBox = new JComboBox<String>(stringArray);
        this.protocolComboBox.setSelectedIndex(1);
        jPanel2.add(jLabel);
        jPanel2.add(this.protocolComboBox);
        this.protocolComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
            }
        });
        this.protocolComboBox.addKeyListener(new KeyOperationsListener(this.dialog));
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel("Port");
        this.portField = new JTextField(4);
        this.portField.setText(Integer.toString(this.getSelectedDefaultPort()));
        jPanel3.add(jLabel2);
        jPanel3.add(this.portField);
        this.portField.addKeyListener(new KeyOperationsListener(this.dialog));
        JPanel jPanel4 = new JPanel();
        this.timeoutCheckBox = new JCheckBox("Timeout");
        this.timeoutTextField = new JTextField(3);
        this.timeoutTextField.setEditable(false);
        this.timeoutTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        this.timeoutCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    ConnectDialog.this.timeoutTextField.setEditable(true);
                } else {
                    ConnectDialog.this.timeoutTextField.setText("");
                    ConnectDialog.this.timeoutTextField.setEditable(false);
                }
            }
        });
        this.timeoutCheckBox.addKeyListener(new KeyOperationsListener(this.dialog));
        JLabel jLabel3 = new JLabel("seconds");
        jPanel4.add(this.timeoutCheckBox);
        jPanel4.add(this.timeoutTextField);
        jPanel4.add(jLabel3);
        this.connectionParametersPanel.add(jPanel2);
        this.connectionParametersPanel.add(jPanel3);
        this.connectionParametersPanel.add(jPanel4);
        this.advancedOptionsPanel.add((Component)this.connectionParametersPanel, "North");
        JLabel jLabel4 = new JLabel("");
        this.vfilerTunnelingCheckBox = new JCheckBox("Use vFiler or Vserver tunneling");
        this.vfilerTunnelingCheckBox.setSelected(false);
        JLabel jLabel5 = new JLabel("vFiler unit or Vserver name");
        this.vfiler = new JTextField(16);
        this.vfiler.setEditable(false);
        this.vfiler.addKeyListener(new KeyOperationsListener(this.dialog));
        this.vfilerTunnelingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    ConnectDialog.this.vfiler.setEditable(true);
                } else {
                    ConnectDialog.this.vfiler.setText("");
                    ConnectDialog.this.vfiler.setEditable(false);
                }
            }
        });
        this.vfilerTunnelingCheckBox.addKeyListener(new KeyOperationsListener(this.dialog));
        this.vfilerTunnelingPanel.add(jLabel4);
        this.vfilerTunnelingPanel.add(jLabel5);
        this.vfilerTunnelingPanel.add(this.vfilerTunnelingCheckBox);
        this.vfilerTunnelingPanel.add(this.vfiler);
        this.advancedOptionsPanel.add((Component)this.vfilerTunnelingPanel, "South");
        this.advancedOptionsPanelWithEmptyBorder.add(this.advancedOptionsPanel);
        jPanel.add((Component)this.advancedOptionsPanelWithEmptyBorder, "Center");
    }

    private void addControlKeyListener(JComponent jComponent) {
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ConnectDialog.this.connect();
                }
            }
        });
    }

    private int getSelectedDefaultPort() {
        if (this.ontapRadioButton.isSelected()) {
            if (this.protocolComboBox.getSelectedItem().toString().equals("HTTP")) {
                return 80;
            }
            return 443;
        }
        if (this.protocolComboBox.getSelectedItem().toString().equals("HTTP")) {
            return 8088;
        }
        return 8488;
    }

    private void connect() {
        String string;
        String string2 = "ontap";
        if (this.dfmRadioButton.isSelected()) {
            string2 = "dfm";
        }
        String string3 = this.serverTextField.getText().trim();
        String string4 = this.userTextField.getText().trim();
        String string5 = this.passwordField.getText().trim();
        String string6 = this.protocolComboBox.getSelectedItem().toString();
        int n = this.getSelectedDefaultPort();
        String string7 = this.portField.getText().trim();
        if (!string7.isEmpty()) {
            n = Integer.parseInt(string7);
        }
        int n2 = 0;
        String string8 = this.timeoutTextField.getText().trim();
        if (!string8.isEmpty()) {
            n2 = Integer.parseInt(string8);
        }
        if ((string = this.vfiler.getText().trim()).isEmpty()) {
            string = null;
        }
        Server server = null;
        try {
            server = new Server(string2, string3, string4, string5, string6, n, n2, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(View.frame, "Failed to connect: " + exception.getMessage(), "Connection Error", 0);
            this.dispose();
            return;
        }
        int n3 = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n3);
        executeTabPanel.setServer(server);
        View.statusBar.setServerStatus(server);
        String string9 = server.getApiDocVersion();
        if (!APIExplorerPanel.apiDropDownComboBox.selectApiDocVersion(string9)) {
            this.dispose();
            JOptionPane.showMessageDialog(View.frame, "API Version: " + string9 + " not listed.\nPlease select the API Document manually.", "Warning!", 2);
        }
        this.dispose();
    }

    private void loadConnection() {
        int n = this.connectionsListTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.autoCompleteConnectionName = false;
        ConnectionListTableModel connectionListTableModel = (ConnectionListTableModel)this.connectionsListTable.getModel();
        String string = (String)connectionListTableModel.getValueAt(n, 0);
        Connection connection = ConnectItem.connectionList.getConnection(string);
        this.connectionNameField.setText(string);
        if (connection.getServerType() == Connection.ServerType.ONTAP) {
            this.ontapRadioButton.setSelected(true);
            this.vfilerTunnelingPanel.setVisible(true);
            if (this.optionsButton.getText().equals("Basic <<")) {
                this.dialog.setSize(this.dialogAdvancedOntapDim);
                this.mainPanel.updateUI();
            }
        } else {
            this.dfmRadioButton.setSelected(true);
            this.vfilerTunnelingPanel.setVisible(false);
            if (this.optionsButton.getText().equals("Basic <<")) {
                this.dialog.setSize(this.dialogAdvancedDfmDim);
                this.mainPanel.updateUI();
            }
        }
        this.serverTextField.setText(connection.getServerName());
        this.userTextField.setText(connection.getUserName());
        this.passwordField.setText("");
        if (connection.getTransportType() == Connection.Transport.HTTPS) {
            this.protocolComboBox.setSelectedIndex(1);
        } else {
            this.protocolComboBox.setSelectedIndex(0);
        }
        this.portField.setText(connection.getPort());
        this.timeoutCheckBox.setSelected(connection.isTimeoutChecked());
        this.timeoutTextField.setText(connection.getTimeout());
        this.timeoutTextField.setEditable(connection.isTimeoutChecked());
        this.vfilerTunnelingCheckBox.setSelected(connection.isVfilerTunnelChecked());
        this.vfiler.setText(connection.getVfilerUnitName());
        this.vfiler.setEditable(connection.isVfilerTunnelChecked());
        this.autoCompleteConnectionName = true;
    }

    private void saveConnection() {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        if (!ConnectItem.connectionList.addConnection(connection)) {
            int n = JOptionPane.showConfirmDialog(View.frame, "Connection name: " + connection.getConnectionName() + " already exists.\nDo you want to overwrite?", "Duplicate Connection", 0);
            if (n == 0) {
                ConnectItem.connectionList.overwriteConnection(connection);
            }
            return;
        }
        ConnectionListTableModel connectionListTableModel = (ConnectionListTableModel)this.connectionsListTable.getModel();
        String[] stringArray = new String[]{connection.getConnectionName()};
        connectionListTableModel.addRow(stringArray);
    }

    private void deleteConnection() {
        int n = this.connectionsListTable.getSelectedRow();
        String string = (String)this.connectionsListTable.getValueAt(n, 0);
        Connection connection = ConnectItem.connectionList.getConnection(string);
        ConnectItem.connectionList.removeConnection(connection);
        ConnectionListTableModel connectionListTableModel = (ConnectionListTableModel)this.connectionsListTable.getModel();
        connectionListTableModel.removeRow(n);
    }

    public Connection getConnection() {
        String string = this.connectionNameField.getText().trim();
        if (string.isEmpty()) {
            return null;
        }
        Connection.ServerType serverType = Connection.ServerType.ONTAP;
        if (this.dfmRadioButton.isSelected()) {
            serverType = Connection.ServerType.DFM;
        }
        String string2 = this.serverTextField.getText().trim();
        String string3 = this.userTextField.getText().trim();
        Connection.Transport transport = Connection.Transport.HTTPS;
        if (this.protocolComboBox.getSelectedIndex() == 0) {
            transport = Connection.Transport.HTTP;
        }
        String string4 = this.portField.getText().trim();
        boolean bl = this.timeoutCheckBox.isSelected();
        String string5 = this.timeoutTextField.getText().trim();
        boolean bl2 = this.vfilerTunnelingCheckBox.isSelected();
        String string6 = this.vfiler.getText().trim();
        return new Connection(string, serverType, string2, string3, transport, string4, bl, string5, bl2, string6);
    }
}

