/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.View;

public class UserGuideDialog
extends JDialog {
    private static final long serialVersionUID = 1061281322456172992L;
    private static final String USER_GUIDE_DIR = "/user_guide";
    private static final String HOME_PAGE = "/user_guide/intro.html";
    private static JPanel backForwardButtonsPanel = new JPanel(new BorderLayout());
    private static JButton backButton;
    private static JButton forwardButton;
    private static String currentPage;
    private static Stack<String> backStack;
    private static Stack<String> forwardStack;
    private JPanel userGuidePanel = new JPanel(new BorderLayout());
    private JEditorPane editorPane = new JEditorPane();
    private JScrollPane scrollPane = new JScrollPane(this.editorPane, 20, 30);

    public UserGuideDialog() {
        super(View.frame, "ZExplore Development Interface User Guide", false);
        this.loadBackForwardHomeButtons();
        this.add((Component)backForwardButtonsPanel, "North");
        this.loadUserGuide();
        this.add((Component)this.userGuidePanel, "Center");
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(View.frame);
        this.setDefaultCloseOperation(2);
        this.setVisible(false);
    }

    private void loadUserGuide() {
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.editorPane.setEditorKit(hTMLEditorKit);
        if (currentPage == null) {
            currentPage = HOME_PAGE;
        }
        URL uRL = this.getClass().getResource(currentPage);
        try {
            this.editorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            this.editorPane.setText("<html>Failed to load ZExplore Development Interface User Guide</html>");
        }
        this.editorPane.addKeyListener(new KeyOperationsListener(this));
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().toString();
                    int n = string.lastIndexOf("/");
                    String string2 = UserGuideDialog.USER_GUIDE_DIR + string.substring(n, string.length());
                    if (string2.contains("#")) {
                        int n2 = string2.lastIndexOf("#");
                        String string3 = string2.substring(n2 + 1, string2.length());
                        UserGuideDialog.this.editorPane.scrollToReference(string3);
                        return;
                    }
                    URL uRL = this.getClass().getResource(string2);
                    try {
                        backStack.push(currentPage);
                        currentPage = string2;
                        backButton.setEnabled(true);
                        forwardButton.setEnabled(false);
                        forwardStack.setSize(0);
                        UserGuideDialog.this.editorPane.setPage(uRL);
                    }
                    catch (IOException iOException) {
                        UserGuideDialog.this.editorPane.setText("<html>Failed to load " + string2 + "</html>");
                    }
                }
            }
        });
        this.userGuidePanel.setPreferredSize(new Dimension(800, 600));
        this.userGuidePanel.add((Component)this.scrollPane, "Center");
    }

    private void loadBackForwardHomeButtons() {
        this.addBackButton();
        this.addForwardButton();
    }

    private void addBackButton() {
        backButton = new JButton();
        backButton.setIcon(new IconMap().getIcon("left-arrow"));
        backButton.setToolTipText("Go back one page");
        backButton.setEnabled(false);
        backButton.setContentAreaFilled(false);
        backForwardButtonsPanel.add((Component)backButton, "West");
        backButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                backButton.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                backButton.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                UserGuideDialog.this.goBack();
            }
        });
        backButton.addKeyListener(new KeyOperationsListener());
    }

    private void addForwardButton() {
        forwardButton = new JButton();
        forwardButton.setIcon(new IconMap().getIcon("right-arrow"));
        forwardButton.setToolTipText("Go forward one page");
        forwardButton.setEnabled(false);
        forwardButton.setContentAreaFilled(false);
        backForwardButtonsPanel.add((Component)forwardButton, "East");
        forwardButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                forwardButton.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                forwardButton.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                UserGuideDialog.this.goForward();
            }
        });
        forwardButton.addKeyListener(new KeyOperationsListener());
    }

    private void goBack() {
        forwardStack.push(currentPage);
        forwardButton.setEnabled(true);
        currentPage = backStack.pop();
        if (backStack.isEmpty()) {
            backButton.setEnabled(false);
        }
        URL uRL = this.getClass().getResource(currentPage);
        try {
            this.editorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            this.editorPane.setText("<html>Failed to load " + currentPage + "</html>");
        }
    }

    private void goForward() {
        backStack.push(currentPage);
        backButton.setEnabled(true);
        currentPage = forwardStack.pop();
        if (forwardStack.isEmpty()) {
            forwardButton.setEnabled(false);
        }
        URL uRL = this.getClass().getResource(currentPage);
        try {
            this.editorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            this.editorPane.setText("<html>Failed to load " + currentPage + "</html>");
        }
    }

    static {
        currentPage = null;
        backStack = new Stack();
        forwardStack = new Stack();
    }
}

