/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tab;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.tab.TabLabelCloseButtonPanel;
import zexplore.executedevelop.tab.TabLabelEditTextArea;

public class TabLabel
extends JLabel {
    private static final long serialVersionUID = -722687172414694721L;
    private static String tabNamePadding = " ";
    private TabLabelEditTextArea textArea;
    private TabLabelCloseButtonPanel tabLabelCloseButtonPanel;

    public TabLabel(String string, TabLabelCloseButtonPanel tabLabelCloseButtonPanel) {
        super(tabNamePadding + string + tabNamePadding);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.tabLabelCloseButtonPanel = tabLabelCloseButtonPanel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    TabLabel.this.tabLabelCloseButtonPanel.setTabSelected();
                }
                if (mouseEvent.getClickCount() == 2) {
                    TabLabel.this.addTextArea();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TabLabel.this.tabLabelCloseButtonPanel.setTabSelected();
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                    ExecuteDevelopPane.executeDevelopTabPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void addTextArea() {
        this.textArea = new TabLabelEditTextArea(this);
        this.add(this.textArea);
        this.textArea.requestFocus();
        this.textArea.selectAll();
    }

    public void removeTextArea() {
        this.remove(this.textArea);
        this.tabLabelCloseButtonPanel.renameTab();
    }

    public String getPadding() {
        return tabNamePadding;
    }
}

