/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.execute;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.TreeSearcher;
import zexplore.executedevelop.execute.TreeOutputIconRenderer;

public class TreeOutputPanel
extends JPanel {
    private static final long serialVersionUID = -1742648701810850314L;
    public JTree outputTree;
    private JTextComponent outputSearchField;
    private JButton nextNode;
    private JButton lastNode;

    public TreeOutputPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 100));
        this.addOutputTreeComponents(this);
        this.outputTree.setRootVisible(false);
        this.outputTree.setCellRenderer(new TreeOutputIconRenderer());
        this.addKeyListener(new KeyOperationsListener());
    }

    private void addOutputTreeComponents(Container container) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.outputSearchField = new JTextField(30);
        this.outputSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TreeOutputPanel.this.findNextNode(TreeOutputPanel.this.outputTree.getSelectionPath(), TreeOutputPanel.this.outputSearchField.getText());
                }
            }
        });
        this.outputSearchField.setToolTipText("Search the output tree using a regular expression.");
        this.nextNode = new JButton(new IconMap().getIcon("nextNode"));
        this.nextNode.setPreferredSize(new Dimension(20, 20));
        this.nextNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeOutputPanel.this.findNextNode(TreeOutputPanel.this.outputTree.getSelectionPath(), TreeOutputPanel.this.outputSearchField.getText());
            }
        });
        this.lastNode = new JButton(new IconMap().getIcon("lastNode"));
        this.lastNode.setPreferredSize(new Dimension(20, 20));
        this.lastNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeOutputPanel.this.findLastNode(TreeOutputPanel.this.outputTree.getSelectionPath(), TreeOutputPanel.this.outputSearchField.getText());
            }
        });
        jPanel2.add(this.outputSearchField);
        jPanel2.add(this.nextNode);
        jPanel2.add(this.lastNode);
        this.outputTree = new JTree();
        this.outputTree.setModel(null);
        this.outputTree.getSelectionModel().setSelectionMode(1);
        this.outputTree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.outputTree, 22, 30);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "Center");
    }

    private void findNextNode(TreePath treePath, String string) {
        TreeModel treeModel = this.outputTree.getModel();
        if (treeModel == null) {
            return;
        }
        TreeSearcher treeSearcher = new TreeSearcher(treeModel);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        TreePath treePath2 = treeSearcher.findNextPath(treePath, pattern);
        if (treePath2 == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.outputTree.setSelectionPath(treePath2);
            this.outputTree.scrollPathToVisible(treePath2);
        }
    }

    private void findLastNode(TreePath treePath, String string) {
        TreeModel treeModel = this.outputTree.getModel();
        if (treeModel == null) {
            return;
        }
        TreeSearcher treeSearcher = new TreeSearcher(treeModel);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        TreePath treePath2 = treeSearcher.findLastPath(treePath, pattern);
        if (treePath2 == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.outputTree.setSelectionPath(treePath2);
            this.outputTree.scrollPathToVisible(treePath2);
        }
    }
}

