/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.execute;

import java.awt.Dimension;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import zexplore.KeyOperationsListener;
import zexplore.addedapisworkflows.addedapis.AddedApisTreePanel;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.codegenerator.CodeGenerator;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;

public class InputPanel
extends JScrollPane {
    private static final long serialVersionUID = 6443540091988949366L;
    public JEditorPane input = new JEditorPane();
    public DefaultTreeModel treeModel = null;
    public File importPath = null;
    public int cloneCount = 0;
    public static boolean updateAddedApisTree = true;
    public static boolean updateWorkflowsTree = true;

    public InputPanel() {
        super.getViewport().add(this.input);
        super.setVerticalScrollBarPolicy(22);
        super.setHorizontalScrollBarPolicy(30);
        this.input.setContentType("text/xml");
        this.input.setPreferredSize(new Dimension(400, 100));
        this.setMinimumSize(new Dimension(400, 100));
        this.input.addKeyListener(new KeyOperationsListener());
        this.input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CodeGenerator.generateSampleCode();
                InputPanel.this.unsaveLoadedWorkflow();
                String string = InputPanel.this.input.getText();
                if (updateWorkflowsTree) {
                    InputPanel.this.updateWorkflowTree();
                }
                if (string.trim().equals("")) {
                    return;
                }
                if (updateAddedApisTree) {
                    InputPanel.this.treeModel = AddedApisTreePanel.tree.createTree(string);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CodeGenerator.generateSampleCode();
                InputPanel.this.unsaveLoadedWorkflow();
                String string = InputPanel.this.input.getText();
                if (updateWorkflowsTree) {
                    InputPanel.this.updateWorkflowTree();
                }
                if (updateAddedApisTree) {
                    if (string.trim().equals("")) {
                        InputPanel.this.treeModel = null;
                        AddedApisTreePanel.tree.setModel(InputPanel.this.treeModel);
                    } else {
                        InputPanel.this.treeModel = AddedApisTreePanel.tree.createTree(string);
                    }
                }
            }
        });
    }

    public void updateWorkflowTree() {
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)this.getParent().getParent();
        int n = executeTabPanel.getWorkflowNodeIndex();
        if (n >= 0) {
            n = WorkflowsTreePanel.tree.updateUserDefinedWorkflow(this.input.getText().trim(), n);
            executeTabPanel.setWorkflowNodeIndex(n);
        }
    }

    public void unsaveLoadedWorkflow() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        String string = ExecuteDevelopPane.executeTabbedPane.getTitleAt(n);
        File file = this.importPath;
        if (file == null) {
            File file2 = PreferencesMenu.workflowsPathItem.getWorkflowsPath();
            String string2 = file2.getPath() + File.separator + string + ".xml";
            file = new File(string2);
        }
        LoadedWorkflowList.setSavedWorkflow(file.getAbsolutePath(), false);
        LoadedWorkflowList.setNewWorkflow(file.getAbsolutePath(), false);
    }
}

