/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.execute;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.addedapisworkflows.addedapis.AddedApisTreePanel;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.executedevelop.execute.InputPanel;
import zexplore.executedevelop.tab.TabLabel;
import zexplore.executedevelop.tab.TabLabelCloseButtonPanel;
import zexplore.executedevelop.tabpopupmenu.ExecuteDevelopTabPopupMenu;
import zexplore.menubar.file.FileMenu;
import zexplore.menubar.preferences.PreferencesMenu;

public class ExecuteTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2295578573631308254L;
    private static int newTabIndex = 0;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static final String PREF_NODE_WORKFLOW_COUNT = "WORKFLOW_COUNT";
    private static final String PREF_NODE_WORKFLOW_ENTRY_PREFIX = "WORKFLOW";
    private static final String PREF_NODE_SELECTED_WORKFLOW_INDEX = "SELECTED_WORKFLOW_INDEX";

    public ExecuteTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                if (ExecuteTabbedPane.this.getTabCount() == ExecuteDevelopPane.developTabbedPane.getTabCount()) {
                    ExecuteDevelopPane.developTabbedPane.setSelectedIndex(ExecuteTabbedPane.this.getSelectedIndex());
                }
                if ((n = ExecuteTabbedPane.this.getSelectedIndex()) >= 0) {
                    ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteTabbedPane.this.getComponentAt(n);
                    AddedApisTreePanel.tree.setModel(executeTabPanel.inputPanel.treeModel);
                    Server server = executeTabPanel.getServer();
                    View.statusBar.setServerStatus(server);
                    String string = executeTabPanel.getApiDocVersion();
                    if (string != null) {
                        APIExplorerPanel.apiDropDownComboBox.selectApiDocVersion(string);
                    }
                } else {
                    AddedApisTreePanel.tree.setModel(null);
                    View.statusBar.setDefaultStatus();
                }
            }
        });
        this.addKeyListener(new KeyOperationsListener());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Component component = ExecuteTabbedPane.this.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
                if (component.getClass().getName().contains("TabContainer") && mouseEvent.getClickCount() == 2) {
                    FileMenu.newItem.addNewWorkflow();
                }
            }
        });
    }

    public void addNewTab() {
        String string = this.getValidTabName();
        ExecuteTabPanel executeTabPanel = new ExecuteTabPanel();
        this.addTab(string, executeTabPanel);
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = new TabLabelCloseButtonPanel(string, this);
        this.setTabComponentAt(this.getTabCount() - 1, tabLabelCloseButtonPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        File file = PreferencesMenu.workflowsPathItem.getWorkflowsPath();
        String string2 = file.getPath() + File.separator + string + ".xml";
        String string3 = LoadedWorkflowList.sanitizeFilePath(new File(string2).getAbsolutePath());
        LoadedWorkflowList.addLoadedWorkflow(string3, false);
        LoadedWorkflowList.setNewWorkflow(string3, true);
        LoadedWorkflowList.setExecuteTabPanel(string3, executeTabPanel);
        executeTabPanel.inputPanel.importPath = new File(string3);
        executeTabPanel.setApiDocVersion(APIExplorerPanel.apiDropDownComboBox.getSelectedDocName());
        if (this.getTabCount() > 1) {
            ExecuteTabPanel executeTabPanel2 = (ExecuteTabPanel)this.getComponentAt(this.getTabCount() - 2);
            executeTabPanel.setServer(executeTabPanel2.getServer());
            View.statusBar.setServerStatus(executeTabPanel.getServer());
        }
        AddedApisTreePanel.tree.setModel(null);
        int n = WorkflowsTreePanel.tree.addUserDefinedWorkflow("", string, -1, false);
        executeTabPanel.setWorkflowNodeIndex(n);
        WorkflowsTreePanel.tree.setExecuteTabPanelIndex(n, this.getTabCount() - 1);
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public String getValidTabName() {
        String string = "New " + Integer.toString(++newTabIndex);
        File file = PreferencesMenu.workflowsPathItem.getWorkflowsPath();
        String string2 = file.getPath() + File.separator + string + ".xml";
        String string3 = LoadedWorkflowList.sanitizeFilePath(new File(string2).getAbsolutePath());
        if (LoadedWorkflowList.getLoadedWorkflowList().contains(string3)) {
            string = this.getValidTabName();
        }
        return string;
    }

    public void addImportTab(String string) {
        ExecuteTabPanel executeTabPanel = new ExecuteTabPanel();
        this.addTab(string, executeTabPanel);
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = new TabLabelCloseButtonPanel(string, this);
        this.setTabComponentAt(this.getTabCount() - 1, tabLabelCloseButtonPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        executeTabPanel.setApiDocVersion(APIExplorerPanel.apiDropDownComboBox.getSelectedDocName());
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void removeSelectedTab(int n, boolean bl, boolean bl2) {
        String string = ExecuteDevelopPane.executeTabbedPane.getTitleAt(n);
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        File file = executeTabPanel.inputPanel.importPath;
        String string2 = LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath());
        if (bl2 && !LoadedWorkflowList.isSaved(string2) && !LoadedWorkflowList.isNew(string2)) {
            int n2 = JOptionPane.showConfirmDialog(View.frame, "Workflow '" + string + "' has been modified. Do you want to save the changes?", "Save Workflow", 1, 2);
            if (n2 == 0) {
                FileMenu.saveItem.saveFile(string, executeTabPanel.inputPanel);
            } else if (n2 == 2 || n2 == -1) {
                return;
            }
        }
        if (LoadedWorkflowList.isSaved(string2)) {
            ExecuteDevelopTabPopupMenu.undoCloseTabItem.enableUndoCloseTabItem(string2, executeTabPanel.getServer());
        }
        LoadedWorkflowList.removeLoadedWorkflow(file.getAbsolutePath());
        this.removeWorkflow(n);
        this.remove(n);
        if (bl) {
            ExecuteDevelopPane.developTabbedPane.removeSelectedTab(n, false);
        }
        if (this.getTabCount() == 0) {
            this.addNewTab();
        }
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void renameTab(int n, String string) {
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = (TabLabelCloseButtonPanel)this.getTabComponentAt(n);
        TabLabel tabLabel = (TabLabel)tabLabelCloseButtonPanel.getComponent(0);
        if (tabLabel.getText().equals(string) && this.getTitleAt(n).equals(string.trim())) {
            return;
        }
        tabLabel.setText(string);
        this.setTitleAt(n, string.trim());
        ExecuteDevelopPane.developTabbedPane.renameTab(n, string);
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        File file = executeTabPanel.inputPanel.importPath;
        String string2 = file.getAbsolutePath();
        String string3 = file.getParent();
        String string4 = string3 + File.separator + string.trim() + ".xml";
        executeTabPanel.inputPanel.importPath = new File(string4);
        boolean bl = LoadedWorkflowList.isNew(string2);
        boolean bl2 = LoadedWorkflowList.isSaved(string2);
        LoadedWorkflowList.removeLoadedWorkflow(string2);
        LoadedWorkflowList.addLoadedWorkflow(string4, bl2);
        LoadedWorkflowList.setNewWorkflow(string4, bl);
        LoadedWorkflowList.setExecuteTabPanel(string4, executeTabPanel);
        int n2 = executeTabPanel.getWorkflowNodeIndex();
        if (n2 >= 0) {
            InputPanel inputPanel = executeTabPanel.inputPanel;
            String string5 = inputPanel.input.getText().trim();
            n2 = WorkflowsTreePanel.tree.updateUserDefinedWorkflow(string5, n2);
            executeTabPanel.setWorkflowNodeIndex(n2);
        }
    }

    private void removeWorkflow(int n) {
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)this.getComponentAt(n);
        int n2 = executeTabPanel.getWorkflowNodeIndex();
        if (n2 < 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)WorkflowsTreePanel.tree.getModel().getRoot();
        for (int i = n2 + 1; i < defaultMutableTreeNode.getChildCount(); ++i) {
            int n3 = WorkflowsTreePanel.tree.getExecuteTabPanelIndex(i);
            ExecuteTabPanel executeTabPanel2 = (ExecuteTabPanel)this.getComponentAt(n3);
            executeTabPanel2.setWorkflowNodeIndex(i - 1);
            WorkflowsTreePanel.tree.setExecuteTabPanelIndex(i - 1, n3 - 1);
            boolean bl = WorkflowsTreePanel.tree.isImported(i);
            WorkflowsTreePanel.tree.setImported(i - 1, bl);
            WorkflowsTreePanel.tree.clearImported(i);
        }
        WorkflowsTreePanel.tree.removeUserDefinedWorkflow(n2);
    }

    public void loadSavedWorkflows() {
        int n;
        int n2 = this.prefs.getInt(PREF_NODE_WORKFLOW_COUNT, 0);
        if (n2 == 0) {
            this.addNewTab();
            ExecuteDevelopPane.developTabbedPane.addNewTab();
            return;
        }
        int n3 = this.getTabCount();
        for (n = 0; n < n2; ++n) {
            String string = PREF_NODE_WORKFLOW_ENTRY_PREFIX + n;
            String string2 = this.prefs.get(string, null);
            if (string2 == null) continue;
            String[] stringArray = string2.split("#:!");
            String string3 = stringArray[0];
            boolean bl = Boolean.parseBoolean(stringArray[1]);
            String string4 = stringArray[2];
            File file = new File(string3);
            FileMenu.importItem.readFileSetContent(file, bl);
            int n4 = this.getTabCount();
            if (n4 != n3 + 1) continue;
            ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)this.getSelectedComponent();
            executeTabPanel.setApiDocVersion(string4);
            ++n3;
        }
        n = this.getTabCount();
        if (n <= 0) {
            this.addNewTab();
            ExecuteDevelopPane.developTabbedPane.addNewTab();
            return;
        }
        int n5 = this.prefs.getInt(PREF_NODE_SELECTED_WORKFLOW_INDEX, 0);
        if (n5 < n) {
            this.setSelectedIndex(n5);
        }
    }

    public void storeSavedWorkflows() {
        this.clearPreferences();
        int n = 0;
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)this.getComponentAt(i);
            File file = executeTabPanel.inputPanel.importPath;
            String string = LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath());
            if (!LoadedWorkflowList.isSaved(string)) continue;
            if (this.getSelectedIndex() == i) {
                this.prefs.putInt(PREF_NODE_SELECTED_WORKFLOW_INDEX, n);
            }
            int n3 = executeTabPanel.getWorkflowNodeIndex();
            boolean bl = WorkflowsTreePanel.tree.isImported(n3);
            String string2 = executeTabPanel.getApiDocVersion();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string + "#:!" + String.valueOf(bl) + "#:!" + string2;
            String string4 = PREF_NODE_WORKFLOW_ENTRY_PREFIX + n;
            this.prefs.put(string4, string3);
            ++n;
        }
        this.prefs.putInt(PREF_NODE_WORKFLOW_COUNT, n);
    }

    public void clearPreferences() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }
}

