/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.develop;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import zexplore.KeyOperationsListener;
import zexplore.codegenerator.CodeGenerator;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.develop.DevelopTabPanel;
import zexplore.executedevelop.tab.TabLabel;
import zexplore.executedevelop.tab.TabLabelCloseButtonPanel;
import zexplore.menubar.file.FileMenu;

public class DevelopTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2295578573631308254L;
    private static int newTabIndex = 0;

    public DevelopTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DevelopTabbedPane.this.getTabCount() == ExecuteDevelopPane.executeTabbedPane.getTabCount()) {
                    int n = DevelopTabbedPane.this.getSelectedIndex();
                    ExecuteDevelopPane.executeTabbedPane.setSelectedIndex(n);
                    if (n >= 0 && DevelopTabbedPane.this.isShowing()) {
                        CodeGenerator.generateSampleCode();
                    }
                }
            }
        });
        this.addKeyListener(new KeyOperationsListener());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Component component = DevelopTabbedPane.this.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
                if (component.getClass().getName().contains("TabContainer") && mouseEvent.getClickCount() == 2) {
                    FileMenu.newItem.addNewWorkflow();
                }
            }
        });
    }

    public void addNewTab() {
        String string = "New " + Integer.toString(++newTabIndex);
        DevelopTabPanel developTabPanel = new DevelopTabPanel();
        this.addTab(string, developTabPanel);
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = new TabLabelCloseButtonPanel(string, this);
        this.setTabComponentAt(this.getTabCount() - 1, tabLabelCloseButtonPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void addImportTab(String string) {
        DevelopTabPanel developTabPanel = new DevelopTabPanel();
        this.addTab(string, developTabPanel);
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = new TabLabelCloseButtonPanel(string, this);
        this.setTabComponentAt(this.getTabCount() - 1, tabLabelCloseButtonPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void removeSelectedTab(int n, boolean bl) {
        this.remove(n);
        if (bl) {
            ExecuteDevelopPane.executeTabbedPane.removeSelectedTab(n, false, true);
        }
        if (this.getTabCount() == 0) {
            this.addNewTab();
        }
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void renameTab(int n, String string) {
        TabLabelCloseButtonPanel tabLabelCloseButtonPanel = (TabLabelCloseButtonPanel)this.getTabComponentAt(n);
        TabLabel tabLabel = (TabLabel)tabLabelCloseButtonPanel.getComponent(0);
        if (tabLabel.getText().equals(string) && this.getTitleAt(n).equals(string.trim())) {
            return;
        }
        tabLabel.setText(string);
        this.setTitleAt(n, string.trim());
        ExecuteDevelopPane.executeTabbedPane.renameTab(n, string);
    }
}

