/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import zexplore.KeyOperationsListener;
import zexplore.apiexplorer.APIParser;
import zexplore.apiexplorer.APITreeIconRenderer;
import zexplore.apiexplorer.ContextMenuFactory;
import zexplore.apiexplorer.DragDropListener;
import zexplore.apiexplorer.ParsedTreeMap;

public class APITree
extends JTree {
    private static final long serialVersionUID = 7010507129033130967L;
    public static final ParsedTreeMap parsedTreeMap = new ParsedTreeMap();
    public APIParser apiParser = null;
    public TreeModel apiTreeModel = null;
    public static final int toolTipDismissDelay = 600000;

    public APITree() {
        this.setModel(null);
        this.addKeyListener(new KeyOperationsListener());
    }

    public void addTree(String string, String string2) throws IOException {
        this.apiTreeModel = parsedTreeMap.getTreeModel(string);
        if (this.apiTreeModel == null) {
            if (parsedTreeMap.getApiParser(string) == null) {
                InputStream inputStream = null;
                try {
                    inputStream = this.getClass().getResourceAsStream("/" + string2);
                    if (inputStream == null) {
                        inputStream = new FileInputStream(string2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.toString());
                }
                this.apiParser = new APIParser(inputStream);
                parsedTreeMap.setApiParser(string, this.apiParser);
            } else {
                this.apiParser = parsedTreeMap.getApiParser(string);
            }
            this.setParserNamespace(this.apiParser, string);
            this.setParserFamily(this.apiParser, string);
            this.apiTreeModel = this.apiParser.getTreeModel();
            parsedTreeMap.setTreeModel(string, this.apiTreeModel);
        } else {
            this.apiParser = parsedTreeMap.getApiParser(string);
        }
        this.setModel(this.apiTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                try {
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        APITree.this.apiParser.expandTree(defaultMutableTreeNode);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addTreeMouseListener();
        new DragDropListener(this, this.apiParser);
        this.setCellRenderer(new APITreeIconRenderer(this.apiParser));
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    private void addTreeMouseListener() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.createContextMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.createContextMenu(mouseEvent);
                }
            }

            private void createContextMenu(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                TreePath treePath = APITree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (mouseEvent.getButton() == 3 && !mouseEvent.isControlDown()) {
                    APITree.this.setSelectionPath(treePath);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                int n = defaultMutableTreeNode.getLevel();
                boolean bl = false;
                ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
                TreePath[] treePathArray = APITree.this.getSelectionPaths();
                if (treePathArray != null && treePathArray.length > 0) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2;
                        if (treePath == treePathArray[i]) {
                            bl = true;
                        }
                        if (n != (defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getLevel()) continue;
                        arrayList.add(defaultMutableTreeNode2);
                    }
                }
                if (!bl && mouseEvent.getButton() == 3) {
                    if (mouseEvent.isControlDown()) {
                        APITree.this.addSelectionPath(treePath);
                    }
                    arrayList.add(defaultMutableTreeNode);
                }
                if ((jPopupMenu = ContextMenuFactory.createMenu(arrayList, APITree.this.apiParser)) != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void setParserNamespace(APIParser aPIParser, String string) {
        String string2 = null;
        string2 = string.contains("Ontapi") ? "filer" : "dfm";
        aPIParser.setNamespace(string2);
    }

    private void setParserFamily(APIParser aPIParser, String string) {
        String string2 = null;
        if (string.contains("DFM")) {
            return;
        }
        if (string.equals("Ontapi 1.2") || string.equals("Ontapi 1.3") || string.equals("Ontapi 1.4") || string.equals("Ontapi 1.5")) {
            return;
        }
        if (string.contains("Cluster-Mode")) {
            string2 = "ontap-cluster";
        } else if (string.contains("Vserver")) {
            string2 = "ontap-vserver";
        } else if (string.contains("Ontapi")) {
            string2 = "ontap-c";
        }
        if (string2 != null) {
            aPIParser.setFamily(string2);
        }
    }
}

