/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import com.netapp.nmsdk.common.api.annotation.DocEnum;
import com.netapp.nmsdk.common.api.annotation.StatusEnum;
import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.Category;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.Type;
import com.netapp.zapi.parser.ZapidocFilter;
import com.netapp.zapi.parser.ZapidocParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import zexplore.apiexplorer.APITreeModel;

public class APIParser
extends ZapidocParser {
    private String namespaceFilter = null;
    public String familyFilter = null;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("root", true);
    private Map<String, DefaultMutableTreeNode> categoryNodeMap = new HashMap<String, DefaultMutableTreeNode>();
    private Map<String, Category> categoryMap = new HashMap<String, Category>();
    private Map<String, Api> apiMap = new HashMap<String, Api>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private Map<String, Type> typeMap = new HashMap<String, Type>();
    private Map<String, Field> typedefFieldMap = new HashMap<String, Field>();

    public APIParser(InputStream inputStream) throws IOException {
        super(inputStream, new ZapidocFilter(), false);
    }

    public Category getCategory(String string) {
        return this.categoryMap.get(string);
    }

    public Api getApi(String string) {
        return this.apiMap.get(string);
    }

    public Field getField(String string) {
        return this.fieldMap.get(string);
    }

    public Type getType(String string) {
        string = string.replace("[]", "");
        return this.typeMap.get(string);
    }

    public Field getTypedefField(String string) {
        return this.typedefFieldMap.get(string);
    }

    public void setFamily(String string) {
        this.familyFilter = string;
    }

    public void setNamespace(String string) {
        this.namespaceFilter = string;
    }

    public TreeModel getTreeModel() {
        ArrayList<Api> arrayList = new ArrayList<Api>(this.getNamespace(this.namespaceFilter).getApis());
        Collections.sort(arrayList);
        for (Api api : arrayList) {
            if (this.familyFilter != null && !api.getFamily().isEmpty() && !api.getFamily().contains(this.familyFilter) || this.familyFilter != null && (this.familyFilter.equals("ontap-cluster") || this.familyFilter.equals("ontap-vserver")) && api.getFamily().isEmpty() || api.getStatus() != StatusEnum.PUBLIC) continue;
            Category category = api.getCategory();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            if (this.categoryNodeMap.get(category.getName()) == null) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(category.getName());
                this.root.add(defaultMutableTreeNode);
                this.categoryNodeMap.put(category.getName(), defaultMutableTreeNode);
                this.categoryMap.put(category.getName(), category);
            } else {
                defaultMutableTreeNode = this.categoryNodeMap.get(category.getName());
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(api.getName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.apiMap.put(api.getName(), api);
        }
        return new APITreeModel(this.root);
    }

    public void expandTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        block10: {
            int n;
            block12: {
                block11: {
                    block9: {
                        n = defaultMutableTreeNode.getLevel();
                        if (n != 1) break block9;
                        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextSibling()) {
                            String string;
                            DefaultMutableTreeNode defaultMutableTreeNode3;
                            if (!defaultMutableTreeNode2.isLeaf()) continue;
                            Api api = this.apiMap.get(defaultMutableTreeNode2.toString());
                            for (Field field : api.getInputFields()) {
                                if (!field.getScope().isEmpty() && !field.getScope().contains(this.familyFilter) || field.getDoc() == DocEnum.HIDDEN) continue;
                                defaultMutableTreeNode3 = new DefaultMutableTreeNode(field.getName());
                                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                                string = defaultMutableTreeNode2.toString() + ":" + field.getName();
                                this.fieldMap.put(string, field);
                            }
                            for (Field field : api.getOutputFields()) {
                                if (!field.getScope().isEmpty() && !field.getScope().contains(this.familyFilter) || field.getDoc() == DocEnum.HIDDEN) continue;
                                defaultMutableTreeNode3 = new DefaultMutableTreeNode(field.getName());
                                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                                string = defaultMutableTreeNode2.toString() + ":" + field.getName();
                                this.fieldMap.put(string, field);
                            }
                        }
                        break block10;
                    }
                    if (n != 2) break block11;
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                    while (defaultMutableTreeNode4 != null) {
                        if (defaultMutableTreeNode4.isLeaf()) {
                            String string = defaultMutableTreeNode4.getParent().toString() + ":" + defaultMutableTreeNode4.toString();
                            Field field = this.fieldMap.get(string);
                            if (!field.getScope().isEmpty() && !field.getScope().contains(this.familyFilter) || field.getDoc() == DocEnum.HIDDEN) continue;
                            String string2 = null;
                            Type type = field.getTypedefType();
                            Type type2 = type.getRootType();
                            string2 = type2.isPrimitive() && !field.isCollection() ? type2.getName() : type.getName();
                            this.typeMap.put(string2, type);
                            if (field.isCollection()) {
                                string2 = string2.concat("[]");
                            }
                            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(string2);
                            defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                        }
                        defaultMutableTreeNode4 = defaultMutableTreeNode4.getNextSibling();
                    }
                    break block10;
                }
                if (n != 3) break block12;
                for (DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode6 != null; defaultMutableTreeNode6 = defaultMutableTreeNode6.getNextSibling()) {
                    if (!defaultMutableTreeNode6.isLeaf()) continue;
                    String string = defaultMutableTreeNode6.toString();
                    Type type = this.typeMap.get(string = string.replace("[]", ""));
                    if (type == null) continue;
                    for (Field field : type.getFields()) {
                        if (!field.getScope().isEmpty() && !field.getScope().contains(this.familyFilter) || field.getDoc() == DocEnum.HIDDEN) continue;
                        String string3 = field.getName();
                        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(string3);
                        defaultMutableTreeNode6.add(defaultMutableTreeNode7);
                        this.typedefFieldMap.put(string3, field);
                    }
                }
                break block10;
            }
            if (n != 4) break block10;
            for (DefaultMutableTreeNode defaultMutableTreeNode8 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode8 != null; defaultMutableTreeNode8 = defaultMutableTreeNode8.getNextSibling()) {
                if (!defaultMutableTreeNode8.isLeaf()) continue;
                this.addRecuriveTypedefs(defaultMutableTreeNode8);
            }
        }
    }

    private void addRecuriveTypedefs(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = defaultMutableTreeNode.toString();
        Field field = this.typedefFieldMap.get(string);
        if (!field.getScope().isEmpty() && !field.getScope().contains(this.familyFilter)) {
            return;
        }
        if (field.getDoc() == DocEnum.HIDDEN) {
            return;
        }
        Type type = null;
        String string2 = null;
        try {
            type = field.getTypedefType();
            Type type2 = type.getRootType();
            string2 = type2.isPrimitive() && !field.isCollection() ? type2.getName() : type.getName();
            this.typeMap.put(string2, type);
            if (field.isCollection()) {
                string2 = string2.concat("[]");
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!type.isPrimitive()) {
                for (Field field2 : type.getFields()) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(field2.getName());
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    this.typedefFieldMap.put(field2.getName(), field2);
                    this.addRecuriveTypedefs(defaultMutableTreeNode3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isInputField(String string, String string2) {
        Api api = this.apiMap.get(string);
        for (Field field : api.getInputFields()) {
            if (!field.getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputField(String string, String string2) {
        Api api = this.apiMap.get(string);
        for (Field field : api.getOutputFields()) {
            if (!field.getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptionalField(String string, String string2) {
        Api api = this.apiMap.get(string);
        for (Field field : api.getFields()) {
            if (!field.getName().equals(string2)) continue;
            return field.isOptional();
        }
        return false;
    }

    public boolean isOptionalTypedefField(String string) {
        Field field = this.typedefFieldMap.get(string);
        return field.isOptional();
    }

    public String getCategorySynopsis(String string) {
        String string2 = null;
        Category category = this.categoryMap.get(string);
        if (category != null) {
            string2 = category.getSynopsis();
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public String getCategoryDesc(String string) {
        String string2 = null;
        Category category = this.categoryMap.get(string);
        if (category != null) {
            string2 = category.getDiscussion();
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getApiDesc(String string) {
        String string2 = null;
        Api api = this.apiMap.get(string);
        if (api != null) {
            string2 = api.getDesc();
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getFieldDesc(String string, String string2) {
        String string3 = null;
        Api api = this.apiMap.get(string);
        for (Field field : api.getFields()) {
            if (!field.getName().equals(string2)) continue;
            string3 = field.getDesc();
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public String getTypeDesc(String string) {
        String string2 = null;
        if ((string = string.replace("[]", "")).equals("string")) {
            string2 = "The field is a sequence of characters, UTF8 encoded.";
        } else if (string.equals("integer")) {
            string2 = "The field is a number.";
        } else if (string.equals("boolean")) {
            string2 = "'true' or 'false'";
        } else {
            Type type = this.typeMap.get(string);
            if (type != null) {
                string2 = type.getDesc();
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getTypedefDesc(String string) {
        Field field = this.typedefFieldMap.get(string);
        String string2 = field.getDesc();
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        return string2;
    }
}

