/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import zexplore.KeyOperationsListener;
import zexplore.View;
import zexplore.apiexplorer.APIDocList;
import zexplore.apiexplorer.APIParser;
import zexplore.apiexplorer.APITree;
import zexplore.apiexplorer.APITreePanel;
import zexplore.apiexplorer.AddNewApiDocDialog;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

public class APIDropDownComboBox
extends JComboBox {
    private static final long serialVersionUID = 1125913886216827209L;
    private static final String dropDownHeader = "<html>\n<DIV style=\"color:#000080\">\n<b><i>--- Choose Api Version ---</i></b></html>";
    private static final String dropDownFooter = "<html>\n<DIV style=\"color:#000080\">\n<b><i>--- Add New Api Document ---</i></b></html>";
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static final String PREF_NODE_DOC_COUNT = "DOC_COUNT";
    private static final String PREF_NODE_APIDOC = "APIDOC";
    public APIDocList apiDocList = new APIDocList();

    public APIDropDownComboBox() {
        String string2;
        this.setToolTipText("Choose Api version from the list to view Api definitions in a tree format");
        this.addItem(dropDownHeader);
        for (String string2 : this.apiDocList.getDocList()) {
            this.addItem(string2);
        }
        this.addItem(dropDownFooter);
        List<String> list = this.getSavedDocNames();
        this.addSavedDocsToDropDownList(list, false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<String> list;
                String string = APIDropDownComboBox.this.getSelectedItem().toString();
                if (string.equals(APIDropDownComboBox.dropDownHeader)) {
                    return;
                }
                String string2 = null;
                if (string.equals(APIDropDownComboBox.dropDownFooter)) {
                    AddNewApiDocDialog addNewApiDocDialog = new AddNewApiDocDialog();
                    list = addNewApiDocDialog.getDocNames();
                    if (list == null || list.isEmpty()) {
                        return;
                    }
                    if (!addNewApiDocDialog.shouldOverwriteDocName()) {
                        APIDropDownComboBox.this.addSavedDocsToDropDownList(list, false);
                    }
                    string = list.get(0);
                    APIDropDownComboBox.this.setSelectedItem(string);
                    if (addNewApiDocDialog.shouldRememberPath()) {
                        if (!addNewApiDocDialog.shouldOverwriteDocName()) {
                            APIDropDownComboBox.this.putSavedDocNames(list);
                        }
                        String string3 = addNewApiDocDialog.getDocPath();
                        for (String string4 : list) {
                            APIDropDownComboBox.this.putSavedDocPath(string4, string3);
                        }
                    }
                } else {
                    string2 = APIDropDownComboBox.this.apiDocList.getFileName(string);
                    if (string2 == null) {
                        string2 = APIDropDownComboBox.this.getSavedDocPath(string);
                    }
                }
                if (ExecuteDevelopPane.executeTabbedPane != null) {
                    int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
                    list = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
                    ((ExecuteTabPanel)((Object)list)).setApiDocVersion(string);
                }
                try {
                    APITreePanel.tree.addTree(string, string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        string2 = this.loadStoredApidoc();
        if (string2 != null) {
            this.setSelectedItem(string2);
        }
        this.addKeyListener(new KeyOperationsListener());
        this.addControlKeyListener(this);
    }

    public String getSelectedDocName() {
        return this.getSelectedItem().toString();
    }

    public String getServerType() {
        String string = this.getSelectedItem().toString();
        if (string.contains("Ontapi")) {
            return "FILER";
        }
        return "DFM";
    }

    public String getApiVersion() {
        String[] stringArray;
        String string = this.getSelectedItem().toString();
        String string2 = "1.0";
        if (string.contains("Ontapi") && (string2 = (stringArray = string.split("\\s+"))[1]).contains("/")) {
            stringArray = string2.split("/");
            string2 = stringArray[1];
        }
        return string2;
    }

    public String getApiMajorVersion() {
        String string = this.getApiVersion();
        String[] stringArray = string.split("\\.");
        return stringArray[0];
    }

    public String getApiMinorVersion() {
        String string = this.getApiVersion();
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return stringArray[2];
    }

    public boolean isClusterMode() {
        String string = this.getSelectedItem().toString();
        return string.contains("Ontapi") && string.contains("Cluster-Mode");
    }

    public boolean selectApiDocVersion(String string) {
        int n = this.getItemCount() - 2;
        for (int i = 1; i <= n; ++i) {
            if (!this.getItemAt(i).equals(string)) continue;
            this.setSelectedItem(string);
            return true;
        }
        if (string.contains("Ontapi")) {
            String[] stringArray = string.split("\\s+");
            String string2 = null;
            if (stringArray.length == 3) {
                string2 = stringArray[2];
            }
            for (String string3 : this.apiDocList.getOntapDocList()) {
                if (string2 != null) {
                    if (!string3.contains(string2)) continue;
                    this.setSelectedItem(string3);
                    continue;
                }
                if (!string3.contains("7-Mode")) continue;
                this.setSelectedItem(string3);
            }
        } else {
            this.setSelectedItem(this.apiDocList.getDfmDocList().get(0));
        }
        return false;
    }

    public List<String> getSavedDocNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.prefs.getInt(PREF_NODE_DOC_COUNT, 0);
        for (int i = 0; i < n; ++i) {
            String string = "DOC" + i;
            String string2 = this.prefs.get(string, null);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void putSavedDocNames(List<String> list) {
        int n = this.prefs.getInt(PREF_NODE_DOC_COUNT, 0);
        for (String string : list) {
            String string2 = "DOC" + n++;
            this.prefs.put(string2, string);
            this.prefs.putInt(PREF_NODE_DOC_COUNT, n);
        }
    }

    public String getSavedDocPath(String string) {
        return this.prefs.get(string, null);
    }

    private void putSavedDocPath(String string, String string2) {
        this.prefs.put(string, string2);
    }

    private void removeSavedDocPath(String string) {
        int n = this.prefs.getInt(PREF_NODE_DOC_COUNT, 0);
        this.prefs.remove(string);
        this.prefs.putInt(PREF_NODE_DOC_COUNT, n - 1);
    }

    private void addSavedDocsToDropDownList(List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        block0: for (String string : list) {
            if (string == null) continue;
            if (bl) {
                if (!this.readFileSetParser(string, this.getSavedDocPath(string))) {
                    this.removeSavedDocPath(string);
                    continue;
                }
            } else {
                File file;
                String string2 = this.getSavedDocPath(string);
                if (string2 != null && !(file = new File(string2)).exists()) {
                    this.removeSavedDocPath(string);
                    arrayList.add(string);
                    arrayList2.add(string2);
                    continue;
                }
            }
            if (string.contains("Vserver")) {
                this.insertItemAt(string, 2);
                continue;
            }
            if (string.contains("Ontapi")) {
                this.insertItemAt(string, 1);
                continue;
            }
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getItemAt(i).toString().contains("DFM")) continue;
                this.insertItemAt(string, i);
                continue block0;
            }
        }
        int n = arrayList.size();
        if (n > 0) {
            String string;
            string = new String("");
            for (int i = 0; i < n; ++i) {
                string = string + "\n" + (String)arrayList.get(i) + " : " + (String)arrayList2.get(i);
            }
            JOptionPane.showMessageDialog(View.frame, "Failed to load following API Document(s):\n" + string, "File Not Found", 0);
        }
    }

    public boolean readFileSetParser(String string, String string2) {
        File file = new File(string2);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(View.frame, string + " : " + fileNotFoundException.getMessage(), "File Error", 0);
            return false;
        }
        APIParser aPIParser = null;
        try {
            aPIParser = new APIParser(fileInputStream);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(View.frame, string + " : " + iOException.getMessage(), "Parse Error", 0);
            return false;
        }
        APITree.parsedTreeMap.setApiParser(string, aPIParser);
        return true;
    }

    public String loadStoredApidoc() {
        return this.prefs.get(PREF_NODE_APIDOC, null);
    }

    public void storeApidoc() {
        this.prefs.put(PREF_NODE_APIDOC, this.getSelectedDocName());
    }

    private void clearPreferences() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private void addControlKeyListener(JComboBox jComboBox) {
        jComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 90 && (keyEvent.getModifiers() & 1) != 0 && (keyEvent.getModifiers() & 2) != 0) {
                    APIDropDownComboBox.this.clearPreferences();
                }
            }
        });
    }
}

