/*
 * Decompiled with CFR 0.152.
 */
package zexplore.addedapisworkflows.workflows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import util.TreeUtil;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;

public class WorkflowsSearchPanel
extends JPanel {
    private static final long serialVersionUID = -2704592550483256700L;
    private JTextComponent WorkflowsSearchField;
    private static TreeModel originalTreeModel = null;

    public WorkflowsSearchPanel() {
        this.setLayout(new BorderLayout());
        this.WorkflowsSearchField = new JTextField(20);
        this.WorkflowsSearchField.setToolTipText("Filter Workflows Apis with a regular expression");
        this.WorkflowsSearchField.addKeyListener(new KeyOperationsListener());
        this.WorkflowsSearchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = WorkflowsSearchPanel.this.WorkflowsSearchField.getText().trim();
                WorkflowsSearchPanel.this.searchAndFilterApi(string);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = WorkflowsSearchPanel.this.WorkflowsSearchField.getText().trim();
                WorkflowsSearchPanel.this.searchAndFilterApi(string);
            }
        });
        String string = "search";
        ImageIcon imageIcon = new IconMap().getIcon(string);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        jLabel.setToolTipText("Filter Workflows Apis with a regular expression");
        this.add((Component)this.WorkflowsSearchField, "Center");
        this.add((Component)jLabel, "East");
    }

    private void searchAndFilterApi(String string) {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (originalTreeModel == null && (originalTreeModel = WorkflowsTreePanel.tree.getModel()) == null) {
            return;
        }
        if (string.trim().isEmpty()) {
            WorkflowsTreePanel.tree.setModel(originalTreeModel);
            originalTreeModel = null;
            return;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)originalTreeModel.getRoot();
        if (defaultMutableTreeNode2.getChildCount() <= 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("");
        for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
            boolean bl = false;
            serializable = null;
            for (DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode4 != null; defaultMutableTreeNode4 = defaultMutableTreeNode4.getNextSibling()) {
                boolean bl2 = false;
                Matcher matcher = pattern.matcher(defaultMutableTreeNode4.getUserObject().toString());
                while (matcher.find()) {
                    bl2 = true;
                }
                if (!bl2) continue;
                if (!bl) {
                    serializable = new DefaultMutableTreeNode(defaultMutableTreeNode.getUserObject().toString());
                    defaultMutableTreeNode3.add((MutableTreeNode)((Object)serializable));
                    bl = true;
                }
                DefaultMutableTreeNode defaultMutableTreeNode5 = TreeUtil.createClonedTreeNode(defaultMutableTreeNode4);
                ((DefaultMutableTreeNode)serializable).add(defaultMutableTreeNode5);
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode3);
        WorkflowsTreePanel.tree.setModel(defaultTreeModel);
        if (defaultMutableTreeNode3.getChildCount() > 0) {
            for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode3.getFirstChild(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
                serializable = new TreePath(defaultMutableTreeNode.getPath());
                WorkflowsTreePanel.tree.expandPath((TreePath)serializable);
            }
        }
    }
}

