/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.awt.BorderLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import zexplore.IconMap;
import zexplore.addedapisworkflows.AddedApisWorkflowsPane;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.executedevelop.tabpopupmenu.SaveUnsavedWorkflowsDialog;
import zexplore.executedevelop.tabpopupmenu.WorkflowFileListTableModel;
import zexplore.menubar.MenuBar;
import zexplore.menubar.file.FileMenu;
import zexplore.menubar.preferences.ConnectItem;
import zexplore.menubar.preferences.PreferencesMenu;
import zexplore.statusbar.StatusBar;
import zexplore.toolbar.ToolBar;

public class View
implements Runnable {
    public static JFrame frame;
    public static MenuBar menuBar;
    public static ToolBar toolBar;
    public static ExecuteDevelopPane executeDevelopPane;
    public static APIExplorerPanel apiExplorerPanel;
    public static AddedApisWorkflowsPane addedApisWorkflowsPane;
    public static StatusBar statusBar;

    @Override
    public void run() {
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        frame = new JFrame("ZExplore Development Interface");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                View.this.zexploreApplicationExit();
            }
        });
        try {
            frame.setIconImage(new IconMap().getImage("zexplore.png"));
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        frame.setBounds(new Rectangle(0, 0, rectangle.width, rectangle.height));
        menuBar = new MenuBar();
        frame.setJMenuBar(menuBar);
        JSplitPane jSplitPane = new JSplitPane(0);
        frame.add(jSplitPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        toolBar = new ToolBar();
        jPanel.add(toolBar);
        jSplitPane.setTopComponent(jPanel);
        JSplitPane jSplitPane2 = new JSplitPane(1);
        APIExplorerPanel aPIExplorerPanel = new APIExplorerPanel();
        jSplitPane2.setLeftComponent(aPIExplorerPanel);
        JSplitPane jSplitPane3 = new JSplitPane(1);
        jSplitPane3.setResizeWeight(1.0);
        executeDevelopPane = new ExecuteDevelopPane();
        jSplitPane3.setLeftComponent(executeDevelopPane);
        addedApisWorkflowsPane = new AddedApisWorkflowsPane();
        jSplitPane3.setRightComponent(addedApisWorkflowsPane);
        jSplitPane2.setRightComponent(jSplitPane3);
        jSplitPane.setBottomComponent(jSplitPane2);
        JSplitPane jSplitPane4 = new JSplitPane(0);
        jSplitPane4.setResizeWeight(1.0);
        jSplitPane4.setTopComponent(jSplitPane);
        statusBar = new StatusBar();
        jSplitPane4.setBottomComponent(statusBar);
        frame.add(jSplitPane4);
        ExecuteDevelopPane.executeTabbedPane.loadSavedWorkflows();
        frame.setVisible(true);
    }

    private void zexploreApplicationExit() {
        if (!this.saveUnsavedWorkflows()) {
            return;
        }
        this.savePreferences();
        System.exit(0);
    }

    private boolean saveUnsavedWorkflows() {
        SaveUnsavedWorkflowsDialog saveUnsavedWorkflowsDialog;
        Vector<String> vector = LoadedWorkflowList.getUnsavedWorkflowList(true);
        if (vector.size() == 1) {
            String string = vector.firstElement();
            String string2 = LoadedWorkflowList.getWorkflowName(string);
            ExecuteTabPanel executeTabPanel = LoadedWorkflowList.getExecuteTabPanel(string);
            int n = JOptionPane.showConfirmDialog(frame, "Workflow '" + string2 + "' has been modified. Do you want to save the changes?", "Save Workflow", 1, 2);
            if (n == 0) {
                FileMenu.saveItem.saveFile(string2, executeTabPanel.inputPanel);
            } else if (n == 2 || n == -1) {
                return false;
            }
        } else if (vector.size() > 1 && !(saveUnsavedWorkflowsDialog = new SaveUnsavedWorkflowsDialog(WorkflowFileListTableModel.FileType.UNSAVED)).canCloseTabs()) {
            return false;
        }
        return true;
    }

    private void savePreferences() {
        ConnectItem.connectionList.putSavedConnections();
        PreferencesMenu.languagesMenu.storeDefaultLanguage();
        PreferencesMenu.optionsItem.storeCurrentOptions();
        PreferencesMenu.workflowsPathItem.storeDefaultWorkflowPath();
        APIExplorerPanel.apiDropDownComboBox.storeApidoc();
        ExecuteDevelopPane.executeTabbedPane.storeSavedWorkflows();
    }
}

