/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeSearcher {
    private final TreeModel model;

    public TreeSearcher(TreeModel treeModel) {
        this.model = treeModel;
    }

    public TreePath findNextPath(TreePath treePath, Pattern pattern) {
        TreePath treePath2 = new TreePath(this.model.getRoot());
        if (treePath == null) {
            treePath = treePath2;
        }
        TreePath treePath3 = this.getNextPath(treePath);
        while (!treePath3.equals(treePath2)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath3.getLastPathComponent();
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (pattern.matcher(string).find()) {
                return treePath3;
            }
            treePath3 = this.getNextPath(treePath3);
        }
        return null;
    }

    public TreePath findLastPath(TreePath treePath, Pattern pattern) {
        TreePath treePath2 = new TreePath(this.model.getRoot());
        if (treePath == null) {
            treePath = treePath2;
        }
        TreePath treePath3 = this.getPrevPath(treePath);
        while (!treePath3.equals(treePath2)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath3.getLastPathComponent();
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (pattern.matcher(string).find()) {
                return treePath3;
            }
            treePath3 = this.getPrevPath(treePath3);
        }
        return null;
    }

    private TreePath getNextPath(TreePath treePath) {
        if (treePath == null) {
            return new TreePath(this.model.getRoot());
        }
        Object object = treePath.getLastPathComponent();
        if (this.model.getChildCount(object) > 0) {
            return treePath.pathByAddingChild(this.model.getChild(object, 0));
        }
        int n = 0;
        int n2 = treePath.getPathCount();
        Object object2 = treePath.getPathComponent(n2 - 2);
        if (n2 > 1) {
            n = this.model.getIndexOfChild(object2, object);
        }
        if (n2 == 1) {
            return treePath;
        }
        if (n + 1 < this.model.getChildCount(object2)) {
            return treePath.getParentPath().pathByAddingChild(this.model.getChild(object2, n + 1));
        }
        do {
            if ((treePath = treePath.getParentPath()).getParentPath() != null) continue;
            return treePath;
        } while ((n = this.model.getIndexOfChild(object2 = treePath.getPathComponent((n2 = treePath.getPathCount()) - 2), treePath.getLastPathComponent())) + 1 >= this.model.getChildCount(object2));
        return treePath.getParentPath().pathByAddingChild(this.model.getChild(object2, n + 1));
    }

    private TreePath getPrevPath(TreePath treePath) {
        int n;
        if (treePath == null) {
            int n2;
            treePath = new TreePath(this.model.getRoot());
            Object object = treePath.getLastPathComponent();
            while ((n2 = this.model.getChildCount(object)) > 0) {
                treePath = treePath.pathByAddingChild(this.model.getChild(object, n2 - 1));
                object = treePath.getLastPathComponent();
            }
            return treePath;
        }
        int n3 = 0;
        int n4 = treePath.getPathCount();
        Object object = null;
        Object object2 = treePath.getLastPathComponent();
        if (n4 > 1) {
            object = treePath.getPathComponent(n4 - 2);
            n3 = this.model.getIndexOfChild(object, object2);
        }
        if (n3 > 0) {
            int n5;
            TreePath treePath2 = treePath.getParentPath().pathByAddingChild(this.model.getChild(object, n3 - 1));
            object2 = treePath2.getLastPathComponent();
            while ((n5 = this.model.getChildCount(object2)) > 0) {
                treePath2 = treePath2.pathByAddingChild(this.model.getChild(object2, n5 - 1));
                object2 = treePath2.getLastPathComponent();
            }
            return treePath2;
        }
        TreePath treePath3 = treePath.getParentPath();
        if (treePath3 != null) {
            return treePath3;
        }
        object2 = treePath.getLastPathComponent();
        while ((n = this.model.getChildCount(object2)) > 0) {
            treePath = treePath.pathByAddingChild(this.model.getChild(object2, n - 1));
            object2 = treePath.getLastPathComponent();
        }
        return treePath;
    }
}

