/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;
import zexplore.View;
import zexplore.menubar.preferences.PreferencesMenu;

public class Server
extends SwingWorker<Void, Void> {
    private NaServer server;
    private String serverType = null;
    private String vTunnel = null;
    private String version = null;
    private String apiVersion = null;
    private String apiDocVersion = null;
    private String mode = "";
    private long executionTime = 0L;
    private NaElement apiInput = null;
    private String xmlOutput = null;

    public Server(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6) throws NaAuthenticationException, NaAPIFailedException, NaProtocolException, IOException {
        this.serverType = string;
        if (string.equalsIgnoreCase("ontap") && string6 != null) {
            this.server = new NaServer(string2, 1, 7);
            this.server.setVfilerTunneling(string6);
            this.vTunnel = string6;
        } else {
            this.server = new NaServer(string2, 1, 0);
        }
        NaServer.setApplicationName("ZEDI");
        if (string.equalsIgnoreCase("ontap")) {
            this.server.setServerType(1);
        } else {
            this.server.setServerType(4);
        }
        if (string5.equalsIgnoreCase("HTTPS")) {
            this.server.setTransportType(2);
        } else {
            this.server.setTransportType(1);
        }
        this.server.setPort(n);
        this.server.setStyle(1);
        this.server.setAdminUser(string3, string4);
        if (n2 > 0) {
            this.server.setTimeout(n2);
        }
        NaElement naElement = null;
        NaElement naElement2 = null;
        if (this.server.getServerType() == 1) {
            naElement = new NaElement("netapp");
            NaElement naElement3 = new NaElement("system-get-version");
            NaElement naElement4 = new NaElement("system-get-ontapi-version");
            naElement.addChildElem(naElement3);
            naElement.addChildElem(naElement4);
            naElement2 = this.server.invokeElem(naElement);
            int n3 = 1;
            List list = naElement2.getChildren();
            for (NaElement naElement5 : list) {
                if (n3 == 1) {
                    this.version = naElement5.getChildContent("version");
                    String string7 = naElement5.getChildContent("is-clustered");
                    if (string7 != null) {
                        if (string7.equals("true")) {
                            this.mode = " Cluster-Mode";
                            if (this.server.getVserver() != null) {
                                this.mode = " Vserver";
                            }
                        } else {
                            this.mode = " 7-Mode";
                        }
                    }
                } else {
                    this.apiVersion = naElement5.getChildContent("major-version") + "." + naElement5.getChildContent("minor-version");
                    this.apiDocVersion = "Ontapi " + this.apiVersion + this.mode;
                }
                ++n3;
            }
        } else {
            naElement = new NaElement("dfm-about");
            naElement2 = this.server.invokeElem(naElement);
            this.version = naElement2.getChildContent("version");
            String[] stringArray = this.version.split(" ");
            this.apiVersion = stringArray[0].trim();
            this.apiDocVersion = "DFM " + this.apiVersion;
        }
    }

    public Server(Server server) {
        this.server = server.server;
        this.serverType = server.serverType;
        this.vTunnel = server.vTunnel;
        this.version = server.version;
        this.apiVersion = server.apiVersion;
        this.apiDocVersion = server.apiDocVersion;
        this.mode = server.mode;
        this.executionTime = server.executionTime;
        this.apiInput = server.apiInput;
        this.xmlOutput = server.xmlOutput;
    }

    public NaServer getNaServer() {
        return this.server;
    }

    public String getServerType() {
        return this.serverType;
    }

    public boolean isClusterMode() {
        return this.mode.contains("Cluster-Mode") || this.mode.contains("Vserver");
    }

    public String getServerFieldInfo(String string) {
        String[] stringArray;
        String string2 = this.server.toString();
        string2 = string2.replace("[", "");
        string2 = string2.replace("]", "");
        for (String string3 : stringArray = string2.trim().split(",")) {
            String[] stringArray2 = string3.split("=");
            if (!stringArray2[0].equals(string)) continue;
            return stringArray2[1];
        }
        return null;
    }

    public String getVTunnel() {
        return this.vTunnel;
    }

    public String getVersion() {
        return this.version;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getApiDocVersion() {
        return this.apiDocVersion;
    }

    public void setApiDocVersion(String string) {
        this.apiDocVersion = string;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public void setApiInput(NaElement naElement) {
        this.apiInput = naElement;
    }

    public NaElement getApiInput() {
        return this.apiInput;
    }

    public void setXmlOutput(String string) {
        this.xmlOutput = string;
    }

    public String getXmlOutput() {
        return this.xmlOutput;
    }

    public NaElement getApiElement(String string) {
        int n = string.indexOf("<netapp");
        string = string.substring(n, string.length());
        int n2 = string.indexOf(">");
        String string2 = string.substring(0, n2);
        string = string.replace(string2, "<netapp");
        string = string.replaceAll("\n", "");
        string = string.replaceAll(" ", "");
        NaElement naElement = null;
        try {
            naElement = this.server.getXMLParseInput(string.trim());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(View.frame, "Failed to Parse XML Input: " + exception.getMessage(), "Execution Error", 0);
        }
        return naElement;
    }

    public String executeXMLApi(String string) {
        NaElement naElement = this.getApiElement(string);
        if (PreferencesMenu.optionsItem.getCurrentEnableIteratorComprehension() && string.contains("iter-start")) {
            this.setExecutionTime(0L);
            return this.handleIteratorComprehension(naElement);
        }
        return this.invoke(naElement);
    }

    private String invoke(NaElement naElement) {
        long l;
        String string = null;
        long l2 = l = System.currentTimeMillis();
        try {
            string = this.server.invokeElemForXML(naElement);
            l2 = System.currentTimeMillis();
        }
        catch (NaAPIFailedException naAPIFailedException) {
            string = "<netapp version=\"1.1\">\n<results status=\"failed\" reason=\"" + naAPIFailedException.getReason() + "\" errno=\"" + naAPIFailedException.getErrno() + "\"/>\n" + "</netapp>";
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(View.frame, "Failed to execute API: " + exception.getMessage(), "Execution Error", 0);
        }
        long l3 = l2 - l;
        this.setExecutionTime(l3);
        if (string == null) {
            return "";
        }
        int n = string.indexOf("<results");
        String string2 = string.substring(0, n);
        String string3 = string.replace(string2, "<netapp>");
        NaElement naElement2 = null;
        try {
            naElement2 = this.server.getXMLParseInput(string3);
        }
        catch (Exception exception) {
            return string;
        }
        string = naElement2.toPrettyString("").replace("<netapp>", string2.trim());
        return string;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.xmlOutput = this.invoke(this.apiInput);
        return null;
    }

    private String handleIteratorComprehension(NaElement naElement) {
        String string = "";
        long l = 0L;
        NaElement naElement2 = new NaElement("netapp");
        List list = naElement.getChildren();
        for (NaElement naElement3 : list) {
            Object object;
            naElement2.addChildElem(naElement3);
            String string2 = naElement3.getName();
            if (!string2.contains("iter-start")) continue;
            l = this.getExecutionTime();
            string = this.mergeXMLOutput(string, this.invoke(naElement2));
            this.setExecutionTime(this.getExecutionTime() + l);
            int n = string.lastIndexOf("<results");
            if (n < 0) {
                JOptionPane.showMessageDialog(View.frame, "Failed to execute API: with iterator comprehension", "Execution Error", 0);
                return string;
            }
            String string3 = string.substring(n, string.length());
            String string4 = this.getTagValue(string3, "tag");
            String string5 = this.getTagValue(string3, "records");
            if (string4 == null || string5 == null) {
                JOptionPane.showMessageDialog(View.frame, "Failed to execute API: with iterator comprehension", "Execution Error", 0);
                return string;
            }
            long l2 = PreferencesMenu.optionsItem.getCurrentIteratorFetchSize();
            String string6 = Long.toString(l2);
            String string7 = string2.replace("iter-start", "");
            String string8 = string7 + "iter-next";
            naElement2 = new NaElement("netapp");
            for (long i = Long.parseLong(string5); i > 0L; i -= l2) {
                object = new NaElement(string8);
                ((NaElement)object).addNewChild("maximum", string6);
                ((NaElement)object).addNewChild("tag", string4);
                naElement2.addChildElem((NaElement)object);
            }
            object = string7 + "iter-end";
            NaElement naElement4 = new NaElement((String)object);
            naElement4.addNewChild("tag", string4);
            naElement2.addChildElem(naElement4);
        }
        l = this.getExecutionTime();
        string = this.mergeXMLOutput(string, this.invoke(naElement2));
        this.setExecutionTime(this.getExecutionTime() + l);
        return string;
    }

    private String getTagValue(String string, String string2) {
        String string3 = "<" + string2 + ">";
        String string4 = "</" + string2 + ">";
        int n = string.indexOf(string3);
        int n2 = string.indexOf(string4);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return string.substring(n + string3.length(), n2);
    }

    public String mergeXMLOutput(String string, String string2) {
        int n;
        if (!string.trim().isEmpty() && (n = string.lastIndexOf("</netapp>")) > 0) {
            string = string.substring(0, n);
            string = string + "\n";
        }
        if ((n = string2.indexOf("<results")) > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n - 1, string2.length());
            if (string.trim().isEmpty()) {
                string = string3.trim() + "\n\n";
            }
            if (PreferencesMenu.optionsItem.getCurrentShowAPINameExecutionTime()) {
                String string5 = this.apiInput.getName();
                if (PreferencesMenu.optionsItem.getCurrentExecuteMultipleAPIs()) {
                    if (this.apiInput.hasChildren() && this.apiInput.getName().equals("netapp")) {
                        NaElement naElement = (NaElement)this.apiInput.getChildren().get(0);
                        if (naElement != null) {
                            string5 = naElement.getName() + ", ...";
                        }
                    } else {
                        string5 = this.apiInput.getName();
                    }
                }
                string2 = "    <!-- Output of " + string5 + " [Execution Time: " + this.getExecutionTime() + " ms] -->" + "\n" + string4;
            } else {
                string2 = string4;
            }
        }
        return string + string2;
    }
}

