/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaProxyFailedException;
import netapp.manage.NaServer;

public class NaProxyServer
extends NaServer {
    private String _target;
    private String _username;

    public NaProxyServer(InetAddress inetAddress, String string) {
        super(inetAddress);
        this.setProxyTarget(string);
    }

    public NaProxyServer(String string, String string2) throws UnknownHostException {
        this(InetAddress.getByName(string), string2);
    }

    public void setProxyTarget(String string) {
        if (null == string) {
            throw new IllegalArgumentException("target cannot be null");
        }
        this._target = string;
    }

    public void setProxyUsername(String string) {
        this._username = string;
    }

    public NaElement invokeElem(NaElement naElement) throws IOException, NaAuthenticationException, NaProxyFailedException, NaAPIFailedException, NaProtocolException {
        int n;
        NaElement naElement2;
        Object object;
        NaElement naElement3;
        NaElement naElement4 = new NaElement("api-proxy");
        naElement4.addNewChild("target", this._target);
        NaElement naElement5 = new NaElement("request");
        naElement4.addChildElem(naElement5);
        naElement5.addNewChild("name", naElement.getName());
        List list = naElement.getChildren();
        if (0 != list.size()) {
            naElement3 = new NaElement("args");
            naElement5.addChildElem(naElement3);
            object = list.iterator();
            while (object.hasNext()) {
                naElement2 = (NaElement)object.next();
                naElement3.addChildElem(naElement2);
            }
        }
        try {
            naElement3 = super.invokeElem(naElement4);
        }
        catch (NaAPIFailedException naAPIFailedException) {
            throw new NaProxyFailedException(naAPIFailedException.getErrno(), naAPIFailedException.getReason());
        }
        object = naElement3.getChildByName("response");
        if (null == object) {
            throw new NaProtocolException("Missing proxy reponse");
        }
        if ("passed".equals(((NaElement)object).getChildContent("status"))) {
            naElement2 = ((NaElement)object).getChildByName("results");
            if (null == naElement2) {
                throw new NaProtocolException("Missing proxy results");
            }
            return naElement2;
        }
        String string = ((NaElement)object).getChildContent("errno");
        if (null == string) {
            throw new NaProtocolException("Missing errno in proxy response");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NaProtocolException("Malformed errno code: " + string, numberFormatException);
        }
        String string2 = ((NaElement)object).getChildContent("reason");
        if (null == string2) {
            throw new NaProtocolException("Missing reason in proxy response");
        }
        throw new NaAPIFailedException(n, string2);
    }
}

