/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Block {
    private static final NALogger logger = NALogger.getLogger(Block.class);
    static final Pattern BEGIN_BLOCK = Pattern.compile("\\s*/\\*+\\s*");
    static final Pattern BEGIN_TAG = Pattern.compile("\\s*\\*+\\s*@(\\w+)\\s+(\\S.*)");
    static final Pattern CONTINUE_TAG = Pattern.compile("\\s*\\**\\s*([^\\s\\*@].*)");
    static final Pattern END_BLOCK = Pattern.compile("\\s*\\*+\\/.*");
    private Queue<Tag> tags = new LinkedList<Tag>();

    private Block() {
    }

    private void addTag(Tag tag) {
        this.tags.add(tag);
    }

    Queue<Tag> getTags() {
        return this.tags;
    }

    static List<Block> readBlocks(BufferedReader reader) throws IOException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block block = Block.readBlock(reader);
        while (block != null) {
            blocks.add(block);
            block = Block.readBlock(reader);
        }
        return blocks;
    }

    private static Block readBlock(BufferedReader reader) throws IOException {
        Block block = null;
        Tag tag = null;
        String line = reader.readLine();
        while (line != null) {
            line = line.replaceAll("\\s+", " ");
            Matcher blockBegin = BEGIN_BLOCK.matcher(line);
            Matcher tagBegin = BEGIN_TAG.matcher(line);
            Matcher tagCont = CONTINUE_TAG.matcher(line);
            Matcher blockEnd = END_BLOCK.matcher(line);
            if (blockBegin.matches()) {
                assert (block == null);
                block = new Block();
            } else {
                if (blockEnd.matches()) break;
                if (tagBegin.matches()) {
                    tag = null;
                    try {
                        if (block != null) {
                            tag = new Tag(tagBegin.group(1), tagBegin.group(2));
                            block.addTag(tag);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug((MessageKey)MsgKey.ZAPI_PARSER_UNKNOWN_TAG, tagBegin.group(1));
                    }
                } else if (tagCont.matches() && tag != null) {
                    tag.append(tagCont.group(1));
                }
            }
            line = reader.readLine();
        }
        return block;
    }
}

