/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.generator.error;

import com.netapp.nmsdk.common.util.CollectionUtils;
import com.netapp.nmsdk.common.util.Transformer;
import com.netapp.zapi.parser.Errdef;
import com.netapp.zapi.parser.ZapidocParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.ClassUtils;

public class ErrorNameLookupGenerator {
    private final File outputDir;
    private final String outputFilenamePrefix;
    private final Collection<Errdef> errdefs;

    private ErrorNameLookupGenerator(File outputDir, String outputFilenamePrefix, Collection<Errdef> errdefs) {
        this.outputDir = outputDir;
        this.outputFilenamePrefix = outputFilenamePrefix;
        this.errdefs = errdefs;
    }

    private void generateErrorMap() throws IOException, ParserConfigurationException, TransformerException {
        this.generateHeader();
        this.generateCpp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHeader() throws FileNotFoundException {
        PrintWriter h = null;
        try {
            h = new PrintWriter(new File(this.outputDir, this.outputFilenamePrefix + ".h"));
            h.println("/*");
            h.println(String.format(" * Generated by %s.  Do not edit!", this.getClass().getName()));
            h.println(" */");
            h.println();
            h.println("/*");
            h.println(" * Returns the error name for the given error_code (or 0 if no error_name can be determined).");
            h.println(" */");
            h.println("const char* api_lookup_error_name(int error_code);");
        }
        finally {
            if (h != null) {
                h.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCpp() throws FileNotFoundException {
        PrintWriter cpp = null;
        try {
            cpp = new PrintWriter(new File(this.outputDir, this.outputFilenamePrefix + ".cpp"));
            cpp.println("/*");
            cpp.println(String.format(" * Generated by %s.  Do not edit!", this.getClass().getName()));
            cpp.println(" */");
            cpp.println();
            cpp.println(String.format("#include \"%s.h\"", this.outputFilenamePrefix));
            cpp.println();
            cpp.println("/*");
            cpp.println(" * Returns the error name for the given error_code (or 0 if no error_name can be determined).");
            cpp.println(" */");
            cpp.println("const char* api_lookup_error_name(int error_code) {");
            cpp.println("    switch (error_code) {");
            for (Errdef errdef : this.errdefs) {
                cpp.println(String.format("        case %d:", errdef.getCode()));
                cpp.println(String.format("            return \"%s\";", errdef.getName()));
            }
            cpp.println("    }");
            cpp.println("    return 0;");
            cpp.println("}");
        }
        finally {
            if (cpp != null) {
                cpp.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            ErrorNameLookupGenerator.printUsage();
            System.exit(1);
        }
        File outputDir = new File(args[0]);
        String outputFilenamePrefix = args[1];
        List zapidocFiles = CollectionUtils.transform(Arrays.asList(args).subList(2, args.length), new ArrayList(), new Transformer<String, File>(){

            @Override
            public File transform(String s) {
                return new File(s);
            }
        });
        try {
            if (!outputDir.exists() || !outputDir.isDirectory()) {
                throw new RuntimeException("Output source directory " + outputDir + " does not exist");
            }
            ZapidocParser parser = new ZapidocParser(zapidocFiles);
            ErrorNameLookupGenerator generator = new ErrorNameLookupGenerator(outputDir, outputFilenamePrefix, parser.getErrdefs());
            generator.generateErrorMap();
        }
        catch (IOException e) {
            ErrorNameLookupGenerator.printUsage(e);
        }
        catch (ParserConfigurationException e) {
            ErrorNameLookupGenerator.printUsage(e);
        }
        catch (TransformerException e) {
            ErrorNameLookupGenerator.printUsage(e);
        }
    }

    static void printUsage() {
        System.err.println("Usage: " + ClassUtils.getShortClassName(ErrorNameLookupGenerator.class) + " <output_dir> <output_filename_prefix> <zapidoc_file> [<zapidoc_file> ...]");
    }

    static void printUsage(Throwable t) {
        ErrorNameLookupGenerator.printUsage();
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.exit(1);
    }
}

