/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.google.common.base.Predicate;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.nmsdk.common.util.ChangeSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

@SuppressWarnings(value={"IS"})
public class ChangeTracker<T> {
    private static final NALogger logger = NALogger.getLogger(ChangeTracker.class);
    private static final Timer SCAVENGER_TIMER = new Timer("ChangeTrackerScavenger", true);
    private long nextChangeNumber = 1L;
    private Generation head;
    private TimerTask scavengerTask = new ScavengerTask();

    public ChangeTracker() {
        this(600000L);
    }

    public ChangeTracker(long maxLifetime) {
        SCAVENGER_TIMER.schedule(this.scavengerTask, maxLifetime, maxLifetime);
    }

    public synchronized void addChange(T change) {
        Generation g;
        this.head = g = new Generation(change, this.head);
        logger.internal("Created change %s", g.getId());
    }

    public ChangeSet<T> getChanges(long since) {
        return this.getChanges(since, null);
    }

    public ChangeSet<T> getChanges(long since, Predicate<T> predicate) {
        long tag;
        LinkedList results = new LinkedList();
        Generation c = this.head;
        long l = tag = c != null ? c.getId() : 0L;
        while (c != null && c.getId() > since) {
            if (predicate == null || predicate.apply(c.getValue())) {
                results.addFirst(c.getValue());
            }
            c = c.getPrev();
        }
        return new ChangeSet(tag, results);
    }

    protected void finalize() throws Throwable {
        if (this.scavengerTask != null) {
            this.scavengerTask.cancel();
        }
        super.finalize();
    }

    private class ScavengerTask
    extends TimerTask {
        private Generation last;

        private ScavengerTask() {
        }

        @Override
        public void run() {
            if (this.last != null) {
                this.last.truncate();
            }
            this.last = ChangeTracker.this.head;
        }
    }

    private class Generation {
        private final long id;
        private final long time;
        private final T value;
        private Generation prev;

        Generation(T value, Generation prev) {
            this.id = ChangeTracker.this.nextChangeNumber++;
            this.time = System.currentTimeMillis();
            this.value = value;
            this.prev = prev;
        }

        public long getId() {
            return this.id;
        }

        public long getTime() {
            return this.time;
        }

        public T getValue() {
            return this.value;
        }

        public Generation getPrev() {
            return this.prev;
        }

        public long truncate() {
            this.prev = null;
            return this.time;
        }
    }
}

