/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.text;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;

public class DynamicTableWriter {
    public void write(Appendable appendable, Table table) {
        Formatter formatter = new Formatter(appendable);
        Integer[] columnWidths = this.getColumnWidths(table);
        String formatString = this.createFormatStringForColumns(columnWidths);
        this.printHeading(table, formatter, formatString, columnWidths);
        this.printRows(table, formatter, formatString);
    }

    private void printRows(Table table, Formatter formatter, String formatString) {
        for (String[] row : table.getRows()) {
            formatter.format(formatString, row);
        }
    }

    private void printHeading(Table table, Formatter formatter, String formatString, Integer[] columnWidths) {
        if (table.getHeadings() != null && table.getHeadings().length > 0) {
            formatter.format(formatString, table.getHeadings());
            String[] headingSeparator = this.getHeadingSeparator(columnWidths);
            formatter.format(formatString, headingSeparator);
        }
    }

    private Integer[] getColumnWidths(Table table) {
        int numColumns = table.getColumnCount();
        Integer[] columnWidths = new Integer[numColumns];
        this.updateColumnWidths(columnWidths, table.getHeadings());
        for (String[] row : table.getRows()) {
            this.updateColumnWidths(columnWidths, row);
        }
        return columnWidths;
    }

    private void updateColumnWidths(Integer[] columnWidths, String[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                int valueWidth = values[i] == null ? 0 : values[i].length();
                int currentWidth = columnWidths[i] == null ? 0 : columnWidths[i];
                columnWidths[i] = Math.max(currentWidth, valueWidth);
            }
        }
    }

    private String createFormatStringForColumns(Integer ... columnWidths) {
        StringBuilder formatString = new StringBuilder(10 * columnWidths.length);
        String prefix = "";
        Integer[] arr$ = columnWidths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int width = arr$[i$];
            formatString.append(prefix).append("%-").append(width).append("s");
            prefix = " ";
        }
        formatString.append(System.getProperty("line.separator"));
        return formatString.toString();
    }

    private String[] getHeadingSeparator(Integer[] columnWidths) {
        String[] headingSeparator = new String[columnWidths.length];
        for (int i = 0; i < columnWidths.length; ++i) {
            char[] columnHeading = new char[columnWidths[i].intValue()];
            Arrays.fill(columnHeading, '-');
            headingSeparator[i] = new String(columnHeading);
        }
        return headingSeparator;
    }

    public static class Table {
        private String[] headings;
        private List<String[]> rows;

        @SuppressWarnings(value={"EI2"})
        public Table(String ... headings) {
            this.headings = headings;
            this.rows = new LinkedList<String[]>();
        }

        public void addRow(String ... columns) {
            this.rows.add(columns);
        }

        public List<String[]> getRows() {
            return this.rows;
        }

        @SuppressWarnings(value={"EI"})
        public String[] getHeadings() {
            return this.headings;
        }

        public int getColumnCount() {
            int columnCount = 0;
            if (this.headings != null) {
                columnCount = this.headings.length;
            }
            for (String[] row : this.rows) {
                columnCount = Math.max(columnCount, row.length);
            }
            return columnCount;
        }
    }
}

