/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.logging;

import com.netapp.nmsdk.common.logging.LogAdapter;
import com.netapp.nmsdk.common.logging.LogLevel;
import com.netapp.nmsdk.common.logging.LogMessage;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdkLoggerAdapter
implements LogAdapter {
    private static final Map<LogLevel, Level> LEVELS = new EnumMap<LogLevel, Level>(LogLevel.class);
    private final Logger logger;

    JdkLoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void log(LogMessage msg) {
        this.log(msg.getLevel(), msg.localizedMessage());
    }

    @Override
    public void log(LogMessage msg, Throwable t) {
        this.log(msg.getLevel(), msg.localizedMessage(), t);
    }

    @Override
    public void log(LogLevel level, String msg) {
        this.logger.log(JdkLoggerAdapter.level(level), msg);
    }

    @Override
    public void log(LogLevel level, String msg, Throwable t) {
        this.logger.log(JdkLoggerAdapter.level(level), msg, t);
    }

    private static Level level(LogLevel level) {
        Level jdk = LEVELS.get((Object)level);
        return jdk != null ? jdk : Level.FINE;
    }

    @Override
    public final boolean isLogLevelEnabled(LogLevel logLevel) {
        return this.logger.isLoggable(JdkLoggerAdapter.level(logLevel));
    }

    static {
        LEVELS.put(LogLevel.TRACE, Level.FINEST);
        LEVELS.put(LogLevel.DEBUG, Level.FINE);
        LEVELS.put(LogLevel.INFO, Level.INFO);
        LEVELS.put(LogLevel.PROGRESS, Level.INFO);
        LEVELS.put(LogLevel.WARN, Level.WARNING);
        LEVELS.put(LogLevel.ERROR, Level.SEVERE);
        LEVELS.put(LogLevel.FATAL, Level.SEVERE);
    }
}

