#===============================================================#
#                                                               #
# ID                                                            #
#                                                               #
# multistore.py                                                 #
#                                                               #
# Copyright (c) 2011 NetApp, Inc. All rights reserved.          #
# Specifications subject to change without notice.              #
#                                                               #
# Sample code to demonstrate how to:                            #
#        - create/destroy/setup a multistore                    #
#                                                               #
# This Sample code is supported from DataFabric Manager 3.8     #
# onwards.                                                      #
# However few of the functionalities of the sample code may     #
# work on older versions of DataFabric Manager.                 #
#===============================================================#

import sys
sys.path.append("../../../../../../../lib/python/NetApp")
from NaServer import *

def print_usage() :
	print ("Usage:\n")
	print ("multistore.py <dfmserver> <user> <password> create <vfiler> <ip> <protocol> <rpool>\n")
	print ("multistore.py <dfmserver> <user> <password> destroy <vfiler>\n")
	print ("multistore.py <dfmserver> <user> <password> setup <vfiler> <if> <ip> <nm> [-c]\n")
	print ("<dfmserver>  -- Name/IP Address of the DFM server\n")
	print ("<user>       -- DFM server User name\n")
	print ("<password>   -- DFM server User Password\n")
	print ("<vfiler>     -- Vfiler name to be created or setup\n")
	print ("<ip>         -- IP Address to be assigned to the vfiler\n")
	print ("<protocol>   -- nas - for NFS & CIFS\n")
	print ("san - for iSCSI\n")
	print ("all - for both NFS & CIFS\n")
	print ("<rpool>      -- Resource pool in which vfiler will be created\n")
	print ("<if>         -- interface on the vfiler to be used, for e.g e0a, e0b\n")
	print ("<nm>         -- netmask on the vfiler to be used, for e.g 255.255.255.0\n")
	print ("-c           -- specify this flag to run cifs setup for nas & all protocols\n")
	sys.exit (1)


# Variables declaration
args      = len(sys.argv) - 1

# check for valid number of parameters
if ( args < 4 ) :
    print_usage()

dfmserver = sys.argv[1]
dfmuser   = sys.argv[2]
dfmpw     = sys.argv[3]
command   = sys.argv[4]

# Setup DFM server connection
s = NaServer( dfmserver, 1, 0 )
s.set_style("LOGIN")
s.set_transport_type("HTTP")
s.set_server_type("DFM")
s.set_port(8088)
s.set_admin_user( dfmuser, dfmpw )

# Create a new Multistore
if ( command == "create" ) :
	if ( args < 8 ) :
		print_usage()
	
	vfiler_name = sys.argv[5]
	ip          = sys.argv[6]
	protocols   = sys.argv[7]
	rpool       = sys.argv[8]

	# Create multistore with ip and choose the resourcepool to be created from.
	input = NaElement("vfiler-create")
	input.child_add_string( "name", vfiler_name )
	input.child_add_string( "ip-address", ip )
	input.child_add_string( "resource-name-or-id", rpool )

	# Based on the option on the commandline setup the right protocols
	# needed on the multistore
	allproto = NaElement("allowed-protocols")
	
	if( protocols == "all" ) :
		allproto.child_add_string( "protocols", "nfs" )
		allproto.child_add_string( "protocols", "cifs" )
		allproto.child_add_string( "protocols", "iscsi" )
	
	elif( protocols == "nas" ) :
		allproto.child_add_string( "protocols", "nfs" )
		allproto.child_add_string( "protocols", "cifs" )
		
	elif( protocols == "san" ) :
		allproto.child_add_string( "protocols", "iscsi" )
	
	else :
		print ("Protocols allowed are: nfs, cifs, all\n" )
		sys.exit (1)
	
	input.child_add(allproto)

	out = s.invoke_elem(input)
	
	if (out.results_status() == "failed" ) :
		print( "Error : " + out.results_reason() + "\n" )
		sys.exit(2)
	
	print ("VFiler '" + vfiler_name  + "' created on " + out.child_get_string("filer-name") + ":" + out.child_get_string("root-volume-name"))

	
# After a multistore creation, you need to set it up with right IPs and CIFS
# as needed.  With out this step Multistore is not completely operational.
elif ( command == "setup" ) :
	
	if ( args < 8 ) :
		print_usage()
	
	vfiler_name = sys.argv[5]
	interface   = sys.argv[6]
	ip          = sys.argv[7]
	netmask     = sys.argv[8]
	
	if(args > 8):
		cifs = sys.argv[9]
	
	else :
		cifs = None

	input = NaElement("vfiler-setup")
	input.child_add_string( "vfiler-name-or-id", vfiler_name )
	
	if ( cifs == "-c" ) :
		input.child_add_string( "run-cifs-setup", "true" )
	
	# Have to manually choose the interface on the storage system,
	# that needs to host the IP of this multistore
	ipbind     = NaElement("ip-bindings")
	ipbindinfo = NaElement("ip-binding-info")
	ipbindinfo.child_add_string( "interface",  interface )
	ipbindinfo.child_add_string( "ip-address", ip )
	ipbindinfo.child_add_string( "netmask",    netmask )

	ipbind.child_add(ipbindinfo)
	input.child_add(ipbind)
	out = s.invoke_elem(input)

	if ( out.results_status() == "failed" ) :
		print( "Error : " + out.results_reason() + "\n" )
		sys.exit(2)
	
	print ("VFiler '" + vfiler_name + "' setup!\n")

elif ( command == "destroy" ) :
	# Destroy an existing multistore.  This will stop and delete the multistore.
	if ( args < 5 ) :
		print_usage()
	
	vfiler_name = sys.argv[5]
	out = s.invoke( "vfiler-destroy", "vfiler-name-or-id", vfiler_name )
	
	if ( out.results_status() == "failed" ) :
		print( "Error : " + out.results_reason() + "\n" )
		sys.exit(2)
	
	print ("VFiler " + vfiler_name + " destroyed! \n")

else :
	print_usage()


